/*
 * Decompiled with CFR 0.152.
 */
package org.radarcns.monitor.questionnaire;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.nio.ByteBuffer;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.Map;
import org.apache.avro.AvroMissingFieldException;
import org.apache.avro.AvroRuntimeException;
import org.apache.avro.Schema;
import org.apache.avro.data.RecordBuilder;
import org.apache.avro.generic.GenericData;
import org.apache.avro.io.DatumReader;
import org.apache.avro.io.DatumWriter;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.Encoder;
import org.apache.avro.io.ResolvingDecoder;
import org.apache.avro.message.BinaryMessageDecoder;
import org.apache.avro.message.BinaryMessageEncoder;
import org.apache.avro.message.SchemaStore;
import org.apache.avro.specific.AvroGenerated;
import org.apache.avro.specific.SpecificData;
import org.apache.avro.specific.SpecificRecord;
import org.apache.avro.specific.SpecificRecordBase;
import org.apache.avro.specific.SpecificRecordBuilderBase;
import org.radarcns.monitor.questionnaire.InteractionEventType;

@AvroGenerated
public class QuestionnaireApplicationInteractionEvent
extends SpecificRecordBase
implements SpecificRecord {
    private static final long serialVersionUID = 3731767932687863308L;
    public static final Schema SCHEMA$ = new Schema.Parser().parse("{\"type\":\"record\",\"name\":\"QuestionnaireApplicationInteractionEvent\",\"namespace\":\"org.radarcns.monitor.questionnaire\",\"doc\":\"Schema of reporting events for user interaction with the questionnaire application. This describes significant user interactions, such as response to notifications and starting or completing questionnaires.\",\"fields\":[{\"name\":\"time\",\"type\":\"double\",\"doc\":\"Device timestamp in UTC (s).\"},{\"name\":\"eventType\",\"type\":{\"type\":\"enum\",\"name\":\"InteractionEventType\",\"doc\":\"NOTIFICATION_OPEN = When a user presses the notification to open the app, APP_OPEN = When a user opens the app directly, QUESTIONNAIRE_STARTED = When a user starts a questionnaire, QUESTIONNAIRE_FINISHED = When a user completes a questionnaire, QUESTIONNAIRE_CANCELLED = When a user closes a questionnaire without completing it., QUESTIONNAIRE_TRIGGERED = When a data message triggers a new questionnaire.\",\"symbols\":[\"NOTIFICATION_OPEN\",\"APP_OPEN\",\"QUESTIONNAIRE_STARTED\",\"QUESTIONNAIRE_FINISHED\",\"QUESTIONNAIRE_CANCELLED\",\"OTHER\",\"UNKNOWN\",\"RECORDING_STARTED\",\"RECORDING_STOPPED\",\"QUESTIONNAIRE_TRIGGERED\"]},\"doc\":\"Questionnaire app activity usage event type.\",\"default\":\"UNKNOWN\"},{\"name\":\"questionnaireName\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"doc\":\"Name of the questionnaire.\",\"default\":null},{\"name\":\"metadata\",\"type\":[\"null\",{\"type\":\"map\",\"values\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"avro.java.string\":\"String\"}],\"doc\":\"Event metadata.\",\"default\":null}]}");
    private static final SpecificData MODEL$ = new SpecificData();
    private static final BinaryMessageEncoder<QuestionnaireApplicationInteractionEvent> ENCODER = new BinaryMessageEncoder((GenericData)MODEL$, SCHEMA$);
    private static final BinaryMessageDecoder<QuestionnaireApplicationInteractionEvent> DECODER = new BinaryMessageDecoder((GenericData)MODEL$, SCHEMA$);
    private double time;
    private InteractionEventType eventType;
    private String questionnaireName;
    private Map<String, String> metadata;
    private static final DatumWriter<QuestionnaireApplicationInteractionEvent> WRITER$ = MODEL$.createDatumWriter(SCHEMA$);
    private static final DatumReader<QuestionnaireApplicationInteractionEvent> READER$ = MODEL$.createDatumReader(SCHEMA$);

    public static Schema getClassSchema() {
        return SCHEMA$;
    }

    public static BinaryMessageEncoder<QuestionnaireApplicationInteractionEvent> getEncoder() {
        return ENCODER;
    }

    public static BinaryMessageDecoder<QuestionnaireApplicationInteractionEvent> getDecoder() {
        return DECODER;
    }

    public static BinaryMessageDecoder<QuestionnaireApplicationInteractionEvent> createDecoder(SchemaStore resolver) {
        return new BinaryMessageDecoder((GenericData)MODEL$, SCHEMA$, resolver);
    }

    public ByteBuffer toByteBuffer() throws IOException {
        return ENCODER.encode((Object)this);
    }

    public static QuestionnaireApplicationInteractionEvent fromByteBuffer(ByteBuffer b) throws IOException {
        return (QuestionnaireApplicationInteractionEvent)((Object)DECODER.decode(b));
    }

    public QuestionnaireApplicationInteractionEvent() {
    }

    public QuestionnaireApplicationInteractionEvent(Double time, InteractionEventType eventType, String questionnaireName, Map<String, String> metadata) {
        this.time = time;
        this.eventType = eventType;
        this.questionnaireName = questionnaireName;
        this.metadata = metadata;
    }

    public SpecificData getSpecificData() {
        return MODEL$;
    }

    public Schema getSchema() {
        return SCHEMA$;
    }

    public Object get(int field$) {
        switch (field$) {
            case 0: {
                return this.time;
            }
            case 1: {
                return this.eventType;
            }
            case 2: {
                return this.questionnaireName;
            }
            case 3: {
                return this.metadata;
            }
        }
        throw new IndexOutOfBoundsException("Invalid index: " + field$);
    }

    public void put(int field$, Object value$) {
        switch (field$) {
            case 0: {
                this.time = (Double)value$;
                break;
            }
            case 1: {
                this.eventType = (InteractionEventType)((Object)value$);
                break;
            }
            case 2: {
                this.questionnaireName = value$ != null ? value$.toString() : null;
                break;
            }
            case 3: {
                this.metadata = (Map)value$;
                break;
            }
            default: {
                throw new IndexOutOfBoundsException("Invalid index: " + field$);
            }
        }
    }

    public double getTime() {
        return this.time;
    }

    public void setTime(double value) {
        this.time = value;
    }

    public InteractionEventType getEventType() {
        return this.eventType;
    }

    public void setEventType(InteractionEventType value) {
        this.eventType = value;
    }

    public String getQuestionnaireName() {
        return this.questionnaireName;
    }

    public void setQuestionnaireName(String value) {
        this.questionnaireName = value;
    }

    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public void setMetadata(Map<String, String> value) {
        this.metadata = value;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newBuilder(Builder other) {
        if (other == null) {
            return new Builder();
        }
        return new Builder(other);
    }

    public static Builder newBuilder(QuestionnaireApplicationInteractionEvent other) {
        if (other == null) {
            return new Builder();
        }
        return new Builder(other);
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        WRITER$.write((Object)this, (Encoder)SpecificData.getEncoder((ObjectOutput)out));
    }

    public void readExternal(ObjectInput in) throws IOException {
        READER$.read((Object)this, (Decoder)SpecificData.getDecoder((ObjectInput)in));
    }

    protected boolean hasCustomCoders() {
        return true;
    }

    public void customEncode(Encoder out) throws IOException {
        out.writeDouble(this.time);
        out.writeEnum(this.eventType.ordinal());
        if (this.questionnaireName == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeString(this.questionnaireName);
        }
        if (this.metadata == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            long size0 = this.metadata.size();
            out.writeMapStart();
            out.setItemCount(size0);
            long actualSize0 = 0L;
            for (Map.Entry<String, String> e0 : this.metadata.entrySet()) {
                ++actualSize0;
                out.startItem();
                out.writeString(e0.getKey());
                String v0 = e0.getValue();
                if (v0 == null) {
                    out.writeIndex(0);
                    out.writeNull();
                    continue;
                }
                out.writeIndex(1);
                out.writeString(v0);
            }
            out.writeMapEnd();
            if (actualSize0 != size0) {
                throw new ConcurrentModificationException("Map-size written was " + size0 + ", but element count was " + actualSize0 + ".");
            }
        }
    }

    public void customDecode(ResolvingDecoder in) throws IOException {
        Schema.Field[] fieldOrder = in.readFieldOrderIfDiff();
        if (fieldOrder == null) {
            this.time = in.readDouble();
            this.eventType = InteractionEventType.values()[in.readEnum()];
            if (in.readIndex() != 1) {
                in.readNull();
                this.questionnaireName = null;
            } else {
                this.questionnaireName = in.readString();
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.metadata = null;
            } else {
                long size0 = in.readMapStart();
                Map<String, String> m0 = this.metadata;
                if (m0 == null) {
                    this.metadata = m0 = new HashMap<String, String>((int)size0);
                } else {
                    m0.clear();
                }
                while (0L < size0) {
                    while (size0 != 0L) {
                        String k0 = null;
                        k0 = in.readString();
                        String v0 = null;
                        if (in.readIndex() != 1) {
                            in.readNull();
                            v0 = null;
                        } else {
                            v0 = in.readString();
                        }
                        m0.put(k0, v0);
                        --size0;
                    }
                    size0 = in.mapNext();
                }
            }
        } else {
            block8: for (int i = 0; i < 4; ++i) {
                switch (fieldOrder[i].pos()) {
                    case 0: {
                        this.time = in.readDouble();
                        continue block8;
                    }
                    case 1: {
                        this.eventType = InteractionEventType.values()[in.readEnum()];
                        continue block8;
                    }
                    case 2: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.questionnaireName = null;
                            continue block8;
                        }
                        this.questionnaireName = in.readString();
                        continue block8;
                    }
                    case 3: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.metadata = null;
                            continue block8;
                        }
                        long size0 = in.readMapStart();
                        Map<String, String> m0 = this.metadata;
                        if (m0 == null) {
                            this.metadata = m0 = new HashMap<String, String>((int)size0);
                        } else {
                            m0.clear();
                        }
                        while (0L < size0) {
                            while (size0 != 0L) {
                                String k0 = null;
                                k0 = in.readString();
                                String v0 = null;
                                if (in.readIndex() != 1) {
                                    in.readNull();
                                    v0 = null;
                                } else {
                                    v0 = in.readString();
                                }
                                m0.put(k0, v0);
                                --size0;
                            }
                            size0 = in.mapNext();
                        }
                        continue block8;
                    }
                    default: {
                        throw new IOException("Corrupt ResolvingDecoder.");
                    }
                }
            }
        }
    }

    @AvroGenerated
    public static class Builder
    extends SpecificRecordBuilderBase<QuestionnaireApplicationInteractionEvent>
    implements RecordBuilder<QuestionnaireApplicationInteractionEvent> {
        private double time;
        private InteractionEventType eventType;
        private String questionnaireName;
        private Map<String, String> metadata;

        private Builder() {
            super(SCHEMA$, MODEL$);
        }

        private Builder(Builder other) {
            super((SpecificRecordBuilderBase)other);
            if (Builder.isValidValue((Schema.Field)this.fields()[0], (Object)other.time)) {
                this.time = (Double)this.data().deepCopy(this.fields()[0].schema(), (Object)other.time);
                this.fieldSetFlags()[0] = other.fieldSetFlags()[0];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[1], (Object)((Object)other.eventType))) {
                this.eventType = (InteractionEventType)((Object)this.data().deepCopy(this.fields()[1].schema(), (Object)other.eventType));
                this.fieldSetFlags()[1] = other.fieldSetFlags()[1];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[2], (Object)other.questionnaireName)) {
                this.questionnaireName = (String)this.data().deepCopy(this.fields()[2].schema(), (Object)other.questionnaireName);
                this.fieldSetFlags()[2] = other.fieldSetFlags()[2];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[3], other.metadata)) {
                this.metadata = (Map)this.data().deepCopy(this.fields()[3].schema(), other.metadata);
                this.fieldSetFlags()[3] = other.fieldSetFlags()[3];
            }
        }

        private Builder(QuestionnaireApplicationInteractionEvent other) {
            super(SCHEMA$, MODEL$);
            if (Builder.isValidValue((Schema.Field)this.fields()[0], (Object)other.time)) {
                this.time = (Double)this.data().deepCopy(this.fields()[0].schema(), (Object)other.time);
                this.fieldSetFlags()[0] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[1], (Object)((Object)other.eventType))) {
                this.eventType = (InteractionEventType)((Object)this.data().deepCopy(this.fields()[1].schema(), (Object)other.eventType));
                this.fieldSetFlags()[1] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[2], (Object)other.questionnaireName)) {
                this.questionnaireName = (String)this.data().deepCopy(this.fields()[2].schema(), (Object)other.questionnaireName);
                this.fieldSetFlags()[2] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[3], other.metadata)) {
                this.metadata = (Map)this.data().deepCopy(this.fields()[3].schema(), other.metadata);
                this.fieldSetFlags()[3] = true;
            }
        }

        public double getTime() {
            return this.time;
        }

        public Builder setTime(double value) {
            this.validate(this.fields()[0], value);
            this.time = value;
            this.fieldSetFlags()[0] = true;
            return this;
        }

        public boolean hasTime() {
            return this.fieldSetFlags()[0];
        }

        public Builder clearTime() {
            this.fieldSetFlags()[0] = false;
            return this;
        }

        public InteractionEventType getEventType() {
            return this.eventType;
        }

        public Builder setEventType(InteractionEventType value) {
            this.validate(this.fields()[1], (Object)value);
            this.eventType = value;
            this.fieldSetFlags()[1] = true;
            return this;
        }

        public boolean hasEventType() {
            return this.fieldSetFlags()[1];
        }

        public Builder clearEventType() {
            this.eventType = null;
            this.fieldSetFlags()[1] = false;
            return this;
        }

        public String getQuestionnaireName() {
            return this.questionnaireName;
        }

        public Builder setQuestionnaireName(String value) {
            this.validate(this.fields()[2], value);
            this.questionnaireName = value;
            this.fieldSetFlags()[2] = true;
            return this;
        }

        public boolean hasQuestionnaireName() {
            return this.fieldSetFlags()[2];
        }

        public Builder clearQuestionnaireName() {
            this.questionnaireName = null;
            this.fieldSetFlags()[2] = false;
            return this;
        }

        public Map<String, String> getMetadata() {
            return this.metadata;
        }

        public Builder setMetadata(Map<String, String> value) {
            this.validate(this.fields()[3], value);
            this.metadata = value;
            this.fieldSetFlags()[3] = true;
            return this;
        }

        public boolean hasMetadata() {
            return this.fieldSetFlags()[3];
        }

        public Builder clearMetadata() {
            this.metadata = null;
            this.fieldSetFlags()[3] = false;
            return this;
        }

        public QuestionnaireApplicationInteractionEvent build() {
            try {
                QuestionnaireApplicationInteractionEvent record = new QuestionnaireApplicationInteractionEvent();
                record.time = this.fieldSetFlags()[0] ? this.time : (Double)this.defaultValue(this.fields()[0]);
                record.eventType = this.fieldSetFlags()[1] ? this.eventType : (InteractionEventType)((Object)this.defaultValue(this.fields()[1]));
                record.questionnaireName = this.fieldSetFlags()[2] ? this.questionnaireName : (String)this.defaultValue(this.fields()[2]);
                record.metadata = this.fieldSetFlags()[3] ? this.metadata : (Map)this.defaultValue(this.fields()[3]);
                return record;
            }
            catch (AvroMissingFieldException e) {
                throw e;
            }
            catch (Exception e) {
                throw new AvroRuntimeException((Throwable)e);
            }
        }
    }
}

