/*
 * Decompiled with CFR 0.152.
 */
package org.radarcns.connector.oura;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.nio.ByteBuffer;
import org.apache.avro.AvroMissingFieldException;
import org.apache.avro.AvroRuntimeException;
import org.apache.avro.Schema;
import org.apache.avro.data.RecordBuilder;
import org.apache.avro.generic.GenericData;
import org.apache.avro.io.DatumReader;
import org.apache.avro.io.DatumWriter;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.Encoder;
import org.apache.avro.io.ResolvingDecoder;
import org.apache.avro.message.BinaryMessageDecoder;
import org.apache.avro.message.BinaryMessageEncoder;
import org.apache.avro.message.SchemaStore;
import org.apache.avro.specific.AvroGenerated;
import org.apache.avro.specific.SpecificData;
import org.apache.avro.specific.SpecificRecord;
import org.apache.avro.specific.SpecificRecordBase;
import org.apache.avro.specific.SpecificRecordBuilderBase;
import org.radarcns.connector.oura.OuraSleepPhaseType;

@AvroGenerated
public class OuraSleepPhase
extends SpecificRecordBase
implements SpecificRecord {
    private static final long serialVersionUID = -8035897884801310692L;
    public static final Schema SCHEMA$ = new Schema.Parser().parse("{\"type\":\"record\",\"name\":\"OuraSleepPhase\",\"namespace\":\"org.radarcns.connector.oura\",\"doc\":\"Oura Sleep phases in 5-minute intervals as defined in https://cloud.ouraring.com/v2/docs#operation/Single_sleep_Document_v2_usercollection_sleep__document_id__get.\",\"fields\":[{\"name\":\"time\",\"type\":\"double\",\"doc\":\"Start time of the sleep phase in seconds since January 1, 1970, 00:00:00 UTC (Unix timestamp).\"},{\"name\":\"timeReceived\",\"type\":\"double\",\"doc\":\"Time that this record was collected by a service in seconds since the Unix Epoch (s).\"},{\"name\":\"id\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"doc\":\"Unique identifier of the Oura sleep record the sleep stage data is taken from.\",\"default\":null},{\"name\":\"phase\",\"type\":{\"type\":\"enum\",\"name\":\"OuraSleepPhaseType\",\"doc\":\"Sleep phase type as computed by Oura.\",\"symbols\":[\"DEEP\",\"LIGHT\",\"REM\",\"AWAKE\",\"UNKNOWN\"]},\"doc\":\"Sleep phase at a 5-minute interval. UNKNOWN when this data is not provided (e.g. samples from sleep API).\",\"default\":\"UNKNOWN\"}]}");
    private static final SpecificData MODEL$ = new SpecificData();
    private static final BinaryMessageEncoder<OuraSleepPhase> ENCODER = new BinaryMessageEncoder((GenericData)MODEL$, SCHEMA$);
    private static final BinaryMessageDecoder<OuraSleepPhase> DECODER = new BinaryMessageDecoder((GenericData)MODEL$, SCHEMA$);
    private double time;
    private double timeReceived;
    private String id;
    private OuraSleepPhaseType phase;
    private static final DatumWriter<OuraSleepPhase> WRITER$ = MODEL$.createDatumWriter(SCHEMA$);
    private static final DatumReader<OuraSleepPhase> READER$ = MODEL$.createDatumReader(SCHEMA$);

    public static Schema getClassSchema() {
        return SCHEMA$;
    }

    public static BinaryMessageEncoder<OuraSleepPhase> getEncoder() {
        return ENCODER;
    }

    public static BinaryMessageDecoder<OuraSleepPhase> getDecoder() {
        return DECODER;
    }

    public static BinaryMessageDecoder<OuraSleepPhase> createDecoder(SchemaStore resolver) {
        return new BinaryMessageDecoder((GenericData)MODEL$, SCHEMA$, resolver);
    }

    public ByteBuffer toByteBuffer() throws IOException {
        return ENCODER.encode((Object)this);
    }

    public static OuraSleepPhase fromByteBuffer(ByteBuffer b) throws IOException {
        return (OuraSleepPhase)((Object)DECODER.decode(b));
    }

    public OuraSleepPhase() {
    }

    public OuraSleepPhase(Double time, Double timeReceived, String id, OuraSleepPhaseType phase) {
        this.time = time;
        this.timeReceived = timeReceived;
        this.id = id;
        this.phase = phase;
    }

    public SpecificData getSpecificData() {
        return MODEL$;
    }

    public Schema getSchema() {
        return SCHEMA$;
    }

    public Object get(int field$) {
        switch (field$) {
            case 0: {
                return this.time;
            }
            case 1: {
                return this.timeReceived;
            }
            case 2: {
                return this.id;
            }
            case 3: {
                return this.phase;
            }
        }
        throw new IndexOutOfBoundsException("Invalid index: " + field$);
    }

    public void put(int field$, Object value$) {
        switch (field$) {
            case 0: {
                this.time = (Double)value$;
                break;
            }
            case 1: {
                this.timeReceived = (Double)value$;
                break;
            }
            case 2: {
                this.id = value$ != null ? value$.toString() : null;
                break;
            }
            case 3: {
                this.phase = (OuraSleepPhaseType)((Object)value$);
                break;
            }
            default: {
                throw new IndexOutOfBoundsException("Invalid index: " + field$);
            }
        }
    }

    public double getTime() {
        return this.time;
    }

    public void setTime(double value) {
        this.time = value;
    }

    public double getTimeReceived() {
        return this.timeReceived;
    }

    public void setTimeReceived(double value) {
        this.timeReceived = value;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String value) {
        this.id = value;
    }

    public OuraSleepPhaseType getPhase() {
        return this.phase;
    }

    public void setPhase(OuraSleepPhaseType value) {
        this.phase = value;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newBuilder(Builder other) {
        if (other == null) {
            return new Builder();
        }
        return new Builder(other);
    }

    public static Builder newBuilder(OuraSleepPhase other) {
        if (other == null) {
            return new Builder();
        }
        return new Builder(other);
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        WRITER$.write((Object)this, (Encoder)SpecificData.getEncoder((ObjectOutput)out));
    }

    public void readExternal(ObjectInput in) throws IOException {
        READER$.read((Object)this, (Decoder)SpecificData.getDecoder((ObjectInput)in));
    }

    protected boolean hasCustomCoders() {
        return true;
    }

    public void customEncode(Encoder out) throws IOException {
        out.writeDouble(this.time);
        out.writeDouble(this.timeReceived);
        if (this.id == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeString(this.id);
        }
        out.writeEnum(this.phase.ordinal());
    }

    public void customDecode(ResolvingDecoder in) throws IOException {
        Schema.Field[] fieldOrder = in.readFieldOrderIfDiff();
        if (fieldOrder == null) {
            this.time = in.readDouble();
            this.timeReceived = in.readDouble();
            if (in.readIndex() != 1) {
                in.readNull();
                this.id = null;
            } else {
                this.id = in.readString();
            }
            this.phase = OuraSleepPhaseType.values()[in.readEnum()];
        } else {
            block6: for (int i = 0; i < 4; ++i) {
                switch (fieldOrder[i].pos()) {
                    case 0: {
                        this.time = in.readDouble();
                        continue block6;
                    }
                    case 1: {
                        this.timeReceived = in.readDouble();
                        continue block6;
                    }
                    case 2: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.id = null;
                            continue block6;
                        }
                        this.id = in.readString();
                        continue block6;
                    }
                    case 3: {
                        this.phase = OuraSleepPhaseType.values()[in.readEnum()];
                        continue block6;
                    }
                    default: {
                        throw new IOException("Corrupt ResolvingDecoder.");
                    }
                }
            }
        }
    }

    @AvroGenerated
    public static class Builder
    extends SpecificRecordBuilderBase<OuraSleepPhase>
    implements RecordBuilder<OuraSleepPhase> {
        private double time;
        private double timeReceived;
        private String id;
        private OuraSleepPhaseType phase;

        private Builder() {
            super(SCHEMA$, MODEL$);
        }

        private Builder(Builder other) {
            super((SpecificRecordBuilderBase)other);
            if (Builder.isValidValue((Schema.Field)this.fields()[0], (Object)other.time)) {
                this.time = (Double)this.data().deepCopy(this.fields()[0].schema(), (Object)other.time);
                this.fieldSetFlags()[0] = other.fieldSetFlags()[0];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[1], (Object)other.timeReceived)) {
                this.timeReceived = (Double)this.data().deepCopy(this.fields()[1].schema(), (Object)other.timeReceived);
                this.fieldSetFlags()[1] = other.fieldSetFlags()[1];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[2], (Object)other.id)) {
                this.id = (String)this.data().deepCopy(this.fields()[2].schema(), (Object)other.id);
                this.fieldSetFlags()[2] = other.fieldSetFlags()[2];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[3], (Object)((Object)other.phase))) {
                this.phase = (OuraSleepPhaseType)((Object)this.data().deepCopy(this.fields()[3].schema(), (Object)other.phase));
                this.fieldSetFlags()[3] = other.fieldSetFlags()[3];
            }
        }

        private Builder(OuraSleepPhase other) {
            super(SCHEMA$, MODEL$);
            if (Builder.isValidValue((Schema.Field)this.fields()[0], (Object)other.time)) {
                this.time = (Double)this.data().deepCopy(this.fields()[0].schema(), (Object)other.time);
                this.fieldSetFlags()[0] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[1], (Object)other.timeReceived)) {
                this.timeReceived = (Double)this.data().deepCopy(this.fields()[1].schema(), (Object)other.timeReceived);
                this.fieldSetFlags()[1] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[2], (Object)other.id)) {
                this.id = (String)this.data().deepCopy(this.fields()[2].schema(), (Object)other.id);
                this.fieldSetFlags()[2] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[3], (Object)((Object)other.phase))) {
                this.phase = (OuraSleepPhaseType)((Object)this.data().deepCopy(this.fields()[3].schema(), (Object)other.phase));
                this.fieldSetFlags()[3] = true;
            }
        }

        public double getTime() {
            return this.time;
        }

        public Builder setTime(double value) {
            this.validate(this.fields()[0], value);
            this.time = value;
            this.fieldSetFlags()[0] = true;
            return this;
        }

        public boolean hasTime() {
            return this.fieldSetFlags()[0];
        }

        public Builder clearTime() {
            this.fieldSetFlags()[0] = false;
            return this;
        }

        public double getTimeReceived() {
            return this.timeReceived;
        }

        public Builder setTimeReceived(double value) {
            this.validate(this.fields()[1], value);
            this.timeReceived = value;
            this.fieldSetFlags()[1] = true;
            return this;
        }

        public boolean hasTimeReceived() {
            return this.fieldSetFlags()[1];
        }

        public Builder clearTimeReceived() {
            this.fieldSetFlags()[1] = false;
            return this;
        }

        public String getId() {
            return this.id;
        }

        public Builder setId(String value) {
            this.validate(this.fields()[2], value);
            this.id = value;
            this.fieldSetFlags()[2] = true;
            return this;
        }

        public boolean hasId() {
            return this.fieldSetFlags()[2];
        }

        public Builder clearId() {
            this.id = null;
            this.fieldSetFlags()[2] = false;
            return this;
        }

        public OuraSleepPhaseType getPhase() {
            return this.phase;
        }

        public Builder setPhase(OuraSleepPhaseType value) {
            this.validate(this.fields()[3], (Object)value);
            this.phase = value;
            this.fieldSetFlags()[3] = true;
            return this;
        }

        public boolean hasPhase() {
            return this.fieldSetFlags()[3];
        }

        public Builder clearPhase() {
            this.phase = null;
            this.fieldSetFlags()[3] = false;
            return this;
        }

        public OuraSleepPhase build() {
            try {
                OuraSleepPhase record = new OuraSleepPhase();
                record.time = this.fieldSetFlags()[0] ? this.time : (Double)this.defaultValue(this.fields()[0]);
                record.timeReceived = this.fieldSetFlags()[1] ? this.timeReceived : (Double)this.defaultValue(this.fields()[1]);
                record.id = this.fieldSetFlags()[2] ? this.id : (String)this.defaultValue(this.fields()[2]);
                record.phase = this.fieldSetFlags()[3] ? this.phase : (OuraSleepPhaseType)((Object)this.defaultValue(this.fields()[3]));
                return record;
            }
            catch (AvroMissingFieldException e) {
                throw e;
            }
            catch (Exception e) {
                throw new AvroRuntimeException((Throwable)e);
            }
        }
    }
}

