/*
 * Decompiled with CFR 0.152.
 */
package org.radarcns.connector.oura;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.nio.ByteBuffer;
import org.apache.avro.AvroMissingFieldException;
import org.apache.avro.AvroRuntimeException;
import org.apache.avro.Schema;
import org.apache.avro.data.RecordBuilder;
import org.apache.avro.generic.GenericData;
import org.apache.avro.io.DatumReader;
import org.apache.avro.io.DatumWriter;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.Encoder;
import org.apache.avro.io.ResolvingDecoder;
import org.apache.avro.message.BinaryMessageDecoder;
import org.apache.avro.message.BinaryMessageEncoder;
import org.apache.avro.message.SchemaStore;
import org.apache.avro.specific.AvroGenerated;
import org.apache.avro.specific.SpecificData;
import org.apache.avro.specific.SpecificRecord;
import org.apache.avro.specific.SpecificRecordBase;
import org.apache.avro.specific.SpecificRecordBuilderBase;
import org.radarcns.connector.oura.OuraSleepAlgorithmVersion;
import org.radarcns.connector.oura.OuraSleepType;

@AvroGenerated
public class OuraSleep
extends SpecificRecordBase
implements SpecificRecord {
    private static final long serialVersionUID = 6777988939968299502L;
    public static final Schema SCHEMA$ = new Schema.Parser().parse("{\"type\":\"record\",\"name\":\"OuraSleep\",\"namespace\":\"org.radarcns.connector.oura\",\"doc\":\"Oura Sleep data for the specified Oura user within a given timeframe. A user can have multiple sleep periods per day.\",\"fields\":[{\"name\":\"time\",\"type\":\"double\",\"doc\":\"Start time of the sleep in seconds.\"},{\"name\":\"timeReceived\",\"type\":\"double\",\"doc\":\"Time that this record was collected by a service in seconds since the Unix Epoch (s).\"},{\"name\":\"id\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"doc\":\"ID of the sleep record.\",\"default\":null},{\"name\":\"averageBreath\",\"type\":[\"null\",\"float\"],\"doc\":\"Average breathing rate during sleep as breaths/second.\",\"default\":null},{\"name\":\"averageHeartRate\",\"type\":[\"null\",\"float\"],\"doc\":\"Average heart rate during sleep as beats/minute.\",\"default\":null},{\"name\":\"averageHrv\",\"type\":[\"null\",\"int\"],\"doc\":\"Average heart rate variability during sleep.\",\"default\":null},{\"name\":\"awakeTime\",\"type\":[\"null\",\"int\"],\"doc\":\"Duration spent awake in seconds.\",\"default\":null},{\"name\":\"bedtimeEnd\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"doc\":\"Bedtime end of the sleep.\",\"default\":null},{\"name\":\"bedtimeStart\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"doc\":\"Bedtime start of the sleep.\",\"default\":null},{\"name\":\"day\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"doc\":\"Day that the sleep belongs to.\",\"default\":null},{\"name\":\"deepSleepDuration\",\"type\":[\"null\",\"int\"],\"doc\":\"Duration spent in deep sleep in seconds.\",\"default\":null},{\"name\":\"efficiency\",\"type\":[\"null\",\"int\"],\"doc\":\"Sleep efficiency rating in range [1, 100].\",\"default\":null},{\"name\":\"latency\",\"type\":[\"null\",\"int\"],\"doc\":\"Sleep latency in seconds. This is the time it took for the user to fall asleep after going to bed.\",\"default\":null},{\"name\":\"lightSleepDuration\",\"type\":[\"null\",\"int\"],\"doc\":\"Duration spent in light sleep in seconds.\",\"default\":null},{\"name\":\"lowBatteryAlert\",\"type\":[\"null\",\"boolean\"],\"doc\":\"Flag indicating if a low battery alert occurred.\",\"default\":null},{\"name\":\"lowestHeartRate\",\"type\":[\"null\",\"int\"],\"doc\":\"Lowest heart rate during sleep.\",\"default\":null},{\"name\":\"period\",\"type\":[\"null\",\"int\"],\"doc\":\"ECore sleep period identifier.\",\"default\":null},{\"name\":\"readinessContributorActivityBalance\",\"type\":[\"null\",\"int\"],\"doc\":\"Contribution of cumulative activity balance to the readiness score in range [1, 100].\",\"default\":null},{\"name\":\"readinessContributorBodyTemperature\",\"type\":[\"null\",\"int\"],\"doc\":\"Contribution of cumulative activity balance to the readiness score in range [1, 100].\",\"default\":null},{\"name\":\"readinessContributorHrvBalance\",\"type\":[\"null\",\"int\"],\"doc\":\"Contribution of cumulative activity balance to the readiness score in range [1, 100].\",\"default\":null},{\"name\":\"readinessContributorPreviousDayActivity\",\"type\":[\"null\",\"int\"],\"doc\":\"Contribution of cumulative activity balance to the readiness score in range [1, 100].\",\"default\":null},{\"name\":\"readinessContributorPreviousNight\",\"type\":[\"null\",\"int\"],\"doc\":\"Contribution of cumulative activity balance to the readiness score in range [1, 100].\",\"default\":null},{\"name\":\"readinessContributorRecoveryIndex\",\"type\":[\"null\",\"int\"],\"doc\":\"Contribution of cumulative activity balance to the readiness score in range [1, 100].\",\"default\":null},{\"name\":\"readinessContributorRestingHeartRate\",\"type\":[\"null\",\"int\"],\"doc\":\"Contribution of cumulative activity balance to the readiness score in range [1, 100].\",\"default\":null},{\"name\":\"readinessContributorSleepBalance\",\"type\":[\"null\",\"int\"],\"doc\":\"Contribution of cumulative activity balance to the readiness score in range [1, 100].\",\"default\":null},{\"name\":\"readinessScore\",\"type\":[\"null\",\"int\"],\"doc\":\"Readiness score for this sleep.\",\"default\":null},{\"name\":\"readinessTemperatureDeviation\",\"type\":[\"null\",\"int\"],\"doc\":\"Readiness temperature deviation in degrees Celsius.\",\"default\":null},{\"name\":\"readinessTemperatureTrendDeviation\",\"type\":[\"null\",\"int\"],\"doc\":\"Readiness trend deviation in degrees Celsius.\",\"default\":null},{\"name\":\"readinessScoreDelta\",\"type\":[\"null\",\"int\"],\"doc\":\"Effect on readiness score caused by this sleep period.\",\"default\":null},{\"name\":\"remSleepDuration\",\"type\":[\"null\",\"int\"],\"doc\":\"Duration spent in REM sleep in seconds.\",\"default\":null},{\"name\":\"restlessPeriods\",\"type\":[\"null\",\"int\"],\"doc\":\"Number of restless periods during sleep.\",\"default\":null},{\"name\":\"sleepScoreDelta\",\"type\":[\"null\",\"int\"],\"doc\":\"Effect on sleep score caused by this sleep period.\",\"default\":null},{\"name\":\"sleepAlgorithmVersion\",\"type\":{\"type\":\"enum\",\"name\":\"OuraSleepAlgorithmVersion\",\"doc\":\"Oura Sleep algorithm version.\",\"symbols\":[\"V1\",\"V2\"]},\"doc\":\"Version of the sleep algorithm used to calculate the sleep data.\",\"default\":\"V2\"},{\"name\":\"timeInBed\",\"type\":[\"null\",\"int\"],\"doc\":\"Duration spent in bed in seconds.\",\"default\":null},{\"name\":\"totalSleepDuration\",\"type\":[\"null\",\"int\"],\"doc\":\"Total sleep duration in seconds.\",\"default\":null},{\"name\":\"type\",\"type\":{\"type\":\"enum\",\"name\":\"OuraSleepType\",\"doc\":\"Sleep type as computed by Oura.\",\"symbols\":[\"DELETED\",\"SLEEP\",\"LONG_SLEEP\",\"LATE_NAP\",\"REST\",\"UNKNOWN\"]},\"doc\":\"Possible sleep period types. UNKNOWN when this data is not provided.\",\"default\":\"UNKNOWN\"}]}");
    private static final SpecificData MODEL$ = new SpecificData();
    private static final BinaryMessageEncoder<OuraSleep> ENCODER = new BinaryMessageEncoder((GenericData)MODEL$, SCHEMA$);
    private static final BinaryMessageDecoder<OuraSleep> DECODER = new BinaryMessageDecoder((GenericData)MODEL$, SCHEMA$);
    private double time;
    private double timeReceived;
    private String id;
    private Float averageBreath;
    private Float averageHeartRate;
    private Integer averageHrv;
    private Integer awakeTime;
    private String bedtimeEnd;
    private String bedtimeStart;
    private String day;
    private Integer deepSleepDuration;
    private Integer efficiency;
    private Integer latency;
    private Integer lightSleepDuration;
    private Boolean lowBatteryAlert;
    private Integer lowestHeartRate;
    private Integer period;
    private Integer readinessContributorActivityBalance;
    private Integer readinessContributorBodyTemperature;
    private Integer readinessContributorHrvBalance;
    private Integer readinessContributorPreviousDayActivity;
    private Integer readinessContributorPreviousNight;
    private Integer readinessContributorRecoveryIndex;
    private Integer readinessContributorRestingHeartRate;
    private Integer readinessContributorSleepBalance;
    private Integer readinessScore;
    private Integer readinessTemperatureDeviation;
    private Integer readinessTemperatureTrendDeviation;
    private Integer readinessScoreDelta;
    private Integer remSleepDuration;
    private Integer restlessPeriods;
    private Integer sleepScoreDelta;
    private OuraSleepAlgorithmVersion sleepAlgorithmVersion;
    private Integer timeInBed;
    private Integer totalSleepDuration;
    private OuraSleepType type;
    private static final DatumWriter<OuraSleep> WRITER$ = MODEL$.createDatumWriter(SCHEMA$);
    private static final DatumReader<OuraSleep> READER$ = MODEL$.createDatumReader(SCHEMA$);

    public static Schema getClassSchema() {
        return SCHEMA$;
    }

    public static BinaryMessageEncoder<OuraSleep> getEncoder() {
        return ENCODER;
    }

    public static BinaryMessageDecoder<OuraSleep> getDecoder() {
        return DECODER;
    }

    public static BinaryMessageDecoder<OuraSleep> createDecoder(SchemaStore resolver) {
        return new BinaryMessageDecoder((GenericData)MODEL$, SCHEMA$, resolver);
    }

    public ByteBuffer toByteBuffer() throws IOException {
        return ENCODER.encode((Object)this);
    }

    public static OuraSleep fromByteBuffer(ByteBuffer b) throws IOException {
        return (OuraSleep)((Object)DECODER.decode(b));
    }

    public OuraSleep() {
    }

    public OuraSleep(Double time, Double timeReceived, String id, Float averageBreath, Float averageHeartRate, Integer averageHrv, Integer awakeTime, String bedtimeEnd, String bedtimeStart, String day, Integer deepSleepDuration, Integer efficiency, Integer latency, Integer lightSleepDuration, Boolean lowBatteryAlert, Integer lowestHeartRate, Integer period, Integer readinessContributorActivityBalance, Integer readinessContributorBodyTemperature, Integer readinessContributorHrvBalance, Integer readinessContributorPreviousDayActivity, Integer readinessContributorPreviousNight, Integer readinessContributorRecoveryIndex, Integer readinessContributorRestingHeartRate, Integer readinessContributorSleepBalance, Integer readinessScore, Integer readinessTemperatureDeviation, Integer readinessTemperatureTrendDeviation, Integer readinessScoreDelta, Integer remSleepDuration, Integer restlessPeriods, Integer sleepScoreDelta, OuraSleepAlgorithmVersion sleepAlgorithmVersion, Integer timeInBed, Integer totalSleepDuration, OuraSleepType type) {
        this.time = time;
        this.timeReceived = timeReceived;
        this.id = id;
        this.averageBreath = averageBreath;
        this.averageHeartRate = averageHeartRate;
        this.averageHrv = averageHrv;
        this.awakeTime = awakeTime;
        this.bedtimeEnd = bedtimeEnd;
        this.bedtimeStart = bedtimeStart;
        this.day = day;
        this.deepSleepDuration = deepSleepDuration;
        this.efficiency = efficiency;
        this.latency = latency;
        this.lightSleepDuration = lightSleepDuration;
        this.lowBatteryAlert = lowBatteryAlert;
        this.lowestHeartRate = lowestHeartRate;
        this.period = period;
        this.readinessContributorActivityBalance = readinessContributorActivityBalance;
        this.readinessContributorBodyTemperature = readinessContributorBodyTemperature;
        this.readinessContributorHrvBalance = readinessContributorHrvBalance;
        this.readinessContributorPreviousDayActivity = readinessContributorPreviousDayActivity;
        this.readinessContributorPreviousNight = readinessContributorPreviousNight;
        this.readinessContributorRecoveryIndex = readinessContributorRecoveryIndex;
        this.readinessContributorRestingHeartRate = readinessContributorRestingHeartRate;
        this.readinessContributorSleepBalance = readinessContributorSleepBalance;
        this.readinessScore = readinessScore;
        this.readinessTemperatureDeviation = readinessTemperatureDeviation;
        this.readinessTemperatureTrendDeviation = readinessTemperatureTrendDeviation;
        this.readinessScoreDelta = readinessScoreDelta;
        this.remSleepDuration = remSleepDuration;
        this.restlessPeriods = restlessPeriods;
        this.sleepScoreDelta = sleepScoreDelta;
        this.sleepAlgorithmVersion = sleepAlgorithmVersion;
        this.timeInBed = timeInBed;
        this.totalSleepDuration = totalSleepDuration;
        this.type = type;
    }

    public SpecificData getSpecificData() {
        return MODEL$;
    }

    public Schema getSchema() {
        return SCHEMA$;
    }

    public Object get(int field$) {
        switch (field$) {
            case 0: {
                return this.time;
            }
            case 1: {
                return this.timeReceived;
            }
            case 2: {
                return this.id;
            }
            case 3: {
                return this.averageBreath;
            }
            case 4: {
                return this.averageHeartRate;
            }
            case 5: {
                return this.averageHrv;
            }
            case 6: {
                return this.awakeTime;
            }
            case 7: {
                return this.bedtimeEnd;
            }
            case 8: {
                return this.bedtimeStart;
            }
            case 9: {
                return this.day;
            }
            case 10: {
                return this.deepSleepDuration;
            }
            case 11: {
                return this.efficiency;
            }
            case 12: {
                return this.latency;
            }
            case 13: {
                return this.lightSleepDuration;
            }
            case 14: {
                return this.lowBatteryAlert;
            }
            case 15: {
                return this.lowestHeartRate;
            }
            case 16: {
                return this.period;
            }
            case 17: {
                return this.readinessContributorActivityBalance;
            }
            case 18: {
                return this.readinessContributorBodyTemperature;
            }
            case 19: {
                return this.readinessContributorHrvBalance;
            }
            case 20: {
                return this.readinessContributorPreviousDayActivity;
            }
            case 21: {
                return this.readinessContributorPreviousNight;
            }
            case 22: {
                return this.readinessContributorRecoveryIndex;
            }
            case 23: {
                return this.readinessContributorRestingHeartRate;
            }
            case 24: {
                return this.readinessContributorSleepBalance;
            }
            case 25: {
                return this.readinessScore;
            }
            case 26: {
                return this.readinessTemperatureDeviation;
            }
            case 27: {
                return this.readinessTemperatureTrendDeviation;
            }
            case 28: {
                return this.readinessScoreDelta;
            }
            case 29: {
                return this.remSleepDuration;
            }
            case 30: {
                return this.restlessPeriods;
            }
            case 31: {
                return this.sleepScoreDelta;
            }
            case 32: {
                return this.sleepAlgorithmVersion;
            }
            case 33: {
                return this.timeInBed;
            }
            case 34: {
                return this.totalSleepDuration;
            }
            case 35: {
                return this.type;
            }
        }
        throw new IndexOutOfBoundsException("Invalid index: " + field$);
    }

    public void put(int field$, Object value$) {
        switch (field$) {
            case 0: {
                this.time = (Double)value$;
                break;
            }
            case 1: {
                this.timeReceived = (Double)value$;
                break;
            }
            case 2: {
                this.id = value$ != null ? value$.toString() : null;
                break;
            }
            case 3: {
                this.averageBreath = (Float)value$;
                break;
            }
            case 4: {
                this.averageHeartRate = (Float)value$;
                break;
            }
            case 5: {
                this.averageHrv = (Integer)value$;
                break;
            }
            case 6: {
                this.awakeTime = (Integer)value$;
                break;
            }
            case 7: {
                this.bedtimeEnd = value$ != null ? value$.toString() : null;
                break;
            }
            case 8: {
                this.bedtimeStart = value$ != null ? value$.toString() : null;
                break;
            }
            case 9: {
                this.day = value$ != null ? value$.toString() : null;
                break;
            }
            case 10: {
                this.deepSleepDuration = (Integer)value$;
                break;
            }
            case 11: {
                this.efficiency = (Integer)value$;
                break;
            }
            case 12: {
                this.latency = (Integer)value$;
                break;
            }
            case 13: {
                this.lightSleepDuration = (Integer)value$;
                break;
            }
            case 14: {
                this.lowBatteryAlert = (Boolean)value$;
                break;
            }
            case 15: {
                this.lowestHeartRate = (Integer)value$;
                break;
            }
            case 16: {
                this.period = (Integer)value$;
                break;
            }
            case 17: {
                this.readinessContributorActivityBalance = (Integer)value$;
                break;
            }
            case 18: {
                this.readinessContributorBodyTemperature = (Integer)value$;
                break;
            }
            case 19: {
                this.readinessContributorHrvBalance = (Integer)value$;
                break;
            }
            case 20: {
                this.readinessContributorPreviousDayActivity = (Integer)value$;
                break;
            }
            case 21: {
                this.readinessContributorPreviousNight = (Integer)value$;
                break;
            }
            case 22: {
                this.readinessContributorRecoveryIndex = (Integer)value$;
                break;
            }
            case 23: {
                this.readinessContributorRestingHeartRate = (Integer)value$;
                break;
            }
            case 24: {
                this.readinessContributorSleepBalance = (Integer)value$;
                break;
            }
            case 25: {
                this.readinessScore = (Integer)value$;
                break;
            }
            case 26: {
                this.readinessTemperatureDeviation = (Integer)value$;
                break;
            }
            case 27: {
                this.readinessTemperatureTrendDeviation = (Integer)value$;
                break;
            }
            case 28: {
                this.readinessScoreDelta = (Integer)value$;
                break;
            }
            case 29: {
                this.remSleepDuration = (Integer)value$;
                break;
            }
            case 30: {
                this.restlessPeriods = (Integer)value$;
                break;
            }
            case 31: {
                this.sleepScoreDelta = (Integer)value$;
                break;
            }
            case 32: {
                this.sleepAlgorithmVersion = (OuraSleepAlgorithmVersion)((Object)value$);
                break;
            }
            case 33: {
                this.timeInBed = (Integer)value$;
                break;
            }
            case 34: {
                this.totalSleepDuration = (Integer)value$;
                break;
            }
            case 35: {
                this.type = (OuraSleepType)((Object)value$);
                break;
            }
            default: {
                throw new IndexOutOfBoundsException("Invalid index: " + field$);
            }
        }
    }

    public double getTime() {
        return this.time;
    }

    public void setTime(double value) {
        this.time = value;
    }

    public double getTimeReceived() {
        return this.timeReceived;
    }

    public void setTimeReceived(double value) {
        this.timeReceived = value;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String value) {
        this.id = value;
    }

    public Float getAverageBreath() {
        return this.averageBreath;
    }

    public void setAverageBreath(Float value) {
        this.averageBreath = value;
    }

    public Float getAverageHeartRate() {
        return this.averageHeartRate;
    }

    public void setAverageHeartRate(Float value) {
        this.averageHeartRate = value;
    }

    public Integer getAverageHrv() {
        return this.averageHrv;
    }

    public void setAverageHrv(Integer value) {
        this.averageHrv = value;
    }

    public Integer getAwakeTime() {
        return this.awakeTime;
    }

    public void setAwakeTime(Integer value) {
        this.awakeTime = value;
    }

    public String getBedtimeEnd() {
        return this.bedtimeEnd;
    }

    public void setBedtimeEnd(String value) {
        this.bedtimeEnd = value;
    }

    public String getBedtimeStart() {
        return this.bedtimeStart;
    }

    public void setBedtimeStart(String value) {
        this.bedtimeStart = value;
    }

    public String getDay() {
        return this.day;
    }

    public void setDay(String value) {
        this.day = value;
    }

    public Integer getDeepSleepDuration() {
        return this.deepSleepDuration;
    }

    public void setDeepSleepDuration(Integer value) {
        this.deepSleepDuration = value;
    }

    public Integer getEfficiency() {
        return this.efficiency;
    }

    public void setEfficiency(Integer value) {
        this.efficiency = value;
    }

    public Integer getLatency() {
        return this.latency;
    }

    public void setLatency(Integer value) {
        this.latency = value;
    }

    public Integer getLightSleepDuration() {
        return this.lightSleepDuration;
    }

    public void setLightSleepDuration(Integer value) {
        this.lightSleepDuration = value;
    }

    public Boolean getLowBatteryAlert() {
        return this.lowBatteryAlert;
    }

    public void setLowBatteryAlert(Boolean value) {
        this.lowBatteryAlert = value;
    }

    public Integer getLowestHeartRate() {
        return this.lowestHeartRate;
    }

    public void setLowestHeartRate(Integer value) {
        this.lowestHeartRate = value;
    }

    public Integer getPeriod() {
        return this.period;
    }

    public void setPeriod(Integer value) {
        this.period = value;
    }

    public Integer getReadinessContributorActivityBalance() {
        return this.readinessContributorActivityBalance;
    }

    public void setReadinessContributorActivityBalance(Integer value) {
        this.readinessContributorActivityBalance = value;
    }

    public Integer getReadinessContributorBodyTemperature() {
        return this.readinessContributorBodyTemperature;
    }

    public void setReadinessContributorBodyTemperature(Integer value) {
        this.readinessContributorBodyTemperature = value;
    }

    public Integer getReadinessContributorHrvBalance() {
        return this.readinessContributorHrvBalance;
    }

    public void setReadinessContributorHrvBalance(Integer value) {
        this.readinessContributorHrvBalance = value;
    }

    public Integer getReadinessContributorPreviousDayActivity() {
        return this.readinessContributorPreviousDayActivity;
    }

    public void setReadinessContributorPreviousDayActivity(Integer value) {
        this.readinessContributorPreviousDayActivity = value;
    }

    public Integer getReadinessContributorPreviousNight() {
        return this.readinessContributorPreviousNight;
    }

    public void setReadinessContributorPreviousNight(Integer value) {
        this.readinessContributorPreviousNight = value;
    }

    public Integer getReadinessContributorRecoveryIndex() {
        return this.readinessContributorRecoveryIndex;
    }

    public void setReadinessContributorRecoveryIndex(Integer value) {
        this.readinessContributorRecoveryIndex = value;
    }

    public Integer getReadinessContributorRestingHeartRate() {
        return this.readinessContributorRestingHeartRate;
    }

    public void setReadinessContributorRestingHeartRate(Integer value) {
        this.readinessContributorRestingHeartRate = value;
    }

    public Integer getReadinessContributorSleepBalance() {
        return this.readinessContributorSleepBalance;
    }

    public void setReadinessContributorSleepBalance(Integer value) {
        this.readinessContributorSleepBalance = value;
    }

    public Integer getReadinessScore() {
        return this.readinessScore;
    }

    public void setReadinessScore(Integer value) {
        this.readinessScore = value;
    }

    public Integer getReadinessTemperatureDeviation() {
        return this.readinessTemperatureDeviation;
    }

    public void setReadinessTemperatureDeviation(Integer value) {
        this.readinessTemperatureDeviation = value;
    }

    public Integer getReadinessTemperatureTrendDeviation() {
        return this.readinessTemperatureTrendDeviation;
    }

    public void setReadinessTemperatureTrendDeviation(Integer value) {
        this.readinessTemperatureTrendDeviation = value;
    }

    public Integer getReadinessScoreDelta() {
        return this.readinessScoreDelta;
    }

    public void setReadinessScoreDelta(Integer value) {
        this.readinessScoreDelta = value;
    }

    public Integer getRemSleepDuration() {
        return this.remSleepDuration;
    }

    public void setRemSleepDuration(Integer value) {
        this.remSleepDuration = value;
    }

    public Integer getRestlessPeriods() {
        return this.restlessPeriods;
    }

    public void setRestlessPeriods(Integer value) {
        this.restlessPeriods = value;
    }

    public Integer getSleepScoreDelta() {
        return this.sleepScoreDelta;
    }

    public void setSleepScoreDelta(Integer value) {
        this.sleepScoreDelta = value;
    }

    public OuraSleepAlgorithmVersion getSleepAlgorithmVersion() {
        return this.sleepAlgorithmVersion;
    }

    public void setSleepAlgorithmVersion(OuraSleepAlgorithmVersion value) {
        this.sleepAlgorithmVersion = value;
    }

    public Integer getTimeInBed() {
        return this.timeInBed;
    }

    public void setTimeInBed(Integer value) {
        this.timeInBed = value;
    }

    public Integer getTotalSleepDuration() {
        return this.totalSleepDuration;
    }

    public void setTotalSleepDuration(Integer value) {
        this.totalSleepDuration = value;
    }

    public OuraSleepType getType() {
        return this.type;
    }

    public void setType(OuraSleepType value) {
        this.type = value;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newBuilder(Builder other) {
        if (other == null) {
            return new Builder();
        }
        return new Builder(other);
    }

    public static Builder newBuilder(OuraSleep other) {
        if (other == null) {
            return new Builder();
        }
        return new Builder(other);
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        WRITER$.write((Object)this, (Encoder)SpecificData.getEncoder((ObjectOutput)out));
    }

    public void readExternal(ObjectInput in) throws IOException {
        READER$.read((Object)this, (Decoder)SpecificData.getDecoder((ObjectInput)in));
    }

    protected boolean hasCustomCoders() {
        return true;
    }

    public void customEncode(Encoder out) throws IOException {
        out.writeDouble(this.time);
        out.writeDouble(this.timeReceived);
        if (this.id == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeString(this.id);
        }
        if (this.averageBreath == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeFloat(this.averageBreath.floatValue());
        }
        if (this.averageHeartRate == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeFloat(this.averageHeartRate.floatValue());
        }
        if (this.averageHrv == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeInt(this.averageHrv.intValue());
        }
        if (this.awakeTime == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeInt(this.awakeTime.intValue());
        }
        if (this.bedtimeEnd == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeString(this.bedtimeEnd);
        }
        if (this.bedtimeStart == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeString(this.bedtimeStart);
        }
        if (this.day == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeString(this.day);
        }
        if (this.deepSleepDuration == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeInt(this.deepSleepDuration.intValue());
        }
        if (this.efficiency == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeInt(this.efficiency.intValue());
        }
        if (this.latency == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeInt(this.latency.intValue());
        }
        if (this.lightSleepDuration == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeInt(this.lightSleepDuration.intValue());
        }
        if (this.lowBatteryAlert == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeBoolean(this.lowBatteryAlert.booleanValue());
        }
        if (this.lowestHeartRate == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeInt(this.lowestHeartRate.intValue());
        }
        if (this.period == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeInt(this.period.intValue());
        }
        if (this.readinessContributorActivityBalance == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeInt(this.readinessContributorActivityBalance.intValue());
        }
        if (this.readinessContributorBodyTemperature == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeInt(this.readinessContributorBodyTemperature.intValue());
        }
        if (this.readinessContributorHrvBalance == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeInt(this.readinessContributorHrvBalance.intValue());
        }
        if (this.readinessContributorPreviousDayActivity == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeInt(this.readinessContributorPreviousDayActivity.intValue());
        }
        if (this.readinessContributorPreviousNight == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeInt(this.readinessContributorPreviousNight.intValue());
        }
        if (this.readinessContributorRecoveryIndex == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeInt(this.readinessContributorRecoveryIndex.intValue());
        }
        if (this.readinessContributorRestingHeartRate == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeInt(this.readinessContributorRestingHeartRate.intValue());
        }
        if (this.readinessContributorSleepBalance == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeInt(this.readinessContributorSleepBalance.intValue());
        }
        if (this.readinessScore == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeInt(this.readinessScore.intValue());
        }
        if (this.readinessTemperatureDeviation == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeInt(this.readinessTemperatureDeviation.intValue());
        }
        if (this.readinessTemperatureTrendDeviation == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeInt(this.readinessTemperatureTrendDeviation.intValue());
        }
        if (this.readinessScoreDelta == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeInt(this.readinessScoreDelta.intValue());
        }
        if (this.remSleepDuration == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeInt(this.remSleepDuration.intValue());
        }
        if (this.restlessPeriods == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeInt(this.restlessPeriods.intValue());
        }
        if (this.sleepScoreDelta == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeInt(this.sleepScoreDelta.intValue());
        }
        out.writeEnum(this.sleepAlgorithmVersion.ordinal());
        if (this.timeInBed == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeInt(this.timeInBed.intValue());
        }
        if (this.totalSleepDuration == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeInt(this.totalSleepDuration.intValue());
        }
        out.writeEnum(this.type.ordinal());
    }

    public void customDecode(ResolvingDecoder in) throws IOException {
        Schema.Field[] fieldOrder = in.readFieldOrderIfDiff();
        if (fieldOrder == null) {
            this.time = in.readDouble();
            this.timeReceived = in.readDouble();
            if (in.readIndex() != 1) {
                in.readNull();
                this.id = null;
            } else {
                this.id = in.readString();
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.averageBreath = null;
            } else {
                this.averageBreath = Float.valueOf(in.readFloat());
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.averageHeartRate = null;
            } else {
                this.averageHeartRate = Float.valueOf(in.readFloat());
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.averageHrv = null;
            } else {
                this.averageHrv = in.readInt();
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.awakeTime = null;
            } else {
                this.awakeTime = in.readInt();
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.bedtimeEnd = null;
            } else {
                this.bedtimeEnd = in.readString();
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.bedtimeStart = null;
            } else {
                this.bedtimeStart = in.readString();
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.day = null;
            } else {
                this.day = in.readString();
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.deepSleepDuration = null;
            } else {
                this.deepSleepDuration = in.readInt();
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.efficiency = null;
            } else {
                this.efficiency = in.readInt();
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.latency = null;
            } else {
                this.latency = in.readInt();
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.lightSleepDuration = null;
            } else {
                this.lightSleepDuration = in.readInt();
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.lowBatteryAlert = null;
            } else {
                this.lowBatteryAlert = in.readBoolean();
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.lowestHeartRate = null;
            } else {
                this.lowestHeartRate = in.readInt();
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.period = null;
            } else {
                this.period = in.readInt();
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.readinessContributorActivityBalance = null;
            } else {
                this.readinessContributorActivityBalance = in.readInt();
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.readinessContributorBodyTemperature = null;
            } else {
                this.readinessContributorBodyTemperature = in.readInt();
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.readinessContributorHrvBalance = null;
            } else {
                this.readinessContributorHrvBalance = in.readInt();
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.readinessContributorPreviousDayActivity = null;
            } else {
                this.readinessContributorPreviousDayActivity = in.readInt();
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.readinessContributorPreviousNight = null;
            } else {
                this.readinessContributorPreviousNight = in.readInt();
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.readinessContributorRecoveryIndex = null;
            } else {
                this.readinessContributorRecoveryIndex = in.readInt();
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.readinessContributorRestingHeartRate = null;
            } else {
                this.readinessContributorRestingHeartRate = in.readInt();
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.readinessContributorSleepBalance = null;
            } else {
                this.readinessContributorSleepBalance = in.readInt();
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.readinessScore = null;
            } else {
                this.readinessScore = in.readInt();
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.readinessTemperatureDeviation = null;
            } else {
                this.readinessTemperatureDeviation = in.readInt();
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.readinessTemperatureTrendDeviation = null;
            } else {
                this.readinessTemperatureTrendDeviation = in.readInt();
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.readinessScoreDelta = null;
            } else {
                this.readinessScoreDelta = in.readInt();
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.remSleepDuration = null;
            } else {
                this.remSleepDuration = in.readInt();
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.restlessPeriods = null;
            } else {
                this.restlessPeriods = in.readInt();
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.sleepScoreDelta = null;
            } else {
                this.sleepScoreDelta = in.readInt();
            }
            this.sleepAlgorithmVersion = OuraSleepAlgorithmVersion.values()[in.readEnum()];
            if (in.readIndex() != 1) {
                in.readNull();
                this.timeInBed = null;
            } else {
                this.timeInBed = in.readInt();
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.totalSleepDuration = null;
            } else {
                this.totalSleepDuration = in.readInt();
            }
            this.type = OuraSleepType.values()[in.readEnum()];
        } else {
            block38: for (int i = 0; i < 36; ++i) {
                switch (fieldOrder[i].pos()) {
                    case 0: {
                        this.time = in.readDouble();
                        continue block38;
                    }
                    case 1: {
                        this.timeReceived = in.readDouble();
                        continue block38;
                    }
                    case 2: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.id = null;
                            continue block38;
                        }
                        this.id = in.readString();
                        continue block38;
                    }
                    case 3: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.averageBreath = null;
                            continue block38;
                        }
                        this.averageBreath = Float.valueOf(in.readFloat());
                        continue block38;
                    }
                    case 4: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.averageHeartRate = null;
                            continue block38;
                        }
                        this.averageHeartRate = Float.valueOf(in.readFloat());
                        continue block38;
                    }
                    case 5: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.averageHrv = null;
                            continue block38;
                        }
                        this.averageHrv = in.readInt();
                        continue block38;
                    }
                    case 6: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.awakeTime = null;
                            continue block38;
                        }
                        this.awakeTime = in.readInt();
                        continue block38;
                    }
                    case 7: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.bedtimeEnd = null;
                            continue block38;
                        }
                        this.bedtimeEnd = in.readString();
                        continue block38;
                    }
                    case 8: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.bedtimeStart = null;
                            continue block38;
                        }
                        this.bedtimeStart = in.readString();
                        continue block38;
                    }
                    case 9: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.day = null;
                            continue block38;
                        }
                        this.day = in.readString();
                        continue block38;
                    }
                    case 10: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.deepSleepDuration = null;
                            continue block38;
                        }
                        this.deepSleepDuration = in.readInt();
                        continue block38;
                    }
                    case 11: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.efficiency = null;
                            continue block38;
                        }
                        this.efficiency = in.readInt();
                        continue block38;
                    }
                    case 12: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.latency = null;
                            continue block38;
                        }
                        this.latency = in.readInt();
                        continue block38;
                    }
                    case 13: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.lightSleepDuration = null;
                            continue block38;
                        }
                        this.lightSleepDuration = in.readInt();
                        continue block38;
                    }
                    case 14: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.lowBatteryAlert = null;
                            continue block38;
                        }
                        this.lowBatteryAlert = in.readBoolean();
                        continue block38;
                    }
                    case 15: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.lowestHeartRate = null;
                            continue block38;
                        }
                        this.lowestHeartRate = in.readInt();
                        continue block38;
                    }
                    case 16: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.period = null;
                            continue block38;
                        }
                        this.period = in.readInt();
                        continue block38;
                    }
                    case 17: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.readinessContributorActivityBalance = null;
                            continue block38;
                        }
                        this.readinessContributorActivityBalance = in.readInt();
                        continue block38;
                    }
                    case 18: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.readinessContributorBodyTemperature = null;
                            continue block38;
                        }
                        this.readinessContributorBodyTemperature = in.readInt();
                        continue block38;
                    }
                    case 19: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.readinessContributorHrvBalance = null;
                            continue block38;
                        }
                        this.readinessContributorHrvBalance = in.readInt();
                        continue block38;
                    }
                    case 20: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.readinessContributorPreviousDayActivity = null;
                            continue block38;
                        }
                        this.readinessContributorPreviousDayActivity = in.readInt();
                        continue block38;
                    }
                    case 21: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.readinessContributorPreviousNight = null;
                            continue block38;
                        }
                        this.readinessContributorPreviousNight = in.readInt();
                        continue block38;
                    }
                    case 22: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.readinessContributorRecoveryIndex = null;
                            continue block38;
                        }
                        this.readinessContributorRecoveryIndex = in.readInt();
                        continue block38;
                    }
                    case 23: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.readinessContributorRestingHeartRate = null;
                            continue block38;
                        }
                        this.readinessContributorRestingHeartRate = in.readInt();
                        continue block38;
                    }
                    case 24: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.readinessContributorSleepBalance = null;
                            continue block38;
                        }
                        this.readinessContributorSleepBalance = in.readInt();
                        continue block38;
                    }
                    case 25: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.readinessScore = null;
                            continue block38;
                        }
                        this.readinessScore = in.readInt();
                        continue block38;
                    }
                    case 26: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.readinessTemperatureDeviation = null;
                            continue block38;
                        }
                        this.readinessTemperatureDeviation = in.readInt();
                        continue block38;
                    }
                    case 27: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.readinessTemperatureTrendDeviation = null;
                            continue block38;
                        }
                        this.readinessTemperatureTrendDeviation = in.readInt();
                        continue block38;
                    }
                    case 28: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.readinessScoreDelta = null;
                            continue block38;
                        }
                        this.readinessScoreDelta = in.readInt();
                        continue block38;
                    }
                    case 29: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.remSleepDuration = null;
                            continue block38;
                        }
                        this.remSleepDuration = in.readInt();
                        continue block38;
                    }
                    case 30: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.restlessPeriods = null;
                            continue block38;
                        }
                        this.restlessPeriods = in.readInt();
                        continue block38;
                    }
                    case 31: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.sleepScoreDelta = null;
                            continue block38;
                        }
                        this.sleepScoreDelta = in.readInt();
                        continue block38;
                    }
                    case 32: {
                        this.sleepAlgorithmVersion = OuraSleepAlgorithmVersion.values()[in.readEnum()];
                        continue block38;
                    }
                    case 33: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.timeInBed = null;
                            continue block38;
                        }
                        this.timeInBed = in.readInt();
                        continue block38;
                    }
                    case 34: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.totalSleepDuration = null;
                            continue block38;
                        }
                        this.totalSleepDuration = in.readInt();
                        continue block38;
                    }
                    case 35: {
                        this.type = OuraSleepType.values()[in.readEnum()];
                        continue block38;
                    }
                    default: {
                        throw new IOException("Corrupt ResolvingDecoder.");
                    }
                }
            }
        }
    }

    @AvroGenerated
    public static class Builder
    extends SpecificRecordBuilderBase<OuraSleep>
    implements RecordBuilder<OuraSleep> {
        private double time;
        private double timeReceived;
        private String id;
        private Float averageBreath;
        private Float averageHeartRate;
        private Integer averageHrv;
        private Integer awakeTime;
        private String bedtimeEnd;
        private String bedtimeStart;
        private String day;
        private Integer deepSleepDuration;
        private Integer efficiency;
        private Integer latency;
        private Integer lightSleepDuration;
        private Boolean lowBatteryAlert;
        private Integer lowestHeartRate;
        private Integer period;
        private Integer readinessContributorActivityBalance;
        private Integer readinessContributorBodyTemperature;
        private Integer readinessContributorHrvBalance;
        private Integer readinessContributorPreviousDayActivity;
        private Integer readinessContributorPreviousNight;
        private Integer readinessContributorRecoveryIndex;
        private Integer readinessContributorRestingHeartRate;
        private Integer readinessContributorSleepBalance;
        private Integer readinessScore;
        private Integer readinessTemperatureDeviation;
        private Integer readinessTemperatureTrendDeviation;
        private Integer readinessScoreDelta;
        private Integer remSleepDuration;
        private Integer restlessPeriods;
        private Integer sleepScoreDelta;
        private OuraSleepAlgorithmVersion sleepAlgorithmVersion;
        private Integer timeInBed;
        private Integer totalSleepDuration;
        private OuraSleepType type;

        private Builder() {
            super(SCHEMA$, MODEL$);
        }

        private Builder(Builder other) {
            super((SpecificRecordBuilderBase)other);
            if (Builder.isValidValue((Schema.Field)this.fields()[0], (Object)other.time)) {
                this.time = (Double)this.data().deepCopy(this.fields()[0].schema(), (Object)other.time);
                this.fieldSetFlags()[0] = other.fieldSetFlags()[0];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[1], (Object)other.timeReceived)) {
                this.timeReceived = (Double)this.data().deepCopy(this.fields()[1].schema(), (Object)other.timeReceived);
                this.fieldSetFlags()[1] = other.fieldSetFlags()[1];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[2], (Object)other.id)) {
                this.id = (String)this.data().deepCopy(this.fields()[2].schema(), (Object)other.id);
                this.fieldSetFlags()[2] = other.fieldSetFlags()[2];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[3], (Object)other.averageBreath)) {
                this.averageBreath = (Float)this.data().deepCopy(this.fields()[3].schema(), (Object)other.averageBreath);
                this.fieldSetFlags()[3] = other.fieldSetFlags()[3];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[4], (Object)other.averageHeartRate)) {
                this.averageHeartRate = (Float)this.data().deepCopy(this.fields()[4].schema(), (Object)other.averageHeartRate);
                this.fieldSetFlags()[4] = other.fieldSetFlags()[4];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[5], (Object)other.averageHrv)) {
                this.averageHrv = (Integer)this.data().deepCopy(this.fields()[5].schema(), (Object)other.averageHrv);
                this.fieldSetFlags()[5] = other.fieldSetFlags()[5];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[6], (Object)other.awakeTime)) {
                this.awakeTime = (Integer)this.data().deepCopy(this.fields()[6].schema(), (Object)other.awakeTime);
                this.fieldSetFlags()[6] = other.fieldSetFlags()[6];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[7], (Object)other.bedtimeEnd)) {
                this.bedtimeEnd = (String)this.data().deepCopy(this.fields()[7].schema(), (Object)other.bedtimeEnd);
                this.fieldSetFlags()[7] = other.fieldSetFlags()[7];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[8], (Object)other.bedtimeStart)) {
                this.bedtimeStart = (String)this.data().deepCopy(this.fields()[8].schema(), (Object)other.bedtimeStart);
                this.fieldSetFlags()[8] = other.fieldSetFlags()[8];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[9], (Object)other.day)) {
                this.day = (String)this.data().deepCopy(this.fields()[9].schema(), (Object)other.day);
                this.fieldSetFlags()[9] = other.fieldSetFlags()[9];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[10], (Object)other.deepSleepDuration)) {
                this.deepSleepDuration = (Integer)this.data().deepCopy(this.fields()[10].schema(), (Object)other.deepSleepDuration);
                this.fieldSetFlags()[10] = other.fieldSetFlags()[10];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[11], (Object)other.efficiency)) {
                this.efficiency = (Integer)this.data().deepCopy(this.fields()[11].schema(), (Object)other.efficiency);
                this.fieldSetFlags()[11] = other.fieldSetFlags()[11];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[12], (Object)other.latency)) {
                this.latency = (Integer)this.data().deepCopy(this.fields()[12].schema(), (Object)other.latency);
                this.fieldSetFlags()[12] = other.fieldSetFlags()[12];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[13], (Object)other.lightSleepDuration)) {
                this.lightSleepDuration = (Integer)this.data().deepCopy(this.fields()[13].schema(), (Object)other.lightSleepDuration);
                this.fieldSetFlags()[13] = other.fieldSetFlags()[13];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[14], (Object)other.lowBatteryAlert)) {
                this.lowBatteryAlert = (Boolean)this.data().deepCopy(this.fields()[14].schema(), (Object)other.lowBatteryAlert);
                this.fieldSetFlags()[14] = other.fieldSetFlags()[14];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[15], (Object)other.lowestHeartRate)) {
                this.lowestHeartRate = (Integer)this.data().deepCopy(this.fields()[15].schema(), (Object)other.lowestHeartRate);
                this.fieldSetFlags()[15] = other.fieldSetFlags()[15];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[16], (Object)other.period)) {
                this.period = (Integer)this.data().deepCopy(this.fields()[16].schema(), (Object)other.period);
                this.fieldSetFlags()[16] = other.fieldSetFlags()[16];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[17], (Object)other.readinessContributorActivityBalance)) {
                this.readinessContributorActivityBalance = (Integer)this.data().deepCopy(this.fields()[17].schema(), (Object)other.readinessContributorActivityBalance);
                this.fieldSetFlags()[17] = other.fieldSetFlags()[17];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[18], (Object)other.readinessContributorBodyTemperature)) {
                this.readinessContributorBodyTemperature = (Integer)this.data().deepCopy(this.fields()[18].schema(), (Object)other.readinessContributorBodyTemperature);
                this.fieldSetFlags()[18] = other.fieldSetFlags()[18];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[19], (Object)other.readinessContributorHrvBalance)) {
                this.readinessContributorHrvBalance = (Integer)this.data().deepCopy(this.fields()[19].schema(), (Object)other.readinessContributorHrvBalance);
                this.fieldSetFlags()[19] = other.fieldSetFlags()[19];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[20], (Object)other.readinessContributorPreviousDayActivity)) {
                this.readinessContributorPreviousDayActivity = (Integer)this.data().deepCopy(this.fields()[20].schema(), (Object)other.readinessContributorPreviousDayActivity);
                this.fieldSetFlags()[20] = other.fieldSetFlags()[20];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[21], (Object)other.readinessContributorPreviousNight)) {
                this.readinessContributorPreviousNight = (Integer)this.data().deepCopy(this.fields()[21].schema(), (Object)other.readinessContributorPreviousNight);
                this.fieldSetFlags()[21] = other.fieldSetFlags()[21];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[22], (Object)other.readinessContributorRecoveryIndex)) {
                this.readinessContributorRecoveryIndex = (Integer)this.data().deepCopy(this.fields()[22].schema(), (Object)other.readinessContributorRecoveryIndex);
                this.fieldSetFlags()[22] = other.fieldSetFlags()[22];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[23], (Object)other.readinessContributorRestingHeartRate)) {
                this.readinessContributorRestingHeartRate = (Integer)this.data().deepCopy(this.fields()[23].schema(), (Object)other.readinessContributorRestingHeartRate);
                this.fieldSetFlags()[23] = other.fieldSetFlags()[23];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[24], (Object)other.readinessContributorSleepBalance)) {
                this.readinessContributorSleepBalance = (Integer)this.data().deepCopy(this.fields()[24].schema(), (Object)other.readinessContributorSleepBalance);
                this.fieldSetFlags()[24] = other.fieldSetFlags()[24];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[25], (Object)other.readinessScore)) {
                this.readinessScore = (Integer)this.data().deepCopy(this.fields()[25].schema(), (Object)other.readinessScore);
                this.fieldSetFlags()[25] = other.fieldSetFlags()[25];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[26], (Object)other.readinessTemperatureDeviation)) {
                this.readinessTemperatureDeviation = (Integer)this.data().deepCopy(this.fields()[26].schema(), (Object)other.readinessTemperatureDeviation);
                this.fieldSetFlags()[26] = other.fieldSetFlags()[26];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[27], (Object)other.readinessTemperatureTrendDeviation)) {
                this.readinessTemperatureTrendDeviation = (Integer)this.data().deepCopy(this.fields()[27].schema(), (Object)other.readinessTemperatureTrendDeviation);
                this.fieldSetFlags()[27] = other.fieldSetFlags()[27];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[28], (Object)other.readinessScoreDelta)) {
                this.readinessScoreDelta = (Integer)this.data().deepCopy(this.fields()[28].schema(), (Object)other.readinessScoreDelta);
                this.fieldSetFlags()[28] = other.fieldSetFlags()[28];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[29], (Object)other.remSleepDuration)) {
                this.remSleepDuration = (Integer)this.data().deepCopy(this.fields()[29].schema(), (Object)other.remSleepDuration);
                this.fieldSetFlags()[29] = other.fieldSetFlags()[29];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[30], (Object)other.restlessPeriods)) {
                this.restlessPeriods = (Integer)this.data().deepCopy(this.fields()[30].schema(), (Object)other.restlessPeriods);
                this.fieldSetFlags()[30] = other.fieldSetFlags()[30];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[31], (Object)other.sleepScoreDelta)) {
                this.sleepScoreDelta = (Integer)this.data().deepCopy(this.fields()[31].schema(), (Object)other.sleepScoreDelta);
                this.fieldSetFlags()[31] = other.fieldSetFlags()[31];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[32], (Object)((Object)other.sleepAlgorithmVersion))) {
                this.sleepAlgorithmVersion = (OuraSleepAlgorithmVersion)((Object)this.data().deepCopy(this.fields()[32].schema(), (Object)other.sleepAlgorithmVersion));
                this.fieldSetFlags()[32] = other.fieldSetFlags()[32];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[33], (Object)other.timeInBed)) {
                this.timeInBed = (Integer)this.data().deepCopy(this.fields()[33].schema(), (Object)other.timeInBed);
                this.fieldSetFlags()[33] = other.fieldSetFlags()[33];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[34], (Object)other.totalSleepDuration)) {
                this.totalSleepDuration = (Integer)this.data().deepCopy(this.fields()[34].schema(), (Object)other.totalSleepDuration);
                this.fieldSetFlags()[34] = other.fieldSetFlags()[34];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[35], (Object)((Object)other.type))) {
                this.type = (OuraSleepType)((Object)this.data().deepCopy(this.fields()[35].schema(), (Object)other.type));
                this.fieldSetFlags()[35] = other.fieldSetFlags()[35];
            }
        }

        private Builder(OuraSleep other) {
            super(SCHEMA$, MODEL$);
            if (Builder.isValidValue((Schema.Field)this.fields()[0], (Object)other.time)) {
                this.time = (Double)this.data().deepCopy(this.fields()[0].schema(), (Object)other.time);
                this.fieldSetFlags()[0] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[1], (Object)other.timeReceived)) {
                this.timeReceived = (Double)this.data().deepCopy(this.fields()[1].schema(), (Object)other.timeReceived);
                this.fieldSetFlags()[1] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[2], (Object)other.id)) {
                this.id = (String)this.data().deepCopy(this.fields()[2].schema(), (Object)other.id);
                this.fieldSetFlags()[2] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[3], (Object)other.averageBreath)) {
                this.averageBreath = (Float)this.data().deepCopy(this.fields()[3].schema(), (Object)other.averageBreath);
                this.fieldSetFlags()[3] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[4], (Object)other.averageHeartRate)) {
                this.averageHeartRate = (Float)this.data().deepCopy(this.fields()[4].schema(), (Object)other.averageHeartRate);
                this.fieldSetFlags()[4] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[5], (Object)other.averageHrv)) {
                this.averageHrv = (Integer)this.data().deepCopy(this.fields()[5].schema(), (Object)other.averageHrv);
                this.fieldSetFlags()[5] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[6], (Object)other.awakeTime)) {
                this.awakeTime = (Integer)this.data().deepCopy(this.fields()[6].schema(), (Object)other.awakeTime);
                this.fieldSetFlags()[6] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[7], (Object)other.bedtimeEnd)) {
                this.bedtimeEnd = (String)this.data().deepCopy(this.fields()[7].schema(), (Object)other.bedtimeEnd);
                this.fieldSetFlags()[7] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[8], (Object)other.bedtimeStart)) {
                this.bedtimeStart = (String)this.data().deepCopy(this.fields()[8].schema(), (Object)other.bedtimeStart);
                this.fieldSetFlags()[8] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[9], (Object)other.day)) {
                this.day = (String)this.data().deepCopy(this.fields()[9].schema(), (Object)other.day);
                this.fieldSetFlags()[9] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[10], (Object)other.deepSleepDuration)) {
                this.deepSleepDuration = (Integer)this.data().deepCopy(this.fields()[10].schema(), (Object)other.deepSleepDuration);
                this.fieldSetFlags()[10] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[11], (Object)other.efficiency)) {
                this.efficiency = (Integer)this.data().deepCopy(this.fields()[11].schema(), (Object)other.efficiency);
                this.fieldSetFlags()[11] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[12], (Object)other.latency)) {
                this.latency = (Integer)this.data().deepCopy(this.fields()[12].schema(), (Object)other.latency);
                this.fieldSetFlags()[12] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[13], (Object)other.lightSleepDuration)) {
                this.lightSleepDuration = (Integer)this.data().deepCopy(this.fields()[13].schema(), (Object)other.lightSleepDuration);
                this.fieldSetFlags()[13] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[14], (Object)other.lowBatteryAlert)) {
                this.lowBatteryAlert = (Boolean)this.data().deepCopy(this.fields()[14].schema(), (Object)other.lowBatteryAlert);
                this.fieldSetFlags()[14] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[15], (Object)other.lowestHeartRate)) {
                this.lowestHeartRate = (Integer)this.data().deepCopy(this.fields()[15].schema(), (Object)other.lowestHeartRate);
                this.fieldSetFlags()[15] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[16], (Object)other.period)) {
                this.period = (Integer)this.data().deepCopy(this.fields()[16].schema(), (Object)other.period);
                this.fieldSetFlags()[16] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[17], (Object)other.readinessContributorActivityBalance)) {
                this.readinessContributorActivityBalance = (Integer)this.data().deepCopy(this.fields()[17].schema(), (Object)other.readinessContributorActivityBalance);
                this.fieldSetFlags()[17] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[18], (Object)other.readinessContributorBodyTemperature)) {
                this.readinessContributorBodyTemperature = (Integer)this.data().deepCopy(this.fields()[18].schema(), (Object)other.readinessContributorBodyTemperature);
                this.fieldSetFlags()[18] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[19], (Object)other.readinessContributorHrvBalance)) {
                this.readinessContributorHrvBalance = (Integer)this.data().deepCopy(this.fields()[19].schema(), (Object)other.readinessContributorHrvBalance);
                this.fieldSetFlags()[19] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[20], (Object)other.readinessContributorPreviousDayActivity)) {
                this.readinessContributorPreviousDayActivity = (Integer)this.data().deepCopy(this.fields()[20].schema(), (Object)other.readinessContributorPreviousDayActivity);
                this.fieldSetFlags()[20] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[21], (Object)other.readinessContributorPreviousNight)) {
                this.readinessContributorPreviousNight = (Integer)this.data().deepCopy(this.fields()[21].schema(), (Object)other.readinessContributorPreviousNight);
                this.fieldSetFlags()[21] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[22], (Object)other.readinessContributorRecoveryIndex)) {
                this.readinessContributorRecoveryIndex = (Integer)this.data().deepCopy(this.fields()[22].schema(), (Object)other.readinessContributorRecoveryIndex);
                this.fieldSetFlags()[22] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[23], (Object)other.readinessContributorRestingHeartRate)) {
                this.readinessContributorRestingHeartRate = (Integer)this.data().deepCopy(this.fields()[23].schema(), (Object)other.readinessContributorRestingHeartRate);
                this.fieldSetFlags()[23] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[24], (Object)other.readinessContributorSleepBalance)) {
                this.readinessContributorSleepBalance = (Integer)this.data().deepCopy(this.fields()[24].schema(), (Object)other.readinessContributorSleepBalance);
                this.fieldSetFlags()[24] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[25], (Object)other.readinessScore)) {
                this.readinessScore = (Integer)this.data().deepCopy(this.fields()[25].schema(), (Object)other.readinessScore);
                this.fieldSetFlags()[25] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[26], (Object)other.readinessTemperatureDeviation)) {
                this.readinessTemperatureDeviation = (Integer)this.data().deepCopy(this.fields()[26].schema(), (Object)other.readinessTemperatureDeviation);
                this.fieldSetFlags()[26] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[27], (Object)other.readinessTemperatureTrendDeviation)) {
                this.readinessTemperatureTrendDeviation = (Integer)this.data().deepCopy(this.fields()[27].schema(), (Object)other.readinessTemperatureTrendDeviation);
                this.fieldSetFlags()[27] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[28], (Object)other.readinessScoreDelta)) {
                this.readinessScoreDelta = (Integer)this.data().deepCopy(this.fields()[28].schema(), (Object)other.readinessScoreDelta);
                this.fieldSetFlags()[28] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[29], (Object)other.remSleepDuration)) {
                this.remSleepDuration = (Integer)this.data().deepCopy(this.fields()[29].schema(), (Object)other.remSleepDuration);
                this.fieldSetFlags()[29] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[30], (Object)other.restlessPeriods)) {
                this.restlessPeriods = (Integer)this.data().deepCopy(this.fields()[30].schema(), (Object)other.restlessPeriods);
                this.fieldSetFlags()[30] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[31], (Object)other.sleepScoreDelta)) {
                this.sleepScoreDelta = (Integer)this.data().deepCopy(this.fields()[31].schema(), (Object)other.sleepScoreDelta);
                this.fieldSetFlags()[31] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[32], (Object)((Object)other.sleepAlgorithmVersion))) {
                this.sleepAlgorithmVersion = (OuraSleepAlgorithmVersion)((Object)this.data().deepCopy(this.fields()[32].schema(), (Object)other.sleepAlgorithmVersion));
                this.fieldSetFlags()[32] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[33], (Object)other.timeInBed)) {
                this.timeInBed = (Integer)this.data().deepCopy(this.fields()[33].schema(), (Object)other.timeInBed);
                this.fieldSetFlags()[33] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[34], (Object)other.totalSleepDuration)) {
                this.totalSleepDuration = (Integer)this.data().deepCopy(this.fields()[34].schema(), (Object)other.totalSleepDuration);
                this.fieldSetFlags()[34] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[35], (Object)((Object)other.type))) {
                this.type = (OuraSleepType)((Object)this.data().deepCopy(this.fields()[35].schema(), (Object)other.type));
                this.fieldSetFlags()[35] = true;
            }
        }

        public double getTime() {
            return this.time;
        }

        public Builder setTime(double value) {
            this.validate(this.fields()[0], value);
            this.time = value;
            this.fieldSetFlags()[0] = true;
            return this;
        }

        public boolean hasTime() {
            return this.fieldSetFlags()[0];
        }

        public Builder clearTime() {
            this.fieldSetFlags()[0] = false;
            return this;
        }

        public double getTimeReceived() {
            return this.timeReceived;
        }

        public Builder setTimeReceived(double value) {
            this.validate(this.fields()[1], value);
            this.timeReceived = value;
            this.fieldSetFlags()[1] = true;
            return this;
        }

        public boolean hasTimeReceived() {
            return this.fieldSetFlags()[1];
        }

        public Builder clearTimeReceived() {
            this.fieldSetFlags()[1] = false;
            return this;
        }

        public String getId() {
            return this.id;
        }

        public Builder setId(String value) {
            this.validate(this.fields()[2], value);
            this.id = value;
            this.fieldSetFlags()[2] = true;
            return this;
        }

        public boolean hasId() {
            return this.fieldSetFlags()[2];
        }

        public Builder clearId() {
            this.id = null;
            this.fieldSetFlags()[2] = false;
            return this;
        }

        public Float getAverageBreath() {
            return this.averageBreath;
        }

        public Builder setAverageBreath(Float value) {
            this.validate(this.fields()[3], value);
            this.averageBreath = value;
            this.fieldSetFlags()[3] = true;
            return this;
        }

        public boolean hasAverageBreath() {
            return this.fieldSetFlags()[3];
        }

        public Builder clearAverageBreath() {
            this.averageBreath = null;
            this.fieldSetFlags()[3] = false;
            return this;
        }

        public Float getAverageHeartRate() {
            return this.averageHeartRate;
        }

        public Builder setAverageHeartRate(Float value) {
            this.validate(this.fields()[4], value);
            this.averageHeartRate = value;
            this.fieldSetFlags()[4] = true;
            return this;
        }

        public boolean hasAverageHeartRate() {
            return this.fieldSetFlags()[4];
        }

        public Builder clearAverageHeartRate() {
            this.averageHeartRate = null;
            this.fieldSetFlags()[4] = false;
            return this;
        }

        public Integer getAverageHrv() {
            return this.averageHrv;
        }

        public Builder setAverageHrv(Integer value) {
            this.validate(this.fields()[5], value);
            this.averageHrv = value;
            this.fieldSetFlags()[5] = true;
            return this;
        }

        public boolean hasAverageHrv() {
            return this.fieldSetFlags()[5];
        }

        public Builder clearAverageHrv() {
            this.averageHrv = null;
            this.fieldSetFlags()[5] = false;
            return this;
        }

        public Integer getAwakeTime() {
            return this.awakeTime;
        }

        public Builder setAwakeTime(Integer value) {
            this.validate(this.fields()[6], value);
            this.awakeTime = value;
            this.fieldSetFlags()[6] = true;
            return this;
        }

        public boolean hasAwakeTime() {
            return this.fieldSetFlags()[6];
        }

        public Builder clearAwakeTime() {
            this.awakeTime = null;
            this.fieldSetFlags()[6] = false;
            return this;
        }

        public String getBedtimeEnd() {
            return this.bedtimeEnd;
        }

        public Builder setBedtimeEnd(String value) {
            this.validate(this.fields()[7], value);
            this.bedtimeEnd = value;
            this.fieldSetFlags()[7] = true;
            return this;
        }

        public boolean hasBedtimeEnd() {
            return this.fieldSetFlags()[7];
        }

        public Builder clearBedtimeEnd() {
            this.bedtimeEnd = null;
            this.fieldSetFlags()[7] = false;
            return this;
        }

        public String getBedtimeStart() {
            return this.bedtimeStart;
        }

        public Builder setBedtimeStart(String value) {
            this.validate(this.fields()[8], value);
            this.bedtimeStart = value;
            this.fieldSetFlags()[8] = true;
            return this;
        }

        public boolean hasBedtimeStart() {
            return this.fieldSetFlags()[8];
        }

        public Builder clearBedtimeStart() {
            this.bedtimeStart = null;
            this.fieldSetFlags()[8] = false;
            return this;
        }

        public String getDay() {
            return this.day;
        }

        public Builder setDay(String value) {
            this.validate(this.fields()[9], value);
            this.day = value;
            this.fieldSetFlags()[9] = true;
            return this;
        }

        public boolean hasDay() {
            return this.fieldSetFlags()[9];
        }

        public Builder clearDay() {
            this.day = null;
            this.fieldSetFlags()[9] = false;
            return this;
        }

        public Integer getDeepSleepDuration() {
            return this.deepSleepDuration;
        }

        public Builder setDeepSleepDuration(Integer value) {
            this.validate(this.fields()[10], value);
            this.deepSleepDuration = value;
            this.fieldSetFlags()[10] = true;
            return this;
        }

        public boolean hasDeepSleepDuration() {
            return this.fieldSetFlags()[10];
        }

        public Builder clearDeepSleepDuration() {
            this.deepSleepDuration = null;
            this.fieldSetFlags()[10] = false;
            return this;
        }

        public Integer getEfficiency() {
            return this.efficiency;
        }

        public Builder setEfficiency(Integer value) {
            this.validate(this.fields()[11], value);
            this.efficiency = value;
            this.fieldSetFlags()[11] = true;
            return this;
        }

        public boolean hasEfficiency() {
            return this.fieldSetFlags()[11];
        }

        public Builder clearEfficiency() {
            this.efficiency = null;
            this.fieldSetFlags()[11] = false;
            return this;
        }

        public Integer getLatency() {
            return this.latency;
        }

        public Builder setLatency(Integer value) {
            this.validate(this.fields()[12], value);
            this.latency = value;
            this.fieldSetFlags()[12] = true;
            return this;
        }

        public boolean hasLatency() {
            return this.fieldSetFlags()[12];
        }

        public Builder clearLatency() {
            this.latency = null;
            this.fieldSetFlags()[12] = false;
            return this;
        }

        public Integer getLightSleepDuration() {
            return this.lightSleepDuration;
        }

        public Builder setLightSleepDuration(Integer value) {
            this.validate(this.fields()[13], value);
            this.lightSleepDuration = value;
            this.fieldSetFlags()[13] = true;
            return this;
        }

        public boolean hasLightSleepDuration() {
            return this.fieldSetFlags()[13];
        }

        public Builder clearLightSleepDuration() {
            this.lightSleepDuration = null;
            this.fieldSetFlags()[13] = false;
            return this;
        }

        public Boolean getLowBatteryAlert() {
            return this.lowBatteryAlert;
        }

        public Builder setLowBatteryAlert(Boolean value) {
            this.validate(this.fields()[14], value);
            this.lowBatteryAlert = value;
            this.fieldSetFlags()[14] = true;
            return this;
        }

        public boolean hasLowBatteryAlert() {
            return this.fieldSetFlags()[14];
        }

        public Builder clearLowBatteryAlert() {
            this.lowBatteryAlert = null;
            this.fieldSetFlags()[14] = false;
            return this;
        }

        public Integer getLowestHeartRate() {
            return this.lowestHeartRate;
        }

        public Builder setLowestHeartRate(Integer value) {
            this.validate(this.fields()[15], value);
            this.lowestHeartRate = value;
            this.fieldSetFlags()[15] = true;
            return this;
        }

        public boolean hasLowestHeartRate() {
            return this.fieldSetFlags()[15];
        }

        public Builder clearLowestHeartRate() {
            this.lowestHeartRate = null;
            this.fieldSetFlags()[15] = false;
            return this;
        }

        public Integer getPeriod() {
            return this.period;
        }

        public Builder setPeriod(Integer value) {
            this.validate(this.fields()[16], value);
            this.period = value;
            this.fieldSetFlags()[16] = true;
            return this;
        }

        public boolean hasPeriod() {
            return this.fieldSetFlags()[16];
        }

        public Builder clearPeriod() {
            this.period = null;
            this.fieldSetFlags()[16] = false;
            return this;
        }

        public Integer getReadinessContributorActivityBalance() {
            return this.readinessContributorActivityBalance;
        }

        public Builder setReadinessContributorActivityBalance(Integer value) {
            this.validate(this.fields()[17], value);
            this.readinessContributorActivityBalance = value;
            this.fieldSetFlags()[17] = true;
            return this;
        }

        public boolean hasReadinessContributorActivityBalance() {
            return this.fieldSetFlags()[17];
        }

        public Builder clearReadinessContributorActivityBalance() {
            this.readinessContributorActivityBalance = null;
            this.fieldSetFlags()[17] = false;
            return this;
        }

        public Integer getReadinessContributorBodyTemperature() {
            return this.readinessContributorBodyTemperature;
        }

        public Builder setReadinessContributorBodyTemperature(Integer value) {
            this.validate(this.fields()[18], value);
            this.readinessContributorBodyTemperature = value;
            this.fieldSetFlags()[18] = true;
            return this;
        }

        public boolean hasReadinessContributorBodyTemperature() {
            return this.fieldSetFlags()[18];
        }

        public Builder clearReadinessContributorBodyTemperature() {
            this.readinessContributorBodyTemperature = null;
            this.fieldSetFlags()[18] = false;
            return this;
        }

        public Integer getReadinessContributorHrvBalance() {
            return this.readinessContributorHrvBalance;
        }

        public Builder setReadinessContributorHrvBalance(Integer value) {
            this.validate(this.fields()[19], value);
            this.readinessContributorHrvBalance = value;
            this.fieldSetFlags()[19] = true;
            return this;
        }

        public boolean hasReadinessContributorHrvBalance() {
            return this.fieldSetFlags()[19];
        }

        public Builder clearReadinessContributorHrvBalance() {
            this.readinessContributorHrvBalance = null;
            this.fieldSetFlags()[19] = false;
            return this;
        }

        public Integer getReadinessContributorPreviousDayActivity() {
            return this.readinessContributorPreviousDayActivity;
        }

        public Builder setReadinessContributorPreviousDayActivity(Integer value) {
            this.validate(this.fields()[20], value);
            this.readinessContributorPreviousDayActivity = value;
            this.fieldSetFlags()[20] = true;
            return this;
        }

        public boolean hasReadinessContributorPreviousDayActivity() {
            return this.fieldSetFlags()[20];
        }

        public Builder clearReadinessContributorPreviousDayActivity() {
            this.readinessContributorPreviousDayActivity = null;
            this.fieldSetFlags()[20] = false;
            return this;
        }

        public Integer getReadinessContributorPreviousNight() {
            return this.readinessContributorPreviousNight;
        }

        public Builder setReadinessContributorPreviousNight(Integer value) {
            this.validate(this.fields()[21], value);
            this.readinessContributorPreviousNight = value;
            this.fieldSetFlags()[21] = true;
            return this;
        }

        public boolean hasReadinessContributorPreviousNight() {
            return this.fieldSetFlags()[21];
        }

        public Builder clearReadinessContributorPreviousNight() {
            this.readinessContributorPreviousNight = null;
            this.fieldSetFlags()[21] = false;
            return this;
        }

        public Integer getReadinessContributorRecoveryIndex() {
            return this.readinessContributorRecoveryIndex;
        }

        public Builder setReadinessContributorRecoveryIndex(Integer value) {
            this.validate(this.fields()[22], value);
            this.readinessContributorRecoveryIndex = value;
            this.fieldSetFlags()[22] = true;
            return this;
        }

        public boolean hasReadinessContributorRecoveryIndex() {
            return this.fieldSetFlags()[22];
        }

        public Builder clearReadinessContributorRecoveryIndex() {
            this.readinessContributorRecoveryIndex = null;
            this.fieldSetFlags()[22] = false;
            return this;
        }

        public Integer getReadinessContributorRestingHeartRate() {
            return this.readinessContributorRestingHeartRate;
        }

        public Builder setReadinessContributorRestingHeartRate(Integer value) {
            this.validate(this.fields()[23], value);
            this.readinessContributorRestingHeartRate = value;
            this.fieldSetFlags()[23] = true;
            return this;
        }

        public boolean hasReadinessContributorRestingHeartRate() {
            return this.fieldSetFlags()[23];
        }

        public Builder clearReadinessContributorRestingHeartRate() {
            this.readinessContributorRestingHeartRate = null;
            this.fieldSetFlags()[23] = false;
            return this;
        }

        public Integer getReadinessContributorSleepBalance() {
            return this.readinessContributorSleepBalance;
        }

        public Builder setReadinessContributorSleepBalance(Integer value) {
            this.validate(this.fields()[24], value);
            this.readinessContributorSleepBalance = value;
            this.fieldSetFlags()[24] = true;
            return this;
        }

        public boolean hasReadinessContributorSleepBalance() {
            return this.fieldSetFlags()[24];
        }

        public Builder clearReadinessContributorSleepBalance() {
            this.readinessContributorSleepBalance = null;
            this.fieldSetFlags()[24] = false;
            return this;
        }

        public Integer getReadinessScore() {
            return this.readinessScore;
        }

        public Builder setReadinessScore(Integer value) {
            this.validate(this.fields()[25], value);
            this.readinessScore = value;
            this.fieldSetFlags()[25] = true;
            return this;
        }

        public boolean hasReadinessScore() {
            return this.fieldSetFlags()[25];
        }

        public Builder clearReadinessScore() {
            this.readinessScore = null;
            this.fieldSetFlags()[25] = false;
            return this;
        }

        public Integer getReadinessTemperatureDeviation() {
            return this.readinessTemperatureDeviation;
        }

        public Builder setReadinessTemperatureDeviation(Integer value) {
            this.validate(this.fields()[26], value);
            this.readinessTemperatureDeviation = value;
            this.fieldSetFlags()[26] = true;
            return this;
        }

        public boolean hasReadinessTemperatureDeviation() {
            return this.fieldSetFlags()[26];
        }

        public Builder clearReadinessTemperatureDeviation() {
            this.readinessTemperatureDeviation = null;
            this.fieldSetFlags()[26] = false;
            return this;
        }

        public Integer getReadinessTemperatureTrendDeviation() {
            return this.readinessTemperatureTrendDeviation;
        }

        public Builder setReadinessTemperatureTrendDeviation(Integer value) {
            this.validate(this.fields()[27], value);
            this.readinessTemperatureTrendDeviation = value;
            this.fieldSetFlags()[27] = true;
            return this;
        }

        public boolean hasReadinessTemperatureTrendDeviation() {
            return this.fieldSetFlags()[27];
        }

        public Builder clearReadinessTemperatureTrendDeviation() {
            this.readinessTemperatureTrendDeviation = null;
            this.fieldSetFlags()[27] = false;
            return this;
        }

        public Integer getReadinessScoreDelta() {
            return this.readinessScoreDelta;
        }

        public Builder setReadinessScoreDelta(Integer value) {
            this.validate(this.fields()[28], value);
            this.readinessScoreDelta = value;
            this.fieldSetFlags()[28] = true;
            return this;
        }

        public boolean hasReadinessScoreDelta() {
            return this.fieldSetFlags()[28];
        }

        public Builder clearReadinessScoreDelta() {
            this.readinessScoreDelta = null;
            this.fieldSetFlags()[28] = false;
            return this;
        }

        public Integer getRemSleepDuration() {
            return this.remSleepDuration;
        }

        public Builder setRemSleepDuration(Integer value) {
            this.validate(this.fields()[29], value);
            this.remSleepDuration = value;
            this.fieldSetFlags()[29] = true;
            return this;
        }

        public boolean hasRemSleepDuration() {
            return this.fieldSetFlags()[29];
        }

        public Builder clearRemSleepDuration() {
            this.remSleepDuration = null;
            this.fieldSetFlags()[29] = false;
            return this;
        }

        public Integer getRestlessPeriods() {
            return this.restlessPeriods;
        }

        public Builder setRestlessPeriods(Integer value) {
            this.validate(this.fields()[30], value);
            this.restlessPeriods = value;
            this.fieldSetFlags()[30] = true;
            return this;
        }

        public boolean hasRestlessPeriods() {
            return this.fieldSetFlags()[30];
        }

        public Builder clearRestlessPeriods() {
            this.restlessPeriods = null;
            this.fieldSetFlags()[30] = false;
            return this;
        }

        public Integer getSleepScoreDelta() {
            return this.sleepScoreDelta;
        }

        public Builder setSleepScoreDelta(Integer value) {
            this.validate(this.fields()[31], value);
            this.sleepScoreDelta = value;
            this.fieldSetFlags()[31] = true;
            return this;
        }

        public boolean hasSleepScoreDelta() {
            return this.fieldSetFlags()[31];
        }

        public Builder clearSleepScoreDelta() {
            this.sleepScoreDelta = null;
            this.fieldSetFlags()[31] = false;
            return this;
        }

        public OuraSleepAlgorithmVersion getSleepAlgorithmVersion() {
            return this.sleepAlgorithmVersion;
        }

        public Builder setSleepAlgorithmVersion(OuraSleepAlgorithmVersion value) {
            this.validate(this.fields()[32], (Object)value);
            this.sleepAlgorithmVersion = value;
            this.fieldSetFlags()[32] = true;
            return this;
        }

        public boolean hasSleepAlgorithmVersion() {
            return this.fieldSetFlags()[32];
        }

        public Builder clearSleepAlgorithmVersion() {
            this.sleepAlgorithmVersion = null;
            this.fieldSetFlags()[32] = false;
            return this;
        }

        public Integer getTimeInBed() {
            return this.timeInBed;
        }

        public Builder setTimeInBed(Integer value) {
            this.validate(this.fields()[33], value);
            this.timeInBed = value;
            this.fieldSetFlags()[33] = true;
            return this;
        }

        public boolean hasTimeInBed() {
            return this.fieldSetFlags()[33];
        }

        public Builder clearTimeInBed() {
            this.timeInBed = null;
            this.fieldSetFlags()[33] = false;
            return this;
        }

        public Integer getTotalSleepDuration() {
            return this.totalSleepDuration;
        }

        public Builder setTotalSleepDuration(Integer value) {
            this.validate(this.fields()[34], value);
            this.totalSleepDuration = value;
            this.fieldSetFlags()[34] = true;
            return this;
        }

        public boolean hasTotalSleepDuration() {
            return this.fieldSetFlags()[34];
        }

        public Builder clearTotalSleepDuration() {
            this.totalSleepDuration = null;
            this.fieldSetFlags()[34] = false;
            return this;
        }

        public OuraSleepType getType() {
            return this.type;
        }

        public Builder setType(OuraSleepType value) {
            this.validate(this.fields()[35], (Object)value);
            this.type = value;
            this.fieldSetFlags()[35] = true;
            return this;
        }

        public boolean hasType() {
            return this.fieldSetFlags()[35];
        }

        public Builder clearType() {
            this.type = null;
            this.fieldSetFlags()[35] = false;
            return this;
        }

        public OuraSleep build() {
            try {
                OuraSleep record = new OuraSleep();
                record.time = this.fieldSetFlags()[0] ? this.time : (Double)this.defaultValue(this.fields()[0]);
                record.timeReceived = this.fieldSetFlags()[1] ? this.timeReceived : (Double)this.defaultValue(this.fields()[1]);
                record.id = this.fieldSetFlags()[2] ? this.id : (String)this.defaultValue(this.fields()[2]);
                record.averageBreath = this.fieldSetFlags()[3] ? this.averageBreath : (Float)this.defaultValue(this.fields()[3]);
                record.averageHeartRate = this.fieldSetFlags()[4] ? this.averageHeartRate : (Float)this.defaultValue(this.fields()[4]);
                record.averageHrv = this.fieldSetFlags()[5] ? this.averageHrv : (Integer)this.defaultValue(this.fields()[5]);
                record.awakeTime = this.fieldSetFlags()[6] ? this.awakeTime : (Integer)this.defaultValue(this.fields()[6]);
                record.bedtimeEnd = this.fieldSetFlags()[7] ? this.bedtimeEnd : (String)this.defaultValue(this.fields()[7]);
                record.bedtimeStart = this.fieldSetFlags()[8] ? this.bedtimeStart : (String)this.defaultValue(this.fields()[8]);
                record.day = this.fieldSetFlags()[9] ? this.day : (String)this.defaultValue(this.fields()[9]);
                record.deepSleepDuration = this.fieldSetFlags()[10] ? this.deepSleepDuration : (Integer)this.defaultValue(this.fields()[10]);
                record.efficiency = this.fieldSetFlags()[11] ? this.efficiency : (Integer)this.defaultValue(this.fields()[11]);
                record.latency = this.fieldSetFlags()[12] ? this.latency : (Integer)this.defaultValue(this.fields()[12]);
                record.lightSleepDuration = this.fieldSetFlags()[13] ? this.lightSleepDuration : (Integer)this.defaultValue(this.fields()[13]);
                record.lowBatteryAlert = this.fieldSetFlags()[14] ? this.lowBatteryAlert : (Boolean)this.defaultValue(this.fields()[14]);
                record.lowestHeartRate = this.fieldSetFlags()[15] ? this.lowestHeartRate : (Integer)this.defaultValue(this.fields()[15]);
                record.period = this.fieldSetFlags()[16] ? this.period : (Integer)this.defaultValue(this.fields()[16]);
                record.readinessContributorActivityBalance = this.fieldSetFlags()[17] ? this.readinessContributorActivityBalance : (Integer)this.defaultValue(this.fields()[17]);
                record.readinessContributorBodyTemperature = this.fieldSetFlags()[18] ? this.readinessContributorBodyTemperature : (Integer)this.defaultValue(this.fields()[18]);
                record.readinessContributorHrvBalance = this.fieldSetFlags()[19] ? this.readinessContributorHrvBalance : (Integer)this.defaultValue(this.fields()[19]);
                record.readinessContributorPreviousDayActivity = this.fieldSetFlags()[20] ? this.readinessContributorPreviousDayActivity : (Integer)this.defaultValue(this.fields()[20]);
                record.readinessContributorPreviousNight = this.fieldSetFlags()[21] ? this.readinessContributorPreviousNight : (Integer)this.defaultValue(this.fields()[21]);
                record.readinessContributorRecoveryIndex = this.fieldSetFlags()[22] ? this.readinessContributorRecoveryIndex : (Integer)this.defaultValue(this.fields()[22]);
                record.readinessContributorRestingHeartRate = this.fieldSetFlags()[23] ? this.readinessContributorRestingHeartRate : (Integer)this.defaultValue(this.fields()[23]);
                record.readinessContributorSleepBalance = this.fieldSetFlags()[24] ? this.readinessContributorSleepBalance : (Integer)this.defaultValue(this.fields()[24]);
                record.readinessScore = this.fieldSetFlags()[25] ? this.readinessScore : (Integer)this.defaultValue(this.fields()[25]);
                record.readinessTemperatureDeviation = this.fieldSetFlags()[26] ? this.readinessTemperatureDeviation : (Integer)this.defaultValue(this.fields()[26]);
                record.readinessTemperatureTrendDeviation = this.fieldSetFlags()[27] ? this.readinessTemperatureTrendDeviation : (Integer)this.defaultValue(this.fields()[27]);
                record.readinessScoreDelta = this.fieldSetFlags()[28] ? this.readinessScoreDelta : (Integer)this.defaultValue(this.fields()[28]);
                record.remSleepDuration = this.fieldSetFlags()[29] ? this.remSleepDuration : (Integer)this.defaultValue(this.fields()[29]);
                record.restlessPeriods = this.fieldSetFlags()[30] ? this.restlessPeriods : (Integer)this.defaultValue(this.fields()[30]);
                record.sleepScoreDelta = this.fieldSetFlags()[31] ? this.sleepScoreDelta : (Integer)this.defaultValue(this.fields()[31]);
                record.sleepAlgorithmVersion = this.fieldSetFlags()[32] ? this.sleepAlgorithmVersion : (OuraSleepAlgorithmVersion)((Object)this.defaultValue(this.fields()[32]));
                record.timeInBed = this.fieldSetFlags()[33] ? this.timeInBed : (Integer)this.defaultValue(this.fields()[33]);
                record.totalSleepDuration = this.fieldSetFlags()[34] ? this.totalSleepDuration : (Integer)this.defaultValue(this.fields()[34]);
                record.type = this.fieldSetFlags()[35] ? this.type : (OuraSleepType)((Object)this.defaultValue(this.fields()[35]));
                return record;
            }
            catch (AvroMissingFieldException e) {
                throw e;
            }
            catch (Exception e) {
                throw new AvroRuntimeException((Throwable)e);
            }
        }
    }
}

