/*
 * Decompiled with CFR 0.152.
 */
package org.radarcns.connector.oura;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.nio.ByteBuffer;
import org.apache.avro.AvroMissingFieldException;
import org.apache.avro.AvroRuntimeException;
import org.apache.avro.Schema;
import org.apache.avro.data.RecordBuilder;
import org.apache.avro.generic.GenericData;
import org.apache.avro.io.DatumReader;
import org.apache.avro.io.DatumWriter;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.Encoder;
import org.apache.avro.io.ResolvingDecoder;
import org.apache.avro.message.BinaryMessageDecoder;
import org.apache.avro.message.BinaryMessageEncoder;
import org.apache.avro.message.SchemaStore;
import org.apache.avro.specific.AvroGenerated;
import org.apache.avro.specific.SpecificData;
import org.apache.avro.specific.SpecificRecord;
import org.apache.avro.specific.SpecificRecordBase;
import org.apache.avro.specific.SpecificRecordBuilderBase;
import org.radarcns.connector.oura.OuraRingColor;
import org.radarcns.connector.oura.OuraRingDesign;
import org.radarcns.connector.oura.OuraRingHardwareType;

@AvroGenerated
public class OuraRingConfiguration
extends SpecificRecordBase
implements SpecificRecord {
    private static final long serialVersionUID = -2881361237463501524L;
    public static final Schema SCHEMA$ = new Schema.Parser().parse("{\"type\":\"record\",\"name\":\"OuraRingConfiguration\",\"namespace\":\"org.radarcns.connector.oura\",\"doc\":\"The Ring Configuration scope includes information about the user's ring(s). This includes the model, size, color, etc.\",\"fields\":[{\"name\":\"time\",\"type\":\"double\",\"doc\":\"Timestamp of the record in seconds since January 1, 1970, 00:00:00 UTC (Unix timestamp).\"},{\"name\":\"timeReceived\",\"type\":\"double\",\"doc\":\"Time that this record was collected by a service in seconds since the Unix Epoch (s).\"},{\"name\":\"id\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"doc\":\"Unique identifier of the ring configuration from Oura.\",\"default\":null},{\"name\":\"color\",\"type\":{\"type\":\"enum\",\"name\":\"OuraRingColor\",\"doc\":\"Oura ring colors.\",\"symbols\":[\"GLOSSY_BLACK\",\"STEALTH_BLACK\",\"ROSE\",\"SILVER\",\"GLOSSY_GOLD\",\"UNKNOWN\"]},\"doc\":\"Oura ring color.\",\"default\":\"UNKNOWN\"},{\"name\":\"design\",\"type\":{\"type\":\"enum\",\"name\":\"OuraRingDesign\",\"doc\":\"Oura ring designs.\",\"symbols\":[\"HERITAGE\",\"HORIZON\",\"UNKNOWN\"]},\"doc\":\"Oura ring design.\",\"default\":\"UNKNOWN\"},{\"name\":\"firmwareVersion\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"doc\":\"Firmware version of the ring. Null if unknown.\",\"default\":null},{\"name\":\"hardwareType\",\"type\":{\"type\":\"enum\",\"name\":\"OuraRingHardwareType\",\"doc\":\"Oura ring hardware type.\",\"symbols\":[\"GEN1\",\"GEN2\",\"GEN2M\",\"GEN3\",\"UNKNOWN\"]},\"doc\":\"Oura ring hardware types.\",\"default\":\"UNKNOWN\"},{\"name\":\"setUpAt\",\"type\":[\"null\",\"double\"],\"doc\":\"Timestamp indicating when the ring was set up. Null if unknown.\",\"default\":null},{\"name\":\"size\",\"type\":[\"null\",\"int\"],\"doc\":\"US size of the Oura ring. Null if unknown.\",\"default\":null}]}");
    private static final SpecificData MODEL$ = new SpecificData();
    private static final BinaryMessageEncoder<OuraRingConfiguration> ENCODER = new BinaryMessageEncoder((GenericData)MODEL$, SCHEMA$);
    private static final BinaryMessageDecoder<OuraRingConfiguration> DECODER = new BinaryMessageDecoder((GenericData)MODEL$, SCHEMA$);
    private double time;
    private double timeReceived;
    private String id;
    private OuraRingColor color;
    private OuraRingDesign design;
    private String firmwareVersion;
    private OuraRingHardwareType hardwareType;
    private Double setUpAt;
    private Integer size;
    private static final DatumWriter<OuraRingConfiguration> WRITER$ = MODEL$.createDatumWriter(SCHEMA$);
    private static final DatumReader<OuraRingConfiguration> READER$ = MODEL$.createDatumReader(SCHEMA$);

    public static Schema getClassSchema() {
        return SCHEMA$;
    }

    public static BinaryMessageEncoder<OuraRingConfiguration> getEncoder() {
        return ENCODER;
    }

    public static BinaryMessageDecoder<OuraRingConfiguration> getDecoder() {
        return DECODER;
    }

    public static BinaryMessageDecoder<OuraRingConfiguration> createDecoder(SchemaStore resolver) {
        return new BinaryMessageDecoder((GenericData)MODEL$, SCHEMA$, resolver);
    }

    public ByteBuffer toByteBuffer() throws IOException {
        return ENCODER.encode((Object)this);
    }

    public static OuraRingConfiguration fromByteBuffer(ByteBuffer b) throws IOException {
        return (OuraRingConfiguration)((Object)DECODER.decode(b));
    }

    public OuraRingConfiguration() {
    }

    public OuraRingConfiguration(Double time, Double timeReceived, String id, OuraRingColor color, OuraRingDesign design, String firmwareVersion, OuraRingHardwareType hardwareType, Double setUpAt, Integer size) {
        this.time = time;
        this.timeReceived = timeReceived;
        this.id = id;
        this.color = color;
        this.design = design;
        this.firmwareVersion = firmwareVersion;
        this.hardwareType = hardwareType;
        this.setUpAt = setUpAt;
        this.size = size;
    }

    public SpecificData getSpecificData() {
        return MODEL$;
    }

    public Schema getSchema() {
        return SCHEMA$;
    }

    public Object get(int field$) {
        switch (field$) {
            case 0: {
                return this.time;
            }
            case 1: {
                return this.timeReceived;
            }
            case 2: {
                return this.id;
            }
            case 3: {
                return this.color;
            }
            case 4: {
                return this.design;
            }
            case 5: {
                return this.firmwareVersion;
            }
            case 6: {
                return this.hardwareType;
            }
            case 7: {
                return this.setUpAt;
            }
            case 8: {
                return this.size;
            }
        }
        throw new IndexOutOfBoundsException("Invalid index: " + field$);
    }

    public void put(int field$, Object value$) {
        switch (field$) {
            case 0: {
                this.time = (Double)value$;
                break;
            }
            case 1: {
                this.timeReceived = (Double)value$;
                break;
            }
            case 2: {
                this.id = value$ != null ? value$.toString() : null;
                break;
            }
            case 3: {
                this.color = (OuraRingColor)((Object)value$);
                break;
            }
            case 4: {
                this.design = (OuraRingDesign)((Object)value$);
                break;
            }
            case 5: {
                this.firmwareVersion = value$ != null ? value$.toString() : null;
                break;
            }
            case 6: {
                this.hardwareType = (OuraRingHardwareType)((Object)value$);
                break;
            }
            case 7: {
                this.setUpAt = (Double)value$;
                break;
            }
            case 8: {
                this.size = (Integer)value$;
                break;
            }
            default: {
                throw new IndexOutOfBoundsException("Invalid index: " + field$);
            }
        }
    }

    public double getTime() {
        return this.time;
    }

    public void setTime(double value) {
        this.time = value;
    }

    public double getTimeReceived() {
        return this.timeReceived;
    }

    public void setTimeReceived(double value) {
        this.timeReceived = value;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String value) {
        this.id = value;
    }

    public OuraRingColor getColor() {
        return this.color;
    }

    public void setColor(OuraRingColor value) {
        this.color = value;
    }

    public OuraRingDesign getDesign() {
        return this.design;
    }

    public void setDesign(OuraRingDesign value) {
        this.design = value;
    }

    public String getFirmwareVersion() {
        return this.firmwareVersion;
    }

    public void setFirmwareVersion(String value) {
        this.firmwareVersion = value;
    }

    public OuraRingHardwareType getHardwareType() {
        return this.hardwareType;
    }

    public void setHardwareType(OuraRingHardwareType value) {
        this.hardwareType = value;
    }

    public Double getSetUpAt() {
        return this.setUpAt;
    }

    public void setSetUpAt(Double value) {
        this.setUpAt = value;
    }

    public Integer getSize() {
        return this.size;
    }

    public void setSize(Integer value) {
        this.size = value;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newBuilder(Builder other) {
        if (other == null) {
            return new Builder();
        }
        return new Builder(other);
    }

    public static Builder newBuilder(OuraRingConfiguration other) {
        if (other == null) {
            return new Builder();
        }
        return new Builder(other);
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        WRITER$.write((Object)this, (Encoder)SpecificData.getEncoder((ObjectOutput)out));
    }

    public void readExternal(ObjectInput in) throws IOException {
        READER$.read((Object)this, (Decoder)SpecificData.getDecoder((ObjectInput)in));
    }

    protected boolean hasCustomCoders() {
        return true;
    }

    public void customEncode(Encoder out) throws IOException {
        out.writeDouble(this.time);
        out.writeDouble(this.timeReceived);
        if (this.id == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeString(this.id);
        }
        out.writeEnum(this.color.ordinal());
        out.writeEnum(this.design.ordinal());
        if (this.firmwareVersion == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeString(this.firmwareVersion);
        }
        out.writeEnum(this.hardwareType.ordinal());
        if (this.setUpAt == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeDouble(this.setUpAt.doubleValue());
        }
        if (this.size == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeInt(this.size.intValue());
        }
    }

    public void customDecode(ResolvingDecoder in) throws IOException {
        Schema.Field[] fieldOrder = in.readFieldOrderIfDiff();
        if (fieldOrder == null) {
            this.time = in.readDouble();
            this.timeReceived = in.readDouble();
            if (in.readIndex() != 1) {
                in.readNull();
                this.id = null;
            } else {
                this.id = in.readString();
            }
            this.color = OuraRingColor.values()[in.readEnum()];
            this.design = OuraRingDesign.values()[in.readEnum()];
            if (in.readIndex() != 1) {
                in.readNull();
                this.firmwareVersion = null;
            } else {
                this.firmwareVersion = in.readString();
            }
            this.hardwareType = OuraRingHardwareType.values()[in.readEnum()];
            if (in.readIndex() != 1) {
                in.readNull();
                this.setUpAt = null;
            } else {
                this.setUpAt = in.readDouble();
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.size = null;
            } else {
                this.size = in.readInt();
            }
        } else {
            block11: for (int i = 0; i < 9; ++i) {
                switch (fieldOrder[i].pos()) {
                    case 0: {
                        this.time = in.readDouble();
                        continue block11;
                    }
                    case 1: {
                        this.timeReceived = in.readDouble();
                        continue block11;
                    }
                    case 2: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.id = null;
                            continue block11;
                        }
                        this.id = in.readString();
                        continue block11;
                    }
                    case 3: {
                        this.color = OuraRingColor.values()[in.readEnum()];
                        continue block11;
                    }
                    case 4: {
                        this.design = OuraRingDesign.values()[in.readEnum()];
                        continue block11;
                    }
                    case 5: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.firmwareVersion = null;
                            continue block11;
                        }
                        this.firmwareVersion = in.readString();
                        continue block11;
                    }
                    case 6: {
                        this.hardwareType = OuraRingHardwareType.values()[in.readEnum()];
                        continue block11;
                    }
                    case 7: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.setUpAt = null;
                            continue block11;
                        }
                        this.setUpAt = in.readDouble();
                        continue block11;
                    }
                    case 8: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.size = null;
                            continue block11;
                        }
                        this.size = in.readInt();
                        continue block11;
                    }
                    default: {
                        throw new IOException("Corrupt ResolvingDecoder.");
                    }
                }
            }
        }
    }

    @AvroGenerated
    public static class Builder
    extends SpecificRecordBuilderBase<OuraRingConfiguration>
    implements RecordBuilder<OuraRingConfiguration> {
        private double time;
        private double timeReceived;
        private String id;
        private OuraRingColor color;
        private OuraRingDesign design;
        private String firmwareVersion;
        private OuraRingHardwareType hardwareType;
        private Double setUpAt;
        private Integer size;

        private Builder() {
            super(SCHEMA$, MODEL$);
        }

        private Builder(Builder other) {
            super((SpecificRecordBuilderBase)other);
            if (Builder.isValidValue((Schema.Field)this.fields()[0], (Object)other.time)) {
                this.time = (Double)this.data().deepCopy(this.fields()[0].schema(), (Object)other.time);
                this.fieldSetFlags()[0] = other.fieldSetFlags()[0];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[1], (Object)other.timeReceived)) {
                this.timeReceived = (Double)this.data().deepCopy(this.fields()[1].schema(), (Object)other.timeReceived);
                this.fieldSetFlags()[1] = other.fieldSetFlags()[1];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[2], (Object)other.id)) {
                this.id = (String)this.data().deepCopy(this.fields()[2].schema(), (Object)other.id);
                this.fieldSetFlags()[2] = other.fieldSetFlags()[2];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[3], (Object)((Object)other.color))) {
                this.color = (OuraRingColor)((Object)this.data().deepCopy(this.fields()[3].schema(), (Object)other.color));
                this.fieldSetFlags()[3] = other.fieldSetFlags()[3];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[4], (Object)((Object)other.design))) {
                this.design = (OuraRingDesign)((Object)this.data().deepCopy(this.fields()[4].schema(), (Object)other.design));
                this.fieldSetFlags()[4] = other.fieldSetFlags()[4];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[5], (Object)other.firmwareVersion)) {
                this.firmwareVersion = (String)this.data().deepCopy(this.fields()[5].schema(), (Object)other.firmwareVersion);
                this.fieldSetFlags()[5] = other.fieldSetFlags()[5];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[6], (Object)((Object)other.hardwareType))) {
                this.hardwareType = (OuraRingHardwareType)((Object)this.data().deepCopy(this.fields()[6].schema(), (Object)other.hardwareType));
                this.fieldSetFlags()[6] = other.fieldSetFlags()[6];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[7], (Object)other.setUpAt)) {
                this.setUpAt = (Double)this.data().deepCopy(this.fields()[7].schema(), (Object)other.setUpAt);
                this.fieldSetFlags()[7] = other.fieldSetFlags()[7];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[8], (Object)other.size)) {
                this.size = (Integer)this.data().deepCopy(this.fields()[8].schema(), (Object)other.size);
                this.fieldSetFlags()[8] = other.fieldSetFlags()[8];
            }
        }

        private Builder(OuraRingConfiguration other) {
            super(SCHEMA$, MODEL$);
            if (Builder.isValidValue((Schema.Field)this.fields()[0], (Object)other.time)) {
                this.time = (Double)this.data().deepCopy(this.fields()[0].schema(), (Object)other.time);
                this.fieldSetFlags()[0] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[1], (Object)other.timeReceived)) {
                this.timeReceived = (Double)this.data().deepCopy(this.fields()[1].schema(), (Object)other.timeReceived);
                this.fieldSetFlags()[1] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[2], (Object)other.id)) {
                this.id = (String)this.data().deepCopy(this.fields()[2].schema(), (Object)other.id);
                this.fieldSetFlags()[2] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[3], (Object)((Object)other.color))) {
                this.color = (OuraRingColor)((Object)this.data().deepCopy(this.fields()[3].schema(), (Object)other.color));
                this.fieldSetFlags()[3] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[4], (Object)((Object)other.design))) {
                this.design = (OuraRingDesign)((Object)this.data().deepCopy(this.fields()[4].schema(), (Object)other.design));
                this.fieldSetFlags()[4] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[5], (Object)other.firmwareVersion)) {
                this.firmwareVersion = (String)this.data().deepCopy(this.fields()[5].schema(), (Object)other.firmwareVersion);
                this.fieldSetFlags()[5] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[6], (Object)((Object)other.hardwareType))) {
                this.hardwareType = (OuraRingHardwareType)((Object)this.data().deepCopy(this.fields()[6].schema(), (Object)other.hardwareType));
                this.fieldSetFlags()[6] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[7], (Object)other.setUpAt)) {
                this.setUpAt = (Double)this.data().deepCopy(this.fields()[7].schema(), (Object)other.setUpAt);
                this.fieldSetFlags()[7] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[8], (Object)other.size)) {
                this.size = (Integer)this.data().deepCopy(this.fields()[8].schema(), (Object)other.size);
                this.fieldSetFlags()[8] = true;
            }
        }

        public double getTime() {
            return this.time;
        }

        public Builder setTime(double value) {
            this.validate(this.fields()[0], value);
            this.time = value;
            this.fieldSetFlags()[0] = true;
            return this;
        }

        public boolean hasTime() {
            return this.fieldSetFlags()[0];
        }

        public Builder clearTime() {
            this.fieldSetFlags()[0] = false;
            return this;
        }

        public double getTimeReceived() {
            return this.timeReceived;
        }

        public Builder setTimeReceived(double value) {
            this.validate(this.fields()[1], value);
            this.timeReceived = value;
            this.fieldSetFlags()[1] = true;
            return this;
        }

        public boolean hasTimeReceived() {
            return this.fieldSetFlags()[1];
        }

        public Builder clearTimeReceived() {
            this.fieldSetFlags()[1] = false;
            return this;
        }

        public String getId() {
            return this.id;
        }

        public Builder setId(String value) {
            this.validate(this.fields()[2], value);
            this.id = value;
            this.fieldSetFlags()[2] = true;
            return this;
        }

        public boolean hasId() {
            return this.fieldSetFlags()[2];
        }

        public Builder clearId() {
            this.id = null;
            this.fieldSetFlags()[2] = false;
            return this;
        }

        public OuraRingColor getColor() {
            return this.color;
        }

        public Builder setColor(OuraRingColor value) {
            this.validate(this.fields()[3], (Object)value);
            this.color = value;
            this.fieldSetFlags()[3] = true;
            return this;
        }

        public boolean hasColor() {
            return this.fieldSetFlags()[3];
        }

        public Builder clearColor() {
            this.color = null;
            this.fieldSetFlags()[3] = false;
            return this;
        }

        public OuraRingDesign getDesign() {
            return this.design;
        }

        public Builder setDesign(OuraRingDesign value) {
            this.validate(this.fields()[4], (Object)value);
            this.design = value;
            this.fieldSetFlags()[4] = true;
            return this;
        }

        public boolean hasDesign() {
            return this.fieldSetFlags()[4];
        }

        public Builder clearDesign() {
            this.design = null;
            this.fieldSetFlags()[4] = false;
            return this;
        }

        public String getFirmwareVersion() {
            return this.firmwareVersion;
        }

        public Builder setFirmwareVersion(String value) {
            this.validate(this.fields()[5], value);
            this.firmwareVersion = value;
            this.fieldSetFlags()[5] = true;
            return this;
        }

        public boolean hasFirmwareVersion() {
            return this.fieldSetFlags()[5];
        }

        public Builder clearFirmwareVersion() {
            this.firmwareVersion = null;
            this.fieldSetFlags()[5] = false;
            return this;
        }

        public OuraRingHardwareType getHardwareType() {
            return this.hardwareType;
        }

        public Builder setHardwareType(OuraRingHardwareType value) {
            this.validate(this.fields()[6], (Object)value);
            this.hardwareType = value;
            this.fieldSetFlags()[6] = true;
            return this;
        }

        public boolean hasHardwareType() {
            return this.fieldSetFlags()[6];
        }

        public Builder clearHardwareType() {
            this.hardwareType = null;
            this.fieldSetFlags()[6] = false;
            return this;
        }

        public Double getSetUpAt() {
            return this.setUpAt;
        }

        public Builder setSetUpAt(Double value) {
            this.validate(this.fields()[7], value);
            this.setUpAt = value;
            this.fieldSetFlags()[7] = true;
            return this;
        }

        public boolean hasSetUpAt() {
            return this.fieldSetFlags()[7];
        }

        public Builder clearSetUpAt() {
            this.setUpAt = null;
            this.fieldSetFlags()[7] = false;
            return this;
        }

        public Integer getSize() {
            return this.size;
        }

        public Builder setSize(Integer value) {
            this.validate(this.fields()[8], value);
            this.size = value;
            this.fieldSetFlags()[8] = true;
            return this;
        }

        public boolean hasSize() {
            return this.fieldSetFlags()[8];
        }

        public Builder clearSize() {
            this.size = null;
            this.fieldSetFlags()[8] = false;
            return this;
        }

        public OuraRingConfiguration build() {
            try {
                OuraRingConfiguration record = new OuraRingConfiguration();
                record.time = this.fieldSetFlags()[0] ? this.time : (Double)this.defaultValue(this.fields()[0]);
                record.timeReceived = this.fieldSetFlags()[1] ? this.timeReceived : (Double)this.defaultValue(this.fields()[1]);
                record.id = this.fieldSetFlags()[2] ? this.id : (String)this.defaultValue(this.fields()[2]);
                record.color = this.fieldSetFlags()[3] ? this.color : (OuraRingColor)((Object)this.defaultValue(this.fields()[3]));
                record.design = this.fieldSetFlags()[4] ? this.design : (OuraRingDesign)((Object)this.defaultValue(this.fields()[4]));
                record.firmwareVersion = this.fieldSetFlags()[5] ? this.firmwareVersion : (String)this.defaultValue(this.fields()[5]);
                record.hardwareType = this.fieldSetFlags()[6] ? this.hardwareType : (OuraRingHardwareType)((Object)this.defaultValue(this.fields()[6]));
                record.setUpAt = this.fieldSetFlags()[7] ? this.setUpAt : (Double)this.defaultValue(this.fields()[7]);
                record.size = this.fieldSetFlags()[8] ? this.size : (Integer)this.defaultValue(this.fields()[8]);
                return record;
            }
            catch (AvroMissingFieldException e) {
                throw e;
            }
            catch (Exception e) {
                throw new AvroRuntimeException((Throwable)e);
            }
        }
    }
}

