/*
 * Decompiled with CFR 0.152.
 */
package org.radarcns.connector.oura;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.nio.ByteBuffer;
import org.apache.avro.AvroMissingFieldException;
import org.apache.avro.AvroRuntimeException;
import org.apache.avro.Schema;
import org.apache.avro.data.RecordBuilder;
import org.apache.avro.generic.GenericData;
import org.apache.avro.io.DatumReader;
import org.apache.avro.io.DatumWriter;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.Encoder;
import org.apache.avro.io.ResolvingDecoder;
import org.apache.avro.message.BinaryMessageDecoder;
import org.apache.avro.message.BinaryMessageEncoder;
import org.apache.avro.message.SchemaStore;
import org.apache.avro.specific.AvroGenerated;
import org.apache.avro.specific.SpecificData;
import org.apache.avro.specific.SpecificRecord;
import org.apache.avro.specific.SpecificRecordBase;
import org.apache.avro.specific.SpecificRecordBuilderBase;
import org.radarcns.connector.oura.OuraSleepRecommendation;
import org.radarcns.connector.oura.OuraSleepStatus;

@AvroGenerated
public class OuraRecommendedSleepTime
extends SpecificRecordBase
implements SpecificRecord {
    private static final long serialVersionUID = 5984385842050152690L;
    public static final Schema SCHEMA$ = new Schema.Parser().parse("{\"type\":\"record\",\"name\":\"OuraRecommendedSleepTime\",\"namespace\":\"org.radarcns.connector.oura\",\"doc\":\"Oura recommendations for the optimal bedtime window that is calculated based on sleep data.\",\"fields\":[{\"name\":\"time\",\"type\":\"double\",\"doc\":\"Start time of the recomended sleep time period in seconds since January 1, 1970, 00:00:00 UTC (Unix timestamp).\"},{\"name\":\"timeReceived\",\"type\":\"double\",\"doc\":\"Time that this record was collected by a service in seconds since the Unix Epoch (s).\"},{\"name\":\"id\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"doc\":\"Unique identifier of the Oura sleep time recommendation.\",\"default\":null},{\"name\":\"day\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"doc\":\"Day that the sleep recommendation record belongs to. Null if unknown.\",\"default\":null},{\"name\":\"optimalBedtimeStartOffset\",\"type\":[\"null\",\"int\"],\"doc\":\"Recommended optimal bedtime start offset from midnight. Null if unknown.\",\"default\":null},{\"name\":\"optimalBedtimeEndOffset\",\"type\":[\"null\",\"int\"],\"doc\":\"Recommended optimal bedtime end offset from midnight. Null if unknown.\",\"default\":null},{\"name\":\"optimalBedtimeTimezoneOffset\",\"type\":[\"null\",\"int\"],\"doc\":\"Timezone offset in second from GMT of the day. Null if unknown.\",\"default\":null},{\"name\":\"recommendation\",\"type\":{\"type\":\"enum\",\"name\":\"OuraSleepRecommendation\",\"doc\":\"Sleep phase type as computed by Oura.\",\"symbols\":[\"IMPROVE_EFFICIENCY\",\"EARLIER_BEDTIME\",\"LATER_BEDTIME\",\"EARLIER_WAKE_UP_TIME\",\"LATER_WAKE_UP_TIME\",\"FOLLOW_OPTIMAL_BEDTIME\",\"UNKNOWN\"]},\"doc\":\"Oura recommendation action type for bedtime.\",\"default\":\"UNKNOWN\"},{\"name\":\"status\",\"type\":{\"type\":\"enum\",\"name\":\"OuraSleepStatus\",\"doc\":\"Sleep phase type as computed by Oura.\",\"symbols\":[\"NOT_ENOUGH_NIGHTS\",\"NOT_ENOUGH_RECENT_NIGHTS\",\"BAD_SLEEP_QUALITY\",\"ONLY_RECOMMENDED_FOUND\",\"OPTIMAL_FOUND\",\"UNKNOWN\"]},\"doc\":\"Oura sleep time status type. This is used to inform sleep time recommendation.\",\"default\":\"UNKNOWN\"}]}");
    private static final SpecificData MODEL$ = new SpecificData();
    private static final BinaryMessageEncoder<OuraRecommendedSleepTime> ENCODER = new BinaryMessageEncoder((GenericData)MODEL$, SCHEMA$);
    private static final BinaryMessageDecoder<OuraRecommendedSleepTime> DECODER = new BinaryMessageDecoder((GenericData)MODEL$, SCHEMA$);
    private double time;
    private double timeReceived;
    private String id;
    private String day;
    private Integer optimalBedtimeStartOffset;
    private Integer optimalBedtimeEndOffset;
    private Integer optimalBedtimeTimezoneOffset;
    private OuraSleepRecommendation recommendation;
    private OuraSleepStatus status;
    private static final DatumWriter<OuraRecommendedSleepTime> WRITER$ = MODEL$.createDatumWriter(SCHEMA$);
    private static final DatumReader<OuraRecommendedSleepTime> READER$ = MODEL$.createDatumReader(SCHEMA$);

    public static Schema getClassSchema() {
        return SCHEMA$;
    }

    public static BinaryMessageEncoder<OuraRecommendedSleepTime> getEncoder() {
        return ENCODER;
    }

    public static BinaryMessageDecoder<OuraRecommendedSleepTime> getDecoder() {
        return DECODER;
    }

    public static BinaryMessageDecoder<OuraRecommendedSleepTime> createDecoder(SchemaStore resolver) {
        return new BinaryMessageDecoder((GenericData)MODEL$, SCHEMA$, resolver);
    }

    public ByteBuffer toByteBuffer() throws IOException {
        return ENCODER.encode((Object)this);
    }

    public static OuraRecommendedSleepTime fromByteBuffer(ByteBuffer b) throws IOException {
        return (OuraRecommendedSleepTime)((Object)DECODER.decode(b));
    }

    public OuraRecommendedSleepTime() {
    }

    public OuraRecommendedSleepTime(Double time, Double timeReceived, String id, String day, Integer optimalBedtimeStartOffset, Integer optimalBedtimeEndOffset, Integer optimalBedtimeTimezoneOffset, OuraSleepRecommendation recommendation, OuraSleepStatus status) {
        this.time = time;
        this.timeReceived = timeReceived;
        this.id = id;
        this.day = day;
        this.optimalBedtimeStartOffset = optimalBedtimeStartOffset;
        this.optimalBedtimeEndOffset = optimalBedtimeEndOffset;
        this.optimalBedtimeTimezoneOffset = optimalBedtimeTimezoneOffset;
        this.recommendation = recommendation;
        this.status = status;
    }

    public SpecificData getSpecificData() {
        return MODEL$;
    }

    public Schema getSchema() {
        return SCHEMA$;
    }

    public Object get(int field$) {
        switch (field$) {
            case 0: {
                return this.time;
            }
            case 1: {
                return this.timeReceived;
            }
            case 2: {
                return this.id;
            }
            case 3: {
                return this.day;
            }
            case 4: {
                return this.optimalBedtimeStartOffset;
            }
            case 5: {
                return this.optimalBedtimeEndOffset;
            }
            case 6: {
                return this.optimalBedtimeTimezoneOffset;
            }
            case 7: {
                return this.recommendation;
            }
            case 8: {
                return this.status;
            }
        }
        throw new IndexOutOfBoundsException("Invalid index: " + field$);
    }

    public void put(int field$, Object value$) {
        switch (field$) {
            case 0: {
                this.time = (Double)value$;
                break;
            }
            case 1: {
                this.timeReceived = (Double)value$;
                break;
            }
            case 2: {
                this.id = value$ != null ? value$.toString() : null;
                break;
            }
            case 3: {
                this.day = value$ != null ? value$.toString() : null;
                break;
            }
            case 4: {
                this.optimalBedtimeStartOffset = (Integer)value$;
                break;
            }
            case 5: {
                this.optimalBedtimeEndOffset = (Integer)value$;
                break;
            }
            case 6: {
                this.optimalBedtimeTimezoneOffset = (Integer)value$;
                break;
            }
            case 7: {
                this.recommendation = (OuraSleepRecommendation)((Object)value$);
                break;
            }
            case 8: {
                this.status = (OuraSleepStatus)((Object)value$);
                break;
            }
            default: {
                throw new IndexOutOfBoundsException("Invalid index: " + field$);
            }
        }
    }

    public double getTime() {
        return this.time;
    }

    public void setTime(double value) {
        this.time = value;
    }

    public double getTimeReceived() {
        return this.timeReceived;
    }

    public void setTimeReceived(double value) {
        this.timeReceived = value;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String value) {
        this.id = value;
    }

    public String getDay() {
        return this.day;
    }

    public void setDay(String value) {
        this.day = value;
    }

    public Integer getOptimalBedtimeStartOffset() {
        return this.optimalBedtimeStartOffset;
    }

    public void setOptimalBedtimeStartOffset(Integer value) {
        this.optimalBedtimeStartOffset = value;
    }

    public Integer getOptimalBedtimeEndOffset() {
        return this.optimalBedtimeEndOffset;
    }

    public void setOptimalBedtimeEndOffset(Integer value) {
        this.optimalBedtimeEndOffset = value;
    }

    public Integer getOptimalBedtimeTimezoneOffset() {
        return this.optimalBedtimeTimezoneOffset;
    }

    public void setOptimalBedtimeTimezoneOffset(Integer value) {
        this.optimalBedtimeTimezoneOffset = value;
    }

    public OuraSleepRecommendation getRecommendation() {
        return this.recommendation;
    }

    public void setRecommendation(OuraSleepRecommendation value) {
        this.recommendation = value;
    }

    public OuraSleepStatus getStatus() {
        return this.status;
    }

    public void setStatus(OuraSleepStatus value) {
        this.status = value;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newBuilder(Builder other) {
        if (other == null) {
            return new Builder();
        }
        return new Builder(other);
    }

    public static Builder newBuilder(OuraRecommendedSleepTime other) {
        if (other == null) {
            return new Builder();
        }
        return new Builder(other);
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        WRITER$.write((Object)this, (Encoder)SpecificData.getEncoder((ObjectOutput)out));
    }

    public void readExternal(ObjectInput in) throws IOException {
        READER$.read((Object)this, (Decoder)SpecificData.getDecoder((ObjectInput)in));
    }

    protected boolean hasCustomCoders() {
        return true;
    }

    public void customEncode(Encoder out) throws IOException {
        out.writeDouble(this.time);
        out.writeDouble(this.timeReceived);
        if (this.id == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeString(this.id);
        }
        if (this.day == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeString(this.day);
        }
        if (this.optimalBedtimeStartOffset == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeInt(this.optimalBedtimeStartOffset.intValue());
        }
        if (this.optimalBedtimeEndOffset == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeInt(this.optimalBedtimeEndOffset.intValue());
        }
        if (this.optimalBedtimeTimezoneOffset == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeInt(this.optimalBedtimeTimezoneOffset.intValue());
        }
        out.writeEnum(this.recommendation.ordinal());
        out.writeEnum(this.status.ordinal());
    }

    public void customDecode(ResolvingDecoder in) throws IOException {
        Schema.Field[] fieldOrder = in.readFieldOrderIfDiff();
        if (fieldOrder == null) {
            this.time = in.readDouble();
            this.timeReceived = in.readDouble();
            if (in.readIndex() != 1) {
                in.readNull();
                this.id = null;
            } else {
                this.id = in.readString();
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.day = null;
            } else {
                this.day = in.readString();
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.optimalBedtimeStartOffset = null;
            } else {
                this.optimalBedtimeStartOffset = in.readInt();
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.optimalBedtimeEndOffset = null;
            } else {
                this.optimalBedtimeEndOffset = in.readInt();
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.optimalBedtimeTimezoneOffset = null;
            } else {
                this.optimalBedtimeTimezoneOffset = in.readInt();
            }
            this.recommendation = OuraSleepRecommendation.values()[in.readEnum()];
            this.status = OuraSleepStatus.values()[in.readEnum()];
        } else {
            block11: for (int i = 0; i < 9; ++i) {
                switch (fieldOrder[i].pos()) {
                    case 0: {
                        this.time = in.readDouble();
                        continue block11;
                    }
                    case 1: {
                        this.timeReceived = in.readDouble();
                        continue block11;
                    }
                    case 2: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.id = null;
                            continue block11;
                        }
                        this.id = in.readString();
                        continue block11;
                    }
                    case 3: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.day = null;
                            continue block11;
                        }
                        this.day = in.readString();
                        continue block11;
                    }
                    case 4: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.optimalBedtimeStartOffset = null;
                            continue block11;
                        }
                        this.optimalBedtimeStartOffset = in.readInt();
                        continue block11;
                    }
                    case 5: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.optimalBedtimeEndOffset = null;
                            continue block11;
                        }
                        this.optimalBedtimeEndOffset = in.readInt();
                        continue block11;
                    }
                    case 6: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.optimalBedtimeTimezoneOffset = null;
                            continue block11;
                        }
                        this.optimalBedtimeTimezoneOffset = in.readInt();
                        continue block11;
                    }
                    case 7: {
                        this.recommendation = OuraSleepRecommendation.values()[in.readEnum()];
                        continue block11;
                    }
                    case 8: {
                        this.status = OuraSleepStatus.values()[in.readEnum()];
                        continue block11;
                    }
                    default: {
                        throw new IOException("Corrupt ResolvingDecoder.");
                    }
                }
            }
        }
    }

    @AvroGenerated
    public static class Builder
    extends SpecificRecordBuilderBase<OuraRecommendedSleepTime>
    implements RecordBuilder<OuraRecommendedSleepTime> {
        private double time;
        private double timeReceived;
        private String id;
        private String day;
        private Integer optimalBedtimeStartOffset;
        private Integer optimalBedtimeEndOffset;
        private Integer optimalBedtimeTimezoneOffset;
        private OuraSleepRecommendation recommendation;
        private OuraSleepStatus status;

        private Builder() {
            super(SCHEMA$, MODEL$);
        }

        private Builder(Builder other) {
            super((SpecificRecordBuilderBase)other);
            if (Builder.isValidValue((Schema.Field)this.fields()[0], (Object)other.time)) {
                this.time = (Double)this.data().deepCopy(this.fields()[0].schema(), (Object)other.time);
                this.fieldSetFlags()[0] = other.fieldSetFlags()[0];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[1], (Object)other.timeReceived)) {
                this.timeReceived = (Double)this.data().deepCopy(this.fields()[1].schema(), (Object)other.timeReceived);
                this.fieldSetFlags()[1] = other.fieldSetFlags()[1];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[2], (Object)other.id)) {
                this.id = (String)this.data().deepCopy(this.fields()[2].schema(), (Object)other.id);
                this.fieldSetFlags()[2] = other.fieldSetFlags()[2];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[3], (Object)other.day)) {
                this.day = (String)this.data().deepCopy(this.fields()[3].schema(), (Object)other.day);
                this.fieldSetFlags()[3] = other.fieldSetFlags()[3];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[4], (Object)other.optimalBedtimeStartOffset)) {
                this.optimalBedtimeStartOffset = (Integer)this.data().deepCopy(this.fields()[4].schema(), (Object)other.optimalBedtimeStartOffset);
                this.fieldSetFlags()[4] = other.fieldSetFlags()[4];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[5], (Object)other.optimalBedtimeEndOffset)) {
                this.optimalBedtimeEndOffset = (Integer)this.data().deepCopy(this.fields()[5].schema(), (Object)other.optimalBedtimeEndOffset);
                this.fieldSetFlags()[5] = other.fieldSetFlags()[5];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[6], (Object)other.optimalBedtimeTimezoneOffset)) {
                this.optimalBedtimeTimezoneOffset = (Integer)this.data().deepCopy(this.fields()[6].schema(), (Object)other.optimalBedtimeTimezoneOffset);
                this.fieldSetFlags()[6] = other.fieldSetFlags()[6];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[7], (Object)((Object)other.recommendation))) {
                this.recommendation = (OuraSleepRecommendation)((Object)this.data().deepCopy(this.fields()[7].schema(), (Object)other.recommendation));
                this.fieldSetFlags()[7] = other.fieldSetFlags()[7];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[8], (Object)((Object)other.status))) {
                this.status = (OuraSleepStatus)((Object)this.data().deepCopy(this.fields()[8].schema(), (Object)other.status));
                this.fieldSetFlags()[8] = other.fieldSetFlags()[8];
            }
        }

        private Builder(OuraRecommendedSleepTime other) {
            super(SCHEMA$, MODEL$);
            if (Builder.isValidValue((Schema.Field)this.fields()[0], (Object)other.time)) {
                this.time = (Double)this.data().deepCopy(this.fields()[0].schema(), (Object)other.time);
                this.fieldSetFlags()[0] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[1], (Object)other.timeReceived)) {
                this.timeReceived = (Double)this.data().deepCopy(this.fields()[1].schema(), (Object)other.timeReceived);
                this.fieldSetFlags()[1] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[2], (Object)other.id)) {
                this.id = (String)this.data().deepCopy(this.fields()[2].schema(), (Object)other.id);
                this.fieldSetFlags()[2] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[3], (Object)other.day)) {
                this.day = (String)this.data().deepCopy(this.fields()[3].schema(), (Object)other.day);
                this.fieldSetFlags()[3] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[4], (Object)other.optimalBedtimeStartOffset)) {
                this.optimalBedtimeStartOffset = (Integer)this.data().deepCopy(this.fields()[4].schema(), (Object)other.optimalBedtimeStartOffset);
                this.fieldSetFlags()[4] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[5], (Object)other.optimalBedtimeEndOffset)) {
                this.optimalBedtimeEndOffset = (Integer)this.data().deepCopy(this.fields()[5].schema(), (Object)other.optimalBedtimeEndOffset);
                this.fieldSetFlags()[5] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[6], (Object)other.optimalBedtimeTimezoneOffset)) {
                this.optimalBedtimeTimezoneOffset = (Integer)this.data().deepCopy(this.fields()[6].schema(), (Object)other.optimalBedtimeTimezoneOffset);
                this.fieldSetFlags()[6] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[7], (Object)((Object)other.recommendation))) {
                this.recommendation = (OuraSleepRecommendation)((Object)this.data().deepCopy(this.fields()[7].schema(), (Object)other.recommendation));
                this.fieldSetFlags()[7] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[8], (Object)((Object)other.status))) {
                this.status = (OuraSleepStatus)((Object)this.data().deepCopy(this.fields()[8].schema(), (Object)other.status));
                this.fieldSetFlags()[8] = true;
            }
        }

        public double getTime() {
            return this.time;
        }

        public Builder setTime(double value) {
            this.validate(this.fields()[0], value);
            this.time = value;
            this.fieldSetFlags()[0] = true;
            return this;
        }

        public boolean hasTime() {
            return this.fieldSetFlags()[0];
        }

        public Builder clearTime() {
            this.fieldSetFlags()[0] = false;
            return this;
        }

        public double getTimeReceived() {
            return this.timeReceived;
        }

        public Builder setTimeReceived(double value) {
            this.validate(this.fields()[1], value);
            this.timeReceived = value;
            this.fieldSetFlags()[1] = true;
            return this;
        }

        public boolean hasTimeReceived() {
            return this.fieldSetFlags()[1];
        }

        public Builder clearTimeReceived() {
            this.fieldSetFlags()[1] = false;
            return this;
        }

        public String getId() {
            return this.id;
        }

        public Builder setId(String value) {
            this.validate(this.fields()[2], value);
            this.id = value;
            this.fieldSetFlags()[2] = true;
            return this;
        }

        public boolean hasId() {
            return this.fieldSetFlags()[2];
        }

        public Builder clearId() {
            this.id = null;
            this.fieldSetFlags()[2] = false;
            return this;
        }

        public String getDay() {
            return this.day;
        }

        public Builder setDay(String value) {
            this.validate(this.fields()[3], value);
            this.day = value;
            this.fieldSetFlags()[3] = true;
            return this;
        }

        public boolean hasDay() {
            return this.fieldSetFlags()[3];
        }

        public Builder clearDay() {
            this.day = null;
            this.fieldSetFlags()[3] = false;
            return this;
        }

        public Integer getOptimalBedtimeStartOffset() {
            return this.optimalBedtimeStartOffset;
        }

        public Builder setOptimalBedtimeStartOffset(Integer value) {
            this.validate(this.fields()[4], value);
            this.optimalBedtimeStartOffset = value;
            this.fieldSetFlags()[4] = true;
            return this;
        }

        public boolean hasOptimalBedtimeStartOffset() {
            return this.fieldSetFlags()[4];
        }

        public Builder clearOptimalBedtimeStartOffset() {
            this.optimalBedtimeStartOffset = null;
            this.fieldSetFlags()[4] = false;
            return this;
        }

        public Integer getOptimalBedtimeEndOffset() {
            return this.optimalBedtimeEndOffset;
        }

        public Builder setOptimalBedtimeEndOffset(Integer value) {
            this.validate(this.fields()[5], value);
            this.optimalBedtimeEndOffset = value;
            this.fieldSetFlags()[5] = true;
            return this;
        }

        public boolean hasOptimalBedtimeEndOffset() {
            return this.fieldSetFlags()[5];
        }

        public Builder clearOptimalBedtimeEndOffset() {
            this.optimalBedtimeEndOffset = null;
            this.fieldSetFlags()[5] = false;
            return this;
        }

        public Integer getOptimalBedtimeTimezoneOffset() {
            return this.optimalBedtimeTimezoneOffset;
        }

        public Builder setOptimalBedtimeTimezoneOffset(Integer value) {
            this.validate(this.fields()[6], value);
            this.optimalBedtimeTimezoneOffset = value;
            this.fieldSetFlags()[6] = true;
            return this;
        }

        public boolean hasOptimalBedtimeTimezoneOffset() {
            return this.fieldSetFlags()[6];
        }

        public Builder clearOptimalBedtimeTimezoneOffset() {
            this.optimalBedtimeTimezoneOffset = null;
            this.fieldSetFlags()[6] = false;
            return this;
        }

        public OuraSleepRecommendation getRecommendation() {
            return this.recommendation;
        }

        public Builder setRecommendation(OuraSleepRecommendation value) {
            this.validate(this.fields()[7], (Object)value);
            this.recommendation = value;
            this.fieldSetFlags()[7] = true;
            return this;
        }

        public boolean hasRecommendation() {
            return this.fieldSetFlags()[7];
        }

        public Builder clearRecommendation() {
            this.recommendation = null;
            this.fieldSetFlags()[7] = false;
            return this;
        }

        public OuraSleepStatus getStatus() {
            return this.status;
        }

        public Builder setStatus(OuraSleepStatus value) {
            this.validate(this.fields()[8], (Object)value);
            this.status = value;
            this.fieldSetFlags()[8] = true;
            return this;
        }

        public boolean hasStatus() {
            return this.fieldSetFlags()[8];
        }

        public Builder clearStatus() {
            this.status = null;
            this.fieldSetFlags()[8] = false;
            return this;
        }

        public OuraRecommendedSleepTime build() {
            try {
                OuraRecommendedSleepTime record = new OuraRecommendedSleepTime();
                record.time = this.fieldSetFlags()[0] ? this.time : (Double)this.defaultValue(this.fields()[0]);
                record.timeReceived = this.fieldSetFlags()[1] ? this.timeReceived : (Double)this.defaultValue(this.fields()[1]);
                record.id = this.fieldSetFlags()[2] ? this.id : (String)this.defaultValue(this.fields()[2]);
                record.day = this.fieldSetFlags()[3] ? this.day : (String)this.defaultValue(this.fields()[3]);
                record.optimalBedtimeStartOffset = this.fieldSetFlags()[4] ? this.optimalBedtimeStartOffset : (Integer)this.defaultValue(this.fields()[4]);
                record.optimalBedtimeEndOffset = this.fieldSetFlags()[5] ? this.optimalBedtimeEndOffset : (Integer)this.defaultValue(this.fields()[5]);
                record.optimalBedtimeTimezoneOffset = this.fieldSetFlags()[6] ? this.optimalBedtimeTimezoneOffset : (Integer)this.defaultValue(this.fields()[6]);
                record.recommendation = this.fieldSetFlags()[7] ? this.recommendation : (OuraSleepRecommendation)((Object)this.defaultValue(this.fields()[7]));
                record.status = this.fieldSetFlags()[8] ? this.status : (OuraSleepStatus)((Object)this.defaultValue(this.fields()[8]));
                return record;
            }
            catch (AvroMissingFieldException e) {
                throw e;
            }
            catch (Exception e) {
                throw new AvroRuntimeException((Throwable)e);
            }
        }
    }
}

