/*
 * Decompiled with CFR 0.152.
 */
package org.radarcns.connector.fitbit;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.nio.ByteBuffer;
import org.apache.avro.AvroMissingFieldException;
import org.apache.avro.AvroRuntimeException;
import org.apache.avro.Schema;
import org.apache.avro.data.RecordBuilder;
import org.apache.avro.generic.GenericData;
import org.apache.avro.io.DatumReader;
import org.apache.avro.io.DatumWriter;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.Encoder;
import org.apache.avro.io.ResolvingDecoder;
import org.apache.avro.message.BinaryMessageDecoder;
import org.apache.avro.message.BinaryMessageEncoder;
import org.apache.avro.message.SchemaStore;
import org.apache.avro.specific.AvroGenerated;
import org.apache.avro.specific.SpecificData;
import org.apache.avro.specific.SpecificRecord;
import org.apache.avro.specific.SpecificRecordBase;
import org.apache.avro.specific.SpecificRecordBuilderBase;
import org.radarcns.connector.fitbit.FitbitSleepStageLevel;

@AvroGenerated
public class FitbitSleepStage
extends SpecificRecordBase
implements SpecificRecord {
    private static final long serialVersionUID = 1743085587444783791L;
    public static final Schema SCHEMA$ = new Schema.Parser().parse("{\"type\":\"record\",\"name\":\"FitbitSleepStage\",\"namespace\":\"org.radarcns.connector.fitbit\",\"doc\":\"Fitbit 'stages' sleep data as defined at https://dev.fitbit.com/build/reference/web-api/sleep/.\",\"fields\":[{\"name\":\"dateTime\",\"type\":{\"type\":\"string\",\"avro.java.string\":\"String\"},\"doc\":\"ISO 6801 formatted local date time of device (yyyy-MM-ddTHH:mm:ss).\"},{\"name\":\"timeReceived\",\"type\":\"double\",\"doc\":\"Time that the data was received from the Fitbit API (seconds since the Unix Epoch).\"},{\"name\":\"duration\",\"type\":\"int\",\"doc\":\"Duration at this sleep characteristic in seconds.\"},{\"name\":\"level\",\"type\":{\"type\":\"enum\",\"name\":\"FitbitSleepStageLevel\",\"doc\":\"Level of sleep as computed by Fitbit.\",\"symbols\":[\"DEEP\",\"LIGHT\",\"REM\",\"AWAKE\",\"UNKNOWN\"]},\"doc\":\"Level of sleep as computed by Fitbit.\",\"default\":\"UNKNOWN\"},{\"name\":\"efficiency\",\"type\":[\"null\",\"int\"],\"doc\":\"Calculated sleep efficiency score (in percentage). It is a percentage of the amount of time the user was asleep (and not restless) divided by the time they spent in the bed after initially falling asleep.\",\"default\":null}]}");
    private static final SpecificData MODEL$ = new SpecificData();
    private static final BinaryMessageEncoder<FitbitSleepStage> ENCODER = new BinaryMessageEncoder((GenericData)MODEL$, SCHEMA$);
    private static final BinaryMessageDecoder<FitbitSleepStage> DECODER = new BinaryMessageDecoder((GenericData)MODEL$, SCHEMA$);
    private String dateTime;
    private double timeReceived;
    private int duration;
    private FitbitSleepStageLevel level;
    private Integer efficiency;
    private static final DatumWriter<FitbitSleepStage> WRITER$ = MODEL$.createDatumWriter(SCHEMA$);
    private static final DatumReader<FitbitSleepStage> READER$ = MODEL$.createDatumReader(SCHEMA$);

    public static Schema getClassSchema() {
        return SCHEMA$;
    }

    public static BinaryMessageEncoder<FitbitSleepStage> getEncoder() {
        return ENCODER;
    }

    public static BinaryMessageDecoder<FitbitSleepStage> getDecoder() {
        return DECODER;
    }

    public static BinaryMessageDecoder<FitbitSleepStage> createDecoder(SchemaStore resolver) {
        return new BinaryMessageDecoder((GenericData)MODEL$, SCHEMA$, resolver);
    }

    public ByteBuffer toByteBuffer() throws IOException {
        return ENCODER.encode((Object)this);
    }

    public static FitbitSleepStage fromByteBuffer(ByteBuffer b) throws IOException {
        return (FitbitSleepStage)((Object)DECODER.decode(b));
    }

    public FitbitSleepStage() {
    }

    public FitbitSleepStage(String dateTime, Double timeReceived, Integer duration, FitbitSleepStageLevel level, Integer efficiency) {
        this.dateTime = dateTime;
        this.timeReceived = timeReceived;
        this.duration = duration;
        this.level = level;
        this.efficiency = efficiency;
    }

    public SpecificData getSpecificData() {
        return MODEL$;
    }

    public Schema getSchema() {
        return SCHEMA$;
    }

    public Object get(int field$) {
        switch (field$) {
            case 0: {
                return this.dateTime;
            }
            case 1: {
                return this.timeReceived;
            }
            case 2: {
                return this.duration;
            }
            case 3: {
                return this.level;
            }
            case 4: {
                return this.efficiency;
            }
        }
        throw new IndexOutOfBoundsException("Invalid index: " + field$);
    }

    public void put(int field$, Object value$) {
        switch (field$) {
            case 0: {
                this.dateTime = value$ != null ? value$.toString() : null;
                break;
            }
            case 1: {
                this.timeReceived = (Double)value$;
                break;
            }
            case 2: {
                this.duration = (Integer)value$;
                break;
            }
            case 3: {
                this.level = (FitbitSleepStageLevel)((Object)value$);
                break;
            }
            case 4: {
                this.efficiency = (Integer)value$;
                break;
            }
            default: {
                throw new IndexOutOfBoundsException("Invalid index: " + field$);
            }
        }
    }

    public String getDateTime() {
        return this.dateTime;
    }

    public void setDateTime(String value) {
        this.dateTime = value;
    }

    public double getTimeReceived() {
        return this.timeReceived;
    }

    public void setTimeReceived(double value) {
        this.timeReceived = value;
    }

    public int getDuration() {
        return this.duration;
    }

    public void setDuration(int value) {
        this.duration = value;
    }

    public FitbitSleepStageLevel getLevel() {
        return this.level;
    }

    public void setLevel(FitbitSleepStageLevel value) {
        this.level = value;
    }

    public Integer getEfficiency() {
        return this.efficiency;
    }

    public void setEfficiency(Integer value) {
        this.efficiency = value;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newBuilder(Builder other) {
        if (other == null) {
            return new Builder();
        }
        return new Builder(other);
    }

    public static Builder newBuilder(FitbitSleepStage other) {
        if (other == null) {
            return new Builder();
        }
        return new Builder(other);
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        WRITER$.write((Object)this, (Encoder)SpecificData.getEncoder((ObjectOutput)out));
    }

    public void readExternal(ObjectInput in) throws IOException {
        READER$.read((Object)this, (Decoder)SpecificData.getDecoder((ObjectInput)in));
    }

    protected boolean hasCustomCoders() {
        return true;
    }

    public void customEncode(Encoder out) throws IOException {
        out.writeString(this.dateTime);
        out.writeDouble(this.timeReceived);
        out.writeInt(this.duration);
        out.writeEnum(this.level.ordinal());
        if (this.efficiency == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeInt(this.efficiency.intValue());
        }
    }

    public void customDecode(ResolvingDecoder in) throws IOException {
        Schema.Field[] fieldOrder = in.readFieldOrderIfDiff();
        if (fieldOrder == null) {
            this.dateTime = in.readString();
            this.timeReceived = in.readDouble();
            this.duration = in.readInt();
            this.level = FitbitSleepStageLevel.values()[in.readEnum()];
            if (in.readIndex() != 1) {
                in.readNull();
                this.efficiency = null;
            } else {
                this.efficiency = in.readInt();
            }
        } else {
            block7: for (int i = 0; i < 5; ++i) {
                switch (fieldOrder[i].pos()) {
                    case 0: {
                        this.dateTime = in.readString();
                        continue block7;
                    }
                    case 1: {
                        this.timeReceived = in.readDouble();
                        continue block7;
                    }
                    case 2: {
                        this.duration = in.readInt();
                        continue block7;
                    }
                    case 3: {
                        this.level = FitbitSleepStageLevel.values()[in.readEnum()];
                        continue block7;
                    }
                    case 4: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.efficiency = null;
                            continue block7;
                        }
                        this.efficiency = in.readInt();
                        continue block7;
                    }
                    default: {
                        throw new IOException("Corrupt ResolvingDecoder.");
                    }
                }
            }
        }
    }

    @AvroGenerated
    public static class Builder
    extends SpecificRecordBuilderBase<FitbitSleepStage>
    implements RecordBuilder<FitbitSleepStage> {
        private String dateTime;
        private double timeReceived;
        private int duration;
        private FitbitSleepStageLevel level;
        private Integer efficiency;

        private Builder() {
            super(SCHEMA$, MODEL$);
        }

        private Builder(Builder other) {
            super((SpecificRecordBuilderBase)other);
            if (Builder.isValidValue((Schema.Field)this.fields()[0], (Object)other.dateTime)) {
                this.dateTime = (String)this.data().deepCopy(this.fields()[0].schema(), (Object)other.dateTime);
                this.fieldSetFlags()[0] = other.fieldSetFlags()[0];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[1], (Object)other.timeReceived)) {
                this.timeReceived = (Double)this.data().deepCopy(this.fields()[1].schema(), (Object)other.timeReceived);
                this.fieldSetFlags()[1] = other.fieldSetFlags()[1];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[2], (Object)other.duration)) {
                this.duration = (Integer)this.data().deepCopy(this.fields()[2].schema(), (Object)other.duration);
                this.fieldSetFlags()[2] = other.fieldSetFlags()[2];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[3], (Object)((Object)other.level))) {
                this.level = (FitbitSleepStageLevel)((Object)this.data().deepCopy(this.fields()[3].schema(), (Object)other.level));
                this.fieldSetFlags()[3] = other.fieldSetFlags()[3];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[4], (Object)other.efficiency)) {
                this.efficiency = (Integer)this.data().deepCopy(this.fields()[4].schema(), (Object)other.efficiency);
                this.fieldSetFlags()[4] = other.fieldSetFlags()[4];
            }
        }

        private Builder(FitbitSleepStage other) {
            super(SCHEMA$, MODEL$);
            if (Builder.isValidValue((Schema.Field)this.fields()[0], (Object)other.dateTime)) {
                this.dateTime = (String)this.data().deepCopy(this.fields()[0].schema(), (Object)other.dateTime);
                this.fieldSetFlags()[0] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[1], (Object)other.timeReceived)) {
                this.timeReceived = (Double)this.data().deepCopy(this.fields()[1].schema(), (Object)other.timeReceived);
                this.fieldSetFlags()[1] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[2], (Object)other.duration)) {
                this.duration = (Integer)this.data().deepCopy(this.fields()[2].schema(), (Object)other.duration);
                this.fieldSetFlags()[2] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[3], (Object)((Object)other.level))) {
                this.level = (FitbitSleepStageLevel)((Object)this.data().deepCopy(this.fields()[3].schema(), (Object)other.level));
                this.fieldSetFlags()[3] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[4], (Object)other.efficiency)) {
                this.efficiency = (Integer)this.data().deepCopy(this.fields()[4].schema(), (Object)other.efficiency);
                this.fieldSetFlags()[4] = true;
            }
        }

        public String getDateTime() {
            return this.dateTime;
        }

        public Builder setDateTime(String value) {
            this.validate(this.fields()[0], value);
            this.dateTime = value;
            this.fieldSetFlags()[0] = true;
            return this;
        }

        public boolean hasDateTime() {
            return this.fieldSetFlags()[0];
        }

        public Builder clearDateTime() {
            this.dateTime = null;
            this.fieldSetFlags()[0] = false;
            return this;
        }

        public double getTimeReceived() {
            return this.timeReceived;
        }

        public Builder setTimeReceived(double value) {
            this.validate(this.fields()[1], value);
            this.timeReceived = value;
            this.fieldSetFlags()[1] = true;
            return this;
        }

        public boolean hasTimeReceived() {
            return this.fieldSetFlags()[1];
        }

        public Builder clearTimeReceived() {
            this.fieldSetFlags()[1] = false;
            return this;
        }

        public int getDuration() {
            return this.duration;
        }

        public Builder setDuration(int value) {
            this.validate(this.fields()[2], value);
            this.duration = value;
            this.fieldSetFlags()[2] = true;
            return this;
        }

        public boolean hasDuration() {
            return this.fieldSetFlags()[2];
        }

        public Builder clearDuration() {
            this.fieldSetFlags()[2] = false;
            return this;
        }

        public FitbitSleepStageLevel getLevel() {
            return this.level;
        }

        public Builder setLevel(FitbitSleepStageLevel value) {
            this.validate(this.fields()[3], (Object)value);
            this.level = value;
            this.fieldSetFlags()[3] = true;
            return this;
        }

        public boolean hasLevel() {
            return this.fieldSetFlags()[3];
        }

        public Builder clearLevel() {
            this.level = null;
            this.fieldSetFlags()[3] = false;
            return this;
        }

        public Integer getEfficiency() {
            return this.efficiency;
        }

        public Builder setEfficiency(Integer value) {
            this.validate(this.fields()[4], value);
            this.efficiency = value;
            this.fieldSetFlags()[4] = true;
            return this;
        }

        public boolean hasEfficiency() {
            return this.fieldSetFlags()[4];
        }

        public Builder clearEfficiency() {
            this.efficiency = null;
            this.fieldSetFlags()[4] = false;
            return this;
        }

        public FitbitSleepStage build() {
            try {
                FitbitSleepStage record = new FitbitSleepStage();
                record.dateTime = this.fieldSetFlags()[0] ? this.dateTime : (String)this.defaultValue(this.fields()[0]);
                record.timeReceived = this.fieldSetFlags()[1] ? this.timeReceived : (Double)this.defaultValue(this.fields()[1]);
                record.duration = this.fieldSetFlags()[2] ? this.duration : (Integer)this.defaultValue(this.fields()[2]);
                record.level = this.fieldSetFlags()[3] ? this.level : (FitbitSleepStageLevel)((Object)this.defaultValue(this.fields()[3]));
                record.efficiency = this.fieldSetFlags()[4] ? this.efficiency : (Integer)this.defaultValue(this.fields()[4]);
                return record;
            }
            catch (AvroMissingFieldException e) {
                throw e;
            }
            catch (Exception e) {
                throw new AvroRuntimeException((Throwable)e);
            }
        }
    }
}

