/*
 * Decompiled with CFR 0.152.
 */
package org.radarcns.connector.fitbit;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.nio.ByteBuffer;
import org.apache.avro.AvroMissingFieldException;
import org.apache.avro.AvroRuntimeException;
import org.apache.avro.Schema;
import org.apache.avro.data.RecordBuilder;
import org.apache.avro.generic.GenericData;
import org.apache.avro.io.DatumReader;
import org.apache.avro.io.DatumWriter;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.Encoder;
import org.apache.avro.io.ResolvingDecoder;
import org.apache.avro.message.BinaryMessageDecoder;
import org.apache.avro.message.BinaryMessageEncoder;
import org.apache.avro.message.SchemaStore;
import org.apache.avro.specific.AvroGenerated;
import org.apache.avro.specific.SpecificData;
import org.apache.avro.specific.SpecificRecord;
import org.apache.avro.specific.SpecificRecordBase;
import org.apache.avro.specific.SpecificRecordBuilderBase;

@AvroGenerated
public class FitbitIntradayCalories
extends SpecificRecordBase
implements SpecificRecord {
    private static final long serialVersionUID = -7631679173718775395L;
    public static final Schema SCHEMA$ = new Schema.Parser().parse("{\"type\":\"record\",\"name\":\"FitbitIntradayCalories\",\"namespace\":\"org.radarcns.connector.fitbit\",\"doc\":\"Intra day calories and activity level data from fitbit device.\",\"fields\":[{\"name\":\"time\",\"type\":\"double\",\"doc\":\"Device timestamp in UTC (s).\"},{\"name\":\"timeReceived\",\"type\":\"double\",\"doc\":\"Time that the data was received from the Fitbit API (seconds since the Unix Epoch).\"},{\"name\":\"timeInterval\",\"type\":\"int\",\"doc\":\"Chronological window size (s).\"},{\"name\":\"calories\",\"type\":\"double\",\"doc\":\"Calories in this period.\"},{\"name\":\"level\",\"type\":\"int\",\"doc\":\"Level of activity: 0 - sedentary; 1 - lightly active; 2 - fairly active; 3 - very active.\"},{\"name\":\"mets\",\"type\":\"double\",\"doc\":\"The metabolic equivalent of task (MET) -  https://en.wikipedia.org/wiki/Metabolic_equivalent_of_task.\"}]}");
    private static final SpecificData MODEL$ = new SpecificData();
    private static final BinaryMessageEncoder<FitbitIntradayCalories> ENCODER = new BinaryMessageEncoder((GenericData)MODEL$, SCHEMA$);
    private static final BinaryMessageDecoder<FitbitIntradayCalories> DECODER = new BinaryMessageDecoder((GenericData)MODEL$, SCHEMA$);
    private double time;
    private double timeReceived;
    private int timeInterval;
    private double calories;
    private int level;
    private double mets;
    private static final DatumWriter<FitbitIntradayCalories> WRITER$ = MODEL$.createDatumWriter(SCHEMA$);
    private static final DatumReader<FitbitIntradayCalories> READER$ = MODEL$.createDatumReader(SCHEMA$);

    public static Schema getClassSchema() {
        return SCHEMA$;
    }

    public static BinaryMessageEncoder<FitbitIntradayCalories> getEncoder() {
        return ENCODER;
    }

    public static BinaryMessageDecoder<FitbitIntradayCalories> getDecoder() {
        return DECODER;
    }

    public static BinaryMessageDecoder<FitbitIntradayCalories> createDecoder(SchemaStore resolver) {
        return new BinaryMessageDecoder((GenericData)MODEL$, SCHEMA$, resolver);
    }

    public ByteBuffer toByteBuffer() throws IOException {
        return ENCODER.encode((Object)this);
    }

    public static FitbitIntradayCalories fromByteBuffer(ByteBuffer b) throws IOException {
        return (FitbitIntradayCalories)((Object)DECODER.decode(b));
    }

    public FitbitIntradayCalories() {
    }

    public FitbitIntradayCalories(Double time, Double timeReceived, Integer timeInterval, Double calories, Integer level, Double mets) {
        this.time = time;
        this.timeReceived = timeReceived;
        this.timeInterval = timeInterval;
        this.calories = calories;
        this.level = level;
        this.mets = mets;
    }

    public SpecificData getSpecificData() {
        return MODEL$;
    }

    public Schema getSchema() {
        return SCHEMA$;
    }

    public Object get(int field$) {
        switch (field$) {
            case 0: {
                return this.time;
            }
            case 1: {
                return this.timeReceived;
            }
            case 2: {
                return this.timeInterval;
            }
            case 3: {
                return this.calories;
            }
            case 4: {
                return this.level;
            }
            case 5: {
                return this.mets;
            }
        }
        throw new IndexOutOfBoundsException("Invalid index: " + field$);
    }

    public void put(int field$, Object value$) {
        switch (field$) {
            case 0: {
                this.time = (Double)value$;
                break;
            }
            case 1: {
                this.timeReceived = (Double)value$;
                break;
            }
            case 2: {
                this.timeInterval = (Integer)value$;
                break;
            }
            case 3: {
                this.calories = (Double)value$;
                break;
            }
            case 4: {
                this.level = (Integer)value$;
                break;
            }
            case 5: {
                this.mets = (Double)value$;
                break;
            }
            default: {
                throw new IndexOutOfBoundsException("Invalid index: " + field$);
            }
        }
    }

    public double getTime() {
        return this.time;
    }

    public void setTime(double value) {
        this.time = value;
    }

    public double getTimeReceived() {
        return this.timeReceived;
    }

    public void setTimeReceived(double value) {
        this.timeReceived = value;
    }

    public int getTimeInterval() {
        return this.timeInterval;
    }

    public void setTimeInterval(int value) {
        this.timeInterval = value;
    }

    public double getCalories() {
        return this.calories;
    }

    public void setCalories(double value) {
        this.calories = value;
    }

    public int getLevel() {
        return this.level;
    }

    public void setLevel(int value) {
        this.level = value;
    }

    public double getMets() {
        return this.mets;
    }

    public void setMets(double value) {
        this.mets = value;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newBuilder(Builder other) {
        if (other == null) {
            return new Builder();
        }
        return new Builder(other);
    }

    public static Builder newBuilder(FitbitIntradayCalories other) {
        if (other == null) {
            return new Builder();
        }
        return new Builder(other);
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        WRITER$.write((Object)this, (Encoder)SpecificData.getEncoder((ObjectOutput)out));
    }

    public void readExternal(ObjectInput in) throws IOException {
        READER$.read((Object)this, (Decoder)SpecificData.getDecoder((ObjectInput)in));
    }

    protected boolean hasCustomCoders() {
        return true;
    }

    public void customEncode(Encoder out) throws IOException {
        out.writeDouble(this.time);
        out.writeDouble(this.timeReceived);
        out.writeInt(this.timeInterval);
        out.writeDouble(this.calories);
        out.writeInt(this.level);
        out.writeDouble(this.mets);
    }

    public void customDecode(ResolvingDecoder in) throws IOException {
        Schema.Field[] fieldOrder = in.readFieldOrderIfDiff();
        if (fieldOrder == null) {
            this.time = in.readDouble();
            this.timeReceived = in.readDouble();
            this.timeInterval = in.readInt();
            this.calories = in.readDouble();
            this.level = in.readInt();
            this.mets = in.readDouble();
        } else {
            block8: for (int i = 0; i < 6; ++i) {
                switch (fieldOrder[i].pos()) {
                    case 0: {
                        this.time = in.readDouble();
                        continue block8;
                    }
                    case 1: {
                        this.timeReceived = in.readDouble();
                        continue block8;
                    }
                    case 2: {
                        this.timeInterval = in.readInt();
                        continue block8;
                    }
                    case 3: {
                        this.calories = in.readDouble();
                        continue block8;
                    }
                    case 4: {
                        this.level = in.readInt();
                        continue block8;
                    }
                    case 5: {
                        this.mets = in.readDouble();
                        continue block8;
                    }
                    default: {
                        throw new IOException("Corrupt ResolvingDecoder.");
                    }
                }
            }
        }
    }

    @AvroGenerated
    public static class Builder
    extends SpecificRecordBuilderBase<FitbitIntradayCalories>
    implements RecordBuilder<FitbitIntradayCalories> {
        private double time;
        private double timeReceived;
        private int timeInterval;
        private double calories;
        private int level;
        private double mets;

        private Builder() {
            super(SCHEMA$, MODEL$);
        }

        private Builder(Builder other) {
            super((SpecificRecordBuilderBase)other);
            if (Builder.isValidValue((Schema.Field)this.fields()[0], (Object)other.time)) {
                this.time = (Double)this.data().deepCopy(this.fields()[0].schema(), (Object)other.time);
                this.fieldSetFlags()[0] = other.fieldSetFlags()[0];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[1], (Object)other.timeReceived)) {
                this.timeReceived = (Double)this.data().deepCopy(this.fields()[1].schema(), (Object)other.timeReceived);
                this.fieldSetFlags()[1] = other.fieldSetFlags()[1];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[2], (Object)other.timeInterval)) {
                this.timeInterval = (Integer)this.data().deepCopy(this.fields()[2].schema(), (Object)other.timeInterval);
                this.fieldSetFlags()[2] = other.fieldSetFlags()[2];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[3], (Object)other.calories)) {
                this.calories = (Double)this.data().deepCopy(this.fields()[3].schema(), (Object)other.calories);
                this.fieldSetFlags()[3] = other.fieldSetFlags()[3];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[4], (Object)other.level)) {
                this.level = (Integer)this.data().deepCopy(this.fields()[4].schema(), (Object)other.level);
                this.fieldSetFlags()[4] = other.fieldSetFlags()[4];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[5], (Object)other.mets)) {
                this.mets = (Double)this.data().deepCopy(this.fields()[5].schema(), (Object)other.mets);
                this.fieldSetFlags()[5] = other.fieldSetFlags()[5];
            }
        }

        private Builder(FitbitIntradayCalories other) {
            super(SCHEMA$, MODEL$);
            if (Builder.isValidValue((Schema.Field)this.fields()[0], (Object)other.time)) {
                this.time = (Double)this.data().deepCopy(this.fields()[0].schema(), (Object)other.time);
                this.fieldSetFlags()[0] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[1], (Object)other.timeReceived)) {
                this.timeReceived = (Double)this.data().deepCopy(this.fields()[1].schema(), (Object)other.timeReceived);
                this.fieldSetFlags()[1] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[2], (Object)other.timeInterval)) {
                this.timeInterval = (Integer)this.data().deepCopy(this.fields()[2].schema(), (Object)other.timeInterval);
                this.fieldSetFlags()[2] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[3], (Object)other.calories)) {
                this.calories = (Double)this.data().deepCopy(this.fields()[3].schema(), (Object)other.calories);
                this.fieldSetFlags()[3] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[4], (Object)other.level)) {
                this.level = (Integer)this.data().deepCopy(this.fields()[4].schema(), (Object)other.level);
                this.fieldSetFlags()[4] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[5], (Object)other.mets)) {
                this.mets = (Double)this.data().deepCopy(this.fields()[5].schema(), (Object)other.mets);
                this.fieldSetFlags()[5] = true;
            }
        }

        public double getTime() {
            return this.time;
        }

        public Builder setTime(double value) {
            this.validate(this.fields()[0], value);
            this.time = value;
            this.fieldSetFlags()[0] = true;
            return this;
        }

        public boolean hasTime() {
            return this.fieldSetFlags()[0];
        }

        public Builder clearTime() {
            this.fieldSetFlags()[0] = false;
            return this;
        }

        public double getTimeReceived() {
            return this.timeReceived;
        }

        public Builder setTimeReceived(double value) {
            this.validate(this.fields()[1], value);
            this.timeReceived = value;
            this.fieldSetFlags()[1] = true;
            return this;
        }

        public boolean hasTimeReceived() {
            return this.fieldSetFlags()[1];
        }

        public Builder clearTimeReceived() {
            this.fieldSetFlags()[1] = false;
            return this;
        }

        public int getTimeInterval() {
            return this.timeInterval;
        }

        public Builder setTimeInterval(int value) {
            this.validate(this.fields()[2], value);
            this.timeInterval = value;
            this.fieldSetFlags()[2] = true;
            return this;
        }

        public boolean hasTimeInterval() {
            return this.fieldSetFlags()[2];
        }

        public Builder clearTimeInterval() {
            this.fieldSetFlags()[2] = false;
            return this;
        }

        public double getCalories() {
            return this.calories;
        }

        public Builder setCalories(double value) {
            this.validate(this.fields()[3], value);
            this.calories = value;
            this.fieldSetFlags()[3] = true;
            return this;
        }

        public boolean hasCalories() {
            return this.fieldSetFlags()[3];
        }

        public Builder clearCalories() {
            this.fieldSetFlags()[3] = false;
            return this;
        }

        public int getLevel() {
            return this.level;
        }

        public Builder setLevel(int value) {
            this.validate(this.fields()[4], value);
            this.level = value;
            this.fieldSetFlags()[4] = true;
            return this;
        }

        public boolean hasLevel() {
            return this.fieldSetFlags()[4];
        }

        public Builder clearLevel() {
            this.fieldSetFlags()[4] = false;
            return this;
        }

        public double getMets() {
            return this.mets;
        }

        public Builder setMets(double value) {
            this.validate(this.fields()[5], value);
            this.mets = value;
            this.fieldSetFlags()[5] = true;
            return this;
        }

        public boolean hasMets() {
            return this.fieldSetFlags()[5];
        }

        public Builder clearMets() {
            this.fieldSetFlags()[5] = false;
            return this;
        }

        public FitbitIntradayCalories build() {
            try {
                FitbitIntradayCalories record = new FitbitIntradayCalories();
                record.time = this.fieldSetFlags()[0] ? this.time : (Double)this.defaultValue(this.fields()[0]);
                record.timeReceived = this.fieldSetFlags()[1] ? this.timeReceived : (Double)this.defaultValue(this.fields()[1]);
                record.timeInterval = this.fieldSetFlags()[2] ? this.timeInterval : (Integer)this.defaultValue(this.fields()[2]);
                record.calories = this.fieldSetFlags()[3] ? this.calories : (Double)this.defaultValue(this.fields()[3]);
                record.level = this.fieldSetFlags()[4] ? this.level : (Integer)this.defaultValue(this.fields()[4]);
                record.mets = this.fieldSetFlags()[5] ? this.mets : (Double)this.defaultValue(this.fields()[5]);
                return record;
            }
            catch (AvroMissingFieldException e) {
                throw e;
            }
            catch (Exception e) {
                throw new AvroRuntimeException((Throwable)e);
            }
        }
    }
}

