/*
 * Decompiled with CFR 0.152.
 */
package org.radarcns.connector.fitbit;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.nio.ByteBuffer;
import org.apache.avro.AvroMissingFieldException;
import org.apache.avro.AvroRuntimeException;
import org.apache.avro.Schema;
import org.apache.avro.data.RecordBuilder;
import org.apache.avro.generic.GenericData;
import org.apache.avro.io.DatumReader;
import org.apache.avro.io.DatumWriter;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.Encoder;
import org.apache.avro.io.ResolvingDecoder;
import org.apache.avro.message.BinaryMessageDecoder;
import org.apache.avro.message.BinaryMessageEncoder;
import org.apache.avro.message.SchemaStore;
import org.apache.avro.specific.AvroGenerated;
import org.apache.avro.specific.SpecificData;
import org.apache.avro.specific.SpecificRecord;
import org.apache.avro.specific.SpecificRecordBase;
import org.apache.avro.specific.SpecificRecordBuilderBase;

@AvroGenerated
public class FitbitFoodLog
extends SpecificRecordBase
implements SpecificRecord {
    private static final long serialVersionUID = -8821518985068099579L;
    public static final Schema SCHEMA$ = new Schema.Parser().parse("{\"type\":\"record\",\"name\":\"FitbitFoodLog\",\"namespace\":\"org.radarcns.connector.fitbit\",\"doc\":\"A summary of the user's food log entry for a given day.\",\"fields\":[{\"name\":\"time\",\"type\":\"double\",\"doc\":\"Device timestamp in UTC (s).\"},{\"name\":\"timeReceived\",\"type\":\"double\",\"doc\":\"Time that the data was received from the Fitbit API (seconds since the Unix Epoch).\"},{\"name\":\"isFavorite\",\"type\":\"boolean\",\"doc\":\"Whether the food is the favorite one.\"},{\"name\":\"logId\",\"type\":\"long\",\"doc\":\"The id of the logged food.\"},{\"name\":\"accessLevel\",\"type\":{\"type\":\"string\",\"avro.java.string\":\"String\"},\"doc\":\"The access level of the food. There are three access level types for food log entries that an authorized user can view via API requests. Each food is annotated with an accessLevel field with one of the following values: PUBLIC - Foods that are in Fitbit's public food database and are visible to any Fitbit users. Only Fitbit populates this database to avoid spam and duplicate entries. PRIVATE - Foods created by a user either on the website or via the Create Food endpoint. SHARED - A food created by a user whose foods privacy is set to Friends or Anyone. These can be logged either on the website or via the Create Food endpoint. These foods can be discovered using the Search Foods endpoint.\"},{\"name\":\"amount\",\"type\":\"int\",\"doc\":\"The amount of the food. Unit can be accessed from From the unitName of the food.\"},{\"name\":\"brand\",\"type\":{\"type\":\"string\",\"avro.java.string\":\"String\"},\"doc\":\"The brand of the food.\"},{\"name\":\"foodId\",\"type\":\"long\",\"doc\":\"The id of the food. This can be from the Fitbit food database or a private food the authorized user has entered - https://dev.fitbit.com/build/reference/web-api/nutrition/get-food/.\"},{\"name\":\"locale\",\"type\":{\"type\":\"string\",\"avro.java.string\":\"String\"},\"doc\":\"The locale of the food. Example format - en_US.\"},{\"name\":\"mealTypeId\",\"type\":\"long\",\"doc\":\"The meal type id of the food. The mealTypeId field is always 7 (Anytime). Meals are not associated with particular times.\"},{\"name\":\"name\",\"type\":{\"type\":\"string\",\"avro.java.string\":\"String\"},\"doc\":\"The name of the food.\"},{\"name\":\"unitId\",\"type\":\"long\",\"doc\":\"The unit id of the food. Typically, an application retrieves the complete list of units once at startup. From then on, the application will receive a food-specific list of unit ids along with the [Favorite](https://dev.fitbit.com/build/reference/web-api/nutrition/get-favorite-foods/), [Recent](https://dev.fitbit.com/build/reference/web-api/nutrition/get-recent-foods/), or [Frequent](https://dev.fitbit.com/build/reference/web-api/nutrition/get-frequent-foods/) food or by making a query to [Search Foods](https://dev.fitbit.com/build/reference/web-api/nutrition/search-foods/) endpoint. These are the IDs of units that apply to the favorite food. The application will refer to the complete list of units retrieved previously to get and display to the user the unit name or plural name for each unit ID on food-specific list.\"},{\"name\":\"unitName\",\"type\":{\"type\":\"string\",\"avro.java.string\":\"String\"},\"doc\":\"The unit name of the food.\"},{\"name\":\"unitPlural\",\"type\":{\"type\":\"string\",\"avro.java.string\":\"String\"},\"doc\":\"The plural unit name of the food.\"},{\"name\":\"calories\",\"type\":\"float\",\"doc\":\"The calories of the food in kilocalories.\"},{\"name\":\"carbs\",\"type\":\"float\",\"doc\":\"The carbs of the food in grams.\"},{\"name\":\"fat\",\"type\":\"float\",\"doc\":\"The fat of the food in grams.\"},{\"name\":\"fiber\",\"type\":\"float\",\"doc\":\"The fiber of the food in grams.\"},{\"name\":\"protein\",\"type\":\"float\",\"doc\":\"The protein of the food in grams.\"},{\"name\":\"sodium\",\"type\":\"float\",\"doc\":\"The sodium of the food in milligrams.\"}]}");
    private static final SpecificData MODEL$ = new SpecificData();
    private static final BinaryMessageEncoder<FitbitFoodLog> ENCODER = new BinaryMessageEncoder((GenericData)MODEL$, SCHEMA$);
    private static final BinaryMessageDecoder<FitbitFoodLog> DECODER = new BinaryMessageDecoder((GenericData)MODEL$, SCHEMA$);
    private double time;
    private double timeReceived;
    private boolean isFavorite;
    private long logId;
    private String accessLevel;
    private int amount;
    private String brand;
    private long foodId;
    private String locale;
    private long mealTypeId;
    private String name;
    private long unitId;
    private String unitName;
    private String unitPlural;
    private float calories;
    private float carbs;
    private float fat;
    private float fiber;
    private float protein;
    private float sodium;
    private static final DatumWriter<FitbitFoodLog> WRITER$ = MODEL$.createDatumWriter(SCHEMA$);
    private static final DatumReader<FitbitFoodLog> READER$ = MODEL$.createDatumReader(SCHEMA$);

    public static Schema getClassSchema() {
        return SCHEMA$;
    }

    public static BinaryMessageEncoder<FitbitFoodLog> getEncoder() {
        return ENCODER;
    }

    public static BinaryMessageDecoder<FitbitFoodLog> getDecoder() {
        return DECODER;
    }

    public static BinaryMessageDecoder<FitbitFoodLog> createDecoder(SchemaStore resolver) {
        return new BinaryMessageDecoder((GenericData)MODEL$, SCHEMA$, resolver);
    }

    public ByteBuffer toByteBuffer() throws IOException {
        return ENCODER.encode((Object)this);
    }

    public static FitbitFoodLog fromByteBuffer(ByteBuffer b) throws IOException {
        return (FitbitFoodLog)((Object)DECODER.decode(b));
    }

    public FitbitFoodLog() {
    }

    public FitbitFoodLog(Double time, Double timeReceived, Boolean isFavorite, Long logId, String accessLevel, Integer amount, String brand, Long foodId, String locale, Long mealTypeId, String name, Long unitId, String unitName, String unitPlural, Float calories, Float carbs, Float fat, Float fiber, Float protein, Float sodium) {
        this.time = time;
        this.timeReceived = timeReceived;
        this.isFavorite = isFavorite;
        this.logId = logId;
        this.accessLevel = accessLevel;
        this.amount = amount;
        this.brand = brand;
        this.foodId = foodId;
        this.locale = locale;
        this.mealTypeId = mealTypeId;
        this.name = name;
        this.unitId = unitId;
        this.unitName = unitName;
        this.unitPlural = unitPlural;
        this.calories = calories.floatValue();
        this.carbs = carbs.floatValue();
        this.fat = fat.floatValue();
        this.fiber = fiber.floatValue();
        this.protein = protein.floatValue();
        this.sodium = sodium.floatValue();
    }

    public SpecificData getSpecificData() {
        return MODEL$;
    }

    public Schema getSchema() {
        return SCHEMA$;
    }

    public Object get(int field$) {
        switch (field$) {
            case 0: {
                return this.time;
            }
            case 1: {
                return this.timeReceived;
            }
            case 2: {
                return this.isFavorite;
            }
            case 3: {
                return this.logId;
            }
            case 4: {
                return this.accessLevel;
            }
            case 5: {
                return this.amount;
            }
            case 6: {
                return this.brand;
            }
            case 7: {
                return this.foodId;
            }
            case 8: {
                return this.locale;
            }
            case 9: {
                return this.mealTypeId;
            }
            case 10: {
                return this.name;
            }
            case 11: {
                return this.unitId;
            }
            case 12: {
                return this.unitName;
            }
            case 13: {
                return this.unitPlural;
            }
            case 14: {
                return Float.valueOf(this.calories);
            }
            case 15: {
                return Float.valueOf(this.carbs);
            }
            case 16: {
                return Float.valueOf(this.fat);
            }
            case 17: {
                return Float.valueOf(this.fiber);
            }
            case 18: {
                return Float.valueOf(this.protein);
            }
            case 19: {
                return Float.valueOf(this.sodium);
            }
        }
        throw new IndexOutOfBoundsException("Invalid index: " + field$);
    }

    public void put(int field$, Object value$) {
        switch (field$) {
            case 0: {
                this.time = (Double)value$;
                break;
            }
            case 1: {
                this.timeReceived = (Double)value$;
                break;
            }
            case 2: {
                this.isFavorite = (Boolean)value$;
                break;
            }
            case 3: {
                this.logId = (Long)value$;
                break;
            }
            case 4: {
                this.accessLevel = value$ != null ? value$.toString() : null;
                break;
            }
            case 5: {
                this.amount = (Integer)value$;
                break;
            }
            case 6: {
                this.brand = value$ != null ? value$.toString() : null;
                break;
            }
            case 7: {
                this.foodId = (Long)value$;
                break;
            }
            case 8: {
                this.locale = value$ != null ? value$.toString() : null;
                break;
            }
            case 9: {
                this.mealTypeId = (Long)value$;
                break;
            }
            case 10: {
                this.name = value$ != null ? value$.toString() : null;
                break;
            }
            case 11: {
                this.unitId = (Long)value$;
                break;
            }
            case 12: {
                this.unitName = value$ != null ? value$.toString() : null;
                break;
            }
            case 13: {
                this.unitPlural = value$ != null ? value$.toString() : null;
                break;
            }
            case 14: {
                this.calories = ((Float)value$).floatValue();
                break;
            }
            case 15: {
                this.carbs = ((Float)value$).floatValue();
                break;
            }
            case 16: {
                this.fat = ((Float)value$).floatValue();
                break;
            }
            case 17: {
                this.fiber = ((Float)value$).floatValue();
                break;
            }
            case 18: {
                this.protein = ((Float)value$).floatValue();
                break;
            }
            case 19: {
                this.sodium = ((Float)value$).floatValue();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException("Invalid index: " + field$);
            }
        }
    }

    public double getTime() {
        return this.time;
    }

    public void setTime(double value) {
        this.time = value;
    }

    public double getTimeReceived() {
        return this.timeReceived;
    }

    public void setTimeReceived(double value) {
        this.timeReceived = value;
    }

    public boolean getIsFavorite() {
        return this.isFavorite;
    }

    public void setIsFavorite(boolean value) {
        this.isFavorite = value;
    }

    public long getLogId() {
        return this.logId;
    }

    public void setLogId(long value) {
        this.logId = value;
    }

    public String getAccessLevel() {
        return this.accessLevel;
    }

    public void setAccessLevel(String value) {
        this.accessLevel = value;
    }

    public int getAmount() {
        return this.amount;
    }

    public void setAmount(int value) {
        this.amount = value;
    }

    public String getBrand() {
        return this.brand;
    }

    public void setBrand(String value) {
        this.brand = value;
    }

    public long getFoodId() {
        return this.foodId;
    }

    public void setFoodId(long value) {
        this.foodId = value;
    }

    public String getLocale() {
        return this.locale;
    }

    public void setLocale(String value) {
        this.locale = value;
    }

    public long getMealTypeId() {
        return this.mealTypeId;
    }

    public void setMealTypeId(long value) {
        this.mealTypeId = value;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String value) {
        this.name = value;
    }

    public long getUnitId() {
        return this.unitId;
    }

    public void setUnitId(long value) {
        this.unitId = value;
    }

    public String getUnitName() {
        return this.unitName;
    }

    public void setUnitName(String value) {
        this.unitName = value;
    }

    public String getUnitPlural() {
        return this.unitPlural;
    }

    public void setUnitPlural(String value) {
        this.unitPlural = value;
    }

    public float getCalories() {
        return this.calories;
    }

    public void setCalories(float value) {
        this.calories = value;
    }

    public float getCarbs() {
        return this.carbs;
    }

    public void setCarbs(float value) {
        this.carbs = value;
    }

    public float getFat() {
        return this.fat;
    }

    public void setFat(float value) {
        this.fat = value;
    }

    public float getFiber() {
        return this.fiber;
    }

    public void setFiber(float value) {
        this.fiber = value;
    }

    public float getProtein() {
        return this.protein;
    }

    public void setProtein(float value) {
        this.protein = value;
    }

    public float getSodium() {
        return this.sodium;
    }

    public void setSodium(float value) {
        this.sodium = value;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newBuilder(Builder other) {
        if (other == null) {
            return new Builder();
        }
        return new Builder(other);
    }

    public static Builder newBuilder(FitbitFoodLog other) {
        if (other == null) {
            return new Builder();
        }
        return new Builder(other);
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        WRITER$.write((Object)this, (Encoder)SpecificData.getEncoder((ObjectOutput)out));
    }

    public void readExternal(ObjectInput in) throws IOException {
        READER$.read((Object)this, (Decoder)SpecificData.getDecoder((ObjectInput)in));
    }

    protected boolean hasCustomCoders() {
        return true;
    }

    public void customEncode(Encoder out) throws IOException {
        out.writeDouble(this.time);
        out.writeDouble(this.timeReceived);
        out.writeBoolean(this.isFavorite);
        out.writeLong(this.logId);
        out.writeString(this.accessLevel);
        out.writeInt(this.amount);
        out.writeString(this.brand);
        out.writeLong(this.foodId);
        out.writeString(this.locale);
        out.writeLong(this.mealTypeId);
        out.writeString(this.name);
        out.writeLong(this.unitId);
        out.writeString(this.unitName);
        out.writeString(this.unitPlural);
        out.writeFloat(this.calories);
        out.writeFloat(this.carbs);
        out.writeFloat(this.fat);
        out.writeFloat(this.fiber);
        out.writeFloat(this.protein);
        out.writeFloat(this.sodium);
    }

    public void customDecode(ResolvingDecoder in) throws IOException {
        Schema.Field[] fieldOrder = in.readFieldOrderIfDiff();
        if (fieldOrder == null) {
            this.time = in.readDouble();
            this.timeReceived = in.readDouble();
            this.isFavorite = in.readBoolean();
            this.logId = in.readLong();
            this.accessLevel = in.readString();
            this.amount = in.readInt();
            this.brand = in.readString();
            this.foodId = in.readLong();
            this.locale = in.readString();
            this.mealTypeId = in.readLong();
            this.name = in.readString();
            this.unitId = in.readLong();
            this.unitName = in.readString();
            this.unitPlural = in.readString();
            this.calories = in.readFloat();
            this.carbs = in.readFloat();
            this.fat = in.readFloat();
            this.fiber = in.readFloat();
            this.protein = in.readFloat();
            this.sodium = in.readFloat();
        } else {
            block22: for (int i = 0; i < 20; ++i) {
                switch (fieldOrder[i].pos()) {
                    case 0: {
                        this.time = in.readDouble();
                        continue block22;
                    }
                    case 1: {
                        this.timeReceived = in.readDouble();
                        continue block22;
                    }
                    case 2: {
                        this.isFavorite = in.readBoolean();
                        continue block22;
                    }
                    case 3: {
                        this.logId = in.readLong();
                        continue block22;
                    }
                    case 4: {
                        this.accessLevel = in.readString();
                        continue block22;
                    }
                    case 5: {
                        this.amount = in.readInt();
                        continue block22;
                    }
                    case 6: {
                        this.brand = in.readString();
                        continue block22;
                    }
                    case 7: {
                        this.foodId = in.readLong();
                        continue block22;
                    }
                    case 8: {
                        this.locale = in.readString();
                        continue block22;
                    }
                    case 9: {
                        this.mealTypeId = in.readLong();
                        continue block22;
                    }
                    case 10: {
                        this.name = in.readString();
                        continue block22;
                    }
                    case 11: {
                        this.unitId = in.readLong();
                        continue block22;
                    }
                    case 12: {
                        this.unitName = in.readString();
                        continue block22;
                    }
                    case 13: {
                        this.unitPlural = in.readString();
                        continue block22;
                    }
                    case 14: {
                        this.calories = in.readFloat();
                        continue block22;
                    }
                    case 15: {
                        this.carbs = in.readFloat();
                        continue block22;
                    }
                    case 16: {
                        this.fat = in.readFloat();
                        continue block22;
                    }
                    case 17: {
                        this.fiber = in.readFloat();
                        continue block22;
                    }
                    case 18: {
                        this.protein = in.readFloat();
                        continue block22;
                    }
                    case 19: {
                        this.sodium = in.readFloat();
                        continue block22;
                    }
                    default: {
                        throw new IOException("Corrupt ResolvingDecoder.");
                    }
                }
            }
        }
    }

    @AvroGenerated
    public static class Builder
    extends SpecificRecordBuilderBase<FitbitFoodLog>
    implements RecordBuilder<FitbitFoodLog> {
        private double time;
        private double timeReceived;
        private boolean isFavorite;
        private long logId;
        private String accessLevel;
        private int amount;
        private String brand;
        private long foodId;
        private String locale;
        private long mealTypeId;
        private String name;
        private long unitId;
        private String unitName;
        private String unitPlural;
        private float calories;
        private float carbs;
        private float fat;
        private float fiber;
        private float protein;
        private float sodium;

        private Builder() {
            super(SCHEMA$, MODEL$);
        }

        private Builder(Builder other) {
            super((SpecificRecordBuilderBase)other);
            if (Builder.isValidValue((Schema.Field)this.fields()[0], (Object)other.time)) {
                this.time = (Double)this.data().deepCopy(this.fields()[0].schema(), (Object)other.time);
                this.fieldSetFlags()[0] = other.fieldSetFlags()[0];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[1], (Object)other.timeReceived)) {
                this.timeReceived = (Double)this.data().deepCopy(this.fields()[1].schema(), (Object)other.timeReceived);
                this.fieldSetFlags()[1] = other.fieldSetFlags()[1];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[2], (Object)other.isFavorite)) {
                this.isFavorite = (Boolean)this.data().deepCopy(this.fields()[2].schema(), (Object)other.isFavorite);
                this.fieldSetFlags()[2] = other.fieldSetFlags()[2];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[3], (Object)other.logId)) {
                this.logId = (Long)this.data().deepCopy(this.fields()[3].schema(), (Object)other.logId);
                this.fieldSetFlags()[3] = other.fieldSetFlags()[3];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[4], (Object)other.accessLevel)) {
                this.accessLevel = (String)this.data().deepCopy(this.fields()[4].schema(), (Object)other.accessLevel);
                this.fieldSetFlags()[4] = other.fieldSetFlags()[4];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[5], (Object)other.amount)) {
                this.amount = (Integer)this.data().deepCopy(this.fields()[5].schema(), (Object)other.amount);
                this.fieldSetFlags()[5] = other.fieldSetFlags()[5];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[6], (Object)other.brand)) {
                this.brand = (String)this.data().deepCopy(this.fields()[6].schema(), (Object)other.brand);
                this.fieldSetFlags()[6] = other.fieldSetFlags()[6];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[7], (Object)other.foodId)) {
                this.foodId = (Long)this.data().deepCopy(this.fields()[7].schema(), (Object)other.foodId);
                this.fieldSetFlags()[7] = other.fieldSetFlags()[7];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[8], (Object)other.locale)) {
                this.locale = (String)this.data().deepCopy(this.fields()[8].schema(), (Object)other.locale);
                this.fieldSetFlags()[8] = other.fieldSetFlags()[8];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[9], (Object)other.mealTypeId)) {
                this.mealTypeId = (Long)this.data().deepCopy(this.fields()[9].schema(), (Object)other.mealTypeId);
                this.fieldSetFlags()[9] = other.fieldSetFlags()[9];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[10], (Object)other.name)) {
                this.name = (String)this.data().deepCopy(this.fields()[10].schema(), (Object)other.name);
                this.fieldSetFlags()[10] = other.fieldSetFlags()[10];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[11], (Object)other.unitId)) {
                this.unitId = (Long)this.data().deepCopy(this.fields()[11].schema(), (Object)other.unitId);
                this.fieldSetFlags()[11] = other.fieldSetFlags()[11];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[12], (Object)other.unitName)) {
                this.unitName = (String)this.data().deepCopy(this.fields()[12].schema(), (Object)other.unitName);
                this.fieldSetFlags()[12] = other.fieldSetFlags()[12];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[13], (Object)other.unitPlural)) {
                this.unitPlural = (String)this.data().deepCopy(this.fields()[13].schema(), (Object)other.unitPlural);
                this.fieldSetFlags()[13] = other.fieldSetFlags()[13];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[14], (Object)Float.valueOf(other.calories))) {
                this.calories = ((Float)this.data().deepCopy(this.fields()[14].schema(), (Object)Float.valueOf(other.calories))).floatValue();
                this.fieldSetFlags()[14] = other.fieldSetFlags()[14];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[15], (Object)Float.valueOf(other.carbs))) {
                this.carbs = ((Float)this.data().deepCopy(this.fields()[15].schema(), (Object)Float.valueOf(other.carbs))).floatValue();
                this.fieldSetFlags()[15] = other.fieldSetFlags()[15];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[16], (Object)Float.valueOf(other.fat))) {
                this.fat = ((Float)this.data().deepCopy(this.fields()[16].schema(), (Object)Float.valueOf(other.fat))).floatValue();
                this.fieldSetFlags()[16] = other.fieldSetFlags()[16];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[17], (Object)Float.valueOf(other.fiber))) {
                this.fiber = ((Float)this.data().deepCopy(this.fields()[17].schema(), (Object)Float.valueOf(other.fiber))).floatValue();
                this.fieldSetFlags()[17] = other.fieldSetFlags()[17];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[18], (Object)Float.valueOf(other.protein))) {
                this.protein = ((Float)this.data().deepCopy(this.fields()[18].schema(), (Object)Float.valueOf(other.protein))).floatValue();
                this.fieldSetFlags()[18] = other.fieldSetFlags()[18];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[19], (Object)Float.valueOf(other.sodium))) {
                this.sodium = ((Float)this.data().deepCopy(this.fields()[19].schema(), (Object)Float.valueOf(other.sodium))).floatValue();
                this.fieldSetFlags()[19] = other.fieldSetFlags()[19];
            }
        }

        private Builder(FitbitFoodLog other) {
            super(SCHEMA$, MODEL$);
            if (Builder.isValidValue((Schema.Field)this.fields()[0], (Object)other.time)) {
                this.time = (Double)this.data().deepCopy(this.fields()[0].schema(), (Object)other.time);
                this.fieldSetFlags()[0] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[1], (Object)other.timeReceived)) {
                this.timeReceived = (Double)this.data().deepCopy(this.fields()[1].schema(), (Object)other.timeReceived);
                this.fieldSetFlags()[1] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[2], (Object)other.isFavorite)) {
                this.isFavorite = (Boolean)this.data().deepCopy(this.fields()[2].schema(), (Object)other.isFavorite);
                this.fieldSetFlags()[2] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[3], (Object)other.logId)) {
                this.logId = (Long)this.data().deepCopy(this.fields()[3].schema(), (Object)other.logId);
                this.fieldSetFlags()[3] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[4], (Object)other.accessLevel)) {
                this.accessLevel = (String)this.data().deepCopy(this.fields()[4].schema(), (Object)other.accessLevel);
                this.fieldSetFlags()[4] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[5], (Object)other.amount)) {
                this.amount = (Integer)this.data().deepCopy(this.fields()[5].schema(), (Object)other.amount);
                this.fieldSetFlags()[5] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[6], (Object)other.brand)) {
                this.brand = (String)this.data().deepCopy(this.fields()[6].schema(), (Object)other.brand);
                this.fieldSetFlags()[6] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[7], (Object)other.foodId)) {
                this.foodId = (Long)this.data().deepCopy(this.fields()[7].schema(), (Object)other.foodId);
                this.fieldSetFlags()[7] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[8], (Object)other.locale)) {
                this.locale = (String)this.data().deepCopy(this.fields()[8].schema(), (Object)other.locale);
                this.fieldSetFlags()[8] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[9], (Object)other.mealTypeId)) {
                this.mealTypeId = (Long)this.data().deepCopy(this.fields()[9].schema(), (Object)other.mealTypeId);
                this.fieldSetFlags()[9] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[10], (Object)other.name)) {
                this.name = (String)this.data().deepCopy(this.fields()[10].schema(), (Object)other.name);
                this.fieldSetFlags()[10] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[11], (Object)other.unitId)) {
                this.unitId = (Long)this.data().deepCopy(this.fields()[11].schema(), (Object)other.unitId);
                this.fieldSetFlags()[11] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[12], (Object)other.unitName)) {
                this.unitName = (String)this.data().deepCopy(this.fields()[12].schema(), (Object)other.unitName);
                this.fieldSetFlags()[12] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[13], (Object)other.unitPlural)) {
                this.unitPlural = (String)this.data().deepCopy(this.fields()[13].schema(), (Object)other.unitPlural);
                this.fieldSetFlags()[13] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[14], (Object)Float.valueOf(other.calories))) {
                this.calories = ((Float)this.data().deepCopy(this.fields()[14].schema(), (Object)Float.valueOf(other.calories))).floatValue();
                this.fieldSetFlags()[14] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[15], (Object)Float.valueOf(other.carbs))) {
                this.carbs = ((Float)this.data().deepCopy(this.fields()[15].schema(), (Object)Float.valueOf(other.carbs))).floatValue();
                this.fieldSetFlags()[15] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[16], (Object)Float.valueOf(other.fat))) {
                this.fat = ((Float)this.data().deepCopy(this.fields()[16].schema(), (Object)Float.valueOf(other.fat))).floatValue();
                this.fieldSetFlags()[16] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[17], (Object)Float.valueOf(other.fiber))) {
                this.fiber = ((Float)this.data().deepCopy(this.fields()[17].schema(), (Object)Float.valueOf(other.fiber))).floatValue();
                this.fieldSetFlags()[17] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[18], (Object)Float.valueOf(other.protein))) {
                this.protein = ((Float)this.data().deepCopy(this.fields()[18].schema(), (Object)Float.valueOf(other.protein))).floatValue();
                this.fieldSetFlags()[18] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[19], (Object)Float.valueOf(other.sodium))) {
                this.sodium = ((Float)this.data().deepCopy(this.fields()[19].schema(), (Object)Float.valueOf(other.sodium))).floatValue();
                this.fieldSetFlags()[19] = true;
            }
        }

        public double getTime() {
            return this.time;
        }

        public Builder setTime(double value) {
            this.validate(this.fields()[0], value);
            this.time = value;
            this.fieldSetFlags()[0] = true;
            return this;
        }

        public boolean hasTime() {
            return this.fieldSetFlags()[0];
        }

        public Builder clearTime() {
            this.fieldSetFlags()[0] = false;
            return this;
        }

        public double getTimeReceived() {
            return this.timeReceived;
        }

        public Builder setTimeReceived(double value) {
            this.validate(this.fields()[1], value);
            this.timeReceived = value;
            this.fieldSetFlags()[1] = true;
            return this;
        }

        public boolean hasTimeReceived() {
            return this.fieldSetFlags()[1];
        }

        public Builder clearTimeReceived() {
            this.fieldSetFlags()[1] = false;
            return this;
        }

        public boolean getIsFavorite() {
            return this.isFavorite;
        }

        public Builder setIsFavorite(boolean value) {
            this.validate(this.fields()[2], value);
            this.isFavorite = value;
            this.fieldSetFlags()[2] = true;
            return this;
        }

        public boolean hasIsFavorite() {
            return this.fieldSetFlags()[2];
        }

        public Builder clearIsFavorite() {
            this.fieldSetFlags()[2] = false;
            return this;
        }

        public long getLogId() {
            return this.logId;
        }

        public Builder setLogId(long value) {
            this.validate(this.fields()[3], value);
            this.logId = value;
            this.fieldSetFlags()[3] = true;
            return this;
        }

        public boolean hasLogId() {
            return this.fieldSetFlags()[3];
        }

        public Builder clearLogId() {
            this.fieldSetFlags()[3] = false;
            return this;
        }

        public String getAccessLevel() {
            return this.accessLevel;
        }

        public Builder setAccessLevel(String value) {
            this.validate(this.fields()[4], value);
            this.accessLevel = value;
            this.fieldSetFlags()[4] = true;
            return this;
        }

        public boolean hasAccessLevel() {
            return this.fieldSetFlags()[4];
        }

        public Builder clearAccessLevel() {
            this.accessLevel = null;
            this.fieldSetFlags()[4] = false;
            return this;
        }

        public int getAmount() {
            return this.amount;
        }

        public Builder setAmount(int value) {
            this.validate(this.fields()[5], value);
            this.amount = value;
            this.fieldSetFlags()[5] = true;
            return this;
        }

        public boolean hasAmount() {
            return this.fieldSetFlags()[5];
        }

        public Builder clearAmount() {
            this.fieldSetFlags()[5] = false;
            return this;
        }

        public String getBrand() {
            return this.brand;
        }

        public Builder setBrand(String value) {
            this.validate(this.fields()[6], value);
            this.brand = value;
            this.fieldSetFlags()[6] = true;
            return this;
        }

        public boolean hasBrand() {
            return this.fieldSetFlags()[6];
        }

        public Builder clearBrand() {
            this.brand = null;
            this.fieldSetFlags()[6] = false;
            return this;
        }

        public long getFoodId() {
            return this.foodId;
        }

        public Builder setFoodId(long value) {
            this.validate(this.fields()[7], value);
            this.foodId = value;
            this.fieldSetFlags()[7] = true;
            return this;
        }

        public boolean hasFoodId() {
            return this.fieldSetFlags()[7];
        }

        public Builder clearFoodId() {
            this.fieldSetFlags()[7] = false;
            return this;
        }

        public String getLocale() {
            return this.locale;
        }

        public Builder setLocale(String value) {
            this.validate(this.fields()[8], value);
            this.locale = value;
            this.fieldSetFlags()[8] = true;
            return this;
        }

        public boolean hasLocale() {
            return this.fieldSetFlags()[8];
        }

        public Builder clearLocale() {
            this.locale = null;
            this.fieldSetFlags()[8] = false;
            return this;
        }

        public long getMealTypeId() {
            return this.mealTypeId;
        }

        public Builder setMealTypeId(long value) {
            this.validate(this.fields()[9], value);
            this.mealTypeId = value;
            this.fieldSetFlags()[9] = true;
            return this;
        }

        public boolean hasMealTypeId() {
            return this.fieldSetFlags()[9];
        }

        public Builder clearMealTypeId() {
            this.fieldSetFlags()[9] = false;
            return this;
        }

        public String getName() {
            return this.name;
        }

        public Builder setName(String value) {
            this.validate(this.fields()[10], value);
            this.name = value;
            this.fieldSetFlags()[10] = true;
            return this;
        }

        public boolean hasName() {
            return this.fieldSetFlags()[10];
        }

        public Builder clearName() {
            this.name = null;
            this.fieldSetFlags()[10] = false;
            return this;
        }

        public long getUnitId() {
            return this.unitId;
        }

        public Builder setUnitId(long value) {
            this.validate(this.fields()[11], value);
            this.unitId = value;
            this.fieldSetFlags()[11] = true;
            return this;
        }

        public boolean hasUnitId() {
            return this.fieldSetFlags()[11];
        }

        public Builder clearUnitId() {
            this.fieldSetFlags()[11] = false;
            return this;
        }

        public String getUnitName() {
            return this.unitName;
        }

        public Builder setUnitName(String value) {
            this.validate(this.fields()[12], value);
            this.unitName = value;
            this.fieldSetFlags()[12] = true;
            return this;
        }

        public boolean hasUnitName() {
            return this.fieldSetFlags()[12];
        }

        public Builder clearUnitName() {
            this.unitName = null;
            this.fieldSetFlags()[12] = false;
            return this;
        }

        public String getUnitPlural() {
            return this.unitPlural;
        }

        public Builder setUnitPlural(String value) {
            this.validate(this.fields()[13], value);
            this.unitPlural = value;
            this.fieldSetFlags()[13] = true;
            return this;
        }

        public boolean hasUnitPlural() {
            return this.fieldSetFlags()[13];
        }

        public Builder clearUnitPlural() {
            this.unitPlural = null;
            this.fieldSetFlags()[13] = false;
            return this;
        }

        public float getCalories() {
            return this.calories;
        }

        public Builder setCalories(float value) {
            this.validate(this.fields()[14], Float.valueOf(value));
            this.calories = value;
            this.fieldSetFlags()[14] = true;
            return this;
        }

        public boolean hasCalories() {
            return this.fieldSetFlags()[14];
        }

        public Builder clearCalories() {
            this.fieldSetFlags()[14] = false;
            return this;
        }

        public float getCarbs() {
            return this.carbs;
        }

        public Builder setCarbs(float value) {
            this.validate(this.fields()[15], Float.valueOf(value));
            this.carbs = value;
            this.fieldSetFlags()[15] = true;
            return this;
        }

        public boolean hasCarbs() {
            return this.fieldSetFlags()[15];
        }

        public Builder clearCarbs() {
            this.fieldSetFlags()[15] = false;
            return this;
        }

        public float getFat() {
            return this.fat;
        }

        public Builder setFat(float value) {
            this.validate(this.fields()[16], Float.valueOf(value));
            this.fat = value;
            this.fieldSetFlags()[16] = true;
            return this;
        }

        public boolean hasFat() {
            return this.fieldSetFlags()[16];
        }

        public Builder clearFat() {
            this.fieldSetFlags()[16] = false;
            return this;
        }

        public float getFiber() {
            return this.fiber;
        }

        public Builder setFiber(float value) {
            this.validate(this.fields()[17], Float.valueOf(value));
            this.fiber = value;
            this.fieldSetFlags()[17] = true;
            return this;
        }

        public boolean hasFiber() {
            return this.fieldSetFlags()[17];
        }

        public Builder clearFiber() {
            this.fieldSetFlags()[17] = false;
            return this;
        }

        public float getProtein() {
            return this.protein;
        }

        public Builder setProtein(float value) {
            this.validate(this.fields()[18], Float.valueOf(value));
            this.protein = value;
            this.fieldSetFlags()[18] = true;
            return this;
        }

        public boolean hasProtein() {
            return this.fieldSetFlags()[18];
        }

        public Builder clearProtein() {
            this.fieldSetFlags()[18] = false;
            return this;
        }

        public float getSodium() {
            return this.sodium;
        }

        public Builder setSodium(float value) {
            this.validate(this.fields()[19], Float.valueOf(value));
            this.sodium = value;
            this.fieldSetFlags()[19] = true;
            return this;
        }

        public boolean hasSodium() {
            return this.fieldSetFlags()[19];
        }

        public Builder clearSodium() {
            this.fieldSetFlags()[19] = false;
            return this;
        }

        public FitbitFoodLog build() {
            try {
                FitbitFoodLog record = new FitbitFoodLog();
                record.time = this.fieldSetFlags()[0] ? this.time : (Double)this.defaultValue(this.fields()[0]);
                record.timeReceived = this.fieldSetFlags()[1] ? this.timeReceived : (Double)this.defaultValue(this.fields()[1]);
                record.isFavorite = this.fieldSetFlags()[2] ? this.isFavorite : (Boolean)this.defaultValue(this.fields()[2]);
                record.logId = this.fieldSetFlags()[3] ? this.logId : (Long)this.defaultValue(this.fields()[3]);
                record.accessLevel = this.fieldSetFlags()[4] ? this.accessLevel : (String)this.defaultValue(this.fields()[4]);
                record.amount = this.fieldSetFlags()[5] ? this.amount : (Integer)this.defaultValue(this.fields()[5]);
                record.brand = this.fieldSetFlags()[6] ? this.brand : (String)this.defaultValue(this.fields()[6]);
                record.foodId = this.fieldSetFlags()[7] ? this.foodId : (Long)this.defaultValue(this.fields()[7]);
                record.locale = this.fieldSetFlags()[8] ? this.locale : (String)this.defaultValue(this.fields()[8]);
                record.mealTypeId = this.fieldSetFlags()[9] ? this.mealTypeId : (Long)this.defaultValue(this.fields()[9]);
                record.name = this.fieldSetFlags()[10] ? this.name : (String)this.defaultValue(this.fields()[10]);
                record.unitId = this.fieldSetFlags()[11] ? this.unitId : (Long)this.defaultValue(this.fields()[11]);
                record.unitName = this.fieldSetFlags()[12] ? this.unitName : (String)this.defaultValue(this.fields()[12]);
                record.unitPlural = this.fieldSetFlags()[13] ? this.unitPlural : (String)this.defaultValue(this.fields()[13]);
                record.calories = this.fieldSetFlags()[14] ? this.calories : ((Float)this.defaultValue(this.fields()[14])).floatValue();
                record.carbs = this.fieldSetFlags()[15] ? this.carbs : ((Float)this.defaultValue(this.fields()[15])).floatValue();
                record.fat = this.fieldSetFlags()[16] ? this.fat : ((Float)this.defaultValue(this.fields()[16])).floatValue();
                record.fiber = this.fieldSetFlags()[17] ? this.fiber : ((Float)this.defaultValue(this.fields()[17])).floatValue();
                record.protein = this.fieldSetFlags()[18] ? this.protein : ((Float)this.defaultValue(this.fields()[18])).floatValue();
                record.sodium = this.fieldSetFlags()[19] ? this.sodium : ((Float)this.defaultValue(this.fields()[19])).floatValue();
                return record;
            }
            catch (AvroMissingFieldException e) {
                throw e;
            }
            catch (Exception e) {
                throw new AvroRuntimeException((Throwable)e);
            }
        }
    }
}

