/*
 * Decompiled with CFR 0.152.
 */
package org.radarcns.connector.fitbit;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.nio.ByteBuffer;
import org.apache.avro.AvroMissingFieldException;
import org.apache.avro.AvroRuntimeException;
import org.apache.avro.Schema;
import org.apache.avro.data.RecordBuilder;
import org.apache.avro.generic.GenericData;
import org.apache.avro.io.DatumReader;
import org.apache.avro.io.DatumWriter;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.Encoder;
import org.apache.avro.io.ResolvingDecoder;
import org.apache.avro.message.BinaryMessageDecoder;
import org.apache.avro.message.BinaryMessageEncoder;
import org.apache.avro.message.SchemaStore;
import org.apache.avro.specific.AvroGenerated;
import org.apache.avro.specific.SpecificData;
import org.apache.avro.specific.SpecificRecord;
import org.apache.avro.specific.SpecificRecordBase;
import org.apache.avro.specific.SpecificRecordBuilderBase;

@AvroGenerated
public class FitbitBreathingRate
extends SpecificRecordBase
implements SpecificRecord {
    private static final long serialVersionUID = -7028681920445066353L;
    public static final Schema SCHEMA$ = new Schema.Parser().parse("{\"type\":\"record\",\"name\":\"FitbitBreathingRate\",\"namespace\":\"org.radarcns.connector.fitbit\",\"doc\":\"Breathing rate (BR) data from fitbit device. BR measures the average breathing rate throughout the day and categories your breathing rate by sleep stage. Sleep stages vary between light sleep, deep sleep, REM sleep, and full sleep.\",\"fields\":[{\"name\":\"time\",\"type\":\"double\",\"doc\":\"Device timestamp in UTC (s).\"},{\"name\":\"timeReceived\",\"type\":\"double\",\"doc\":\"Time that the data was received from the Fitbit API (seconds since the Unix Epoch).\"},{\"name\":\"lightSleep\",\"type\":\"float\",\"doc\":\"Average number of breaths taken per minute when the user was in light sleep.\"},{\"name\":\"deepSleep\",\"type\":\"float\",\"doc\":\"Average number of breaths taken per minute when the user was in deep sleep.\"},{\"name\":\"remSleep\",\"type\":\"float\",\"doc\":\"Average number of breaths taken per minute when the user was in rem sleep.\"},{\"name\":\"fullSleep\",\"type\":\"float\",\"doc\":\"Average number of breaths taken per minute throughout the entire period of sleep which you can compare to the sleep stage-specific measurements.\"}]}");
    private static final SpecificData MODEL$ = new SpecificData();
    private static final BinaryMessageEncoder<FitbitBreathingRate> ENCODER = new BinaryMessageEncoder((GenericData)MODEL$, SCHEMA$);
    private static final BinaryMessageDecoder<FitbitBreathingRate> DECODER = new BinaryMessageDecoder((GenericData)MODEL$, SCHEMA$);
    private double time;
    private double timeReceived;
    private float lightSleep;
    private float deepSleep;
    private float remSleep;
    private float fullSleep;
    private static final DatumWriter<FitbitBreathingRate> WRITER$ = MODEL$.createDatumWriter(SCHEMA$);
    private static final DatumReader<FitbitBreathingRate> READER$ = MODEL$.createDatumReader(SCHEMA$);

    public static Schema getClassSchema() {
        return SCHEMA$;
    }

    public static BinaryMessageEncoder<FitbitBreathingRate> getEncoder() {
        return ENCODER;
    }

    public static BinaryMessageDecoder<FitbitBreathingRate> getDecoder() {
        return DECODER;
    }

    public static BinaryMessageDecoder<FitbitBreathingRate> createDecoder(SchemaStore resolver) {
        return new BinaryMessageDecoder((GenericData)MODEL$, SCHEMA$, resolver);
    }

    public ByteBuffer toByteBuffer() throws IOException {
        return ENCODER.encode((Object)this);
    }

    public static FitbitBreathingRate fromByteBuffer(ByteBuffer b) throws IOException {
        return (FitbitBreathingRate)((Object)DECODER.decode(b));
    }

    public FitbitBreathingRate() {
    }

    public FitbitBreathingRate(Double time, Double timeReceived, Float lightSleep, Float deepSleep, Float remSleep, Float fullSleep) {
        this.time = time;
        this.timeReceived = timeReceived;
        this.lightSleep = lightSleep.floatValue();
        this.deepSleep = deepSleep.floatValue();
        this.remSleep = remSleep.floatValue();
        this.fullSleep = fullSleep.floatValue();
    }

    public SpecificData getSpecificData() {
        return MODEL$;
    }

    public Schema getSchema() {
        return SCHEMA$;
    }

    public Object get(int field$) {
        switch (field$) {
            case 0: {
                return this.time;
            }
            case 1: {
                return this.timeReceived;
            }
            case 2: {
                return Float.valueOf(this.lightSleep);
            }
            case 3: {
                return Float.valueOf(this.deepSleep);
            }
            case 4: {
                return Float.valueOf(this.remSleep);
            }
            case 5: {
                return Float.valueOf(this.fullSleep);
            }
        }
        throw new IndexOutOfBoundsException("Invalid index: " + field$);
    }

    public void put(int field$, Object value$) {
        switch (field$) {
            case 0: {
                this.time = (Double)value$;
                break;
            }
            case 1: {
                this.timeReceived = (Double)value$;
                break;
            }
            case 2: {
                this.lightSleep = ((Float)value$).floatValue();
                break;
            }
            case 3: {
                this.deepSleep = ((Float)value$).floatValue();
                break;
            }
            case 4: {
                this.remSleep = ((Float)value$).floatValue();
                break;
            }
            case 5: {
                this.fullSleep = ((Float)value$).floatValue();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException("Invalid index: " + field$);
            }
        }
    }

    public double getTime() {
        return this.time;
    }

    public void setTime(double value) {
        this.time = value;
    }

    public double getTimeReceived() {
        return this.timeReceived;
    }

    public void setTimeReceived(double value) {
        this.timeReceived = value;
    }

    public float getLightSleep() {
        return this.lightSleep;
    }

    public void setLightSleep(float value) {
        this.lightSleep = value;
    }

    public float getDeepSleep() {
        return this.deepSleep;
    }

    public void setDeepSleep(float value) {
        this.deepSleep = value;
    }

    public float getRemSleep() {
        return this.remSleep;
    }

    public void setRemSleep(float value) {
        this.remSleep = value;
    }

    public float getFullSleep() {
        return this.fullSleep;
    }

    public void setFullSleep(float value) {
        this.fullSleep = value;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newBuilder(Builder other) {
        if (other == null) {
            return new Builder();
        }
        return new Builder(other);
    }

    public static Builder newBuilder(FitbitBreathingRate other) {
        if (other == null) {
            return new Builder();
        }
        return new Builder(other);
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        WRITER$.write((Object)this, (Encoder)SpecificData.getEncoder((ObjectOutput)out));
    }

    public void readExternal(ObjectInput in) throws IOException {
        READER$.read((Object)this, (Decoder)SpecificData.getDecoder((ObjectInput)in));
    }

    protected boolean hasCustomCoders() {
        return true;
    }

    public void customEncode(Encoder out) throws IOException {
        out.writeDouble(this.time);
        out.writeDouble(this.timeReceived);
        out.writeFloat(this.lightSleep);
        out.writeFloat(this.deepSleep);
        out.writeFloat(this.remSleep);
        out.writeFloat(this.fullSleep);
    }

    public void customDecode(ResolvingDecoder in) throws IOException {
        Schema.Field[] fieldOrder = in.readFieldOrderIfDiff();
        if (fieldOrder == null) {
            this.time = in.readDouble();
            this.timeReceived = in.readDouble();
            this.lightSleep = in.readFloat();
            this.deepSleep = in.readFloat();
            this.remSleep = in.readFloat();
            this.fullSleep = in.readFloat();
        } else {
            block8: for (int i = 0; i < 6; ++i) {
                switch (fieldOrder[i].pos()) {
                    case 0: {
                        this.time = in.readDouble();
                        continue block8;
                    }
                    case 1: {
                        this.timeReceived = in.readDouble();
                        continue block8;
                    }
                    case 2: {
                        this.lightSleep = in.readFloat();
                        continue block8;
                    }
                    case 3: {
                        this.deepSleep = in.readFloat();
                        continue block8;
                    }
                    case 4: {
                        this.remSleep = in.readFloat();
                        continue block8;
                    }
                    case 5: {
                        this.fullSleep = in.readFloat();
                        continue block8;
                    }
                    default: {
                        throw new IOException("Corrupt ResolvingDecoder.");
                    }
                }
            }
        }
    }

    @AvroGenerated
    public static class Builder
    extends SpecificRecordBuilderBase<FitbitBreathingRate>
    implements RecordBuilder<FitbitBreathingRate> {
        private double time;
        private double timeReceived;
        private float lightSleep;
        private float deepSleep;
        private float remSleep;
        private float fullSleep;

        private Builder() {
            super(SCHEMA$, MODEL$);
        }

        private Builder(Builder other) {
            super((SpecificRecordBuilderBase)other);
            if (Builder.isValidValue((Schema.Field)this.fields()[0], (Object)other.time)) {
                this.time = (Double)this.data().deepCopy(this.fields()[0].schema(), (Object)other.time);
                this.fieldSetFlags()[0] = other.fieldSetFlags()[0];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[1], (Object)other.timeReceived)) {
                this.timeReceived = (Double)this.data().deepCopy(this.fields()[1].schema(), (Object)other.timeReceived);
                this.fieldSetFlags()[1] = other.fieldSetFlags()[1];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[2], (Object)Float.valueOf(other.lightSleep))) {
                this.lightSleep = ((Float)this.data().deepCopy(this.fields()[2].schema(), (Object)Float.valueOf(other.lightSleep))).floatValue();
                this.fieldSetFlags()[2] = other.fieldSetFlags()[2];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[3], (Object)Float.valueOf(other.deepSleep))) {
                this.deepSleep = ((Float)this.data().deepCopy(this.fields()[3].schema(), (Object)Float.valueOf(other.deepSleep))).floatValue();
                this.fieldSetFlags()[3] = other.fieldSetFlags()[3];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[4], (Object)Float.valueOf(other.remSleep))) {
                this.remSleep = ((Float)this.data().deepCopy(this.fields()[4].schema(), (Object)Float.valueOf(other.remSleep))).floatValue();
                this.fieldSetFlags()[4] = other.fieldSetFlags()[4];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[5], (Object)Float.valueOf(other.fullSleep))) {
                this.fullSleep = ((Float)this.data().deepCopy(this.fields()[5].schema(), (Object)Float.valueOf(other.fullSleep))).floatValue();
                this.fieldSetFlags()[5] = other.fieldSetFlags()[5];
            }
        }

        private Builder(FitbitBreathingRate other) {
            super(SCHEMA$, MODEL$);
            if (Builder.isValidValue((Schema.Field)this.fields()[0], (Object)other.time)) {
                this.time = (Double)this.data().deepCopy(this.fields()[0].schema(), (Object)other.time);
                this.fieldSetFlags()[0] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[1], (Object)other.timeReceived)) {
                this.timeReceived = (Double)this.data().deepCopy(this.fields()[1].schema(), (Object)other.timeReceived);
                this.fieldSetFlags()[1] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[2], (Object)Float.valueOf(other.lightSleep))) {
                this.lightSleep = ((Float)this.data().deepCopy(this.fields()[2].schema(), (Object)Float.valueOf(other.lightSleep))).floatValue();
                this.fieldSetFlags()[2] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[3], (Object)Float.valueOf(other.deepSleep))) {
                this.deepSleep = ((Float)this.data().deepCopy(this.fields()[3].schema(), (Object)Float.valueOf(other.deepSleep))).floatValue();
                this.fieldSetFlags()[3] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[4], (Object)Float.valueOf(other.remSleep))) {
                this.remSleep = ((Float)this.data().deepCopy(this.fields()[4].schema(), (Object)Float.valueOf(other.remSleep))).floatValue();
                this.fieldSetFlags()[4] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[5], (Object)Float.valueOf(other.fullSleep))) {
                this.fullSleep = ((Float)this.data().deepCopy(this.fields()[5].schema(), (Object)Float.valueOf(other.fullSleep))).floatValue();
                this.fieldSetFlags()[5] = true;
            }
        }

        public double getTime() {
            return this.time;
        }

        public Builder setTime(double value) {
            this.validate(this.fields()[0], value);
            this.time = value;
            this.fieldSetFlags()[0] = true;
            return this;
        }

        public boolean hasTime() {
            return this.fieldSetFlags()[0];
        }

        public Builder clearTime() {
            this.fieldSetFlags()[0] = false;
            return this;
        }

        public double getTimeReceived() {
            return this.timeReceived;
        }

        public Builder setTimeReceived(double value) {
            this.validate(this.fields()[1], value);
            this.timeReceived = value;
            this.fieldSetFlags()[1] = true;
            return this;
        }

        public boolean hasTimeReceived() {
            return this.fieldSetFlags()[1];
        }

        public Builder clearTimeReceived() {
            this.fieldSetFlags()[1] = false;
            return this;
        }

        public float getLightSleep() {
            return this.lightSleep;
        }

        public Builder setLightSleep(float value) {
            this.validate(this.fields()[2], Float.valueOf(value));
            this.lightSleep = value;
            this.fieldSetFlags()[2] = true;
            return this;
        }

        public boolean hasLightSleep() {
            return this.fieldSetFlags()[2];
        }

        public Builder clearLightSleep() {
            this.fieldSetFlags()[2] = false;
            return this;
        }

        public float getDeepSleep() {
            return this.deepSleep;
        }

        public Builder setDeepSleep(float value) {
            this.validate(this.fields()[3], Float.valueOf(value));
            this.deepSleep = value;
            this.fieldSetFlags()[3] = true;
            return this;
        }

        public boolean hasDeepSleep() {
            return this.fieldSetFlags()[3];
        }

        public Builder clearDeepSleep() {
            this.fieldSetFlags()[3] = false;
            return this;
        }

        public float getRemSleep() {
            return this.remSleep;
        }

        public Builder setRemSleep(float value) {
            this.validate(this.fields()[4], Float.valueOf(value));
            this.remSleep = value;
            this.fieldSetFlags()[4] = true;
            return this;
        }

        public boolean hasRemSleep() {
            return this.fieldSetFlags()[4];
        }

        public Builder clearRemSleep() {
            this.fieldSetFlags()[4] = false;
            return this;
        }

        public float getFullSleep() {
            return this.fullSleep;
        }

        public Builder setFullSleep(float value) {
            this.validate(this.fields()[5], Float.valueOf(value));
            this.fullSleep = value;
            this.fieldSetFlags()[5] = true;
            return this;
        }

        public boolean hasFullSleep() {
            return this.fieldSetFlags()[5];
        }

        public Builder clearFullSleep() {
            this.fieldSetFlags()[5] = false;
            return this;
        }

        public FitbitBreathingRate build() {
            try {
                FitbitBreathingRate record = new FitbitBreathingRate();
                record.time = this.fieldSetFlags()[0] ? this.time : (Double)this.defaultValue(this.fields()[0]);
                record.timeReceived = this.fieldSetFlags()[1] ? this.timeReceived : (Double)this.defaultValue(this.fields()[1]);
                record.lightSleep = this.fieldSetFlags()[2] ? this.lightSleep : ((Float)this.defaultValue(this.fields()[2])).floatValue();
                record.deepSleep = this.fieldSetFlags()[3] ? this.deepSleep : ((Float)this.defaultValue(this.fields()[3])).floatValue();
                record.remSleep = this.fieldSetFlags()[4] ? this.remSleep : ((Float)this.defaultValue(this.fields()[4])).floatValue();
                record.fullSleep = this.fieldSetFlags()[5] ? this.fullSleep : ((Float)this.defaultValue(this.fields()[5])).floatValue();
                return record;
            }
            catch (AvroMissingFieldException e) {
                throw e;
            }
            catch (Exception e) {
                throw new AvroRuntimeException((Throwable)e);
            }
        }
    }
}

