/*
 * Decompiled with CFR 0.152.
 */
package org.radarcns.connector.fitbit;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.nio.ByteBuffer;
import org.apache.avro.AvroMissingFieldException;
import org.apache.avro.AvroRuntimeException;
import org.apache.avro.Schema;
import org.apache.avro.data.RecordBuilder;
import org.apache.avro.generic.GenericData;
import org.apache.avro.io.DatumReader;
import org.apache.avro.io.DatumWriter;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.Encoder;
import org.apache.avro.io.ResolvingDecoder;
import org.apache.avro.message.BinaryMessageDecoder;
import org.apache.avro.message.BinaryMessageEncoder;
import org.apache.avro.message.SchemaStore;
import org.apache.avro.specific.AvroGenerated;
import org.apache.avro.specific.SpecificData;
import org.apache.avro.specific.SpecificRecord;
import org.apache.avro.specific.SpecificRecordBase;
import org.apache.avro.specific.SpecificRecordBuilderBase;
import org.radarcns.connector.fitbit.FitbitActivityHeartRate;
import org.radarcns.connector.fitbit.FitbitActivityLevels;
import org.radarcns.connector.fitbit.FitbitManualDataEntry;
import org.radarcns.connector.fitbit.FitbitSource;

@AvroGenerated
public class FitbitActivityLogRecord
extends SpecificRecordBase
implements SpecificRecord {
    private static final long serialVersionUID = 3859612025514742361L;
    public static final Schema SCHEMA$ = new Schema.Parser().parse("{\"type\":\"record\",\"name\":\"FitbitActivityLogRecord\",\"namespace\":\"org.radarcns.connector.fitbit\",\"doc\":\"Fitbit Activity Log record, containing the aggregate data of a single activity. This data is preprocessed by Fitbit, using algorithms based on the intraday data.\",\"fields\":[{\"name\":\"time\",\"type\":\"double\",\"doc\":\"Start time of the activity, time since the Unix Epoch (s).\"},{\"name\":\"timeReceived\",\"type\":\"double\",\"doc\":\"Time that this record was collected by a connector. Start time of the activity, seconds since the Unix Epoch (s).\"},{\"name\":\"timeZoneOffset\",\"type\":\"int\",\"doc\":\"Time zone offset compared to UTC (s).\"},{\"name\":\"timeLastModified\",\"type\":\"double\",\"doc\":\"Time when the record was last modified, time since the Unix Epoch (s).\"},{\"name\":\"duration\",\"type\":\"float\",\"doc\":\"Duration of the activity (s).\"},{\"name\":\"durationActive\",\"type\":\"float\",\"doc\":\"Duration of the part of the activity where the participant was active (s).\"},{\"name\":\"id\",\"type\":\"long\",\"doc\":\"Activity log ID.\"},{\"name\":\"name\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"doc\":\"Activity name. Null if none or unknown.\",\"default\":null},{\"name\":\"logType\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"doc\":\"Type of log, e.g. manual. Null if unknown.\",\"default\":null},{\"name\":\"type\",\"type\":[\"null\",\"long\"],\"doc\":\"Fitbit-generated ID of the type of activity. Null if unknown.\",\"default\":null},{\"name\":\"source\",\"type\":[\"null\",{\"type\":\"record\",\"name\":\"FitbitSource\",\"doc\":\"A single fitbit source, e.g. a watch or an app.\",\"fields\":[{\"name\":\"id\",\"type\":{\"type\":\"string\",\"avro.java.string\":\"String\"},\"doc\":\"Source id.\"},{\"name\":\"name\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"doc\":\"Source name. Null if unknown.\",\"default\":null},{\"name\":\"type\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"doc\":\"Source type. Null if unknown.\",\"default\":null},{\"name\":\"url\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"doc\":\"Source URL. Null if unknown.\",\"default\":null}]}],\"doc\":\"Source of the data. Null if unknown.\",\"default\":null},{\"name\":\"manualDataEntry\",\"type\":[\"null\",{\"type\":\"record\",\"name\":\"FitbitManualDataEntry\",\"doc\":\"Indicates values in an activity log that are entered manually by the user, instead of being automatically collected by a device.\",\"fields\":[{\"name\":\"distance\",\"type\":[\"null\",\"boolean\"],\"doc\":\"Whether the distance field was manually entered. Null if unknown.\",\"default\":null},{\"name\":\"energy\",\"type\":[\"null\",\"boolean\"],\"doc\":\"Whether the energy field was manually entered. Null if unknown.\",\"default\":null},{\"name\":\"steps\",\"type\":[\"null\",\"boolean\"],\"doc\":\"Whether the steps field was manually entered. Null if unknown.\",\"default\":null}]}],\"doc\":\"Indicates what values of this record are entered manually. Null if unknown.\",\"default\":null},{\"name\":\"energy\",\"type\":[\"null\",\"float\"],\"doc\":\"Estimated of energy expended during the activity (kJ). Null if unknown.\",\"default\":null},{\"name\":\"levels\",\"type\":[\"null\",{\"type\":\"record\",\"name\":\"FitbitActivityLevels\",\"doc\":\"Aggregate activity levels during an activity.\",\"fields\":[{\"name\":\"durationSedentary\",\"type\":[\"null\",\"int\"],\"doc\":\"Duration that the activity level was considered sedentary (s). Null if unknown.\",\"default\":null},{\"name\":\"durationLightly\",\"type\":[\"null\",\"int\"],\"doc\":\"Duration that the activity level was considered light (s). Null if unknown.\",\"default\":null},{\"name\":\"durationFairly\",\"type\":[\"null\",\"int\"],\"doc\":\"Duration that the activity level was considered fair (s). Null if unknown.\",\"default\":null},{\"name\":\"durationVery\",\"type\":[\"null\",\"int\"],\"doc\":\"Duration that the activity level was considered very high (s). Null if unknown.\",\"default\":null}]}],\"doc\":\"Levels of activity. Null if unknown.\",\"default\":null},{\"name\":\"heartRate\",\"type\":[\"null\",{\"type\":\"record\",\"name\":\"FitbitActivityHeartRate\",\"doc\":\"Aggregate heart rate as measured over an activity. The heart rates are divided amongst so-called heart rate zones. A heart rate zone is a range of heart rates and it does not overlap with other heart rate zones. These zones are called, in order of increasing heart rate, 'Out of Range', 'Fat Burn', 'Cardio', and 'Peak'. Fitbit uses the common formula of 220 minus your age to estimate your maximum heart rate. The 'Out of Range' zone has heart rates up to 50 percent of maximum heart rate, the 'Fat Burn' has heart rates up to 70 percent of maximum heart rate, 'Cardio' up to 85 percent of maximum heart rate and the 'Peak' range has heart rates higher than that.\",\"fields\":[{\"name\":\"mean\",\"type\":[\"null\",\"int\"],\"doc\":\"Mean heart rate over the duration of an activity (bpm). Null if unknown.\",\"default\":null},{\"name\":\"min\",\"type\":[\"null\",\"int\"],\"doc\":\"Minimum heart rate for the duration of an activity (bpm). Null if unknown.\",\"default\":null},{\"name\":\"max\",\"type\":[\"null\",\"int\"],\"doc\":\"Maximum heart rate for the duration of an activity (bpm). Null if unknown.\",\"default\":null},{\"name\":\"minFatBurn\",\"type\":[\"null\",\"int\"],\"doc\":\"Threshold heart rate above which a the heart rate is considered in the heart rate zone 'Fat Burn' (bpm), up to the value of the minCardio field. Null if unknown.\",\"default\":null},{\"name\":\"minCardio\",\"type\":[\"null\",\"int\"],\"doc\":\"Threshold heart rate above which a the heart rate is considered in the heart rate zone 'Cardio' (bpm), up to the value of the minPeak field. Null if unknown.\",\"default\":null},{\"name\":\"minPeak\",\"type\":[\"null\",\"int\"],\"doc\":\"Threshold heart rate above which a the heart rate is considered in the heart rate zone 'Peak' (bpm). Null if unknown.\",\"default\":null},{\"name\":\"durationOutOfRange\",\"type\":[\"null\",\"int\"],\"doc\":\"Duration in the heart rate zone 'Out Of Range', which is the lowest heart rate zone (s). Null if unknown.\",\"default\":null},{\"name\":\"durationFatBurn\",\"type\":[\"null\",\"int\"],\"doc\":\"Duration in the heart rate zone 'Fat Burn', which is the second lowest heart rate zone (s). Null if unknown.\",\"default\":null},{\"name\":\"durationCardio\",\"type\":[\"null\",\"int\"],\"doc\":\"Duration in the heart rate zone 'Cardio', which is the third lowest heart rate zone (s). Null if unknown.\",\"default\":null},{\"name\":\"durationPeak\",\"type\":[\"null\",\"int\"],\"doc\":\"Duration in the heart rate zone 'Peak', which is the highest heart rate zone (s). Null if unknown.\",\"default\":null}]}],\"doc\":\"Heart rate aggregate information collected during the activity. Null if unknown.\",\"default\":null},{\"name\":\"steps\",\"type\":[\"null\",\"int\"],\"doc\":\"Number of steps made during the activity. Null if unknown or if the type of activity is not step-based.\",\"default\":null},{\"name\":\"distance\",\"type\":[\"null\",\"float\"],\"doc\":\"Distance covered during the activity (km). Null if unknown or if the type of activity is not distance-based.\",\"default\":null},{\"name\":\"speed\",\"type\":[\"null\",\"double\"],\"doc\":\"Mean speed during the activity (km/h). Null if unknown or if the type of activity is not distance-based.\",\"default\":null}]}");
    private static final SpecificData MODEL$ = new SpecificData();
    private static final BinaryMessageEncoder<FitbitActivityLogRecord> ENCODER = new BinaryMessageEncoder((GenericData)MODEL$, SCHEMA$);
    private static final BinaryMessageDecoder<FitbitActivityLogRecord> DECODER = new BinaryMessageDecoder((GenericData)MODEL$, SCHEMA$);
    private double time;
    private double timeReceived;
    private int timeZoneOffset;
    private double timeLastModified;
    private float duration;
    private float durationActive;
    private long id;
    private String name;
    private String logType;
    private Long type;
    private FitbitSource source;
    private FitbitManualDataEntry manualDataEntry;
    private Float energy;
    private FitbitActivityLevels levels;
    private FitbitActivityHeartRate heartRate;
    private Integer steps;
    private Float distance;
    private Double speed;
    private static final DatumWriter<FitbitActivityLogRecord> WRITER$ = MODEL$.createDatumWriter(SCHEMA$);
    private static final DatumReader<FitbitActivityLogRecord> READER$ = MODEL$.createDatumReader(SCHEMA$);

    public static Schema getClassSchema() {
        return SCHEMA$;
    }

    public static BinaryMessageEncoder<FitbitActivityLogRecord> getEncoder() {
        return ENCODER;
    }

    public static BinaryMessageDecoder<FitbitActivityLogRecord> getDecoder() {
        return DECODER;
    }

    public static BinaryMessageDecoder<FitbitActivityLogRecord> createDecoder(SchemaStore resolver) {
        return new BinaryMessageDecoder((GenericData)MODEL$, SCHEMA$, resolver);
    }

    public ByteBuffer toByteBuffer() throws IOException {
        return ENCODER.encode((Object)this);
    }

    public static FitbitActivityLogRecord fromByteBuffer(ByteBuffer b) throws IOException {
        return (FitbitActivityLogRecord)((Object)DECODER.decode(b));
    }

    public FitbitActivityLogRecord() {
    }

    public FitbitActivityLogRecord(Double time, Double timeReceived, Integer timeZoneOffset, Double timeLastModified, Float duration, Float durationActive, Long id, String name, String logType, Long type, FitbitSource source, FitbitManualDataEntry manualDataEntry, Float energy, FitbitActivityLevels levels, FitbitActivityHeartRate heartRate, Integer steps, Float distance, Double speed) {
        this.time = time;
        this.timeReceived = timeReceived;
        this.timeZoneOffset = timeZoneOffset;
        this.timeLastModified = timeLastModified;
        this.duration = duration.floatValue();
        this.durationActive = durationActive.floatValue();
        this.id = id;
        this.name = name;
        this.logType = logType;
        this.type = type;
        this.source = source;
        this.manualDataEntry = manualDataEntry;
        this.energy = energy;
        this.levels = levels;
        this.heartRate = heartRate;
        this.steps = steps;
        this.distance = distance;
        this.speed = speed;
    }

    public SpecificData getSpecificData() {
        return MODEL$;
    }

    public Schema getSchema() {
        return SCHEMA$;
    }

    public Object get(int field$) {
        switch (field$) {
            case 0: {
                return this.time;
            }
            case 1: {
                return this.timeReceived;
            }
            case 2: {
                return this.timeZoneOffset;
            }
            case 3: {
                return this.timeLastModified;
            }
            case 4: {
                return Float.valueOf(this.duration);
            }
            case 5: {
                return Float.valueOf(this.durationActive);
            }
            case 6: {
                return this.id;
            }
            case 7: {
                return this.name;
            }
            case 8: {
                return this.logType;
            }
            case 9: {
                return this.type;
            }
            case 10: {
                return this.source;
            }
            case 11: {
                return this.manualDataEntry;
            }
            case 12: {
                return this.energy;
            }
            case 13: {
                return this.levels;
            }
            case 14: {
                return this.heartRate;
            }
            case 15: {
                return this.steps;
            }
            case 16: {
                return this.distance;
            }
            case 17: {
                return this.speed;
            }
        }
        throw new IndexOutOfBoundsException("Invalid index: " + field$);
    }

    public void put(int field$, Object value$) {
        switch (field$) {
            case 0: {
                this.time = (Double)value$;
                break;
            }
            case 1: {
                this.timeReceived = (Double)value$;
                break;
            }
            case 2: {
                this.timeZoneOffset = (Integer)value$;
                break;
            }
            case 3: {
                this.timeLastModified = (Double)value$;
                break;
            }
            case 4: {
                this.duration = ((Float)value$).floatValue();
                break;
            }
            case 5: {
                this.durationActive = ((Float)value$).floatValue();
                break;
            }
            case 6: {
                this.id = (Long)value$;
                break;
            }
            case 7: {
                this.name = value$ != null ? value$.toString() : null;
                break;
            }
            case 8: {
                this.logType = value$ != null ? value$.toString() : null;
                break;
            }
            case 9: {
                this.type = (Long)value$;
                break;
            }
            case 10: {
                this.source = (FitbitSource)((Object)value$);
                break;
            }
            case 11: {
                this.manualDataEntry = (FitbitManualDataEntry)((Object)value$);
                break;
            }
            case 12: {
                this.energy = (Float)value$;
                break;
            }
            case 13: {
                this.levels = (FitbitActivityLevels)((Object)value$);
                break;
            }
            case 14: {
                this.heartRate = (FitbitActivityHeartRate)((Object)value$);
                break;
            }
            case 15: {
                this.steps = (Integer)value$;
                break;
            }
            case 16: {
                this.distance = (Float)value$;
                break;
            }
            case 17: {
                this.speed = (Double)value$;
                break;
            }
            default: {
                throw new IndexOutOfBoundsException("Invalid index: " + field$);
            }
        }
    }

    public double getTime() {
        return this.time;
    }

    public void setTime(double value) {
        this.time = value;
    }

    public double getTimeReceived() {
        return this.timeReceived;
    }

    public void setTimeReceived(double value) {
        this.timeReceived = value;
    }

    public int getTimeZoneOffset() {
        return this.timeZoneOffset;
    }

    public void setTimeZoneOffset(int value) {
        this.timeZoneOffset = value;
    }

    public double getTimeLastModified() {
        return this.timeLastModified;
    }

    public void setTimeLastModified(double value) {
        this.timeLastModified = value;
    }

    public float getDuration() {
        return this.duration;
    }

    public void setDuration(float value) {
        this.duration = value;
    }

    public float getDurationActive() {
        return this.durationActive;
    }

    public void setDurationActive(float value) {
        this.durationActive = value;
    }

    public long getId() {
        return this.id;
    }

    public void setId(long value) {
        this.id = value;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String value) {
        this.name = value;
    }

    public String getLogType() {
        return this.logType;
    }

    public void setLogType(String value) {
        this.logType = value;
    }

    public Long getType() {
        return this.type;
    }

    public void setType(Long value) {
        this.type = value;
    }

    public FitbitSource getSource() {
        return this.source;
    }

    public void setSource(FitbitSource value) {
        this.source = value;
    }

    public FitbitManualDataEntry getManualDataEntry() {
        return this.manualDataEntry;
    }

    public void setManualDataEntry(FitbitManualDataEntry value) {
        this.manualDataEntry = value;
    }

    public Float getEnergy() {
        return this.energy;
    }

    public void setEnergy(Float value) {
        this.energy = value;
    }

    public FitbitActivityLevels getLevels() {
        return this.levels;
    }

    public void setLevels(FitbitActivityLevels value) {
        this.levels = value;
    }

    public FitbitActivityHeartRate getHeartRate() {
        return this.heartRate;
    }

    public void setHeartRate(FitbitActivityHeartRate value) {
        this.heartRate = value;
    }

    public Integer getSteps() {
        return this.steps;
    }

    public void setSteps(Integer value) {
        this.steps = value;
    }

    public Float getDistance() {
        return this.distance;
    }

    public void setDistance(Float value) {
        this.distance = value;
    }

    public Double getSpeed() {
        return this.speed;
    }

    public void setSpeed(Double value) {
        this.speed = value;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newBuilder(Builder other) {
        if (other == null) {
            return new Builder();
        }
        return new Builder(other);
    }

    public static Builder newBuilder(FitbitActivityLogRecord other) {
        if (other == null) {
            return new Builder();
        }
        return new Builder(other);
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        WRITER$.write((Object)this, (Encoder)SpecificData.getEncoder((ObjectOutput)out));
    }

    public void readExternal(ObjectInput in) throws IOException {
        READER$.read((Object)this, (Decoder)SpecificData.getDecoder((ObjectInput)in));
    }

    protected boolean hasCustomCoders() {
        return true;
    }

    public void customEncode(Encoder out) throws IOException {
        out.writeDouble(this.time);
        out.writeDouble(this.timeReceived);
        out.writeInt(this.timeZoneOffset);
        out.writeDouble(this.timeLastModified);
        out.writeFloat(this.duration);
        out.writeFloat(this.durationActive);
        out.writeLong(this.id);
        if (this.name == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeString(this.name);
        }
        if (this.logType == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeString(this.logType);
        }
        if (this.type == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeLong(this.type.longValue());
        }
        if (this.source == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            this.source.customEncode(out);
        }
        if (this.manualDataEntry == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            this.manualDataEntry.customEncode(out);
        }
        if (this.energy == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeFloat(this.energy.floatValue());
        }
        if (this.levels == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            this.levels.customEncode(out);
        }
        if (this.heartRate == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            this.heartRate.customEncode(out);
        }
        if (this.steps == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeInt(this.steps.intValue());
        }
        if (this.distance == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeFloat(this.distance.floatValue());
        }
        if (this.speed == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeDouble(this.speed.doubleValue());
        }
    }

    public void customDecode(ResolvingDecoder in) throws IOException {
        Schema.Field[] fieldOrder = in.readFieldOrderIfDiff();
        if (fieldOrder == null) {
            this.time = in.readDouble();
            this.timeReceived = in.readDouble();
            this.timeZoneOffset = in.readInt();
            this.timeLastModified = in.readDouble();
            this.duration = in.readFloat();
            this.durationActive = in.readFloat();
            this.id = in.readLong();
            if (in.readIndex() != 1) {
                in.readNull();
                this.name = null;
            } else {
                this.name = in.readString();
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.logType = null;
            } else {
                this.logType = in.readString();
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.type = null;
            } else {
                this.type = in.readLong();
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.source = null;
            } else {
                if (this.source == null) {
                    this.source = new FitbitSource();
                }
                this.source.customDecode(in);
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.manualDataEntry = null;
            } else {
                if (this.manualDataEntry == null) {
                    this.manualDataEntry = new FitbitManualDataEntry();
                }
                this.manualDataEntry.customDecode(in);
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.energy = null;
            } else {
                this.energy = Float.valueOf(in.readFloat());
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.levels = null;
            } else {
                if (this.levels == null) {
                    this.levels = new FitbitActivityLevels();
                }
                this.levels.customDecode(in);
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.heartRate = null;
            } else {
                if (this.heartRate == null) {
                    this.heartRate = new FitbitActivityHeartRate();
                }
                this.heartRate.customDecode(in);
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.steps = null;
            } else {
                this.steps = in.readInt();
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.distance = null;
            } else {
                this.distance = Float.valueOf(in.readFloat());
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.speed = null;
            } else {
                this.speed = in.readDouble();
            }
        } else {
            block20: for (int i = 0; i < 18; ++i) {
                switch (fieldOrder[i].pos()) {
                    case 0: {
                        this.time = in.readDouble();
                        continue block20;
                    }
                    case 1: {
                        this.timeReceived = in.readDouble();
                        continue block20;
                    }
                    case 2: {
                        this.timeZoneOffset = in.readInt();
                        continue block20;
                    }
                    case 3: {
                        this.timeLastModified = in.readDouble();
                        continue block20;
                    }
                    case 4: {
                        this.duration = in.readFloat();
                        continue block20;
                    }
                    case 5: {
                        this.durationActive = in.readFloat();
                        continue block20;
                    }
                    case 6: {
                        this.id = in.readLong();
                        continue block20;
                    }
                    case 7: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.name = null;
                            continue block20;
                        }
                        this.name = in.readString();
                        continue block20;
                    }
                    case 8: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.logType = null;
                            continue block20;
                        }
                        this.logType = in.readString();
                        continue block20;
                    }
                    case 9: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.type = null;
                            continue block20;
                        }
                        this.type = in.readLong();
                        continue block20;
                    }
                    case 10: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.source = null;
                            continue block20;
                        }
                        if (this.source == null) {
                            this.source = new FitbitSource();
                        }
                        this.source.customDecode(in);
                        continue block20;
                    }
                    case 11: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.manualDataEntry = null;
                            continue block20;
                        }
                        if (this.manualDataEntry == null) {
                            this.manualDataEntry = new FitbitManualDataEntry();
                        }
                        this.manualDataEntry.customDecode(in);
                        continue block20;
                    }
                    case 12: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.energy = null;
                            continue block20;
                        }
                        this.energy = Float.valueOf(in.readFloat());
                        continue block20;
                    }
                    case 13: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.levels = null;
                            continue block20;
                        }
                        if (this.levels == null) {
                            this.levels = new FitbitActivityLevels();
                        }
                        this.levels.customDecode(in);
                        continue block20;
                    }
                    case 14: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.heartRate = null;
                            continue block20;
                        }
                        if (this.heartRate == null) {
                            this.heartRate = new FitbitActivityHeartRate();
                        }
                        this.heartRate.customDecode(in);
                        continue block20;
                    }
                    case 15: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.steps = null;
                            continue block20;
                        }
                        this.steps = in.readInt();
                        continue block20;
                    }
                    case 16: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.distance = null;
                            continue block20;
                        }
                        this.distance = Float.valueOf(in.readFloat());
                        continue block20;
                    }
                    case 17: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.speed = null;
                            continue block20;
                        }
                        this.speed = in.readDouble();
                        continue block20;
                    }
                    default: {
                        throw new IOException("Corrupt ResolvingDecoder.");
                    }
                }
            }
        }
    }

    @AvroGenerated
    public static class Builder
    extends SpecificRecordBuilderBase<FitbitActivityLogRecord>
    implements RecordBuilder<FitbitActivityLogRecord> {
        private double time;
        private double timeReceived;
        private int timeZoneOffset;
        private double timeLastModified;
        private float duration;
        private float durationActive;
        private long id;
        private String name;
        private String logType;
        private Long type;
        private FitbitSource source;
        private FitbitSource.Builder sourceBuilder;
        private FitbitManualDataEntry manualDataEntry;
        private FitbitManualDataEntry.Builder manualDataEntryBuilder;
        private Float energy;
        private FitbitActivityLevels levels;
        private FitbitActivityLevels.Builder levelsBuilder;
        private FitbitActivityHeartRate heartRate;
        private FitbitActivityHeartRate.Builder heartRateBuilder;
        private Integer steps;
        private Float distance;
        private Double speed;

        private Builder() {
            super(SCHEMA$, MODEL$);
        }

        private Builder(Builder other) {
            super((SpecificRecordBuilderBase)other);
            if (Builder.isValidValue((Schema.Field)this.fields()[0], (Object)other.time)) {
                this.time = (Double)this.data().deepCopy(this.fields()[0].schema(), (Object)other.time);
                this.fieldSetFlags()[0] = other.fieldSetFlags()[0];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[1], (Object)other.timeReceived)) {
                this.timeReceived = (Double)this.data().deepCopy(this.fields()[1].schema(), (Object)other.timeReceived);
                this.fieldSetFlags()[1] = other.fieldSetFlags()[1];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[2], (Object)other.timeZoneOffset)) {
                this.timeZoneOffset = (Integer)this.data().deepCopy(this.fields()[2].schema(), (Object)other.timeZoneOffset);
                this.fieldSetFlags()[2] = other.fieldSetFlags()[2];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[3], (Object)other.timeLastModified)) {
                this.timeLastModified = (Double)this.data().deepCopy(this.fields()[3].schema(), (Object)other.timeLastModified);
                this.fieldSetFlags()[3] = other.fieldSetFlags()[3];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[4], (Object)Float.valueOf(other.duration))) {
                this.duration = ((Float)this.data().deepCopy(this.fields()[4].schema(), (Object)Float.valueOf(other.duration))).floatValue();
                this.fieldSetFlags()[4] = other.fieldSetFlags()[4];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[5], (Object)Float.valueOf(other.durationActive))) {
                this.durationActive = ((Float)this.data().deepCopy(this.fields()[5].schema(), (Object)Float.valueOf(other.durationActive))).floatValue();
                this.fieldSetFlags()[5] = other.fieldSetFlags()[5];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[6], (Object)other.id)) {
                this.id = (Long)this.data().deepCopy(this.fields()[6].schema(), (Object)other.id);
                this.fieldSetFlags()[6] = other.fieldSetFlags()[6];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[7], (Object)other.name)) {
                this.name = (String)this.data().deepCopy(this.fields()[7].schema(), (Object)other.name);
                this.fieldSetFlags()[7] = other.fieldSetFlags()[7];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[8], (Object)other.logType)) {
                this.logType = (String)this.data().deepCopy(this.fields()[8].schema(), (Object)other.logType);
                this.fieldSetFlags()[8] = other.fieldSetFlags()[8];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[9], (Object)other.type)) {
                this.type = (Long)this.data().deepCopy(this.fields()[9].schema(), (Object)other.type);
                this.fieldSetFlags()[9] = other.fieldSetFlags()[9];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[10], (Object)((Object)other.source))) {
                this.source = (FitbitSource)((Object)this.data().deepCopy(this.fields()[10].schema(), (Object)other.source));
                this.fieldSetFlags()[10] = other.fieldSetFlags()[10];
            }
            if (other.hasSourceBuilder()) {
                this.sourceBuilder = FitbitSource.newBuilder(other.getSourceBuilder());
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[11], (Object)((Object)other.manualDataEntry))) {
                this.manualDataEntry = (FitbitManualDataEntry)((Object)this.data().deepCopy(this.fields()[11].schema(), (Object)other.manualDataEntry));
                this.fieldSetFlags()[11] = other.fieldSetFlags()[11];
            }
            if (other.hasManualDataEntryBuilder()) {
                this.manualDataEntryBuilder = FitbitManualDataEntry.newBuilder(other.getManualDataEntryBuilder());
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[12], (Object)other.energy)) {
                this.energy = (Float)this.data().deepCopy(this.fields()[12].schema(), (Object)other.energy);
                this.fieldSetFlags()[12] = other.fieldSetFlags()[12];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[13], (Object)((Object)other.levels))) {
                this.levels = (FitbitActivityLevels)((Object)this.data().deepCopy(this.fields()[13].schema(), (Object)other.levels));
                this.fieldSetFlags()[13] = other.fieldSetFlags()[13];
            }
            if (other.hasLevelsBuilder()) {
                this.levelsBuilder = FitbitActivityLevels.newBuilder(other.getLevelsBuilder());
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[14], (Object)((Object)other.heartRate))) {
                this.heartRate = (FitbitActivityHeartRate)((Object)this.data().deepCopy(this.fields()[14].schema(), (Object)other.heartRate));
                this.fieldSetFlags()[14] = other.fieldSetFlags()[14];
            }
            if (other.hasHeartRateBuilder()) {
                this.heartRateBuilder = FitbitActivityHeartRate.newBuilder(other.getHeartRateBuilder());
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[15], (Object)other.steps)) {
                this.steps = (Integer)this.data().deepCopy(this.fields()[15].schema(), (Object)other.steps);
                this.fieldSetFlags()[15] = other.fieldSetFlags()[15];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[16], (Object)other.distance)) {
                this.distance = (Float)this.data().deepCopy(this.fields()[16].schema(), (Object)other.distance);
                this.fieldSetFlags()[16] = other.fieldSetFlags()[16];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[17], (Object)other.speed)) {
                this.speed = (Double)this.data().deepCopy(this.fields()[17].schema(), (Object)other.speed);
                this.fieldSetFlags()[17] = other.fieldSetFlags()[17];
            }
        }

        private Builder(FitbitActivityLogRecord other) {
            super(SCHEMA$, MODEL$);
            if (Builder.isValidValue((Schema.Field)this.fields()[0], (Object)other.time)) {
                this.time = (Double)this.data().deepCopy(this.fields()[0].schema(), (Object)other.time);
                this.fieldSetFlags()[0] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[1], (Object)other.timeReceived)) {
                this.timeReceived = (Double)this.data().deepCopy(this.fields()[1].schema(), (Object)other.timeReceived);
                this.fieldSetFlags()[1] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[2], (Object)other.timeZoneOffset)) {
                this.timeZoneOffset = (Integer)this.data().deepCopy(this.fields()[2].schema(), (Object)other.timeZoneOffset);
                this.fieldSetFlags()[2] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[3], (Object)other.timeLastModified)) {
                this.timeLastModified = (Double)this.data().deepCopy(this.fields()[3].schema(), (Object)other.timeLastModified);
                this.fieldSetFlags()[3] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[4], (Object)Float.valueOf(other.duration))) {
                this.duration = ((Float)this.data().deepCopy(this.fields()[4].schema(), (Object)Float.valueOf(other.duration))).floatValue();
                this.fieldSetFlags()[4] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[5], (Object)Float.valueOf(other.durationActive))) {
                this.durationActive = ((Float)this.data().deepCopy(this.fields()[5].schema(), (Object)Float.valueOf(other.durationActive))).floatValue();
                this.fieldSetFlags()[5] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[6], (Object)other.id)) {
                this.id = (Long)this.data().deepCopy(this.fields()[6].schema(), (Object)other.id);
                this.fieldSetFlags()[6] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[7], (Object)other.name)) {
                this.name = (String)this.data().deepCopy(this.fields()[7].schema(), (Object)other.name);
                this.fieldSetFlags()[7] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[8], (Object)other.logType)) {
                this.logType = (String)this.data().deepCopy(this.fields()[8].schema(), (Object)other.logType);
                this.fieldSetFlags()[8] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[9], (Object)other.type)) {
                this.type = (Long)this.data().deepCopy(this.fields()[9].schema(), (Object)other.type);
                this.fieldSetFlags()[9] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[10], (Object)((Object)other.source))) {
                this.source = (FitbitSource)((Object)this.data().deepCopy(this.fields()[10].schema(), (Object)other.source));
                this.fieldSetFlags()[10] = true;
            }
            this.sourceBuilder = null;
            if (Builder.isValidValue((Schema.Field)this.fields()[11], (Object)((Object)other.manualDataEntry))) {
                this.manualDataEntry = (FitbitManualDataEntry)((Object)this.data().deepCopy(this.fields()[11].schema(), (Object)other.manualDataEntry));
                this.fieldSetFlags()[11] = true;
            }
            this.manualDataEntryBuilder = null;
            if (Builder.isValidValue((Schema.Field)this.fields()[12], (Object)other.energy)) {
                this.energy = (Float)this.data().deepCopy(this.fields()[12].schema(), (Object)other.energy);
                this.fieldSetFlags()[12] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[13], (Object)((Object)other.levels))) {
                this.levels = (FitbitActivityLevels)((Object)this.data().deepCopy(this.fields()[13].schema(), (Object)other.levels));
                this.fieldSetFlags()[13] = true;
            }
            this.levelsBuilder = null;
            if (Builder.isValidValue((Schema.Field)this.fields()[14], (Object)((Object)other.heartRate))) {
                this.heartRate = (FitbitActivityHeartRate)((Object)this.data().deepCopy(this.fields()[14].schema(), (Object)other.heartRate));
                this.fieldSetFlags()[14] = true;
            }
            this.heartRateBuilder = null;
            if (Builder.isValidValue((Schema.Field)this.fields()[15], (Object)other.steps)) {
                this.steps = (Integer)this.data().deepCopy(this.fields()[15].schema(), (Object)other.steps);
                this.fieldSetFlags()[15] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[16], (Object)other.distance)) {
                this.distance = (Float)this.data().deepCopy(this.fields()[16].schema(), (Object)other.distance);
                this.fieldSetFlags()[16] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[17], (Object)other.speed)) {
                this.speed = (Double)this.data().deepCopy(this.fields()[17].schema(), (Object)other.speed);
                this.fieldSetFlags()[17] = true;
            }
        }

        public double getTime() {
            return this.time;
        }

        public Builder setTime(double value) {
            this.validate(this.fields()[0], value);
            this.time = value;
            this.fieldSetFlags()[0] = true;
            return this;
        }

        public boolean hasTime() {
            return this.fieldSetFlags()[0];
        }

        public Builder clearTime() {
            this.fieldSetFlags()[0] = false;
            return this;
        }

        public double getTimeReceived() {
            return this.timeReceived;
        }

        public Builder setTimeReceived(double value) {
            this.validate(this.fields()[1], value);
            this.timeReceived = value;
            this.fieldSetFlags()[1] = true;
            return this;
        }

        public boolean hasTimeReceived() {
            return this.fieldSetFlags()[1];
        }

        public Builder clearTimeReceived() {
            this.fieldSetFlags()[1] = false;
            return this;
        }

        public int getTimeZoneOffset() {
            return this.timeZoneOffset;
        }

        public Builder setTimeZoneOffset(int value) {
            this.validate(this.fields()[2], value);
            this.timeZoneOffset = value;
            this.fieldSetFlags()[2] = true;
            return this;
        }

        public boolean hasTimeZoneOffset() {
            return this.fieldSetFlags()[2];
        }

        public Builder clearTimeZoneOffset() {
            this.fieldSetFlags()[2] = false;
            return this;
        }

        public double getTimeLastModified() {
            return this.timeLastModified;
        }

        public Builder setTimeLastModified(double value) {
            this.validate(this.fields()[3], value);
            this.timeLastModified = value;
            this.fieldSetFlags()[3] = true;
            return this;
        }

        public boolean hasTimeLastModified() {
            return this.fieldSetFlags()[3];
        }

        public Builder clearTimeLastModified() {
            this.fieldSetFlags()[3] = false;
            return this;
        }

        public float getDuration() {
            return this.duration;
        }

        public Builder setDuration(float value) {
            this.validate(this.fields()[4], Float.valueOf(value));
            this.duration = value;
            this.fieldSetFlags()[4] = true;
            return this;
        }

        public boolean hasDuration() {
            return this.fieldSetFlags()[4];
        }

        public Builder clearDuration() {
            this.fieldSetFlags()[4] = false;
            return this;
        }

        public float getDurationActive() {
            return this.durationActive;
        }

        public Builder setDurationActive(float value) {
            this.validate(this.fields()[5], Float.valueOf(value));
            this.durationActive = value;
            this.fieldSetFlags()[5] = true;
            return this;
        }

        public boolean hasDurationActive() {
            return this.fieldSetFlags()[5];
        }

        public Builder clearDurationActive() {
            this.fieldSetFlags()[5] = false;
            return this;
        }

        public long getId() {
            return this.id;
        }

        public Builder setId(long value) {
            this.validate(this.fields()[6], value);
            this.id = value;
            this.fieldSetFlags()[6] = true;
            return this;
        }

        public boolean hasId() {
            return this.fieldSetFlags()[6];
        }

        public Builder clearId() {
            this.fieldSetFlags()[6] = false;
            return this;
        }

        public String getName() {
            return this.name;
        }

        public Builder setName(String value) {
            this.validate(this.fields()[7], value);
            this.name = value;
            this.fieldSetFlags()[7] = true;
            return this;
        }

        public boolean hasName() {
            return this.fieldSetFlags()[7];
        }

        public Builder clearName() {
            this.name = null;
            this.fieldSetFlags()[7] = false;
            return this;
        }

        public String getLogType() {
            return this.logType;
        }

        public Builder setLogType(String value) {
            this.validate(this.fields()[8], value);
            this.logType = value;
            this.fieldSetFlags()[8] = true;
            return this;
        }

        public boolean hasLogType() {
            return this.fieldSetFlags()[8];
        }

        public Builder clearLogType() {
            this.logType = null;
            this.fieldSetFlags()[8] = false;
            return this;
        }

        public Long getType() {
            return this.type;
        }

        public Builder setType(Long value) {
            this.validate(this.fields()[9], value);
            this.type = value;
            this.fieldSetFlags()[9] = true;
            return this;
        }

        public boolean hasType() {
            return this.fieldSetFlags()[9];
        }

        public Builder clearType() {
            this.type = null;
            this.fieldSetFlags()[9] = false;
            return this;
        }

        public FitbitSource getSource() {
            return this.source;
        }

        public Builder setSource(FitbitSource value) {
            this.validate(this.fields()[10], (Object)value);
            this.sourceBuilder = null;
            this.source = value;
            this.fieldSetFlags()[10] = true;
            return this;
        }

        public boolean hasSource() {
            return this.fieldSetFlags()[10];
        }

        public FitbitSource.Builder getSourceBuilder() {
            if (this.sourceBuilder == null) {
                if (this.hasSource()) {
                    this.setSourceBuilder(FitbitSource.newBuilder(this.source));
                } else {
                    this.setSourceBuilder(FitbitSource.newBuilder());
                }
            }
            return this.sourceBuilder;
        }

        public Builder setSourceBuilder(FitbitSource.Builder value) {
            this.clearSource();
            this.sourceBuilder = value;
            return this;
        }

        public boolean hasSourceBuilder() {
            return this.sourceBuilder != null;
        }

        public Builder clearSource() {
            this.source = null;
            this.sourceBuilder = null;
            this.fieldSetFlags()[10] = false;
            return this;
        }

        public FitbitManualDataEntry getManualDataEntry() {
            return this.manualDataEntry;
        }

        public Builder setManualDataEntry(FitbitManualDataEntry value) {
            this.validate(this.fields()[11], (Object)value);
            this.manualDataEntryBuilder = null;
            this.manualDataEntry = value;
            this.fieldSetFlags()[11] = true;
            return this;
        }

        public boolean hasManualDataEntry() {
            return this.fieldSetFlags()[11];
        }

        public FitbitManualDataEntry.Builder getManualDataEntryBuilder() {
            if (this.manualDataEntryBuilder == null) {
                if (this.hasManualDataEntry()) {
                    this.setManualDataEntryBuilder(FitbitManualDataEntry.newBuilder(this.manualDataEntry));
                } else {
                    this.setManualDataEntryBuilder(FitbitManualDataEntry.newBuilder());
                }
            }
            return this.manualDataEntryBuilder;
        }

        public Builder setManualDataEntryBuilder(FitbitManualDataEntry.Builder value) {
            this.clearManualDataEntry();
            this.manualDataEntryBuilder = value;
            return this;
        }

        public boolean hasManualDataEntryBuilder() {
            return this.manualDataEntryBuilder != null;
        }

        public Builder clearManualDataEntry() {
            this.manualDataEntry = null;
            this.manualDataEntryBuilder = null;
            this.fieldSetFlags()[11] = false;
            return this;
        }

        public Float getEnergy() {
            return this.energy;
        }

        public Builder setEnergy(Float value) {
            this.validate(this.fields()[12], value);
            this.energy = value;
            this.fieldSetFlags()[12] = true;
            return this;
        }

        public boolean hasEnergy() {
            return this.fieldSetFlags()[12];
        }

        public Builder clearEnergy() {
            this.energy = null;
            this.fieldSetFlags()[12] = false;
            return this;
        }

        public FitbitActivityLevels getLevels() {
            return this.levels;
        }

        public Builder setLevels(FitbitActivityLevels value) {
            this.validate(this.fields()[13], (Object)value);
            this.levelsBuilder = null;
            this.levels = value;
            this.fieldSetFlags()[13] = true;
            return this;
        }

        public boolean hasLevels() {
            return this.fieldSetFlags()[13];
        }

        public FitbitActivityLevels.Builder getLevelsBuilder() {
            if (this.levelsBuilder == null) {
                if (this.hasLevels()) {
                    this.setLevelsBuilder(FitbitActivityLevels.newBuilder(this.levels));
                } else {
                    this.setLevelsBuilder(FitbitActivityLevels.newBuilder());
                }
            }
            return this.levelsBuilder;
        }

        public Builder setLevelsBuilder(FitbitActivityLevels.Builder value) {
            this.clearLevels();
            this.levelsBuilder = value;
            return this;
        }

        public boolean hasLevelsBuilder() {
            return this.levelsBuilder != null;
        }

        public Builder clearLevels() {
            this.levels = null;
            this.levelsBuilder = null;
            this.fieldSetFlags()[13] = false;
            return this;
        }

        public FitbitActivityHeartRate getHeartRate() {
            return this.heartRate;
        }

        public Builder setHeartRate(FitbitActivityHeartRate value) {
            this.validate(this.fields()[14], (Object)value);
            this.heartRateBuilder = null;
            this.heartRate = value;
            this.fieldSetFlags()[14] = true;
            return this;
        }

        public boolean hasHeartRate() {
            return this.fieldSetFlags()[14];
        }

        public FitbitActivityHeartRate.Builder getHeartRateBuilder() {
            if (this.heartRateBuilder == null) {
                if (this.hasHeartRate()) {
                    this.setHeartRateBuilder(FitbitActivityHeartRate.newBuilder(this.heartRate));
                } else {
                    this.setHeartRateBuilder(FitbitActivityHeartRate.newBuilder());
                }
            }
            return this.heartRateBuilder;
        }

        public Builder setHeartRateBuilder(FitbitActivityHeartRate.Builder value) {
            this.clearHeartRate();
            this.heartRateBuilder = value;
            return this;
        }

        public boolean hasHeartRateBuilder() {
            return this.heartRateBuilder != null;
        }

        public Builder clearHeartRate() {
            this.heartRate = null;
            this.heartRateBuilder = null;
            this.fieldSetFlags()[14] = false;
            return this;
        }

        public Integer getSteps() {
            return this.steps;
        }

        public Builder setSteps(Integer value) {
            this.validate(this.fields()[15], value);
            this.steps = value;
            this.fieldSetFlags()[15] = true;
            return this;
        }

        public boolean hasSteps() {
            return this.fieldSetFlags()[15];
        }

        public Builder clearSteps() {
            this.steps = null;
            this.fieldSetFlags()[15] = false;
            return this;
        }

        public Float getDistance() {
            return this.distance;
        }

        public Builder setDistance(Float value) {
            this.validate(this.fields()[16], value);
            this.distance = value;
            this.fieldSetFlags()[16] = true;
            return this;
        }

        public boolean hasDistance() {
            return this.fieldSetFlags()[16];
        }

        public Builder clearDistance() {
            this.distance = null;
            this.fieldSetFlags()[16] = false;
            return this;
        }

        public Double getSpeed() {
            return this.speed;
        }

        public Builder setSpeed(Double value) {
            this.validate(this.fields()[17], value);
            this.speed = value;
            this.fieldSetFlags()[17] = true;
            return this;
        }

        public boolean hasSpeed() {
            return this.fieldSetFlags()[17];
        }

        public Builder clearSpeed() {
            this.speed = null;
            this.fieldSetFlags()[17] = false;
            return this;
        }

        public FitbitActivityLogRecord build() {
            try {
                FitbitActivityLogRecord record = new FitbitActivityLogRecord();
                record.time = this.fieldSetFlags()[0] ? this.time : (Double)this.defaultValue(this.fields()[0]);
                record.timeReceived = this.fieldSetFlags()[1] ? this.timeReceived : (Double)this.defaultValue(this.fields()[1]);
                record.timeZoneOffset = this.fieldSetFlags()[2] ? this.timeZoneOffset : (Integer)this.defaultValue(this.fields()[2]);
                record.timeLastModified = this.fieldSetFlags()[3] ? this.timeLastModified : (Double)this.defaultValue(this.fields()[3]);
                record.duration = this.fieldSetFlags()[4] ? this.duration : ((Float)this.defaultValue(this.fields()[4])).floatValue();
                record.durationActive = this.fieldSetFlags()[5] ? this.durationActive : ((Float)this.defaultValue(this.fields()[5])).floatValue();
                record.id = this.fieldSetFlags()[6] ? this.id : (Long)this.defaultValue(this.fields()[6]);
                record.name = this.fieldSetFlags()[7] ? this.name : (String)this.defaultValue(this.fields()[7]);
                record.logType = this.fieldSetFlags()[8] ? this.logType : (String)this.defaultValue(this.fields()[8]);
                Long l = record.type = this.fieldSetFlags()[9] ? this.type : (Long)this.defaultValue(this.fields()[9]);
                if (this.sourceBuilder != null) {
                    try {
                        record.source = this.sourceBuilder.build();
                    }
                    catch (AvroMissingFieldException e) {
                        e.addParentField(record.getSchema().getField("source"));
                        throw e;
                    }
                } else {
                    FitbitSource fitbitSource = record.source = this.fieldSetFlags()[10] ? this.source : (FitbitSource)((Object)this.defaultValue(this.fields()[10]));
                }
                if (this.manualDataEntryBuilder != null) {
                    try {
                        record.manualDataEntry = this.manualDataEntryBuilder.build();
                    }
                    catch (AvroMissingFieldException e) {
                        e.addParentField(record.getSchema().getField("manualDataEntry"));
                        throw e;
                    }
                } else {
                    record.manualDataEntry = this.fieldSetFlags()[11] ? this.manualDataEntry : (FitbitManualDataEntry)((Object)this.defaultValue(this.fields()[11]));
                }
                Float f = record.energy = this.fieldSetFlags()[12] ? this.energy : (Float)this.defaultValue(this.fields()[12]);
                if (this.levelsBuilder != null) {
                    try {
                        record.levels = this.levelsBuilder.build();
                    }
                    catch (AvroMissingFieldException e) {
                        e.addParentField(record.getSchema().getField("levels"));
                        throw e;
                    }
                } else {
                    FitbitActivityLevels fitbitActivityLevels = record.levels = this.fieldSetFlags()[13] ? this.levels : (FitbitActivityLevels)((Object)this.defaultValue(this.fields()[13]));
                }
                if (this.heartRateBuilder != null) {
                    try {
                        record.heartRate = this.heartRateBuilder.build();
                    }
                    catch (AvroMissingFieldException e) {
                        e.addParentField(record.getSchema().getField("heartRate"));
                        throw e;
                    }
                } else {
                    record.heartRate = this.fieldSetFlags()[14] ? this.heartRate : (FitbitActivityHeartRate)((Object)this.defaultValue(this.fields()[14]));
                }
                record.steps = this.fieldSetFlags()[15] ? this.steps : (Integer)this.defaultValue(this.fields()[15]);
                record.distance = this.fieldSetFlags()[16] ? this.distance : (Float)this.defaultValue(this.fields()[16]);
                record.speed = this.fieldSetFlags()[17] ? this.speed : (Double)this.defaultValue(this.fields()[17]);
                return record;
            }
            catch (AvroMissingFieldException e) {
                throw e;
            }
            catch (Exception e) {
                throw new AvroRuntimeException((Throwable)e);
            }
        }
    }
}

