/*
 * Decompiled with CFR 0.152.
 */
package org.radarcns.active.questionnaire;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.nio.ByteBuffer;
import java.util.List;
import org.apache.avro.AvroMissingFieldException;
import org.apache.avro.AvroRuntimeException;
import org.apache.avro.Schema;
import org.apache.avro.data.RecordBuilder;
import org.apache.avro.generic.GenericData;
import org.apache.avro.io.DatumReader;
import org.apache.avro.io.DatumWriter;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.Encoder;
import org.apache.avro.message.BinaryMessageDecoder;
import org.apache.avro.message.BinaryMessageEncoder;
import org.apache.avro.message.SchemaStore;
import org.apache.avro.specific.AvroGenerated;
import org.apache.avro.specific.SpecificData;
import org.apache.avro.specific.SpecificRecord;
import org.apache.avro.specific.SpecificRecordBase;
import org.apache.avro.specific.SpecificRecordBuilderBase;
import org.radarcns.active.questionnaire.Answer;

@AvroGenerated
public class Questionnaire
extends SpecificRecordBase
implements SpecificRecord {
    private static final long serialVersionUID = -6490010683681633370L;
    public static final Schema SCHEMA$ = new Schema.Parser().parse("{\"type\":\"record\",\"name\":\"Questionnaire\",\"namespace\":\"org.radarcns.active.questionnaire\",\"doc\":\"General schema for questionnaire. Check the specification folder to see how the questionnaire has been defined. For each QuestionnaireType there is a JSON file reporting the questions set and possible answers if available.\",\"fields\":[{\"name\":\"time\",\"type\":\"double\",\"doc\":\"Timestamp in UTC (s) when the questionnaire is started by the subject.\"},{\"name\":\"timeCompleted\",\"type\":\"double\",\"doc\":\"Timestamp in UTC (s) when the questionnaire is completed by the subject.\"},{\"name\":\"timeNotification\",\"type\":[\"null\",\"double\"],\"doc\":\"Timestamp in UTC (s) when the notification to complete the questionnaire is sent.\",\"default\":null},{\"name\":\"name\",\"type\":{\"type\":\"string\",\"avro.java.string\":\"String\"},\"doc\":\"Questionnaire names.\"},{\"name\":\"version\",\"type\":{\"type\":\"string\",\"avro.java.string\":\"String\"},\"doc\":\"It reports the questionnaire version stated in the JSON specification.\"},{\"name\":\"answers\",\"type\":{\"type\":\"array\",\"items\":{\"type\":\"record\",\"name\":\"Answer\",\"doc\":\"Questionnaire answer.\",\"fields\":[{\"name\":\"questionId\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"doc\":\"Unique identifier for the specific question.\",\"default\":null},{\"name\":\"value\",\"type\":[\"int\",{\"type\":\"string\",\"avro.java.string\":\"String\"},\"double\"],\"doc\":\"Subject answer.\"},{\"name\":\"startTime\",\"type\":\"double\",\"doc\":\"Timestamp in UTC (s) when the question is shown.\"},{\"name\":\"endTime\",\"type\":\"double\",\"doc\":\"Timestamp in UTC (s)  when the question is answered.\"}]}},\"doc\":\"Answers list. The answers order must follow the questions order.\"}]}");
    private static final SpecificData MODEL$ = new SpecificData();
    private static final BinaryMessageEncoder<Questionnaire> ENCODER = new BinaryMessageEncoder((GenericData)MODEL$, SCHEMA$);
    private static final BinaryMessageDecoder<Questionnaire> DECODER = new BinaryMessageDecoder((GenericData)MODEL$, SCHEMA$);
    private double time;
    private double timeCompleted;
    private Double timeNotification;
    private String name;
    private String version;
    private List<Answer> answers;
    private static final DatumWriter<Questionnaire> WRITER$ = MODEL$.createDatumWriter(SCHEMA$);
    private static final DatumReader<Questionnaire> READER$ = MODEL$.createDatumReader(SCHEMA$);

    public static Schema getClassSchema() {
        return SCHEMA$;
    }

    public static BinaryMessageEncoder<Questionnaire> getEncoder() {
        return ENCODER;
    }

    public static BinaryMessageDecoder<Questionnaire> getDecoder() {
        return DECODER;
    }

    public static BinaryMessageDecoder<Questionnaire> createDecoder(SchemaStore resolver) {
        return new BinaryMessageDecoder((GenericData)MODEL$, SCHEMA$, resolver);
    }

    public ByteBuffer toByteBuffer() throws IOException {
        return ENCODER.encode((Object)this);
    }

    public static Questionnaire fromByteBuffer(ByteBuffer b) throws IOException {
        return (Questionnaire)((Object)DECODER.decode(b));
    }

    public Questionnaire() {
    }

    public Questionnaire(Double time, Double timeCompleted, Double timeNotification, String name, String version, List<Answer> answers) {
        this.time = time;
        this.timeCompleted = timeCompleted;
        this.timeNotification = timeNotification;
        this.name = name;
        this.version = version;
        this.answers = answers;
    }

    public SpecificData getSpecificData() {
        return MODEL$;
    }

    public Schema getSchema() {
        return SCHEMA$;
    }

    public Object get(int field$) {
        switch (field$) {
            case 0: {
                return this.time;
            }
            case 1: {
                return this.timeCompleted;
            }
            case 2: {
                return this.timeNotification;
            }
            case 3: {
                return this.name;
            }
            case 4: {
                return this.version;
            }
            case 5: {
                return this.answers;
            }
        }
        throw new IndexOutOfBoundsException("Invalid index: " + field$);
    }

    public void put(int field$, Object value$) {
        switch (field$) {
            case 0: {
                this.time = (Double)value$;
                break;
            }
            case 1: {
                this.timeCompleted = (Double)value$;
                break;
            }
            case 2: {
                this.timeNotification = (Double)value$;
                break;
            }
            case 3: {
                this.name = value$ != null ? value$.toString() : null;
                break;
            }
            case 4: {
                this.version = value$ != null ? value$.toString() : null;
                break;
            }
            case 5: {
                this.answers = (List)value$;
                break;
            }
            default: {
                throw new IndexOutOfBoundsException("Invalid index: " + field$);
            }
        }
    }

    public double getTime() {
        return this.time;
    }

    public void setTime(double value) {
        this.time = value;
    }

    public double getTimeCompleted() {
        return this.timeCompleted;
    }

    public void setTimeCompleted(double value) {
        this.timeCompleted = value;
    }

    public Double getTimeNotification() {
        return this.timeNotification;
    }

    public void setTimeNotification(Double value) {
        this.timeNotification = value;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String value) {
        this.name = value;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String value) {
        this.version = value;
    }

    public List<Answer> getAnswers() {
        return this.answers;
    }

    public void setAnswers(List<Answer> value) {
        this.answers = value;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newBuilder(Builder other) {
        if (other == null) {
            return new Builder();
        }
        return new Builder(other);
    }

    public static Builder newBuilder(Questionnaire other) {
        if (other == null) {
            return new Builder();
        }
        return new Builder(other);
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        WRITER$.write((Object)this, (Encoder)SpecificData.getEncoder((ObjectOutput)out));
    }

    public void readExternal(ObjectInput in) throws IOException {
        READER$.read((Object)this, (Decoder)SpecificData.getDecoder((ObjectInput)in));
    }

    @AvroGenerated
    public static class Builder
    extends SpecificRecordBuilderBase<Questionnaire>
    implements RecordBuilder<Questionnaire> {
        private double time;
        private double timeCompleted;
        private Double timeNotification;
        private String name;
        private String version;
        private List<Answer> answers;

        private Builder() {
            super(SCHEMA$, MODEL$);
        }

        private Builder(Builder other) {
            super((SpecificRecordBuilderBase)other);
            if (Builder.isValidValue((Schema.Field)this.fields()[0], (Object)other.time)) {
                this.time = (Double)this.data().deepCopy(this.fields()[0].schema(), (Object)other.time);
                this.fieldSetFlags()[0] = other.fieldSetFlags()[0];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[1], (Object)other.timeCompleted)) {
                this.timeCompleted = (Double)this.data().deepCopy(this.fields()[1].schema(), (Object)other.timeCompleted);
                this.fieldSetFlags()[1] = other.fieldSetFlags()[1];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[2], (Object)other.timeNotification)) {
                this.timeNotification = (Double)this.data().deepCopy(this.fields()[2].schema(), (Object)other.timeNotification);
                this.fieldSetFlags()[2] = other.fieldSetFlags()[2];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[3], (Object)other.name)) {
                this.name = (String)this.data().deepCopy(this.fields()[3].schema(), (Object)other.name);
                this.fieldSetFlags()[3] = other.fieldSetFlags()[3];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[4], (Object)other.version)) {
                this.version = (String)this.data().deepCopy(this.fields()[4].schema(), (Object)other.version);
                this.fieldSetFlags()[4] = other.fieldSetFlags()[4];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[5], other.answers)) {
                this.answers = (List)this.data().deepCopy(this.fields()[5].schema(), other.answers);
                this.fieldSetFlags()[5] = other.fieldSetFlags()[5];
            }
        }

        private Builder(Questionnaire other) {
            super(SCHEMA$, MODEL$);
            if (Builder.isValidValue((Schema.Field)this.fields()[0], (Object)other.time)) {
                this.time = (Double)this.data().deepCopy(this.fields()[0].schema(), (Object)other.time);
                this.fieldSetFlags()[0] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[1], (Object)other.timeCompleted)) {
                this.timeCompleted = (Double)this.data().deepCopy(this.fields()[1].schema(), (Object)other.timeCompleted);
                this.fieldSetFlags()[1] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[2], (Object)other.timeNotification)) {
                this.timeNotification = (Double)this.data().deepCopy(this.fields()[2].schema(), (Object)other.timeNotification);
                this.fieldSetFlags()[2] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[3], (Object)other.name)) {
                this.name = (String)this.data().deepCopy(this.fields()[3].schema(), (Object)other.name);
                this.fieldSetFlags()[3] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[4], (Object)other.version)) {
                this.version = (String)this.data().deepCopy(this.fields()[4].schema(), (Object)other.version);
                this.fieldSetFlags()[4] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[5], other.answers)) {
                this.answers = (List)this.data().deepCopy(this.fields()[5].schema(), other.answers);
                this.fieldSetFlags()[5] = true;
            }
        }

        public double getTime() {
            return this.time;
        }

        public Builder setTime(double value) {
            this.validate(this.fields()[0], value);
            this.time = value;
            this.fieldSetFlags()[0] = true;
            return this;
        }

        public boolean hasTime() {
            return this.fieldSetFlags()[0];
        }

        public Builder clearTime() {
            this.fieldSetFlags()[0] = false;
            return this;
        }

        public double getTimeCompleted() {
            return this.timeCompleted;
        }

        public Builder setTimeCompleted(double value) {
            this.validate(this.fields()[1], value);
            this.timeCompleted = value;
            this.fieldSetFlags()[1] = true;
            return this;
        }

        public boolean hasTimeCompleted() {
            return this.fieldSetFlags()[1];
        }

        public Builder clearTimeCompleted() {
            this.fieldSetFlags()[1] = false;
            return this;
        }

        public Double getTimeNotification() {
            return this.timeNotification;
        }

        public Builder setTimeNotification(Double value) {
            this.validate(this.fields()[2], value);
            this.timeNotification = value;
            this.fieldSetFlags()[2] = true;
            return this;
        }

        public boolean hasTimeNotification() {
            return this.fieldSetFlags()[2];
        }

        public Builder clearTimeNotification() {
            this.timeNotification = null;
            this.fieldSetFlags()[2] = false;
            return this;
        }

        public String getName() {
            return this.name;
        }

        public Builder setName(String value) {
            this.validate(this.fields()[3], value);
            this.name = value;
            this.fieldSetFlags()[3] = true;
            return this;
        }

        public boolean hasName() {
            return this.fieldSetFlags()[3];
        }

        public Builder clearName() {
            this.name = null;
            this.fieldSetFlags()[3] = false;
            return this;
        }

        public String getVersion() {
            return this.version;
        }

        public Builder setVersion(String value) {
            this.validate(this.fields()[4], value);
            this.version = value;
            this.fieldSetFlags()[4] = true;
            return this;
        }

        public boolean hasVersion() {
            return this.fieldSetFlags()[4];
        }

        public Builder clearVersion() {
            this.version = null;
            this.fieldSetFlags()[4] = false;
            return this;
        }

        public List<Answer> getAnswers() {
            return this.answers;
        }

        public Builder setAnswers(List<Answer> value) {
            this.validate(this.fields()[5], value);
            this.answers = value;
            this.fieldSetFlags()[5] = true;
            return this;
        }

        public boolean hasAnswers() {
            return this.fieldSetFlags()[5];
        }

        public Builder clearAnswers() {
            this.answers = null;
            this.fieldSetFlags()[5] = false;
            return this;
        }

        public Questionnaire build() {
            try {
                Questionnaire record = new Questionnaire();
                record.time = this.fieldSetFlags()[0] ? this.time : (Double)this.defaultValue(this.fields()[0]);
                record.timeCompleted = this.fieldSetFlags()[1] ? this.timeCompleted : (Double)this.defaultValue(this.fields()[1]);
                record.timeNotification = this.fieldSetFlags()[2] ? this.timeNotification : (Double)this.defaultValue(this.fields()[2]);
                record.name = this.fieldSetFlags()[3] ? this.name : (String)this.defaultValue(this.fields()[3]);
                record.version = this.fieldSetFlags()[4] ? this.version : (String)this.defaultValue(this.fields()[4]);
                record.answers = this.fieldSetFlags()[5] ? this.answers : (List)this.defaultValue(this.fields()[5]);
                return record;
            }
            catch (AvroMissingFieldException e) {
                throw e;
            }
            catch (Exception e) {
                throw new AvroRuntimeException((Throwable)e);
            }
        }
    }
}

