/*
 * Decompiled with CFR 0.152.
 */
package org.radarcns.push.garmin;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.nio.ByteBuffer;
import org.apache.avro.AvroMissingFieldException;
import org.apache.avro.AvroRuntimeException;
import org.apache.avro.Schema;
import org.apache.avro.data.RecordBuilder;
import org.apache.avro.generic.GenericData;
import org.apache.avro.io.DatumReader;
import org.apache.avro.io.DatumWriter;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.Encoder;
import org.apache.avro.io.ResolvingDecoder;
import org.apache.avro.message.BinaryMessageDecoder;
import org.apache.avro.message.BinaryMessageEncoder;
import org.apache.avro.message.SchemaStore;
import org.apache.avro.specific.AvroGenerated;
import org.apache.avro.specific.SpecificData;
import org.apache.avro.specific.SpecificRecord;
import org.apache.avro.specific.SpecificRecordBase;
import org.apache.avro.specific.SpecificRecordBuilderBase;

@AvroGenerated
public class GarminStressDetailSummary
extends SpecificRecordBase
implements SpecificRecord {
    private static final long serialVersionUID = 3891965657321089716L;
    public static final Schema SCHEMA$ = new Schema.Parser().parse("{\"type\":\"record\",\"name\":\"GarminStressDetailSummary\",\"namespace\":\"org.radarcns.push.garmin\",\"doc\":\"Stress Details summaries contain the user\u2019s stress level values for a given day. Stress levels are provided as 3-minute averages of the real-time stress scores generated on the device with values ranging from 1 to 100. A value of -1 means there was not enough data to detect stress, and -2 means there was too much motion (e.g. the user was walking or running). Scores between 1 and 25 are considered \u201crest\u201d (i.e. not stressful), 26-50 as \u201clow\u201d stress, 51-75 \u201cmedium\u201d stress, and 76- 100 as \u201chigh\u201d stress. These numbers are derived based on a combination of many device sensors and will automatically adjust to the wearer of the device and gain accuracy over time as the stress algorithms learn the user\u2019s natural biometric norms. Stress values from the Health API are exactly the stress values shown on Garmin Connect.\",\"fields\":[{\"name\":\"time\",\"type\":\"double\",\"doc\":\"Start time of the activity in seconds since January 1, 1970, 00:00:00 UTC (Unix timestamp).\"},{\"name\":\"timeReceived\",\"type\":\"double\",\"doc\":\"Time that this record was collected by a service in seconds since the Unix Epoch (s).\"},{\"name\":\"summaryId\",\"type\":{\"type\":\"string\",\"avro.java.string\":\"String\"},\"doc\":\"Unique identifier for the summary.\"},{\"name\":\"startTimeOffset\",\"type\":[\"null\",\"int\"],\"doc\":\"Offset in seconds to add to time to derive the 'local' time of the device that captured the data.\",\"default\":null},{\"name\":\"date\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"doc\":\"The calendar date this summary would be displayed on in Garmin Connect in the local time zone of the device. The date format is \u2018yyyy-mm-dd\u2019.\",\"default\":null},{\"name\":\"duration\",\"type\":[\"null\",\"int\"],\"doc\":\"Length of the monitoring period in seconds. 86400 once a full day is complete, but less if a user syncs mid-day.\",\"default\":null}]}");
    private static SpecificData MODEL$ = new SpecificData();
    private static final BinaryMessageEncoder<GarminStressDetailSummary> ENCODER = new BinaryMessageEncoder((GenericData)MODEL$, SCHEMA$);
    private static final BinaryMessageDecoder<GarminStressDetailSummary> DECODER = new BinaryMessageDecoder((GenericData)MODEL$, SCHEMA$);
    @Deprecated
    public double time;
    @Deprecated
    public double timeReceived;
    @Deprecated
    public String summaryId;
    @Deprecated
    public Integer startTimeOffset;
    @Deprecated
    public String date;
    @Deprecated
    public Integer duration;
    private static final DatumWriter<GarminStressDetailSummary> WRITER$ = MODEL$.createDatumWriter(SCHEMA$);
    private static final DatumReader<GarminStressDetailSummary> READER$ = MODEL$.createDatumReader(SCHEMA$);

    public static Schema getClassSchema() {
        return SCHEMA$;
    }

    public static BinaryMessageEncoder<GarminStressDetailSummary> getEncoder() {
        return ENCODER;
    }

    public static BinaryMessageDecoder<GarminStressDetailSummary> getDecoder() {
        return DECODER;
    }

    public static BinaryMessageDecoder<GarminStressDetailSummary> createDecoder(SchemaStore resolver) {
        return new BinaryMessageDecoder((GenericData)MODEL$, SCHEMA$, resolver);
    }

    public ByteBuffer toByteBuffer() throws IOException {
        return ENCODER.encode((Object)this);
    }

    public static GarminStressDetailSummary fromByteBuffer(ByteBuffer b) throws IOException {
        return (GarminStressDetailSummary)((Object)DECODER.decode(b));
    }

    public GarminStressDetailSummary() {
    }

    public GarminStressDetailSummary(Double time, Double timeReceived, String summaryId, Integer startTimeOffset, String date, Integer duration) {
        this.time = time;
        this.timeReceived = timeReceived;
        this.summaryId = summaryId;
        this.startTimeOffset = startTimeOffset;
        this.date = date;
        this.duration = duration;
    }

    public SpecificData getSpecificData() {
        return MODEL$;
    }

    public Schema getSchema() {
        return SCHEMA$;
    }

    public Object get(int field$) {
        switch (field$) {
            case 0: {
                return this.time;
            }
            case 1: {
                return this.timeReceived;
            }
            case 2: {
                return this.summaryId;
            }
            case 3: {
                return this.startTimeOffset;
            }
            case 4: {
                return this.date;
            }
            case 5: {
                return this.duration;
            }
        }
        throw new IndexOutOfBoundsException("Invalid index: " + field$);
    }

    public void put(int field$, Object value$) {
        switch (field$) {
            case 0: {
                this.time = (Double)value$;
                break;
            }
            case 1: {
                this.timeReceived = (Double)value$;
                break;
            }
            case 2: {
                this.summaryId = value$ != null ? value$.toString() : null;
                break;
            }
            case 3: {
                this.startTimeOffset = (Integer)value$;
                break;
            }
            case 4: {
                this.date = value$ != null ? value$.toString() : null;
                break;
            }
            case 5: {
                this.duration = (Integer)value$;
                break;
            }
            default: {
                throw new IndexOutOfBoundsException("Invalid index: " + field$);
            }
        }
    }

    public double getTime() {
        return this.time;
    }

    public void setTime(double value) {
        this.time = value;
    }

    public double getTimeReceived() {
        return this.timeReceived;
    }

    public void setTimeReceived(double value) {
        this.timeReceived = value;
    }

    public String getSummaryId() {
        return this.summaryId;
    }

    public void setSummaryId(String value) {
        this.summaryId = value;
    }

    public Integer getStartTimeOffset() {
        return this.startTimeOffset;
    }

    public void setStartTimeOffset(Integer value) {
        this.startTimeOffset = value;
    }

    public String getDate() {
        return this.date;
    }

    public void setDate(String value) {
        this.date = value;
    }

    public Integer getDuration() {
        return this.duration;
    }

    public void setDuration(Integer value) {
        this.duration = value;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newBuilder(Builder other) {
        if (other == null) {
            return new Builder();
        }
        return new Builder(other);
    }

    public static Builder newBuilder(GarminStressDetailSummary other) {
        if (other == null) {
            return new Builder();
        }
        return new Builder(other);
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        WRITER$.write((Object)this, (Encoder)SpecificData.getEncoder((ObjectOutput)out));
    }

    public void readExternal(ObjectInput in) throws IOException {
        READER$.read((Object)this, (Decoder)SpecificData.getDecoder((ObjectInput)in));
    }

    protected boolean hasCustomCoders() {
        return true;
    }

    public void customEncode(Encoder out) throws IOException {
        out.writeDouble(this.time);
        out.writeDouble(this.timeReceived);
        out.writeString(this.summaryId);
        if (this.startTimeOffset == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeInt(this.startTimeOffset.intValue());
        }
        if (this.date == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeString(this.date);
        }
        if (this.duration == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeInt(this.duration.intValue());
        }
    }

    public void customDecode(ResolvingDecoder in) throws IOException {
        Schema.Field[] fieldOrder = in.readFieldOrderIfDiff();
        if (fieldOrder == null) {
            this.time = in.readDouble();
            this.timeReceived = in.readDouble();
            this.summaryId = in.readString();
            if (in.readIndex() != 1) {
                in.readNull();
                this.startTimeOffset = null;
            } else {
                this.startTimeOffset = in.readInt();
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.date = null;
            } else {
                this.date = in.readString();
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.duration = null;
            } else {
                this.duration = in.readInt();
            }
        } else {
            block8: for (int i = 0; i < 6; ++i) {
                switch (fieldOrder[i].pos()) {
                    case 0: {
                        this.time = in.readDouble();
                        continue block8;
                    }
                    case 1: {
                        this.timeReceived = in.readDouble();
                        continue block8;
                    }
                    case 2: {
                        this.summaryId = in.readString();
                        continue block8;
                    }
                    case 3: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.startTimeOffset = null;
                            continue block8;
                        }
                        this.startTimeOffset = in.readInt();
                        continue block8;
                    }
                    case 4: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.date = null;
                            continue block8;
                        }
                        this.date = in.readString();
                        continue block8;
                    }
                    case 5: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.duration = null;
                            continue block8;
                        }
                        this.duration = in.readInt();
                        continue block8;
                    }
                    default: {
                        throw new IOException("Corrupt ResolvingDecoder.");
                    }
                }
            }
        }
    }

    @AvroGenerated
    public static class Builder
    extends SpecificRecordBuilderBase<GarminStressDetailSummary>
    implements RecordBuilder<GarminStressDetailSummary> {
        private double time;
        private double timeReceived;
        private String summaryId;
        private Integer startTimeOffset;
        private String date;
        private Integer duration;

        private Builder() {
            super(SCHEMA$);
        }

        private Builder(Builder other) {
            super((SpecificRecordBuilderBase)other);
            if (Builder.isValidValue((Schema.Field)this.fields()[0], (Object)other.time)) {
                this.time = (Double)this.data().deepCopy(this.fields()[0].schema(), (Object)other.time);
                this.fieldSetFlags()[0] = other.fieldSetFlags()[0];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[1], (Object)other.timeReceived)) {
                this.timeReceived = (Double)this.data().deepCopy(this.fields()[1].schema(), (Object)other.timeReceived);
                this.fieldSetFlags()[1] = other.fieldSetFlags()[1];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[2], (Object)other.summaryId)) {
                this.summaryId = (String)this.data().deepCopy(this.fields()[2].schema(), (Object)other.summaryId);
                this.fieldSetFlags()[2] = other.fieldSetFlags()[2];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[3], (Object)other.startTimeOffset)) {
                this.startTimeOffset = (Integer)this.data().deepCopy(this.fields()[3].schema(), (Object)other.startTimeOffset);
                this.fieldSetFlags()[3] = other.fieldSetFlags()[3];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[4], (Object)other.date)) {
                this.date = (String)this.data().deepCopy(this.fields()[4].schema(), (Object)other.date);
                this.fieldSetFlags()[4] = other.fieldSetFlags()[4];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[5], (Object)other.duration)) {
                this.duration = (Integer)this.data().deepCopy(this.fields()[5].schema(), (Object)other.duration);
                this.fieldSetFlags()[5] = other.fieldSetFlags()[5];
            }
        }

        private Builder(GarminStressDetailSummary other) {
            super(SCHEMA$);
            if (Builder.isValidValue((Schema.Field)this.fields()[0], (Object)other.time)) {
                this.time = (Double)this.data().deepCopy(this.fields()[0].schema(), (Object)other.time);
                this.fieldSetFlags()[0] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[1], (Object)other.timeReceived)) {
                this.timeReceived = (Double)this.data().deepCopy(this.fields()[1].schema(), (Object)other.timeReceived);
                this.fieldSetFlags()[1] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[2], (Object)other.summaryId)) {
                this.summaryId = (String)this.data().deepCopy(this.fields()[2].schema(), (Object)other.summaryId);
                this.fieldSetFlags()[2] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[3], (Object)other.startTimeOffset)) {
                this.startTimeOffset = (Integer)this.data().deepCopy(this.fields()[3].schema(), (Object)other.startTimeOffset);
                this.fieldSetFlags()[3] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[4], (Object)other.date)) {
                this.date = (String)this.data().deepCopy(this.fields()[4].schema(), (Object)other.date);
                this.fieldSetFlags()[4] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[5], (Object)other.duration)) {
                this.duration = (Integer)this.data().deepCopy(this.fields()[5].schema(), (Object)other.duration);
                this.fieldSetFlags()[5] = true;
            }
        }

        public double getTime() {
            return this.time;
        }

        public Builder setTime(double value) {
            this.validate(this.fields()[0], value);
            this.time = value;
            this.fieldSetFlags()[0] = true;
            return this;
        }

        public boolean hasTime() {
            return this.fieldSetFlags()[0];
        }

        public Builder clearTime() {
            this.fieldSetFlags()[0] = false;
            return this;
        }

        public double getTimeReceived() {
            return this.timeReceived;
        }

        public Builder setTimeReceived(double value) {
            this.validate(this.fields()[1], value);
            this.timeReceived = value;
            this.fieldSetFlags()[1] = true;
            return this;
        }

        public boolean hasTimeReceived() {
            return this.fieldSetFlags()[1];
        }

        public Builder clearTimeReceived() {
            this.fieldSetFlags()[1] = false;
            return this;
        }

        public String getSummaryId() {
            return this.summaryId;
        }

        public Builder setSummaryId(String value) {
            this.validate(this.fields()[2], value);
            this.summaryId = value;
            this.fieldSetFlags()[2] = true;
            return this;
        }

        public boolean hasSummaryId() {
            return this.fieldSetFlags()[2];
        }

        public Builder clearSummaryId() {
            this.summaryId = null;
            this.fieldSetFlags()[2] = false;
            return this;
        }

        public Integer getStartTimeOffset() {
            return this.startTimeOffset;
        }

        public Builder setStartTimeOffset(Integer value) {
            this.validate(this.fields()[3], value);
            this.startTimeOffset = value;
            this.fieldSetFlags()[3] = true;
            return this;
        }

        public boolean hasStartTimeOffset() {
            return this.fieldSetFlags()[3];
        }

        public Builder clearStartTimeOffset() {
            this.startTimeOffset = null;
            this.fieldSetFlags()[3] = false;
            return this;
        }

        public String getDate() {
            return this.date;
        }

        public Builder setDate(String value) {
            this.validate(this.fields()[4], value);
            this.date = value;
            this.fieldSetFlags()[4] = true;
            return this;
        }

        public boolean hasDate() {
            return this.fieldSetFlags()[4];
        }

        public Builder clearDate() {
            this.date = null;
            this.fieldSetFlags()[4] = false;
            return this;
        }

        public Integer getDuration() {
            return this.duration;
        }

        public Builder setDuration(Integer value) {
            this.validate(this.fields()[5], value);
            this.duration = value;
            this.fieldSetFlags()[5] = true;
            return this;
        }

        public boolean hasDuration() {
            return this.fieldSetFlags()[5];
        }

        public Builder clearDuration() {
            this.duration = null;
            this.fieldSetFlags()[5] = false;
            return this;
        }

        public GarminStressDetailSummary build() {
            try {
                GarminStressDetailSummary record = new GarminStressDetailSummary();
                record.time = this.fieldSetFlags()[0] ? this.time : (Double)this.defaultValue(this.fields()[0]);
                record.timeReceived = this.fieldSetFlags()[1] ? this.timeReceived : (Double)this.defaultValue(this.fields()[1]);
                record.summaryId = this.fieldSetFlags()[2] ? this.summaryId : (String)this.defaultValue(this.fields()[2]);
                record.startTimeOffset = this.fieldSetFlags()[3] ? this.startTimeOffset : (Integer)this.defaultValue(this.fields()[3]);
                record.date = this.fieldSetFlags()[4] ? this.date : (String)this.defaultValue(this.fields()[4]);
                record.duration = this.fieldSetFlags()[5] ? this.duration : (Integer)this.defaultValue(this.fields()[5]);
                return record;
            }
            catch (AvroMissingFieldException e) {
                throw e;
            }
            catch (Exception e) {
                throw new AvroRuntimeException((Throwable)e);
            }
        }
    }
}

