/*
 * Decompiled with CFR 0.152.
 */
package org.radarcns.push.garmin;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.nio.ByteBuffer;
import org.apache.avro.AvroMissingFieldException;
import org.apache.avro.AvroRuntimeException;
import org.apache.avro.Schema;
import org.apache.avro.data.RecordBuilder;
import org.apache.avro.generic.GenericData;
import org.apache.avro.io.DatumReader;
import org.apache.avro.io.DatumWriter;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.Encoder;
import org.apache.avro.io.ResolvingDecoder;
import org.apache.avro.message.BinaryMessageDecoder;
import org.apache.avro.message.BinaryMessageEncoder;
import org.apache.avro.message.SchemaStore;
import org.apache.avro.specific.AvroGenerated;
import org.apache.avro.specific.SpecificData;
import org.apache.avro.specific.SpecificRecord;
import org.apache.avro.specific.SpecificRecordBase;
import org.apache.avro.specific.SpecificRecordBuilderBase;

@AvroGenerated
public class GarminSleepLevel
extends SpecificRecordBase
implements SpecificRecord {
    private static final long serialVersionUID = -5432009684857470481L;
    public static final Schema SCHEMA$ = new Schema.Parser().parse("{\"type\":\"record\",\"name\":\"GarminSleepLevel\",\"namespace\":\"org.radarcns.push.garmin\",\"doc\":\"Sleep level time ranges, currently deep, light, rem and awake. Time ranges are represented as unix timestamps in seconds. Usually associated with Sleep Summary data using the summaryId field.\",\"fields\":[{\"name\":\"time\",\"type\":\"double\",\"doc\":\"Start time of this sleep level in seconds since January 1, 1970, 00:00:00 UTC (Unix timestamp).\"},{\"name\":\"timeReceived\",\"type\":\"double\",\"doc\":\"Time that this record was collected by a service in seconds since the Unix Epoch (s).\"},{\"name\":\"summaryId\",\"type\":{\"type\":\"string\",\"avro.java.string\":\"String\"},\"doc\":\"Unique identifier for the summary that this record is associated with.\"},{\"name\":\"sleepLevel\",\"type\":{\"type\":\"string\",\"avro.java.string\":\"String\"},\"doc\":\"Sleep levels, currently deep, light, rem and awake.\"},{\"name\":\"startTime\",\"type\":\"double\",\"doc\":\"Start time of this sleep period in seconds.\"},{\"name\":\"endTime\",\"type\":\"double\",\"doc\":\"End time of this sleep period in seconds.\"}]}");
    private static SpecificData MODEL$ = new SpecificData();
    private static final BinaryMessageEncoder<GarminSleepLevel> ENCODER = new BinaryMessageEncoder((GenericData)MODEL$, SCHEMA$);
    private static final BinaryMessageDecoder<GarminSleepLevel> DECODER = new BinaryMessageDecoder((GenericData)MODEL$, SCHEMA$);
    @Deprecated
    public double time;
    @Deprecated
    public double timeReceived;
    @Deprecated
    public String summaryId;
    @Deprecated
    public String sleepLevel;
    @Deprecated
    public double startTime;
    @Deprecated
    public double endTime;
    private static final DatumWriter<GarminSleepLevel> WRITER$ = MODEL$.createDatumWriter(SCHEMA$);
    private static final DatumReader<GarminSleepLevel> READER$ = MODEL$.createDatumReader(SCHEMA$);

    public static Schema getClassSchema() {
        return SCHEMA$;
    }

    public static BinaryMessageEncoder<GarminSleepLevel> getEncoder() {
        return ENCODER;
    }

    public static BinaryMessageDecoder<GarminSleepLevel> getDecoder() {
        return DECODER;
    }

    public static BinaryMessageDecoder<GarminSleepLevel> createDecoder(SchemaStore resolver) {
        return new BinaryMessageDecoder((GenericData)MODEL$, SCHEMA$, resolver);
    }

    public ByteBuffer toByteBuffer() throws IOException {
        return ENCODER.encode((Object)this);
    }

    public static GarminSleepLevel fromByteBuffer(ByteBuffer b) throws IOException {
        return (GarminSleepLevel)((Object)DECODER.decode(b));
    }

    public GarminSleepLevel() {
    }

    public GarminSleepLevel(Double time, Double timeReceived, String summaryId, String sleepLevel, Double startTime, Double endTime) {
        this.time = time;
        this.timeReceived = timeReceived;
        this.summaryId = summaryId;
        this.sleepLevel = sleepLevel;
        this.startTime = startTime;
        this.endTime = endTime;
    }

    public SpecificData getSpecificData() {
        return MODEL$;
    }

    public Schema getSchema() {
        return SCHEMA$;
    }

    public Object get(int field$) {
        switch (field$) {
            case 0: {
                return this.time;
            }
            case 1: {
                return this.timeReceived;
            }
            case 2: {
                return this.summaryId;
            }
            case 3: {
                return this.sleepLevel;
            }
            case 4: {
                return this.startTime;
            }
            case 5: {
                return this.endTime;
            }
        }
        throw new IndexOutOfBoundsException("Invalid index: " + field$);
    }

    public void put(int field$, Object value$) {
        switch (field$) {
            case 0: {
                this.time = (Double)value$;
                break;
            }
            case 1: {
                this.timeReceived = (Double)value$;
                break;
            }
            case 2: {
                this.summaryId = value$ != null ? value$.toString() : null;
                break;
            }
            case 3: {
                this.sleepLevel = value$ != null ? value$.toString() : null;
                break;
            }
            case 4: {
                this.startTime = (Double)value$;
                break;
            }
            case 5: {
                this.endTime = (Double)value$;
                break;
            }
            default: {
                throw new IndexOutOfBoundsException("Invalid index: " + field$);
            }
        }
    }

    public double getTime() {
        return this.time;
    }

    public void setTime(double value) {
        this.time = value;
    }

    public double getTimeReceived() {
        return this.timeReceived;
    }

    public void setTimeReceived(double value) {
        this.timeReceived = value;
    }

    public String getSummaryId() {
        return this.summaryId;
    }

    public void setSummaryId(String value) {
        this.summaryId = value;
    }

    public String getSleepLevel() {
        return this.sleepLevel;
    }

    public void setSleepLevel(String value) {
        this.sleepLevel = value;
    }

    public double getStartTime() {
        return this.startTime;
    }

    public void setStartTime(double value) {
        this.startTime = value;
    }

    public double getEndTime() {
        return this.endTime;
    }

    public void setEndTime(double value) {
        this.endTime = value;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newBuilder(Builder other) {
        if (other == null) {
            return new Builder();
        }
        return new Builder(other);
    }

    public static Builder newBuilder(GarminSleepLevel other) {
        if (other == null) {
            return new Builder();
        }
        return new Builder(other);
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        WRITER$.write((Object)this, (Encoder)SpecificData.getEncoder((ObjectOutput)out));
    }

    public void readExternal(ObjectInput in) throws IOException {
        READER$.read((Object)this, (Decoder)SpecificData.getDecoder((ObjectInput)in));
    }

    protected boolean hasCustomCoders() {
        return true;
    }

    public void customEncode(Encoder out) throws IOException {
        out.writeDouble(this.time);
        out.writeDouble(this.timeReceived);
        out.writeString(this.summaryId);
        out.writeString(this.sleepLevel);
        out.writeDouble(this.startTime);
        out.writeDouble(this.endTime);
    }

    public void customDecode(ResolvingDecoder in) throws IOException {
        Schema.Field[] fieldOrder = in.readFieldOrderIfDiff();
        if (fieldOrder == null) {
            this.time = in.readDouble();
            this.timeReceived = in.readDouble();
            this.summaryId = in.readString();
            this.sleepLevel = in.readString();
            this.startTime = in.readDouble();
            this.endTime = in.readDouble();
        } else {
            block8: for (int i = 0; i < 6; ++i) {
                switch (fieldOrder[i].pos()) {
                    case 0: {
                        this.time = in.readDouble();
                        continue block8;
                    }
                    case 1: {
                        this.timeReceived = in.readDouble();
                        continue block8;
                    }
                    case 2: {
                        this.summaryId = in.readString();
                        continue block8;
                    }
                    case 3: {
                        this.sleepLevel = in.readString();
                        continue block8;
                    }
                    case 4: {
                        this.startTime = in.readDouble();
                        continue block8;
                    }
                    case 5: {
                        this.endTime = in.readDouble();
                        continue block8;
                    }
                    default: {
                        throw new IOException("Corrupt ResolvingDecoder.");
                    }
                }
            }
        }
    }

    @AvroGenerated
    public static class Builder
    extends SpecificRecordBuilderBase<GarminSleepLevel>
    implements RecordBuilder<GarminSleepLevel> {
        private double time;
        private double timeReceived;
        private String summaryId;
        private String sleepLevel;
        private double startTime;
        private double endTime;

        private Builder() {
            super(SCHEMA$);
        }

        private Builder(Builder other) {
            super((SpecificRecordBuilderBase)other);
            if (Builder.isValidValue((Schema.Field)this.fields()[0], (Object)other.time)) {
                this.time = (Double)this.data().deepCopy(this.fields()[0].schema(), (Object)other.time);
                this.fieldSetFlags()[0] = other.fieldSetFlags()[0];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[1], (Object)other.timeReceived)) {
                this.timeReceived = (Double)this.data().deepCopy(this.fields()[1].schema(), (Object)other.timeReceived);
                this.fieldSetFlags()[1] = other.fieldSetFlags()[1];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[2], (Object)other.summaryId)) {
                this.summaryId = (String)this.data().deepCopy(this.fields()[2].schema(), (Object)other.summaryId);
                this.fieldSetFlags()[2] = other.fieldSetFlags()[2];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[3], (Object)other.sleepLevel)) {
                this.sleepLevel = (String)this.data().deepCopy(this.fields()[3].schema(), (Object)other.sleepLevel);
                this.fieldSetFlags()[3] = other.fieldSetFlags()[3];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[4], (Object)other.startTime)) {
                this.startTime = (Double)this.data().deepCopy(this.fields()[4].schema(), (Object)other.startTime);
                this.fieldSetFlags()[4] = other.fieldSetFlags()[4];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[5], (Object)other.endTime)) {
                this.endTime = (Double)this.data().deepCopy(this.fields()[5].schema(), (Object)other.endTime);
                this.fieldSetFlags()[5] = other.fieldSetFlags()[5];
            }
        }

        private Builder(GarminSleepLevel other) {
            super(SCHEMA$);
            if (Builder.isValidValue((Schema.Field)this.fields()[0], (Object)other.time)) {
                this.time = (Double)this.data().deepCopy(this.fields()[0].schema(), (Object)other.time);
                this.fieldSetFlags()[0] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[1], (Object)other.timeReceived)) {
                this.timeReceived = (Double)this.data().deepCopy(this.fields()[1].schema(), (Object)other.timeReceived);
                this.fieldSetFlags()[1] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[2], (Object)other.summaryId)) {
                this.summaryId = (String)this.data().deepCopy(this.fields()[2].schema(), (Object)other.summaryId);
                this.fieldSetFlags()[2] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[3], (Object)other.sleepLevel)) {
                this.sleepLevel = (String)this.data().deepCopy(this.fields()[3].schema(), (Object)other.sleepLevel);
                this.fieldSetFlags()[3] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[4], (Object)other.startTime)) {
                this.startTime = (Double)this.data().deepCopy(this.fields()[4].schema(), (Object)other.startTime);
                this.fieldSetFlags()[4] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[5], (Object)other.endTime)) {
                this.endTime = (Double)this.data().deepCopy(this.fields()[5].schema(), (Object)other.endTime);
                this.fieldSetFlags()[5] = true;
            }
        }

        public double getTime() {
            return this.time;
        }

        public Builder setTime(double value) {
            this.validate(this.fields()[0], value);
            this.time = value;
            this.fieldSetFlags()[0] = true;
            return this;
        }

        public boolean hasTime() {
            return this.fieldSetFlags()[0];
        }

        public Builder clearTime() {
            this.fieldSetFlags()[0] = false;
            return this;
        }

        public double getTimeReceived() {
            return this.timeReceived;
        }

        public Builder setTimeReceived(double value) {
            this.validate(this.fields()[1], value);
            this.timeReceived = value;
            this.fieldSetFlags()[1] = true;
            return this;
        }

        public boolean hasTimeReceived() {
            return this.fieldSetFlags()[1];
        }

        public Builder clearTimeReceived() {
            this.fieldSetFlags()[1] = false;
            return this;
        }

        public String getSummaryId() {
            return this.summaryId;
        }

        public Builder setSummaryId(String value) {
            this.validate(this.fields()[2], value);
            this.summaryId = value;
            this.fieldSetFlags()[2] = true;
            return this;
        }

        public boolean hasSummaryId() {
            return this.fieldSetFlags()[2];
        }

        public Builder clearSummaryId() {
            this.summaryId = null;
            this.fieldSetFlags()[2] = false;
            return this;
        }

        public String getSleepLevel() {
            return this.sleepLevel;
        }

        public Builder setSleepLevel(String value) {
            this.validate(this.fields()[3], value);
            this.sleepLevel = value;
            this.fieldSetFlags()[3] = true;
            return this;
        }

        public boolean hasSleepLevel() {
            return this.fieldSetFlags()[3];
        }

        public Builder clearSleepLevel() {
            this.sleepLevel = null;
            this.fieldSetFlags()[3] = false;
            return this;
        }

        public double getStartTime() {
            return this.startTime;
        }

        public Builder setStartTime(double value) {
            this.validate(this.fields()[4], value);
            this.startTime = value;
            this.fieldSetFlags()[4] = true;
            return this;
        }

        public boolean hasStartTime() {
            return this.fieldSetFlags()[4];
        }

        public Builder clearStartTime() {
            this.fieldSetFlags()[4] = false;
            return this;
        }

        public double getEndTime() {
            return this.endTime;
        }

        public Builder setEndTime(double value) {
            this.validate(this.fields()[5], value);
            this.endTime = value;
            this.fieldSetFlags()[5] = true;
            return this;
        }

        public boolean hasEndTime() {
            return this.fieldSetFlags()[5];
        }

        public Builder clearEndTime() {
            this.fieldSetFlags()[5] = false;
            return this;
        }

        public GarminSleepLevel build() {
            try {
                GarminSleepLevel record = new GarminSleepLevel();
                record.time = this.fieldSetFlags()[0] ? this.time : (Double)this.defaultValue(this.fields()[0]);
                record.timeReceived = this.fieldSetFlags()[1] ? this.timeReceived : (Double)this.defaultValue(this.fields()[1]);
                record.summaryId = this.fieldSetFlags()[2] ? this.summaryId : (String)this.defaultValue(this.fields()[2]);
                record.sleepLevel = this.fieldSetFlags()[3] ? this.sleepLevel : (String)this.defaultValue(this.fields()[3]);
                record.startTime = this.fieldSetFlags()[4] ? this.startTime : (Double)this.defaultValue(this.fields()[4]);
                record.endTime = this.fieldSetFlags()[5] ? this.endTime : (Double)this.defaultValue(this.fields()[5]);
                return record;
            }
            catch (AvroMissingFieldException e) {
                throw e;
            }
            catch (Exception e) {
                throw new AvroRuntimeException((Throwable)e);
            }
        }
    }
}

