/*
 * Decompiled with CFR 0.152.
 */
package org.radarcns.passive.phone;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.nio.ByteBuffer;
import org.apache.avro.AvroMissingFieldException;
import org.apache.avro.AvroRuntimeException;
import org.apache.avro.Schema;
import org.apache.avro.data.RecordBuilder;
import org.apache.avro.generic.GenericData;
import org.apache.avro.io.DatumReader;
import org.apache.avro.io.DatumWriter;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.Encoder;
import org.apache.avro.io.ResolvingDecoder;
import org.apache.avro.message.BinaryMessageDecoder;
import org.apache.avro.message.BinaryMessageEncoder;
import org.apache.avro.message.SchemaStore;
import org.apache.avro.specific.AvroGenerated;
import org.apache.avro.specific.SpecificData;
import org.apache.avro.specific.SpecificRecord;
import org.apache.avro.specific.SpecificRecordBase;
import org.apache.avro.specific.SpecificRecordBuilderBase;
import org.radarcns.passive.phone.LocationProvider;

@AvroGenerated
public class PhoneRelativeLocation
extends SpecificRecordBase
implements SpecificRecord {
    private static final long serialVersionUID = 6571166508608248943L;
    public static final Schema SCHEMA$ = new Schema.Parser().parse("{\"type\":\"record\",\"name\":\"PhoneRelativeLocation\",\"namespace\":\"org.radarcns.passive.phone\",\"doc\":\"Data from the gps and network location providers. The latitude and longitude are optionally offset with an unspecified reference location and can thus be treated as relative locations. In that case, a location cannot be used to infer absolute location. This means accurate distances or angles between locations cannot be calculated since those depend on the absolute location. The reference location has a random longitude and a latitude that deviates at most 4 degrees in each direction to the initial location.\",\"fields\":[{\"name\":\"time\",\"type\":\"double\",\"doc\":\"Device timestamp in UTC (s).\"},{\"name\":\"timeReceived\",\"type\":\"double\",\"doc\":\"Device receiver timestamp in UTC (s).\"},{\"name\":\"offsetReference\",\"type\":[\"null\",\"int\"],\"doc\":\"Arbitrary reference to the offset. As long as the offset remains equal, so does this reference. If this reference is 0, no offset is used and the contained latitude and longitude can be considered absolute. If this is null, the location is relative to an offset but the offset is unknown: it may vary between different measurements with null reference. Offset references cannot be compared between users.\",\"default\":null},{\"name\":\"provider\",\"type\":{\"type\":\"enum\",\"name\":\"LocationProvider\",\"doc\":\"Type of provider of location data.\",\"symbols\":[\"GPS\",\"NETWORK\",\"OTHER\",\"UNKNOWN\"]},\"doc\":\"Android provider of the location data.\",\"default\":\"UNKNOWN\"},{\"name\":\"latitude\",\"type\":[\"null\",\"double\"],\"doc\":\"Relative latitude from an initial random reference latitude (degrees with range [-90, 90]).\",\"default\":null},{\"name\":\"longitude\",\"type\":[\"null\",\"double\"],\"doc\":\"Relative longitude from an initial reference longitude (degrees with range [-180, 180]).\",\"default\":null},{\"name\":\"altitude\",\"type\":[\"null\",\"float\"],\"doc\":\"Height above the WGS 84 reference ellipsoid (m).\",\"default\":null},{\"name\":\"accuracy\",\"type\":[\"null\",\"float\"],\"doc\":\"The estimated horizontal accuracy of this location, radial (m). We define horizontal accuracy as the radius of 68% confidence. In other words, if you draw a circle centered at this location's latitude and longitude, and with a radius equal to the accuracy, then there is a 68% probability that the true location is inside the circle.\",\"default\":null},{\"name\":\"speed\",\"type\":[\"null\",\"float\"],\"doc\":\"Speed over ground (m/s).\",\"default\":null},{\"name\":\"bearing\",\"type\":[\"null\",\"float\"],\"doc\":\"The horizontal direction of travel of this device (degrees with range (0, 360]).\",\"default\":null}]}");
    private static SpecificData MODEL$ = new SpecificData();
    private static final BinaryMessageEncoder<PhoneRelativeLocation> ENCODER = new BinaryMessageEncoder((GenericData)MODEL$, SCHEMA$);
    private static final BinaryMessageDecoder<PhoneRelativeLocation> DECODER = new BinaryMessageDecoder((GenericData)MODEL$, SCHEMA$);
    @Deprecated
    public double time;
    @Deprecated
    public double timeReceived;
    @Deprecated
    public Integer offsetReference;
    @Deprecated
    public LocationProvider provider;
    @Deprecated
    public Double latitude;
    @Deprecated
    public Double longitude;
    @Deprecated
    public Float altitude;
    @Deprecated
    public Float accuracy;
    @Deprecated
    public Float speed;
    @Deprecated
    public Float bearing;
    private static final DatumWriter<PhoneRelativeLocation> WRITER$ = MODEL$.createDatumWriter(SCHEMA$);
    private static final DatumReader<PhoneRelativeLocation> READER$ = MODEL$.createDatumReader(SCHEMA$);

    public static Schema getClassSchema() {
        return SCHEMA$;
    }

    public static BinaryMessageEncoder<PhoneRelativeLocation> getEncoder() {
        return ENCODER;
    }

    public static BinaryMessageDecoder<PhoneRelativeLocation> getDecoder() {
        return DECODER;
    }

    public static BinaryMessageDecoder<PhoneRelativeLocation> createDecoder(SchemaStore resolver) {
        return new BinaryMessageDecoder((GenericData)MODEL$, SCHEMA$, resolver);
    }

    public ByteBuffer toByteBuffer() throws IOException {
        return ENCODER.encode((Object)this);
    }

    public static PhoneRelativeLocation fromByteBuffer(ByteBuffer b) throws IOException {
        return (PhoneRelativeLocation)((Object)DECODER.decode(b));
    }

    public PhoneRelativeLocation() {
    }

    public PhoneRelativeLocation(Double time, Double timeReceived, Integer offsetReference, LocationProvider provider, Double latitude, Double longitude, Float altitude, Float accuracy, Float speed, Float bearing) {
        this.time = time;
        this.timeReceived = timeReceived;
        this.offsetReference = offsetReference;
        this.provider = provider;
        this.latitude = latitude;
        this.longitude = longitude;
        this.altitude = altitude;
        this.accuracy = accuracy;
        this.speed = speed;
        this.bearing = bearing;
    }

    public SpecificData getSpecificData() {
        return MODEL$;
    }

    public Schema getSchema() {
        return SCHEMA$;
    }

    public Object get(int field$) {
        switch (field$) {
            case 0: {
                return this.time;
            }
            case 1: {
                return this.timeReceived;
            }
            case 2: {
                return this.offsetReference;
            }
            case 3: {
                return this.provider;
            }
            case 4: {
                return this.latitude;
            }
            case 5: {
                return this.longitude;
            }
            case 6: {
                return this.altitude;
            }
            case 7: {
                return this.accuracy;
            }
            case 8: {
                return this.speed;
            }
            case 9: {
                return this.bearing;
            }
        }
        throw new IndexOutOfBoundsException("Invalid index: " + field$);
    }

    public void put(int field$, Object value$) {
        switch (field$) {
            case 0: {
                this.time = (Double)value$;
                break;
            }
            case 1: {
                this.timeReceived = (Double)value$;
                break;
            }
            case 2: {
                this.offsetReference = (Integer)value$;
                break;
            }
            case 3: {
                this.provider = (LocationProvider)((Object)value$);
                break;
            }
            case 4: {
                this.latitude = (Double)value$;
                break;
            }
            case 5: {
                this.longitude = (Double)value$;
                break;
            }
            case 6: {
                this.altitude = (Float)value$;
                break;
            }
            case 7: {
                this.accuracy = (Float)value$;
                break;
            }
            case 8: {
                this.speed = (Float)value$;
                break;
            }
            case 9: {
                this.bearing = (Float)value$;
                break;
            }
            default: {
                throw new IndexOutOfBoundsException("Invalid index: " + field$);
            }
        }
    }

    public double getTime() {
        return this.time;
    }

    public void setTime(double value) {
        this.time = value;
    }

    public double getTimeReceived() {
        return this.timeReceived;
    }

    public void setTimeReceived(double value) {
        this.timeReceived = value;
    }

    public Integer getOffsetReference() {
        return this.offsetReference;
    }

    public void setOffsetReference(Integer value) {
        this.offsetReference = value;
    }

    public LocationProvider getProvider() {
        return this.provider;
    }

    public void setProvider(LocationProvider value) {
        this.provider = value;
    }

    public Double getLatitude() {
        return this.latitude;
    }

    public void setLatitude(Double value) {
        this.latitude = value;
    }

    public Double getLongitude() {
        return this.longitude;
    }

    public void setLongitude(Double value) {
        this.longitude = value;
    }

    public Float getAltitude() {
        return this.altitude;
    }

    public void setAltitude(Float value) {
        this.altitude = value;
    }

    public Float getAccuracy() {
        return this.accuracy;
    }

    public void setAccuracy(Float value) {
        this.accuracy = value;
    }

    public Float getSpeed() {
        return this.speed;
    }

    public void setSpeed(Float value) {
        this.speed = value;
    }

    public Float getBearing() {
        return this.bearing;
    }

    public void setBearing(Float value) {
        this.bearing = value;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newBuilder(Builder other) {
        if (other == null) {
            return new Builder();
        }
        return new Builder(other);
    }

    public static Builder newBuilder(PhoneRelativeLocation other) {
        if (other == null) {
            return new Builder();
        }
        return new Builder(other);
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        WRITER$.write((Object)this, (Encoder)SpecificData.getEncoder((ObjectOutput)out));
    }

    public void readExternal(ObjectInput in) throws IOException {
        READER$.read((Object)this, (Decoder)SpecificData.getDecoder((ObjectInput)in));
    }

    protected boolean hasCustomCoders() {
        return true;
    }

    public void customEncode(Encoder out) throws IOException {
        out.writeDouble(this.time);
        out.writeDouble(this.timeReceived);
        if (this.offsetReference == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeInt(this.offsetReference.intValue());
        }
        out.writeEnum(this.provider.ordinal());
        if (this.latitude == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeDouble(this.latitude.doubleValue());
        }
        if (this.longitude == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeDouble(this.longitude.doubleValue());
        }
        if (this.altitude == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeFloat(this.altitude.floatValue());
        }
        if (this.accuracy == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeFloat(this.accuracy.floatValue());
        }
        if (this.speed == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeFloat(this.speed.floatValue());
        }
        if (this.bearing == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeFloat(this.bearing.floatValue());
        }
    }

    public void customDecode(ResolvingDecoder in) throws IOException {
        Schema.Field[] fieldOrder = in.readFieldOrderIfDiff();
        if (fieldOrder == null) {
            this.time = in.readDouble();
            this.timeReceived = in.readDouble();
            if (in.readIndex() != 1) {
                in.readNull();
                this.offsetReference = null;
            } else {
                this.offsetReference = in.readInt();
            }
            this.provider = LocationProvider.values()[in.readEnum()];
            if (in.readIndex() != 1) {
                in.readNull();
                this.latitude = null;
            } else {
                this.latitude = in.readDouble();
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.longitude = null;
            } else {
                this.longitude = in.readDouble();
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.altitude = null;
            } else {
                this.altitude = Float.valueOf(in.readFloat());
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.accuracy = null;
            } else {
                this.accuracy = Float.valueOf(in.readFloat());
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.speed = null;
            } else {
                this.speed = Float.valueOf(in.readFloat());
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.bearing = null;
            } else {
                this.bearing = Float.valueOf(in.readFloat());
            }
        } else {
            block12: for (int i = 0; i < 10; ++i) {
                switch (fieldOrder[i].pos()) {
                    case 0: {
                        this.time = in.readDouble();
                        continue block12;
                    }
                    case 1: {
                        this.timeReceived = in.readDouble();
                        continue block12;
                    }
                    case 2: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.offsetReference = null;
                            continue block12;
                        }
                        this.offsetReference = in.readInt();
                        continue block12;
                    }
                    case 3: {
                        this.provider = LocationProvider.values()[in.readEnum()];
                        continue block12;
                    }
                    case 4: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.latitude = null;
                            continue block12;
                        }
                        this.latitude = in.readDouble();
                        continue block12;
                    }
                    case 5: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.longitude = null;
                            continue block12;
                        }
                        this.longitude = in.readDouble();
                        continue block12;
                    }
                    case 6: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.altitude = null;
                            continue block12;
                        }
                        this.altitude = Float.valueOf(in.readFloat());
                        continue block12;
                    }
                    case 7: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.accuracy = null;
                            continue block12;
                        }
                        this.accuracy = Float.valueOf(in.readFloat());
                        continue block12;
                    }
                    case 8: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.speed = null;
                            continue block12;
                        }
                        this.speed = Float.valueOf(in.readFloat());
                        continue block12;
                    }
                    case 9: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.bearing = null;
                            continue block12;
                        }
                        this.bearing = Float.valueOf(in.readFloat());
                        continue block12;
                    }
                    default: {
                        throw new IOException("Corrupt ResolvingDecoder.");
                    }
                }
            }
        }
    }

    @AvroGenerated
    public static class Builder
    extends SpecificRecordBuilderBase<PhoneRelativeLocation>
    implements RecordBuilder<PhoneRelativeLocation> {
        private double time;
        private double timeReceived;
        private Integer offsetReference;
        private LocationProvider provider;
        private Double latitude;
        private Double longitude;
        private Float altitude;
        private Float accuracy;
        private Float speed;
        private Float bearing;

        private Builder() {
            super(SCHEMA$);
        }

        private Builder(Builder other) {
            super((SpecificRecordBuilderBase)other);
            if (Builder.isValidValue((Schema.Field)this.fields()[0], (Object)other.time)) {
                this.time = (Double)this.data().deepCopy(this.fields()[0].schema(), (Object)other.time);
                this.fieldSetFlags()[0] = other.fieldSetFlags()[0];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[1], (Object)other.timeReceived)) {
                this.timeReceived = (Double)this.data().deepCopy(this.fields()[1].schema(), (Object)other.timeReceived);
                this.fieldSetFlags()[1] = other.fieldSetFlags()[1];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[2], (Object)other.offsetReference)) {
                this.offsetReference = (Integer)this.data().deepCopy(this.fields()[2].schema(), (Object)other.offsetReference);
                this.fieldSetFlags()[2] = other.fieldSetFlags()[2];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[3], (Object)((Object)other.provider))) {
                this.provider = (LocationProvider)((Object)this.data().deepCopy(this.fields()[3].schema(), (Object)other.provider));
                this.fieldSetFlags()[3] = other.fieldSetFlags()[3];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[4], (Object)other.latitude)) {
                this.latitude = (Double)this.data().deepCopy(this.fields()[4].schema(), (Object)other.latitude);
                this.fieldSetFlags()[4] = other.fieldSetFlags()[4];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[5], (Object)other.longitude)) {
                this.longitude = (Double)this.data().deepCopy(this.fields()[5].schema(), (Object)other.longitude);
                this.fieldSetFlags()[5] = other.fieldSetFlags()[5];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[6], (Object)other.altitude)) {
                this.altitude = (Float)this.data().deepCopy(this.fields()[6].schema(), (Object)other.altitude);
                this.fieldSetFlags()[6] = other.fieldSetFlags()[6];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[7], (Object)other.accuracy)) {
                this.accuracy = (Float)this.data().deepCopy(this.fields()[7].schema(), (Object)other.accuracy);
                this.fieldSetFlags()[7] = other.fieldSetFlags()[7];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[8], (Object)other.speed)) {
                this.speed = (Float)this.data().deepCopy(this.fields()[8].schema(), (Object)other.speed);
                this.fieldSetFlags()[8] = other.fieldSetFlags()[8];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[9], (Object)other.bearing)) {
                this.bearing = (Float)this.data().deepCopy(this.fields()[9].schema(), (Object)other.bearing);
                this.fieldSetFlags()[9] = other.fieldSetFlags()[9];
            }
        }

        private Builder(PhoneRelativeLocation other) {
            super(SCHEMA$);
            if (Builder.isValidValue((Schema.Field)this.fields()[0], (Object)other.time)) {
                this.time = (Double)this.data().deepCopy(this.fields()[0].schema(), (Object)other.time);
                this.fieldSetFlags()[0] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[1], (Object)other.timeReceived)) {
                this.timeReceived = (Double)this.data().deepCopy(this.fields()[1].schema(), (Object)other.timeReceived);
                this.fieldSetFlags()[1] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[2], (Object)other.offsetReference)) {
                this.offsetReference = (Integer)this.data().deepCopy(this.fields()[2].schema(), (Object)other.offsetReference);
                this.fieldSetFlags()[2] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[3], (Object)((Object)other.provider))) {
                this.provider = (LocationProvider)((Object)this.data().deepCopy(this.fields()[3].schema(), (Object)other.provider));
                this.fieldSetFlags()[3] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[4], (Object)other.latitude)) {
                this.latitude = (Double)this.data().deepCopy(this.fields()[4].schema(), (Object)other.latitude);
                this.fieldSetFlags()[4] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[5], (Object)other.longitude)) {
                this.longitude = (Double)this.data().deepCopy(this.fields()[5].schema(), (Object)other.longitude);
                this.fieldSetFlags()[5] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[6], (Object)other.altitude)) {
                this.altitude = (Float)this.data().deepCopy(this.fields()[6].schema(), (Object)other.altitude);
                this.fieldSetFlags()[6] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[7], (Object)other.accuracy)) {
                this.accuracy = (Float)this.data().deepCopy(this.fields()[7].schema(), (Object)other.accuracy);
                this.fieldSetFlags()[7] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[8], (Object)other.speed)) {
                this.speed = (Float)this.data().deepCopy(this.fields()[8].schema(), (Object)other.speed);
                this.fieldSetFlags()[8] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[9], (Object)other.bearing)) {
                this.bearing = (Float)this.data().deepCopy(this.fields()[9].schema(), (Object)other.bearing);
                this.fieldSetFlags()[9] = true;
            }
        }

        public double getTime() {
            return this.time;
        }

        public Builder setTime(double value) {
            this.validate(this.fields()[0], value);
            this.time = value;
            this.fieldSetFlags()[0] = true;
            return this;
        }

        public boolean hasTime() {
            return this.fieldSetFlags()[0];
        }

        public Builder clearTime() {
            this.fieldSetFlags()[0] = false;
            return this;
        }

        public double getTimeReceived() {
            return this.timeReceived;
        }

        public Builder setTimeReceived(double value) {
            this.validate(this.fields()[1], value);
            this.timeReceived = value;
            this.fieldSetFlags()[1] = true;
            return this;
        }

        public boolean hasTimeReceived() {
            return this.fieldSetFlags()[1];
        }

        public Builder clearTimeReceived() {
            this.fieldSetFlags()[1] = false;
            return this;
        }

        public Integer getOffsetReference() {
            return this.offsetReference;
        }

        public Builder setOffsetReference(Integer value) {
            this.validate(this.fields()[2], value);
            this.offsetReference = value;
            this.fieldSetFlags()[2] = true;
            return this;
        }

        public boolean hasOffsetReference() {
            return this.fieldSetFlags()[2];
        }

        public Builder clearOffsetReference() {
            this.offsetReference = null;
            this.fieldSetFlags()[2] = false;
            return this;
        }

        public LocationProvider getProvider() {
            return this.provider;
        }

        public Builder setProvider(LocationProvider value) {
            this.validate(this.fields()[3], (Object)value);
            this.provider = value;
            this.fieldSetFlags()[3] = true;
            return this;
        }

        public boolean hasProvider() {
            return this.fieldSetFlags()[3];
        }

        public Builder clearProvider() {
            this.provider = null;
            this.fieldSetFlags()[3] = false;
            return this;
        }

        public Double getLatitude() {
            return this.latitude;
        }

        public Builder setLatitude(Double value) {
            this.validate(this.fields()[4], value);
            this.latitude = value;
            this.fieldSetFlags()[4] = true;
            return this;
        }

        public boolean hasLatitude() {
            return this.fieldSetFlags()[4];
        }

        public Builder clearLatitude() {
            this.latitude = null;
            this.fieldSetFlags()[4] = false;
            return this;
        }

        public Double getLongitude() {
            return this.longitude;
        }

        public Builder setLongitude(Double value) {
            this.validate(this.fields()[5], value);
            this.longitude = value;
            this.fieldSetFlags()[5] = true;
            return this;
        }

        public boolean hasLongitude() {
            return this.fieldSetFlags()[5];
        }

        public Builder clearLongitude() {
            this.longitude = null;
            this.fieldSetFlags()[5] = false;
            return this;
        }

        public Float getAltitude() {
            return this.altitude;
        }

        public Builder setAltitude(Float value) {
            this.validate(this.fields()[6], value);
            this.altitude = value;
            this.fieldSetFlags()[6] = true;
            return this;
        }

        public boolean hasAltitude() {
            return this.fieldSetFlags()[6];
        }

        public Builder clearAltitude() {
            this.altitude = null;
            this.fieldSetFlags()[6] = false;
            return this;
        }

        public Float getAccuracy() {
            return this.accuracy;
        }

        public Builder setAccuracy(Float value) {
            this.validate(this.fields()[7], value);
            this.accuracy = value;
            this.fieldSetFlags()[7] = true;
            return this;
        }

        public boolean hasAccuracy() {
            return this.fieldSetFlags()[7];
        }

        public Builder clearAccuracy() {
            this.accuracy = null;
            this.fieldSetFlags()[7] = false;
            return this;
        }

        public Float getSpeed() {
            return this.speed;
        }

        public Builder setSpeed(Float value) {
            this.validate(this.fields()[8], value);
            this.speed = value;
            this.fieldSetFlags()[8] = true;
            return this;
        }

        public boolean hasSpeed() {
            return this.fieldSetFlags()[8];
        }

        public Builder clearSpeed() {
            this.speed = null;
            this.fieldSetFlags()[8] = false;
            return this;
        }

        public Float getBearing() {
            return this.bearing;
        }

        public Builder setBearing(Float value) {
            this.validate(this.fields()[9], value);
            this.bearing = value;
            this.fieldSetFlags()[9] = true;
            return this;
        }

        public boolean hasBearing() {
            return this.fieldSetFlags()[9];
        }

        public Builder clearBearing() {
            this.bearing = null;
            this.fieldSetFlags()[9] = false;
            return this;
        }

        public PhoneRelativeLocation build() {
            try {
                PhoneRelativeLocation record = new PhoneRelativeLocation();
                record.time = this.fieldSetFlags()[0] ? this.time : (Double)this.defaultValue(this.fields()[0]);
                record.timeReceived = this.fieldSetFlags()[1] ? this.timeReceived : (Double)this.defaultValue(this.fields()[1]);
                record.offsetReference = this.fieldSetFlags()[2] ? this.offsetReference : (Integer)this.defaultValue(this.fields()[2]);
                record.provider = this.fieldSetFlags()[3] ? this.provider : (LocationProvider)((Object)this.defaultValue(this.fields()[3]));
                record.latitude = this.fieldSetFlags()[4] ? this.latitude : (Double)this.defaultValue(this.fields()[4]);
                record.longitude = this.fieldSetFlags()[5] ? this.longitude : (Double)this.defaultValue(this.fields()[5]);
                record.altitude = this.fieldSetFlags()[6] ? this.altitude : (Float)this.defaultValue(this.fields()[6]);
                record.accuracy = this.fieldSetFlags()[7] ? this.accuracy : (Float)this.defaultValue(this.fields()[7]);
                record.speed = this.fieldSetFlags()[8] ? this.speed : (Float)this.defaultValue(this.fields()[8]);
                record.bearing = this.fieldSetFlags()[9] ? this.bearing : (Float)this.defaultValue(this.fields()[9]);
                return record;
            }
            catch (AvroMissingFieldException e) {
                throw e;
            }
            catch (Exception e) {
                throw new AvroRuntimeException((Throwable)e);
            }
        }
    }
}

