/*
 * Decompiled with CFR 0.152.
 */
package org.radarcns.passive.bittium;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.nio.ByteBuffer;
import org.apache.avro.AvroMissingFieldException;
import org.apache.avro.AvroRuntimeException;
import org.apache.avro.Schema;
import org.apache.avro.data.RecordBuilder;
import org.apache.avro.generic.GenericData;
import org.apache.avro.io.DatumReader;
import org.apache.avro.io.DatumWriter;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.Encoder;
import org.apache.avro.io.ResolvingDecoder;
import org.apache.avro.message.BinaryMessageDecoder;
import org.apache.avro.message.BinaryMessageEncoder;
import org.apache.avro.message.SchemaStore;
import org.apache.avro.specific.AvroGenerated;
import org.apache.avro.specific.SpecificData;
import org.apache.avro.specific.SpecificRecord;
import org.apache.avro.specific.SpecificRecordBase;
import org.apache.avro.specific.SpecificRecordBuilderBase;

@AvroGenerated
public class BittiumFarosBatteryLevel
extends SpecificRecordBase
implements SpecificRecord {
    private static final long serialVersionUID = 3777047820258727627L;
    public static final Schema SCHEMA$ = new Schema.Parser().parse("{\"type\":\"record\",\"name\":\"BittiumFarosBatteryLevel\",\"namespace\":\"org.radarcns.passive.bittium\",\"doc\":\"Battery level of a Bittium Faros device.\",\"fields\":[{\"name\":\"time\",\"type\":\"double\",\"doc\":\"Device timestamp in UTC (s).\"},{\"name\":\"timeReceived\",\"type\":\"double\",\"doc\":\"Device receiver timestamp in UTC (s).\"},{\"name\":\"batteryLevel\",\"type\":\"float\",\"doc\":\"Battery level from 0 to 1. Note that the battery level is a rough estimate.\"},{\"name\":\"exact\",\"type\":\"boolean\",\"doc\":\"Whether the batteryLevel can be taken as an exact value. True if the battery level is an exact representation, false if it is just an estimate based on the battery status (CRITICAL/LOW/MEDIUM/HIGH).\"}]}");
    private static SpecificData MODEL$ = new SpecificData();
    private static final BinaryMessageEncoder<BittiumFarosBatteryLevel> ENCODER = new BinaryMessageEncoder((GenericData)MODEL$, SCHEMA$);
    private static final BinaryMessageDecoder<BittiumFarosBatteryLevel> DECODER = new BinaryMessageDecoder((GenericData)MODEL$, SCHEMA$);
    @Deprecated
    public double time;
    @Deprecated
    public double timeReceived;
    @Deprecated
    public float batteryLevel;
    @Deprecated
    public boolean exact;
    private static final DatumWriter<BittiumFarosBatteryLevel> WRITER$ = MODEL$.createDatumWriter(SCHEMA$);
    private static final DatumReader<BittiumFarosBatteryLevel> READER$ = MODEL$.createDatumReader(SCHEMA$);

    public static Schema getClassSchema() {
        return SCHEMA$;
    }

    public static BinaryMessageEncoder<BittiumFarosBatteryLevel> getEncoder() {
        return ENCODER;
    }

    public static BinaryMessageDecoder<BittiumFarosBatteryLevel> getDecoder() {
        return DECODER;
    }

    public static BinaryMessageDecoder<BittiumFarosBatteryLevel> createDecoder(SchemaStore resolver) {
        return new BinaryMessageDecoder((GenericData)MODEL$, SCHEMA$, resolver);
    }

    public ByteBuffer toByteBuffer() throws IOException {
        return ENCODER.encode((Object)this);
    }

    public static BittiumFarosBatteryLevel fromByteBuffer(ByteBuffer b) throws IOException {
        return (BittiumFarosBatteryLevel)((Object)DECODER.decode(b));
    }

    public BittiumFarosBatteryLevel() {
    }

    public BittiumFarosBatteryLevel(Double time, Double timeReceived, Float batteryLevel, Boolean exact) {
        this.time = time;
        this.timeReceived = timeReceived;
        this.batteryLevel = batteryLevel.floatValue();
        this.exact = exact;
    }

    public SpecificData getSpecificData() {
        return MODEL$;
    }

    public Schema getSchema() {
        return SCHEMA$;
    }

    public Object get(int field$) {
        switch (field$) {
            case 0: {
                return this.time;
            }
            case 1: {
                return this.timeReceived;
            }
            case 2: {
                return Float.valueOf(this.batteryLevel);
            }
            case 3: {
                return this.exact;
            }
        }
        throw new IndexOutOfBoundsException("Invalid index: " + field$);
    }

    public void put(int field$, Object value$) {
        switch (field$) {
            case 0: {
                this.time = (Double)value$;
                break;
            }
            case 1: {
                this.timeReceived = (Double)value$;
                break;
            }
            case 2: {
                this.batteryLevel = ((Float)value$).floatValue();
                break;
            }
            case 3: {
                this.exact = (Boolean)value$;
                break;
            }
            default: {
                throw new IndexOutOfBoundsException("Invalid index: " + field$);
            }
        }
    }

    public double getTime() {
        return this.time;
    }

    public void setTime(double value) {
        this.time = value;
    }

    public double getTimeReceived() {
        return this.timeReceived;
    }

    public void setTimeReceived(double value) {
        this.timeReceived = value;
    }

    public float getBatteryLevel() {
        return this.batteryLevel;
    }

    public void setBatteryLevel(float value) {
        this.batteryLevel = value;
    }

    public boolean getExact() {
        return this.exact;
    }

    public void setExact(boolean value) {
        this.exact = value;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newBuilder(Builder other) {
        if (other == null) {
            return new Builder();
        }
        return new Builder(other);
    }

    public static Builder newBuilder(BittiumFarosBatteryLevel other) {
        if (other == null) {
            return new Builder();
        }
        return new Builder(other);
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        WRITER$.write((Object)this, (Encoder)SpecificData.getEncoder((ObjectOutput)out));
    }

    public void readExternal(ObjectInput in) throws IOException {
        READER$.read((Object)this, (Decoder)SpecificData.getDecoder((ObjectInput)in));
    }

    protected boolean hasCustomCoders() {
        return true;
    }

    public void customEncode(Encoder out) throws IOException {
        out.writeDouble(this.time);
        out.writeDouble(this.timeReceived);
        out.writeFloat(this.batteryLevel);
        out.writeBoolean(this.exact);
    }

    public void customDecode(ResolvingDecoder in) throws IOException {
        Schema.Field[] fieldOrder = in.readFieldOrderIfDiff();
        if (fieldOrder == null) {
            this.time = in.readDouble();
            this.timeReceived = in.readDouble();
            this.batteryLevel = in.readFloat();
            this.exact = in.readBoolean();
        } else {
            block6: for (int i = 0; i < 4; ++i) {
                switch (fieldOrder[i].pos()) {
                    case 0: {
                        this.time = in.readDouble();
                        continue block6;
                    }
                    case 1: {
                        this.timeReceived = in.readDouble();
                        continue block6;
                    }
                    case 2: {
                        this.batteryLevel = in.readFloat();
                        continue block6;
                    }
                    case 3: {
                        this.exact = in.readBoolean();
                        continue block6;
                    }
                    default: {
                        throw new IOException("Corrupt ResolvingDecoder.");
                    }
                }
            }
        }
    }

    @AvroGenerated
    public static class Builder
    extends SpecificRecordBuilderBase<BittiumFarosBatteryLevel>
    implements RecordBuilder<BittiumFarosBatteryLevel> {
        private double time;
        private double timeReceived;
        private float batteryLevel;
        private boolean exact;

        private Builder() {
            super(SCHEMA$);
        }

        private Builder(Builder other) {
            super((SpecificRecordBuilderBase)other);
            if (Builder.isValidValue((Schema.Field)this.fields()[0], (Object)other.time)) {
                this.time = (Double)this.data().deepCopy(this.fields()[0].schema(), (Object)other.time);
                this.fieldSetFlags()[0] = other.fieldSetFlags()[0];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[1], (Object)other.timeReceived)) {
                this.timeReceived = (Double)this.data().deepCopy(this.fields()[1].schema(), (Object)other.timeReceived);
                this.fieldSetFlags()[1] = other.fieldSetFlags()[1];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[2], (Object)Float.valueOf(other.batteryLevel))) {
                this.batteryLevel = ((Float)this.data().deepCopy(this.fields()[2].schema(), (Object)Float.valueOf(other.batteryLevel))).floatValue();
                this.fieldSetFlags()[2] = other.fieldSetFlags()[2];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[3], (Object)other.exact)) {
                this.exact = (Boolean)this.data().deepCopy(this.fields()[3].schema(), (Object)other.exact);
                this.fieldSetFlags()[3] = other.fieldSetFlags()[3];
            }
        }

        private Builder(BittiumFarosBatteryLevel other) {
            super(SCHEMA$);
            if (Builder.isValidValue((Schema.Field)this.fields()[0], (Object)other.time)) {
                this.time = (Double)this.data().deepCopy(this.fields()[0].schema(), (Object)other.time);
                this.fieldSetFlags()[0] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[1], (Object)other.timeReceived)) {
                this.timeReceived = (Double)this.data().deepCopy(this.fields()[1].schema(), (Object)other.timeReceived);
                this.fieldSetFlags()[1] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[2], (Object)Float.valueOf(other.batteryLevel))) {
                this.batteryLevel = ((Float)this.data().deepCopy(this.fields()[2].schema(), (Object)Float.valueOf(other.batteryLevel))).floatValue();
                this.fieldSetFlags()[2] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[3], (Object)other.exact)) {
                this.exact = (Boolean)this.data().deepCopy(this.fields()[3].schema(), (Object)other.exact);
                this.fieldSetFlags()[3] = true;
            }
        }

        public double getTime() {
            return this.time;
        }

        public Builder setTime(double value) {
            this.validate(this.fields()[0], value);
            this.time = value;
            this.fieldSetFlags()[0] = true;
            return this;
        }

        public boolean hasTime() {
            return this.fieldSetFlags()[0];
        }

        public Builder clearTime() {
            this.fieldSetFlags()[0] = false;
            return this;
        }

        public double getTimeReceived() {
            return this.timeReceived;
        }

        public Builder setTimeReceived(double value) {
            this.validate(this.fields()[1], value);
            this.timeReceived = value;
            this.fieldSetFlags()[1] = true;
            return this;
        }

        public boolean hasTimeReceived() {
            return this.fieldSetFlags()[1];
        }

        public Builder clearTimeReceived() {
            this.fieldSetFlags()[1] = false;
            return this;
        }

        public float getBatteryLevel() {
            return this.batteryLevel;
        }

        public Builder setBatteryLevel(float value) {
            this.validate(this.fields()[2], Float.valueOf(value));
            this.batteryLevel = value;
            this.fieldSetFlags()[2] = true;
            return this;
        }

        public boolean hasBatteryLevel() {
            return this.fieldSetFlags()[2];
        }

        public Builder clearBatteryLevel() {
            this.fieldSetFlags()[2] = false;
            return this;
        }

        public boolean getExact() {
            return this.exact;
        }

        public Builder setExact(boolean value) {
            this.validate(this.fields()[3], value);
            this.exact = value;
            this.fieldSetFlags()[3] = true;
            return this;
        }

        public boolean hasExact() {
            return this.fieldSetFlags()[3];
        }

        public Builder clearExact() {
            this.fieldSetFlags()[3] = false;
            return this;
        }

        public BittiumFarosBatteryLevel build() {
            try {
                BittiumFarosBatteryLevel record = new BittiumFarosBatteryLevel();
                record.time = this.fieldSetFlags()[0] ? this.time : (Double)this.defaultValue(this.fields()[0]);
                record.timeReceived = this.fieldSetFlags()[1] ? this.timeReceived : (Double)this.defaultValue(this.fields()[1]);
                record.batteryLevel = this.fieldSetFlags()[2] ? this.batteryLevel : ((Float)this.defaultValue(this.fields()[2])).floatValue();
                record.exact = this.fieldSetFlags()[3] ? this.exact : (Boolean)this.defaultValue(this.fields()[3]);
                return record;
            }
            catch (AvroMissingFieldException e) {
                throw e;
            }
            catch (Exception e) {
                throw new AvroRuntimeException((Throwable)e);
            }
        }
    }
}

