/*
 * Decompiled with CFR 0.152.
 */
package org.radarcns.passive.biovotion;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.nio.ByteBuffer;
import org.apache.avro.AvroMissingFieldException;
import org.apache.avro.AvroRuntimeException;
import org.apache.avro.Schema;
import org.apache.avro.data.RecordBuilder;
import org.apache.avro.generic.GenericData;
import org.apache.avro.io.DatumReader;
import org.apache.avro.io.DatumWriter;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.Encoder;
import org.apache.avro.io.ResolvingDecoder;
import org.apache.avro.message.BinaryMessageDecoder;
import org.apache.avro.message.BinaryMessageEncoder;
import org.apache.avro.message.SchemaStore;
import org.apache.avro.specific.AvroGenerated;
import org.apache.avro.specific.SpecificData;
import org.apache.avro.specific.SpecificRecord;
import org.apache.avro.specific.SpecificRecordBase;
import org.apache.avro.specific.SpecificRecordBuilderBase;

@AvroGenerated
public class BiovotionVsm1HeartRateVariability
extends SpecificRecordBase
implements SpecificRecord {
    private static final long serialVersionUID = 1174576710124131640L;
    public static final Schema SCHEMA$ = new Schema.Parser().parse("{\"type\":\"record\",\"name\":\"BiovotionVsm1HeartRateVariability\",\"namespace\":\"org.radarcns.passive.biovotion\",\"doc\":\"Heart rate variability data calculated by biovotion device.\",\"fields\":[{\"name\":\"time\",\"type\":\"double\",\"doc\":\"Device timestamp in UTC (s).\"},{\"name\":\"timeReceived\",\"type\":\"double\",\"doc\":\"Device receiver timestamp in UTC (s).\"},{\"name\":\"heartRateVariability\",\"type\":\"float\",\"doc\":\"Heart rate variability value. The applied metric is the root mean squared of successive differences (RMSSD) of heart pulses, measured in milliseconds.\"},{\"name\":\"heartRateVariabilityQuality\",\"type\":\"float\",\"doc\":\"Heart rate variability quality (0-1).\"}]}");
    private static SpecificData MODEL$ = new SpecificData();
    private static final BinaryMessageEncoder<BiovotionVsm1HeartRateVariability> ENCODER = new BinaryMessageEncoder((GenericData)MODEL$, SCHEMA$);
    private static final BinaryMessageDecoder<BiovotionVsm1HeartRateVariability> DECODER = new BinaryMessageDecoder((GenericData)MODEL$, SCHEMA$);
    @Deprecated
    public double time;
    @Deprecated
    public double timeReceived;
    @Deprecated
    public float heartRateVariability;
    @Deprecated
    public float heartRateVariabilityQuality;
    private static final DatumWriter<BiovotionVsm1HeartRateVariability> WRITER$ = MODEL$.createDatumWriter(SCHEMA$);
    private static final DatumReader<BiovotionVsm1HeartRateVariability> READER$ = MODEL$.createDatumReader(SCHEMA$);

    public static Schema getClassSchema() {
        return SCHEMA$;
    }

    public static BinaryMessageEncoder<BiovotionVsm1HeartRateVariability> getEncoder() {
        return ENCODER;
    }

    public static BinaryMessageDecoder<BiovotionVsm1HeartRateVariability> getDecoder() {
        return DECODER;
    }

    public static BinaryMessageDecoder<BiovotionVsm1HeartRateVariability> createDecoder(SchemaStore resolver) {
        return new BinaryMessageDecoder((GenericData)MODEL$, SCHEMA$, resolver);
    }

    public ByteBuffer toByteBuffer() throws IOException {
        return ENCODER.encode((Object)this);
    }

    public static BiovotionVsm1HeartRateVariability fromByteBuffer(ByteBuffer b) throws IOException {
        return (BiovotionVsm1HeartRateVariability)((Object)DECODER.decode(b));
    }

    public BiovotionVsm1HeartRateVariability() {
    }

    public BiovotionVsm1HeartRateVariability(Double time, Double timeReceived, Float heartRateVariability, Float heartRateVariabilityQuality) {
        this.time = time;
        this.timeReceived = timeReceived;
        this.heartRateVariability = heartRateVariability.floatValue();
        this.heartRateVariabilityQuality = heartRateVariabilityQuality.floatValue();
    }

    public SpecificData getSpecificData() {
        return MODEL$;
    }

    public Schema getSchema() {
        return SCHEMA$;
    }

    public Object get(int field$) {
        switch (field$) {
            case 0: {
                return this.time;
            }
            case 1: {
                return this.timeReceived;
            }
            case 2: {
                return Float.valueOf(this.heartRateVariability);
            }
            case 3: {
                return Float.valueOf(this.heartRateVariabilityQuality);
            }
        }
        throw new IndexOutOfBoundsException("Invalid index: " + field$);
    }

    public void put(int field$, Object value$) {
        switch (field$) {
            case 0: {
                this.time = (Double)value$;
                break;
            }
            case 1: {
                this.timeReceived = (Double)value$;
                break;
            }
            case 2: {
                this.heartRateVariability = ((Float)value$).floatValue();
                break;
            }
            case 3: {
                this.heartRateVariabilityQuality = ((Float)value$).floatValue();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException("Invalid index: " + field$);
            }
        }
    }

    public double getTime() {
        return this.time;
    }

    public void setTime(double value) {
        this.time = value;
    }

    public double getTimeReceived() {
        return this.timeReceived;
    }

    public void setTimeReceived(double value) {
        this.timeReceived = value;
    }

    public float getHeartRateVariability() {
        return this.heartRateVariability;
    }

    public void setHeartRateVariability(float value) {
        this.heartRateVariability = value;
    }

    public float getHeartRateVariabilityQuality() {
        return this.heartRateVariabilityQuality;
    }

    public void setHeartRateVariabilityQuality(float value) {
        this.heartRateVariabilityQuality = value;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newBuilder(Builder other) {
        if (other == null) {
            return new Builder();
        }
        return new Builder(other);
    }

    public static Builder newBuilder(BiovotionVsm1HeartRateVariability other) {
        if (other == null) {
            return new Builder();
        }
        return new Builder(other);
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        WRITER$.write((Object)this, (Encoder)SpecificData.getEncoder((ObjectOutput)out));
    }

    public void readExternal(ObjectInput in) throws IOException {
        READER$.read((Object)this, (Decoder)SpecificData.getDecoder((ObjectInput)in));
    }

    protected boolean hasCustomCoders() {
        return true;
    }

    public void customEncode(Encoder out) throws IOException {
        out.writeDouble(this.time);
        out.writeDouble(this.timeReceived);
        out.writeFloat(this.heartRateVariability);
        out.writeFloat(this.heartRateVariabilityQuality);
    }

    public void customDecode(ResolvingDecoder in) throws IOException {
        Schema.Field[] fieldOrder = in.readFieldOrderIfDiff();
        if (fieldOrder == null) {
            this.time = in.readDouble();
            this.timeReceived = in.readDouble();
            this.heartRateVariability = in.readFloat();
            this.heartRateVariabilityQuality = in.readFloat();
        } else {
            block6: for (int i = 0; i < 4; ++i) {
                switch (fieldOrder[i].pos()) {
                    case 0: {
                        this.time = in.readDouble();
                        continue block6;
                    }
                    case 1: {
                        this.timeReceived = in.readDouble();
                        continue block6;
                    }
                    case 2: {
                        this.heartRateVariability = in.readFloat();
                        continue block6;
                    }
                    case 3: {
                        this.heartRateVariabilityQuality = in.readFloat();
                        continue block6;
                    }
                    default: {
                        throw new IOException("Corrupt ResolvingDecoder.");
                    }
                }
            }
        }
    }

    @AvroGenerated
    public static class Builder
    extends SpecificRecordBuilderBase<BiovotionVsm1HeartRateVariability>
    implements RecordBuilder<BiovotionVsm1HeartRateVariability> {
        private double time;
        private double timeReceived;
        private float heartRateVariability;
        private float heartRateVariabilityQuality;

        private Builder() {
            super(SCHEMA$);
        }

        private Builder(Builder other) {
            super((SpecificRecordBuilderBase)other);
            if (Builder.isValidValue((Schema.Field)this.fields()[0], (Object)other.time)) {
                this.time = (Double)this.data().deepCopy(this.fields()[0].schema(), (Object)other.time);
                this.fieldSetFlags()[0] = other.fieldSetFlags()[0];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[1], (Object)other.timeReceived)) {
                this.timeReceived = (Double)this.data().deepCopy(this.fields()[1].schema(), (Object)other.timeReceived);
                this.fieldSetFlags()[1] = other.fieldSetFlags()[1];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[2], (Object)Float.valueOf(other.heartRateVariability))) {
                this.heartRateVariability = ((Float)this.data().deepCopy(this.fields()[2].schema(), (Object)Float.valueOf(other.heartRateVariability))).floatValue();
                this.fieldSetFlags()[2] = other.fieldSetFlags()[2];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[3], (Object)Float.valueOf(other.heartRateVariabilityQuality))) {
                this.heartRateVariabilityQuality = ((Float)this.data().deepCopy(this.fields()[3].schema(), (Object)Float.valueOf(other.heartRateVariabilityQuality))).floatValue();
                this.fieldSetFlags()[3] = other.fieldSetFlags()[3];
            }
        }

        private Builder(BiovotionVsm1HeartRateVariability other) {
            super(SCHEMA$);
            if (Builder.isValidValue((Schema.Field)this.fields()[0], (Object)other.time)) {
                this.time = (Double)this.data().deepCopy(this.fields()[0].schema(), (Object)other.time);
                this.fieldSetFlags()[0] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[1], (Object)other.timeReceived)) {
                this.timeReceived = (Double)this.data().deepCopy(this.fields()[1].schema(), (Object)other.timeReceived);
                this.fieldSetFlags()[1] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[2], (Object)Float.valueOf(other.heartRateVariability))) {
                this.heartRateVariability = ((Float)this.data().deepCopy(this.fields()[2].schema(), (Object)Float.valueOf(other.heartRateVariability))).floatValue();
                this.fieldSetFlags()[2] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[3], (Object)Float.valueOf(other.heartRateVariabilityQuality))) {
                this.heartRateVariabilityQuality = ((Float)this.data().deepCopy(this.fields()[3].schema(), (Object)Float.valueOf(other.heartRateVariabilityQuality))).floatValue();
                this.fieldSetFlags()[3] = true;
            }
        }

        public double getTime() {
            return this.time;
        }

        public Builder setTime(double value) {
            this.validate(this.fields()[0], value);
            this.time = value;
            this.fieldSetFlags()[0] = true;
            return this;
        }

        public boolean hasTime() {
            return this.fieldSetFlags()[0];
        }

        public Builder clearTime() {
            this.fieldSetFlags()[0] = false;
            return this;
        }

        public double getTimeReceived() {
            return this.timeReceived;
        }

        public Builder setTimeReceived(double value) {
            this.validate(this.fields()[1], value);
            this.timeReceived = value;
            this.fieldSetFlags()[1] = true;
            return this;
        }

        public boolean hasTimeReceived() {
            return this.fieldSetFlags()[1];
        }

        public Builder clearTimeReceived() {
            this.fieldSetFlags()[1] = false;
            return this;
        }

        public float getHeartRateVariability() {
            return this.heartRateVariability;
        }

        public Builder setHeartRateVariability(float value) {
            this.validate(this.fields()[2], Float.valueOf(value));
            this.heartRateVariability = value;
            this.fieldSetFlags()[2] = true;
            return this;
        }

        public boolean hasHeartRateVariability() {
            return this.fieldSetFlags()[2];
        }

        public Builder clearHeartRateVariability() {
            this.fieldSetFlags()[2] = false;
            return this;
        }

        public float getHeartRateVariabilityQuality() {
            return this.heartRateVariabilityQuality;
        }

        public Builder setHeartRateVariabilityQuality(float value) {
            this.validate(this.fields()[3], Float.valueOf(value));
            this.heartRateVariabilityQuality = value;
            this.fieldSetFlags()[3] = true;
            return this;
        }

        public boolean hasHeartRateVariabilityQuality() {
            return this.fieldSetFlags()[3];
        }

        public Builder clearHeartRateVariabilityQuality() {
            this.fieldSetFlags()[3] = false;
            return this;
        }

        public BiovotionVsm1HeartRateVariability build() {
            try {
                BiovotionVsm1HeartRateVariability record = new BiovotionVsm1HeartRateVariability();
                record.time = this.fieldSetFlags()[0] ? this.time : (Double)this.defaultValue(this.fields()[0]);
                record.timeReceived = this.fieldSetFlags()[1] ? this.timeReceived : (Double)this.defaultValue(this.fields()[1]);
                record.heartRateVariability = this.fieldSetFlags()[2] ? this.heartRateVariability : ((Float)this.defaultValue(this.fields()[2])).floatValue();
                record.heartRateVariabilityQuality = this.fieldSetFlags()[3] ? this.heartRateVariabilityQuality : ((Float)this.defaultValue(this.fields()[3])).floatValue();
                return record;
            }
            catch (AvroMissingFieldException e) {
                throw e;
            }
            catch (Exception e) {
                throw new AvroRuntimeException((Throwable)e);
            }
        }
    }
}

