/*
 * Decompiled with CFR 0.152.
 */
package org.radarcns.monitor.application;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.nio.ByteBuffer;
import org.apache.avro.AvroMissingFieldException;
import org.apache.avro.AvroRuntimeException;
import org.apache.avro.Schema;
import org.apache.avro.data.RecordBuilder;
import org.apache.avro.generic.GenericData;
import org.apache.avro.io.DatumReader;
import org.apache.avro.io.DatumWriter;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.Encoder;
import org.apache.avro.io.ResolvingDecoder;
import org.apache.avro.message.BinaryMessageDecoder;
import org.apache.avro.message.BinaryMessageEncoder;
import org.apache.avro.message.SchemaStore;
import org.apache.avro.specific.AvroGenerated;
import org.apache.avro.specific.SpecificData;
import org.apache.avro.specific.SpecificRecord;
import org.apache.avro.specific.SpecificRecordBase;
import org.apache.avro.specific.SpecificRecordBuilderBase;
import org.radarcns.monitor.application.ExternalTimeProtocol;

@AvroGenerated
public class ApplicationExternalTime
extends SpecificRecordBase
implements SpecificRecord {
    private static final long serialVersionUID = 3515378028270561350L;
    public static final Schema SCHEMA$ = new Schema.Parser().parse("{\"type\":\"record\",\"name\":\"ApplicationExternalTime\",\"namespace\":\"org.radarcns.monitor.application\",\"doc\":\"Timestamp from an external source.\",\"fields\":[{\"name\":\"time\",\"type\":\"double\",\"doc\":\"Device timestamp in UTC (s).\"},{\"name\":\"externalTime\",\"type\":\"double\",\"doc\":\"Timestamp in UTC according to an external source (s).\"},{\"name\":\"host\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"doc\":\"Hostname or IP address that time was polled from.\",\"default\":null},{\"name\":\"protocol\",\"type\":{\"type\":\"enum\",\"name\":\"ExternalTimeProtocol\",\"doc\":\"SNTP (Simple Network Time Protocol) synchronizes with a single server once, NTP (Network Time Protocol) may synchronize with multiple servers and derive some continuous measures.\",\"symbols\":[\"SNTP\",\"NTP\",\"UNKNOWN\"]},\"doc\":\"Protocol for external time synchronization.\",\"default\":\"UNKNOWN\"},{\"name\":\"delay\",\"type\":[\"null\",\"double\"],\"doc\":\"Delay between sending and receiving a message from the host (s). The lower this delay, the more precise the external timestamp is expected to be.\",\"default\":null}]}");
    private static SpecificData MODEL$ = new SpecificData();
    private static final BinaryMessageEncoder<ApplicationExternalTime> ENCODER = new BinaryMessageEncoder((GenericData)MODEL$, SCHEMA$);
    private static final BinaryMessageDecoder<ApplicationExternalTime> DECODER = new BinaryMessageDecoder((GenericData)MODEL$, SCHEMA$);
    @Deprecated
    public double time;
    @Deprecated
    public double externalTime;
    @Deprecated
    public String host;
    @Deprecated
    public ExternalTimeProtocol protocol;
    @Deprecated
    public Double delay;
    private static final DatumWriter<ApplicationExternalTime> WRITER$ = MODEL$.createDatumWriter(SCHEMA$);
    private static final DatumReader<ApplicationExternalTime> READER$ = MODEL$.createDatumReader(SCHEMA$);

    public static Schema getClassSchema() {
        return SCHEMA$;
    }

    public static BinaryMessageEncoder<ApplicationExternalTime> getEncoder() {
        return ENCODER;
    }

    public static BinaryMessageDecoder<ApplicationExternalTime> getDecoder() {
        return DECODER;
    }

    public static BinaryMessageDecoder<ApplicationExternalTime> createDecoder(SchemaStore resolver) {
        return new BinaryMessageDecoder((GenericData)MODEL$, SCHEMA$, resolver);
    }

    public ByteBuffer toByteBuffer() throws IOException {
        return ENCODER.encode((Object)this);
    }

    public static ApplicationExternalTime fromByteBuffer(ByteBuffer b) throws IOException {
        return (ApplicationExternalTime)((Object)DECODER.decode(b));
    }

    public ApplicationExternalTime() {
    }

    public ApplicationExternalTime(Double time, Double externalTime, String host, ExternalTimeProtocol protocol, Double delay) {
        this.time = time;
        this.externalTime = externalTime;
        this.host = host;
        this.protocol = protocol;
        this.delay = delay;
    }

    public SpecificData getSpecificData() {
        return MODEL$;
    }

    public Schema getSchema() {
        return SCHEMA$;
    }

    public Object get(int field$) {
        switch (field$) {
            case 0: {
                return this.time;
            }
            case 1: {
                return this.externalTime;
            }
            case 2: {
                return this.host;
            }
            case 3: {
                return this.protocol;
            }
            case 4: {
                return this.delay;
            }
        }
        throw new IndexOutOfBoundsException("Invalid index: " + field$);
    }

    public void put(int field$, Object value$) {
        switch (field$) {
            case 0: {
                this.time = (Double)value$;
                break;
            }
            case 1: {
                this.externalTime = (Double)value$;
                break;
            }
            case 2: {
                this.host = value$ != null ? value$.toString() : null;
                break;
            }
            case 3: {
                this.protocol = (ExternalTimeProtocol)((Object)value$);
                break;
            }
            case 4: {
                this.delay = (Double)value$;
                break;
            }
            default: {
                throw new IndexOutOfBoundsException("Invalid index: " + field$);
            }
        }
    }

    public double getTime() {
        return this.time;
    }

    public void setTime(double value) {
        this.time = value;
    }

    public double getExternalTime() {
        return this.externalTime;
    }

    public void setExternalTime(double value) {
        this.externalTime = value;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String value) {
        this.host = value;
    }

    public ExternalTimeProtocol getProtocol() {
        return this.protocol;
    }

    public void setProtocol(ExternalTimeProtocol value) {
        this.protocol = value;
    }

    public Double getDelay() {
        return this.delay;
    }

    public void setDelay(Double value) {
        this.delay = value;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newBuilder(Builder other) {
        if (other == null) {
            return new Builder();
        }
        return new Builder(other);
    }

    public static Builder newBuilder(ApplicationExternalTime other) {
        if (other == null) {
            return new Builder();
        }
        return new Builder(other);
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        WRITER$.write((Object)this, (Encoder)SpecificData.getEncoder((ObjectOutput)out));
    }

    public void readExternal(ObjectInput in) throws IOException {
        READER$.read((Object)this, (Decoder)SpecificData.getDecoder((ObjectInput)in));
    }

    protected boolean hasCustomCoders() {
        return true;
    }

    public void customEncode(Encoder out) throws IOException {
        out.writeDouble(this.time);
        out.writeDouble(this.externalTime);
        if (this.host == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeString(this.host);
        }
        out.writeEnum(this.protocol.ordinal());
        if (this.delay == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeDouble(this.delay.doubleValue());
        }
    }

    public void customDecode(ResolvingDecoder in) throws IOException {
        Schema.Field[] fieldOrder = in.readFieldOrderIfDiff();
        if (fieldOrder == null) {
            this.time = in.readDouble();
            this.externalTime = in.readDouble();
            if (in.readIndex() != 1) {
                in.readNull();
                this.host = null;
            } else {
                this.host = in.readString();
            }
            this.protocol = ExternalTimeProtocol.values()[in.readEnum()];
            if (in.readIndex() != 1) {
                in.readNull();
                this.delay = null;
            } else {
                this.delay = in.readDouble();
            }
        } else {
            block7: for (int i = 0; i < 5; ++i) {
                switch (fieldOrder[i].pos()) {
                    case 0: {
                        this.time = in.readDouble();
                        continue block7;
                    }
                    case 1: {
                        this.externalTime = in.readDouble();
                        continue block7;
                    }
                    case 2: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.host = null;
                            continue block7;
                        }
                        this.host = in.readString();
                        continue block7;
                    }
                    case 3: {
                        this.protocol = ExternalTimeProtocol.values()[in.readEnum()];
                        continue block7;
                    }
                    case 4: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.delay = null;
                            continue block7;
                        }
                        this.delay = in.readDouble();
                        continue block7;
                    }
                    default: {
                        throw new IOException("Corrupt ResolvingDecoder.");
                    }
                }
            }
        }
    }

    @AvroGenerated
    public static class Builder
    extends SpecificRecordBuilderBase<ApplicationExternalTime>
    implements RecordBuilder<ApplicationExternalTime> {
        private double time;
        private double externalTime;
        private String host;
        private ExternalTimeProtocol protocol;
        private Double delay;

        private Builder() {
            super(SCHEMA$);
        }

        private Builder(Builder other) {
            super((SpecificRecordBuilderBase)other);
            if (Builder.isValidValue((Schema.Field)this.fields()[0], (Object)other.time)) {
                this.time = (Double)this.data().deepCopy(this.fields()[0].schema(), (Object)other.time);
                this.fieldSetFlags()[0] = other.fieldSetFlags()[0];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[1], (Object)other.externalTime)) {
                this.externalTime = (Double)this.data().deepCopy(this.fields()[1].schema(), (Object)other.externalTime);
                this.fieldSetFlags()[1] = other.fieldSetFlags()[1];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[2], (Object)other.host)) {
                this.host = (String)this.data().deepCopy(this.fields()[2].schema(), (Object)other.host);
                this.fieldSetFlags()[2] = other.fieldSetFlags()[2];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[3], (Object)((Object)other.protocol))) {
                this.protocol = (ExternalTimeProtocol)((Object)this.data().deepCopy(this.fields()[3].schema(), (Object)other.protocol));
                this.fieldSetFlags()[3] = other.fieldSetFlags()[3];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[4], (Object)other.delay)) {
                this.delay = (Double)this.data().deepCopy(this.fields()[4].schema(), (Object)other.delay);
                this.fieldSetFlags()[4] = other.fieldSetFlags()[4];
            }
        }

        private Builder(ApplicationExternalTime other) {
            super(SCHEMA$);
            if (Builder.isValidValue((Schema.Field)this.fields()[0], (Object)other.time)) {
                this.time = (Double)this.data().deepCopy(this.fields()[0].schema(), (Object)other.time);
                this.fieldSetFlags()[0] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[1], (Object)other.externalTime)) {
                this.externalTime = (Double)this.data().deepCopy(this.fields()[1].schema(), (Object)other.externalTime);
                this.fieldSetFlags()[1] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[2], (Object)other.host)) {
                this.host = (String)this.data().deepCopy(this.fields()[2].schema(), (Object)other.host);
                this.fieldSetFlags()[2] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[3], (Object)((Object)other.protocol))) {
                this.protocol = (ExternalTimeProtocol)((Object)this.data().deepCopy(this.fields()[3].schema(), (Object)other.protocol));
                this.fieldSetFlags()[3] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[4], (Object)other.delay)) {
                this.delay = (Double)this.data().deepCopy(this.fields()[4].schema(), (Object)other.delay);
                this.fieldSetFlags()[4] = true;
            }
        }

        public double getTime() {
            return this.time;
        }

        public Builder setTime(double value) {
            this.validate(this.fields()[0], value);
            this.time = value;
            this.fieldSetFlags()[0] = true;
            return this;
        }

        public boolean hasTime() {
            return this.fieldSetFlags()[0];
        }

        public Builder clearTime() {
            this.fieldSetFlags()[0] = false;
            return this;
        }

        public double getExternalTime() {
            return this.externalTime;
        }

        public Builder setExternalTime(double value) {
            this.validate(this.fields()[1], value);
            this.externalTime = value;
            this.fieldSetFlags()[1] = true;
            return this;
        }

        public boolean hasExternalTime() {
            return this.fieldSetFlags()[1];
        }

        public Builder clearExternalTime() {
            this.fieldSetFlags()[1] = false;
            return this;
        }

        public String getHost() {
            return this.host;
        }

        public Builder setHost(String value) {
            this.validate(this.fields()[2], value);
            this.host = value;
            this.fieldSetFlags()[2] = true;
            return this;
        }

        public boolean hasHost() {
            return this.fieldSetFlags()[2];
        }

        public Builder clearHost() {
            this.host = null;
            this.fieldSetFlags()[2] = false;
            return this;
        }

        public ExternalTimeProtocol getProtocol() {
            return this.protocol;
        }

        public Builder setProtocol(ExternalTimeProtocol value) {
            this.validate(this.fields()[3], (Object)value);
            this.protocol = value;
            this.fieldSetFlags()[3] = true;
            return this;
        }

        public boolean hasProtocol() {
            return this.fieldSetFlags()[3];
        }

        public Builder clearProtocol() {
            this.protocol = null;
            this.fieldSetFlags()[3] = false;
            return this;
        }

        public Double getDelay() {
            return this.delay;
        }

        public Builder setDelay(Double value) {
            this.validate(this.fields()[4], value);
            this.delay = value;
            this.fieldSetFlags()[4] = true;
            return this;
        }

        public boolean hasDelay() {
            return this.fieldSetFlags()[4];
        }

        public Builder clearDelay() {
            this.delay = null;
            this.fieldSetFlags()[4] = false;
            return this;
        }

        public ApplicationExternalTime build() {
            try {
                ApplicationExternalTime record = new ApplicationExternalTime();
                record.time = this.fieldSetFlags()[0] ? this.time : (Double)this.defaultValue(this.fields()[0]);
                record.externalTime = this.fieldSetFlags()[1] ? this.externalTime : (Double)this.defaultValue(this.fields()[1]);
                record.host = this.fieldSetFlags()[2] ? this.host : (String)this.defaultValue(this.fields()[2]);
                record.protocol = this.fieldSetFlags()[3] ? this.protocol : (ExternalTimeProtocol)((Object)this.defaultValue(this.fields()[3]));
                record.delay = this.fieldSetFlags()[4] ? this.delay : (Double)this.defaultValue(this.fields()[4]);
                return record;
            }
            catch (AvroMissingFieldException e) {
                throw e;
            }
            catch (Exception e) {
                throw new AvroRuntimeException((Throwable)e);
            }
        }
    }
}

