/*
 * Decompiled with CFR 0.152.
 */
package org.radarcns.monitor.application;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.nio.ByteBuffer;
import org.apache.avro.AvroMissingFieldException;
import org.apache.avro.AvroRuntimeException;
import org.apache.avro.Schema;
import org.apache.avro.data.RecordBuilder;
import org.apache.avro.generic.GenericData;
import org.apache.avro.io.DatumReader;
import org.apache.avro.io.DatumWriter;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.Encoder;
import org.apache.avro.io.ResolvingDecoder;
import org.apache.avro.message.BinaryMessageDecoder;
import org.apache.avro.message.BinaryMessageEncoder;
import org.apache.avro.message.SchemaStore;
import org.apache.avro.specific.AvroGenerated;
import org.apache.avro.specific.SpecificData;
import org.apache.avro.specific.SpecificRecord;
import org.apache.avro.specific.SpecificRecordBase;
import org.apache.avro.specific.SpecificRecordBuilderBase;
import org.radarcns.monitor.application.OperatingSystem;

@AvroGenerated
public class ApplicationDeviceInfo
extends SpecificRecordBase
implements SpecificRecord {
    private static final long serialVersionUID = -5072425940841487054L;
    public static final Schema SCHEMA$ = new Schema.Parser().parse("{\"type\":\"record\",\"name\":\"ApplicationDeviceInfo\",\"namespace\":\"org.radarcns.monitor.application\",\"doc\":\"Device information where the application is running.\",\"fields\":[{\"name\":\"time\",\"type\":\"double\",\"doc\":\"Device timestamp as time since the Unix Epoch (s).\"},{\"name\":\"manufacturer\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"doc\":\"Manufacturer of the device. Null if unknown.\",\"default\":null},{\"name\":\"model\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"doc\":\"Model of the device. Null if unknown.\",\"default\":null},{\"name\":\"operatingSystem\",\"type\":{\"type\":\"enum\",\"name\":\"OperatingSystem\",\"doc\":\"Operating system types.\",\"symbols\":[\"ANDROID\",\"IOS\",\"MACOS\",\"WINDOWS\",\"LINUX\",\"BSD\",\"OTHER\",\"UNKNOWN\"]},\"doc\":\"Operating system that the application is running on.\",\"default\":\"UNKNOWN\"},{\"name\":\"operatingSystemVersion\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"doc\":\"Operating system version as readable string. Null if unknown.\",\"default\":null},{\"name\":\"operatingSystemVersionCode\",\"type\":[\"null\",\"int\"],\"doc\":\"Operating system unique version number. Null if unknown.\",\"default\":null},{\"name\":\"appVersion\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"doc\":\"App version as a readable string. Null if unknown.\",\"default\":null},{\"name\":\"appVersionCode\",\"type\":[\"null\",\"int\"],\"doc\":\"Unique app version number. Null if unknown.\",\"default\":null}]}");
    private static SpecificData MODEL$ = new SpecificData();
    private static final BinaryMessageEncoder<ApplicationDeviceInfo> ENCODER = new BinaryMessageEncoder((GenericData)MODEL$, SCHEMA$);
    private static final BinaryMessageDecoder<ApplicationDeviceInfo> DECODER = new BinaryMessageDecoder((GenericData)MODEL$, SCHEMA$);
    @Deprecated
    public double time;
    @Deprecated
    public String manufacturer;
    @Deprecated
    public String model;
    @Deprecated
    public OperatingSystem operatingSystem;
    @Deprecated
    public String operatingSystemVersion;
    @Deprecated
    public Integer operatingSystemVersionCode;
    @Deprecated
    public String appVersion;
    @Deprecated
    public Integer appVersionCode;
    private static final DatumWriter<ApplicationDeviceInfo> WRITER$ = MODEL$.createDatumWriter(SCHEMA$);
    private static final DatumReader<ApplicationDeviceInfo> READER$ = MODEL$.createDatumReader(SCHEMA$);

    public static Schema getClassSchema() {
        return SCHEMA$;
    }

    public static BinaryMessageEncoder<ApplicationDeviceInfo> getEncoder() {
        return ENCODER;
    }

    public static BinaryMessageDecoder<ApplicationDeviceInfo> getDecoder() {
        return DECODER;
    }

    public static BinaryMessageDecoder<ApplicationDeviceInfo> createDecoder(SchemaStore resolver) {
        return new BinaryMessageDecoder((GenericData)MODEL$, SCHEMA$, resolver);
    }

    public ByteBuffer toByteBuffer() throws IOException {
        return ENCODER.encode((Object)this);
    }

    public static ApplicationDeviceInfo fromByteBuffer(ByteBuffer b) throws IOException {
        return (ApplicationDeviceInfo)((Object)DECODER.decode(b));
    }

    public ApplicationDeviceInfo() {
    }

    public ApplicationDeviceInfo(Double time, String manufacturer, String model, OperatingSystem operatingSystem, String operatingSystemVersion, Integer operatingSystemVersionCode, String appVersion, Integer appVersionCode) {
        this.time = time;
        this.manufacturer = manufacturer;
        this.model = model;
        this.operatingSystem = operatingSystem;
        this.operatingSystemVersion = operatingSystemVersion;
        this.operatingSystemVersionCode = operatingSystemVersionCode;
        this.appVersion = appVersion;
        this.appVersionCode = appVersionCode;
    }

    public SpecificData getSpecificData() {
        return MODEL$;
    }

    public Schema getSchema() {
        return SCHEMA$;
    }

    public Object get(int field$) {
        switch (field$) {
            case 0: {
                return this.time;
            }
            case 1: {
                return this.manufacturer;
            }
            case 2: {
                return this.model;
            }
            case 3: {
                return this.operatingSystem;
            }
            case 4: {
                return this.operatingSystemVersion;
            }
            case 5: {
                return this.operatingSystemVersionCode;
            }
            case 6: {
                return this.appVersion;
            }
            case 7: {
                return this.appVersionCode;
            }
        }
        throw new IndexOutOfBoundsException("Invalid index: " + field$);
    }

    public void put(int field$, Object value$) {
        switch (field$) {
            case 0: {
                this.time = (Double)value$;
                break;
            }
            case 1: {
                this.manufacturer = value$ != null ? value$.toString() : null;
                break;
            }
            case 2: {
                this.model = value$ != null ? value$.toString() : null;
                break;
            }
            case 3: {
                this.operatingSystem = (OperatingSystem)((Object)value$);
                break;
            }
            case 4: {
                this.operatingSystemVersion = value$ != null ? value$.toString() : null;
                break;
            }
            case 5: {
                this.operatingSystemVersionCode = (Integer)value$;
                break;
            }
            case 6: {
                this.appVersion = value$ != null ? value$.toString() : null;
                break;
            }
            case 7: {
                this.appVersionCode = (Integer)value$;
                break;
            }
            default: {
                throw new IndexOutOfBoundsException("Invalid index: " + field$);
            }
        }
    }

    public double getTime() {
        return this.time;
    }

    public void setTime(double value) {
        this.time = value;
    }

    public String getManufacturer() {
        return this.manufacturer;
    }

    public void setManufacturer(String value) {
        this.manufacturer = value;
    }

    public String getModel() {
        return this.model;
    }

    public void setModel(String value) {
        this.model = value;
    }

    public OperatingSystem getOperatingSystem() {
        return this.operatingSystem;
    }

    public void setOperatingSystem(OperatingSystem value) {
        this.operatingSystem = value;
    }

    public String getOperatingSystemVersion() {
        return this.operatingSystemVersion;
    }

    public void setOperatingSystemVersion(String value) {
        this.operatingSystemVersion = value;
    }

    public Integer getOperatingSystemVersionCode() {
        return this.operatingSystemVersionCode;
    }

    public void setOperatingSystemVersionCode(Integer value) {
        this.operatingSystemVersionCode = value;
    }

    public String getAppVersion() {
        return this.appVersion;
    }

    public void setAppVersion(String value) {
        this.appVersion = value;
    }

    public Integer getAppVersionCode() {
        return this.appVersionCode;
    }

    public void setAppVersionCode(Integer value) {
        this.appVersionCode = value;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newBuilder(Builder other) {
        if (other == null) {
            return new Builder();
        }
        return new Builder(other);
    }

    public static Builder newBuilder(ApplicationDeviceInfo other) {
        if (other == null) {
            return new Builder();
        }
        return new Builder(other);
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        WRITER$.write((Object)this, (Encoder)SpecificData.getEncoder((ObjectOutput)out));
    }

    public void readExternal(ObjectInput in) throws IOException {
        READER$.read((Object)this, (Decoder)SpecificData.getDecoder((ObjectInput)in));
    }

    protected boolean hasCustomCoders() {
        return true;
    }

    public void customEncode(Encoder out) throws IOException {
        out.writeDouble(this.time);
        if (this.manufacturer == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeString(this.manufacturer);
        }
        if (this.model == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeString(this.model);
        }
        out.writeEnum(this.operatingSystem.ordinal());
        if (this.operatingSystemVersion == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeString(this.operatingSystemVersion);
        }
        if (this.operatingSystemVersionCode == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeInt(this.operatingSystemVersionCode.intValue());
        }
        if (this.appVersion == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeString(this.appVersion);
        }
        if (this.appVersionCode == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeInt(this.appVersionCode.intValue());
        }
    }

    public void customDecode(ResolvingDecoder in) throws IOException {
        Schema.Field[] fieldOrder = in.readFieldOrderIfDiff();
        if (fieldOrder == null) {
            this.time = in.readDouble();
            if (in.readIndex() != 1) {
                in.readNull();
                this.manufacturer = null;
            } else {
                this.manufacturer = in.readString();
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.model = null;
            } else {
                this.model = in.readString();
            }
            this.operatingSystem = OperatingSystem.values()[in.readEnum()];
            if (in.readIndex() != 1) {
                in.readNull();
                this.operatingSystemVersion = null;
            } else {
                this.operatingSystemVersion = in.readString();
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.operatingSystemVersionCode = null;
            } else {
                this.operatingSystemVersionCode = in.readInt();
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.appVersion = null;
            } else {
                this.appVersion = in.readString();
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.appVersionCode = null;
            } else {
                this.appVersionCode = in.readInt();
            }
        } else {
            block10: for (int i = 0; i < 8; ++i) {
                switch (fieldOrder[i].pos()) {
                    case 0: {
                        this.time = in.readDouble();
                        continue block10;
                    }
                    case 1: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.manufacturer = null;
                            continue block10;
                        }
                        this.manufacturer = in.readString();
                        continue block10;
                    }
                    case 2: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.model = null;
                            continue block10;
                        }
                        this.model = in.readString();
                        continue block10;
                    }
                    case 3: {
                        this.operatingSystem = OperatingSystem.values()[in.readEnum()];
                        continue block10;
                    }
                    case 4: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.operatingSystemVersion = null;
                            continue block10;
                        }
                        this.operatingSystemVersion = in.readString();
                        continue block10;
                    }
                    case 5: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.operatingSystemVersionCode = null;
                            continue block10;
                        }
                        this.operatingSystemVersionCode = in.readInt();
                        continue block10;
                    }
                    case 6: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.appVersion = null;
                            continue block10;
                        }
                        this.appVersion = in.readString();
                        continue block10;
                    }
                    case 7: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.appVersionCode = null;
                            continue block10;
                        }
                        this.appVersionCode = in.readInt();
                        continue block10;
                    }
                    default: {
                        throw new IOException("Corrupt ResolvingDecoder.");
                    }
                }
            }
        }
    }

    @AvroGenerated
    public static class Builder
    extends SpecificRecordBuilderBase<ApplicationDeviceInfo>
    implements RecordBuilder<ApplicationDeviceInfo> {
        private double time;
        private String manufacturer;
        private String model;
        private OperatingSystem operatingSystem;
        private String operatingSystemVersion;
        private Integer operatingSystemVersionCode;
        private String appVersion;
        private Integer appVersionCode;

        private Builder() {
            super(SCHEMA$);
        }

        private Builder(Builder other) {
            super((SpecificRecordBuilderBase)other);
            if (Builder.isValidValue((Schema.Field)this.fields()[0], (Object)other.time)) {
                this.time = (Double)this.data().deepCopy(this.fields()[0].schema(), (Object)other.time);
                this.fieldSetFlags()[0] = other.fieldSetFlags()[0];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[1], (Object)other.manufacturer)) {
                this.manufacturer = (String)this.data().deepCopy(this.fields()[1].schema(), (Object)other.manufacturer);
                this.fieldSetFlags()[1] = other.fieldSetFlags()[1];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[2], (Object)other.model)) {
                this.model = (String)this.data().deepCopy(this.fields()[2].schema(), (Object)other.model);
                this.fieldSetFlags()[2] = other.fieldSetFlags()[2];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[3], (Object)((Object)other.operatingSystem))) {
                this.operatingSystem = (OperatingSystem)((Object)this.data().deepCopy(this.fields()[3].schema(), (Object)other.operatingSystem));
                this.fieldSetFlags()[3] = other.fieldSetFlags()[3];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[4], (Object)other.operatingSystemVersion)) {
                this.operatingSystemVersion = (String)this.data().deepCopy(this.fields()[4].schema(), (Object)other.operatingSystemVersion);
                this.fieldSetFlags()[4] = other.fieldSetFlags()[4];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[5], (Object)other.operatingSystemVersionCode)) {
                this.operatingSystemVersionCode = (Integer)this.data().deepCopy(this.fields()[5].schema(), (Object)other.operatingSystemVersionCode);
                this.fieldSetFlags()[5] = other.fieldSetFlags()[5];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[6], (Object)other.appVersion)) {
                this.appVersion = (String)this.data().deepCopy(this.fields()[6].schema(), (Object)other.appVersion);
                this.fieldSetFlags()[6] = other.fieldSetFlags()[6];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[7], (Object)other.appVersionCode)) {
                this.appVersionCode = (Integer)this.data().deepCopy(this.fields()[7].schema(), (Object)other.appVersionCode);
                this.fieldSetFlags()[7] = other.fieldSetFlags()[7];
            }
        }

        private Builder(ApplicationDeviceInfo other) {
            super(SCHEMA$);
            if (Builder.isValidValue((Schema.Field)this.fields()[0], (Object)other.time)) {
                this.time = (Double)this.data().deepCopy(this.fields()[0].schema(), (Object)other.time);
                this.fieldSetFlags()[0] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[1], (Object)other.manufacturer)) {
                this.manufacturer = (String)this.data().deepCopy(this.fields()[1].schema(), (Object)other.manufacturer);
                this.fieldSetFlags()[1] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[2], (Object)other.model)) {
                this.model = (String)this.data().deepCopy(this.fields()[2].schema(), (Object)other.model);
                this.fieldSetFlags()[2] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[3], (Object)((Object)other.operatingSystem))) {
                this.operatingSystem = (OperatingSystem)((Object)this.data().deepCopy(this.fields()[3].schema(), (Object)other.operatingSystem));
                this.fieldSetFlags()[3] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[4], (Object)other.operatingSystemVersion)) {
                this.operatingSystemVersion = (String)this.data().deepCopy(this.fields()[4].schema(), (Object)other.operatingSystemVersion);
                this.fieldSetFlags()[4] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[5], (Object)other.operatingSystemVersionCode)) {
                this.operatingSystemVersionCode = (Integer)this.data().deepCopy(this.fields()[5].schema(), (Object)other.operatingSystemVersionCode);
                this.fieldSetFlags()[5] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[6], (Object)other.appVersion)) {
                this.appVersion = (String)this.data().deepCopy(this.fields()[6].schema(), (Object)other.appVersion);
                this.fieldSetFlags()[6] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[7], (Object)other.appVersionCode)) {
                this.appVersionCode = (Integer)this.data().deepCopy(this.fields()[7].schema(), (Object)other.appVersionCode);
                this.fieldSetFlags()[7] = true;
            }
        }

        public double getTime() {
            return this.time;
        }

        public Builder setTime(double value) {
            this.validate(this.fields()[0], value);
            this.time = value;
            this.fieldSetFlags()[0] = true;
            return this;
        }

        public boolean hasTime() {
            return this.fieldSetFlags()[0];
        }

        public Builder clearTime() {
            this.fieldSetFlags()[0] = false;
            return this;
        }

        public String getManufacturer() {
            return this.manufacturer;
        }

        public Builder setManufacturer(String value) {
            this.validate(this.fields()[1], value);
            this.manufacturer = value;
            this.fieldSetFlags()[1] = true;
            return this;
        }

        public boolean hasManufacturer() {
            return this.fieldSetFlags()[1];
        }

        public Builder clearManufacturer() {
            this.manufacturer = null;
            this.fieldSetFlags()[1] = false;
            return this;
        }

        public String getModel() {
            return this.model;
        }

        public Builder setModel(String value) {
            this.validate(this.fields()[2], value);
            this.model = value;
            this.fieldSetFlags()[2] = true;
            return this;
        }

        public boolean hasModel() {
            return this.fieldSetFlags()[2];
        }

        public Builder clearModel() {
            this.model = null;
            this.fieldSetFlags()[2] = false;
            return this;
        }

        public OperatingSystem getOperatingSystem() {
            return this.operatingSystem;
        }

        public Builder setOperatingSystem(OperatingSystem value) {
            this.validate(this.fields()[3], (Object)value);
            this.operatingSystem = value;
            this.fieldSetFlags()[3] = true;
            return this;
        }

        public boolean hasOperatingSystem() {
            return this.fieldSetFlags()[3];
        }

        public Builder clearOperatingSystem() {
            this.operatingSystem = null;
            this.fieldSetFlags()[3] = false;
            return this;
        }

        public String getOperatingSystemVersion() {
            return this.operatingSystemVersion;
        }

        public Builder setOperatingSystemVersion(String value) {
            this.validate(this.fields()[4], value);
            this.operatingSystemVersion = value;
            this.fieldSetFlags()[4] = true;
            return this;
        }

        public boolean hasOperatingSystemVersion() {
            return this.fieldSetFlags()[4];
        }

        public Builder clearOperatingSystemVersion() {
            this.operatingSystemVersion = null;
            this.fieldSetFlags()[4] = false;
            return this;
        }

        public Integer getOperatingSystemVersionCode() {
            return this.operatingSystemVersionCode;
        }

        public Builder setOperatingSystemVersionCode(Integer value) {
            this.validate(this.fields()[5], value);
            this.operatingSystemVersionCode = value;
            this.fieldSetFlags()[5] = true;
            return this;
        }

        public boolean hasOperatingSystemVersionCode() {
            return this.fieldSetFlags()[5];
        }

        public Builder clearOperatingSystemVersionCode() {
            this.operatingSystemVersionCode = null;
            this.fieldSetFlags()[5] = false;
            return this;
        }

        public String getAppVersion() {
            return this.appVersion;
        }

        public Builder setAppVersion(String value) {
            this.validate(this.fields()[6], value);
            this.appVersion = value;
            this.fieldSetFlags()[6] = true;
            return this;
        }

        public boolean hasAppVersion() {
            return this.fieldSetFlags()[6];
        }

        public Builder clearAppVersion() {
            this.appVersion = null;
            this.fieldSetFlags()[6] = false;
            return this;
        }

        public Integer getAppVersionCode() {
            return this.appVersionCode;
        }

        public Builder setAppVersionCode(Integer value) {
            this.validate(this.fields()[7], value);
            this.appVersionCode = value;
            this.fieldSetFlags()[7] = true;
            return this;
        }

        public boolean hasAppVersionCode() {
            return this.fieldSetFlags()[7];
        }

        public Builder clearAppVersionCode() {
            this.appVersionCode = null;
            this.fieldSetFlags()[7] = false;
            return this;
        }

        public ApplicationDeviceInfo build() {
            try {
                ApplicationDeviceInfo record = new ApplicationDeviceInfo();
                record.time = this.fieldSetFlags()[0] ? this.time : (Double)this.defaultValue(this.fields()[0]);
                record.manufacturer = this.fieldSetFlags()[1] ? this.manufacturer : (String)this.defaultValue(this.fields()[1]);
                record.model = this.fieldSetFlags()[2] ? this.model : (String)this.defaultValue(this.fields()[2]);
                record.operatingSystem = this.fieldSetFlags()[3] ? this.operatingSystem : (OperatingSystem)((Object)this.defaultValue(this.fields()[3]));
                record.operatingSystemVersion = this.fieldSetFlags()[4] ? this.operatingSystemVersion : (String)this.defaultValue(this.fields()[4]);
                record.operatingSystemVersionCode = this.fieldSetFlags()[5] ? this.operatingSystemVersionCode : (Integer)this.defaultValue(this.fields()[5]);
                record.appVersion = this.fieldSetFlags()[6] ? this.appVersion : (String)this.defaultValue(this.fields()[6]);
                record.appVersionCode = this.fieldSetFlags()[7] ? this.appVersionCode : (Integer)this.defaultValue(this.fields()[7]);
                return record;
            }
            catch (AvroMissingFieldException e) {
                throw e;
            }
            catch (Exception e) {
                throw new AvroRuntimeException((Throwable)e);
            }
        }
    }
}

