/*
 * Decompiled with CFR 0.152.
 */
package org.radarcns.connector.upload.axivity;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.nio.ByteBuffer;
import org.apache.avro.AvroMissingFieldException;
import org.apache.avro.AvroRuntimeException;
import org.apache.avro.Schema;
import org.apache.avro.data.RecordBuilder;
import org.apache.avro.generic.GenericData;
import org.apache.avro.io.DatumReader;
import org.apache.avro.io.DatumWriter;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.Encoder;
import org.apache.avro.io.ResolvingDecoder;
import org.apache.avro.message.BinaryMessageDecoder;
import org.apache.avro.message.BinaryMessageEncoder;
import org.apache.avro.message.SchemaStore;
import org.apache.avro.specific.AvroGenerated;
import org.apache.avro.specific.SpecificData;
import org.apache.avro.specific.SpecificRecord;
import org.apache.avro.specific.SpecificRecordBase;
import org.apache.avro.specific.SpecificRecordBuilderBase;
import org.radarcns.connector.upload.axivity.AxivityEventType;

@AvroGenerated
public class AxivityEvent
extends SpecificRecordBase
implements SpecificRecord {
    private static final long serialVersionUID = 1627779862449043808L;
    public static final Schema SCHEMA$ = new Schema.Parser().parse("{\"type\":\"record\",\"name\":\"AxivityEvent\",\"namespace\":\"org.radarcns.connector.upload.axivity\",\"doc\":\"Event data available in a CWA block.\",\"fields\":[{\"name\":\"time\",\"type\":\"double\",\"doc\":\"Timestamp in unix time acquired locally from the device.\"},{\"name\":\"timeReceived\",\"type\":\"double\",\"doc\":\"Timestamp in unix time received from upload.\"},{\"name\":\"event\",\"type\":{\"type\":\"enum\",\"name\":\"AxivityEventType\",\"doc\":\"Event types recorded from the axivity device.\",\"symbols\":[\"RESUME\",\"SINGLE_TAP\",\"DOUBLE_TAP\",\"FIFO_OVERFLOW\",\"BUFFER_OVERFLOW\",\"UNHANDLED_INTERRUPT\",\"UNKNOWN\"]},\"doc\":\"Event of the block.\",\"default\":\"UNKNOWN\"}]}");
    private static SpecificData MODEL$ = new SpecificData();
    private static final BinaryMessageEncoder<AxivityEvent> ENCODER = new BinaryMessageEncoder((GenericData)MODEL$, SCHEMA$);
    private static final BinaryMessageDecoder<AxivityEvent> DECODER = new BinaryMessageDecoder((GenericData)MODEL$, SCHEMA$);
    @Deprecated
    public double time;
    @Deprecated
    public double timeReceived;
    @Deprecated
    public AxivityEventType event;
    private static final DatumWriter<AxivityEvent> WRITER$ = MODEL$.createDatumWriter(SCHEMA$);
    private static final DatumReader<AxivityEvent> READER$ = MODEL$.createDatumReader(SCHEMA$);

    public static Schema getClassSchema() {
        return SCHEMA$;
    }

    public static BinaryMessageEncoder<AxivityEvent> getEncoder() {
        return ENCODER;
    }

    public static BinaryMessageDecoder<AxivityEvent> getDecoder() {
        return DECODER;
    }

    public static BinaryMessageDecoder<AxivityEvent> createDecoder(SchemaStore resolver) {
        return new BinaryMessageDecoder((GenericData)MODEL$, SCHEMA$, resolver);
    }

    public ByteBuffer toByteBuffer() throws IOException {
        return ENCODER.encode((Object)this);
    }

    public static AxivityEvent fromByteBuffer(ByteBuffer b) throws IOException {
        return (AxivityEvent)((Object)DECODER.decode(b));
    }

    public AxivityEvent() {
    }

    public AxivityEvent(Double time, Double timeReceived, AxivityEventType event) {
        this.time = time;
        this.timeReceived = timeReceived;
        this.event = event;
    }

    public SpecificData getSpecificData() {
        return MODEL$;
    }

    public Schema getSchema() {
        return SCHEMA$;
    }

    public Object get(int field$) {
        switch (field$) {
            case 0: {
                return this.time;
            }
            case 1: {
                return this.timeReceived;
            }
            case 2: {
                return this.event;
            }
        }
        throw new IndexOutOfBoundsException("Invalid index: " + field$);
    }

    public void put(int field$, Object value$) {
        switch (field$) {
            case 0: {
                this.time = (Double)value$;
                break;
            }
            case 1: {
                this.timeReceived = (Double)value$;
                break;
            }
            case 2: {
                this.event = (AxivityEventType)((Object)value$);
                break;
            }
            default: {
                throw new IndexOutOfBoundsException("Invalid index: " + field$);
            }
        }
    }

    public double getTime() {
        return this.time;
    }

    public void setTime(double value) {
        this.time = value;
    }

    public double getTimeReceived() {
        return this.timeReceived;
    }

    public void setTimeReceived(double value) {
        this.timeReceived = value;
    }

    public AxivityEventType getEvent() {
        return this.event;
    }

    public void setEvent(AxivityEventType value) {
        this.event = value;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newBuilder(Builder other) {
        if (other == null) {
            return new Builder();
        }
        return new Builder(other);
    }

    public static Builder newBuilder(AxivityEvent other) {
        if (other == null) {
            return new Builder();
        }
        return new Builder(other);
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        WRITER$.write((Object)this, (Encoder)SpecificData.getEncoder((ObjectOutput)out));
    }

    public void readExternal(ObjectInput in) throws IOException {
        READER$.read((Object)this, (Decoder)SpecificData.getDecoder((ObjectInput)in));
    }

    protected boolean hasCustomCoders() {
        return true;
    }

    public void customEncode(Encoder out) throws IOException {
        out.writeDouble(this.time);
        out.writeDouble(this.timeReceived);
        out.writeEnum(this.event.ordinal());
    }

    public void customDecode(ResolvingDecoder in) throws IOException {
        Schema.Field[] fieldOrder = in.readFieldOrderIfDiff();
        if (fieldOrder == null) {
            this.time = in.readDouble();
            this.timeReceived = in.readDouble();
            this.event = AxivityEventType.values()[in.readEnum()];
        } else {
            block5: for (int i = 0; i < 3; ++i) {
                switch (fieldOrder[i].pos()) {
                    case 0: {
                        this.time = in.readDouble();
                        continue block5;
                    }
                    case 1: {
                        this.timeReceived = in.readDouble();
                        continue block5;
                    }
                    case 2: {
                        this.event = AxivityEventType.values()[in.readEnum()];
                        continue block5;
                    }
                    default: {
                        throw new IOException("Corrupt ResolvingDecoder.");
                    }
                }
            }
        }
    }

    @AvroGenerated
    public static class Builder
    extends SpecificRecordBuilderBase<AxivityEvent>
    implements RecordBuilder<AxivityEvent> {
        private double time;
        private double timeReceived;
        private AxivityEventType event;

        private Builder() {
            super(SCHEMA$);
        }

        private Builder(Builder other) {
            super((SpecificRecordBuilderBase)other);
            if (Builder.isValidValue((Schema.Field)this.fields()[0], (Object)other.time)) {
                this.time = (Double)this.data().deepCopy(this.fields()[0].schema(), (Object)other.time);
                this.fieldSetFlags()[0] = other.fieldSetFlags()[0];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[1], (Object)other.timeReceived)) {
                this.timeReceived = (Double)this.data().deepCopy(this.fields()[1].schema(), (Object)other.timeReceived);
                this.fieldSetFlags()[1] = other.fieldSetFlags()[1];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[2], (Object)((Object)other.event))) {
                this.event = (AxivityEventType)((Object)this.data().deepCopy(this.fields()[2].schema(), (Object)other.event));
                this.fieldSetFlags()[2] = other.fieldSetFlags()[2];
            }
        }

        private Builder(AxivityEvent other) {
            super(SCHEMA$);
            if (Builder.isValidValue((Schema.Field)this.fields()[0], (Object)other.time)) {
                this.time = (Double)this.data().deepCopy(this.fields()[0].schema(), (Object)other.time);
                this.fieldSetFlags()[0] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[1], (Object)other.timeReceived)) {
                this.timeReceived = (Double)this.data().deepCopy(this.fields()[1].schema(), (Object)other.timeReceived);
                this.fieldSetFlags()[1] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[2], (Object)((Object)other.event))) {
                this.event = (AxivityEventType)((Object)this.data().deepCopy(this.fields()[2].schema(), (Object)other.event));
                this.fieldSetFlags()[2] = true;
            }
        }

        public double getTime() {
            return this.time;
        }

        public Builder setTime(double value) {
            this.validate(this.fields()[0], value);
            this.time = value;
            this.fieldSetFlags()[0] = true;
            return this;
        }

        public boolean hasTime() {
            return this.fieldSetFlags()[0];
        }

        public Builder clearTime() {
            this.fieldSetFlags()[0] = false;
            return this;
        }

        public double getTimeReceived() {
            return this.timeReceived;
        }

        public Builder setTimeReceived(double value) {
            this.validate(this.fields()[1], value);
            this.timeReceived = value;
            this.fieldSetFlags()[1] = true;
            return this;
        }

        public boolean hasTimeReceived() {
            return this.fieldSetFlags()[1];
        }

        public Builder clearTimeReceived() {
            this.fieldSetFlags()[1] = false;
            return this;
        }

        public AxivityEventType getEvent() {
            return this.event;
        }

        public Builder setEvent(AxivityEventType value) {
            this.validate(this.fields()[2], (Object)value);
            this.event = value;
            this.fieldSetFlags()[2] = true;
            return this;
        }

        public boolean hasEvent() {
            return this.fieldSetFlags()[2];
        }

        public Builder clearEvent() {
            this.event = null;
            this.fieldSetFlags()[2] = false;
            return this;
        }

        public AxivityEvent build() {
            try {
                AxivityEvent record = new AxivityEvent();
                record.time = this.fieldSetFlags()[0] ? this.time : (Double)this.defaultValue(this.fields()[0]);
                record.timeReceived = this.fieldSetFlags()[1] ? this.timeReceived : (Double)this.defaultValue(this.fields()[1]);
                record.event = this.fieldSetFlags()[2] ? this.event : (AxivityEventType)((Object)this.defaultValue(this.fields()[2]));
                return record;
            }
            catch (AvroMissingFieldException e) {
                throw e;
            }
            catch (Exception e) {
                throw new AvroRuntimeException((Throwable)e);
            }
        }
    }
}

