/*
 * Decompiled with CFR 0.152.
 */
package org.radarcns.connector.upload.altoida;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.nio.ByteBuffer;
import org.apache.avro.AvroMissingFieldException;
import org.apache.avro.AvroRuntimeException;
import org.apache.avro.Schema;
import org.apache.avro.data.RecordBuilder;
import org.apache.avro.generic.GenericData;
import org.apache.avro.io.DatumReader;
import org.apache.avro.io.DatumWriter;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.Encoder;
import org.apache.avro.io.ResolvingDecoder;
import org.apache.avro.message.BinaryMessageDecoder;
import org.apache.avro.message.BinaryMessageEncoder;
import org.apache.avro.message.SchemaStore;
import org.apache.avro.specific.AvroGenerated;
import org.apache.avro.specific.SpecificData;
import org.apache.avro.specific.SpecificRecord;
import org.apache.avro.specific.SpecificRecordBase;
import org.apache.avro.specific.SpecificRecordBuilderBase;
import org.radarcns.connector.upload.altoida.Classification;
import org.radarcns.connector.upload.altoida.GenderType;

@AvroGenerated
public class AltoidaSummary
extends SpecificRecordBase
implements SpecificRecord {
    private static final long serialVersionUID = 5932388137052578103L;
    public static final Schema SCHEMA$ = new Schema.Parser().parse("{\"type\":\"record\",\"name\":\"AltoidaSummary\",\"namespace\":\"org.radarcns.connector.upload.altoida\",\"doc\":\"Summary and aggregates of a full test with Altoida. Original file is named as export.csv.\",\"fields\":[{\"name\":\"time\",\"type\":\"double\",\"doc\":\"Timestamp in unix time acquired locally from the device.\"},{\"name\":\"timeReceived\",\"type\":\"double\",\"doc\":\"Timestamp in unix time received from Altoida API.\"},{\"name\":\"label\",\"type\":{\"type\":\"string\",\"avro.java.string\":\"String\"},\"doc\":\"Label name of session as entered in the app.\"},{\"name\":\"age\",\"type\":\"int\",\"doc\":\"Age of the participant in years.\"},{\"name\":\"yearsOfEducation\",\"type\":\"int\",\"doc\":\"Years of education in years.\"},{\"name\":\"gender\",\"type\":{\"type\":\"enum\",\"name\":\"GenderType\",\"doc\":\"Gender types provided by Altoida.\",\"symbols\":[\"MALE\",\"FEMALE\",\"OTHER\",\"UNKNOWN\"]},\"doc\":\"Gender of the participant.\",\"default\":\"UNKNOWN\"},{\"name\":\"classification\",\"type\":[\"null\",{\"type\":\"enum\",\"name\":\"Classification\",\"doc\":\"Classifications provided by Altoida.\",\"symbols\":[\"HEALTHY\",\"AT_RISK\",\"MCI_DUE_TO_AD\"]}],\"doc\":\"Classification based on the analysis  0=healthy, 1=at risk, 2=MCI due to AD.\",\"default\":null},{\"name\":\"nmi\",\"type\":\"double\",\"doc\":\"NMI value of the test,a value in 0-100, where 0-33.3 is class 2, 33.3-66.6 is class 1, 66.6-100 is class 0.\"}]}");
    private static SpecificData MODEL$ = new SpecificData();
    private static final BinaryMessageEncoder<AltoidaSummary> ENCODER = new BinaryMessageEncoder((GenericData)MODEL$, SCHEMA$);
    private static final BinaryMessageDecoder<AltoidaSummary> DECODER = new BinaryMessageDecoder((GenericData)MODEL$, SCHEMA$);
    @Deprecated
    public double time;
    @Deprecated
    public double timeReceived;
    @Deprecated
    public String label;
    @Deprecated
    public int age;
    @Deprecated
    public int yearsOfEducation;
    @Deprecated
    public GenderType gender;
    @Deprecated
    public Classification classification;
    @Deprecated
    public double nmi;
    private static final DatumWriter<AltoidaSummary> WRITER$ = MODEL$.createDatumWriter(SCHEMA$);
    private static final DatumReader<AltoidaSummary> READER$ = MODEL$.createDatumReader(SCHEMA$);

    public static Schema getClassSchema() {
        return SCHEMA$;
    }

    public static BinaryMessageEncoder<AltoidaSummary> getEncoder() {
        return ENCODER;
    }

    public static BinaryMessageDecoder<AltoidaSummary> getDecoder() {
        return DECODER;
    }

    public static BinaryMessageDecoder<AltoidaSummary> createDecoder(SchemaStore resolver) {
        return new BinaryMessageDecoder((GenericData)MODEL$, SCHEMA$, resolver);
    }

    public ByteBuffer toByteBuffer() throws IOException {
        return ENCODER.encode((Object)this);
    }

    public static AltoidaSummary fromByteBuffer(ByteBuffer b) throws IOException {
        return (AltoidaSummary)((Object)DECODER.decode(b));
    }

    public AltoidaSummary() {
    }

    public AltoidaSummary(Double time, Double timeReceived, String label, Integer age, Integer yearsOfEducation, GenderType gender, Classification classification, Double nmi) {
        this.time = time;
        this.timeReceived = timeReceived;
        this.label = label;
        this.age = age;
        this.yearsOfEducation = yearsOfEducation;
        this.gender = gender;
        this.classification = classification;
        this.nmi = nmi;
    }

    public SpecificData getSpecificData() {
        return MODEL$;
    }

    public Schema getSchema() {
        return SCHEMA$;
    }

    public Object get(int field$) {
        switch (field$) {
            case 0: {
                return this.time;
            }
            case 1: {
                return this.timeReceived;
            }
            case 2: {
                return this.label;
            }
            case 3: {
                return this.age;
            }
            case 4: {
                return this.yearsOfEducation;
            }
            case 5: {
                return this.gender;
            }
            case 6: {
                return this.classification;
            }
            case 7: {
                return this.nmi;
            }
        }
        throw new IndexOutOfBoundsException("Invalid index: " + field$);
    }

    public void put(int field$, Object value$) {
        switch (field$) {
            case 0: {
                this.time = (Double)value$;
                break;
            }
            case 1: {
                this.timeReceived = (Double)value$;
                break;
            }
            case 2: {
                this.label = value$ != null ? value$.toString() : null;
                break;
            }
            case 3: {
                this.age = (Integer)value$;
                break;
            }
            case 4: {
                this.yearsOfEducation = (Integer)value$;
                break;
            }
            case 5: {
                this.gender = (GenderType)((Object)value$);
                break;
            }
            case 6: {
                this.classification = (Classification)((Object)value$);
                break;
            }
            case 7: {
                this.nmi = (Double)value$;
                break;
            }
            default: {
                throw new IndexOutOfBoundsException("Invalid index: " + field$);
            }
        }
    }

    public double getTime() {
        return this.time;
    }

    public void setTime(double value) {
        this.time = value;
    }

    public double getTimeReceived() {
        return this.timeReceived;
    }

    public void setTimeReceived(double value) {
        this.timeReceived = value;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String value) {
        this.label = value;
    }

    public int getAge() {
        return this.age;
    }

    public void setAge(int value) {
        this.age = value;
    }

    public int getYearsOfEducation() {
        return this.yearsOfEducation;
    }

    public void setYearsOfEducation(int value) {
        this.yearsOfEducation = value;
    }

    public GenderType getGender() {
        return this.gender;
    }

    public void setGender(GenderType value) {
        this.gender = value;
    }

    public Classification getClassification() {
        return this.classification;
    }

    public void setClassification(Classification value) {
        this.classification = value;
    }

    public double getNmi() {
        return this.nmi;
    }

    public void setNmi(double value) {
        this.nmi = value;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newBuilder(Builder other) {
        if (other == null) {
            return new Builder();
        }
        return new Builder(other);
    }

    public static Builder newBuilder(AltoidaSummary other) {
        if (other == null) {
            return new Builder();
        }
        return new Builder(other);
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        WRITER$.write((Object)this, (Encoder)SpecificData.getEncoder((ObjectOutput)out));
    }

    public void readExternal(ObjectInput in) throws IOException {
        READER$.read((Object)this, (Decoder)SpecificData.getDecoder((ObjectInput)in));
    }

    protected boolean hasCustomCoders() {
        return true;
    }

    public void customEncode(Encoder out) throws IOException {
        out.writeDouble(this.time);
        out.writeDouble(this.timeReceived);
        out.writeString(this.label);
        out.writeInt(this.age);
        out.writeInt(this.yearsOfEducation);
        out.writeEnum(this.gender.ordinal());
        if (this.classification == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeEnum(this.classification.ordinal());
        }
        out.writeDouble(this.nmi);
    }

    public void customDecode(ResolvingDecoder in) throws IOException {
        Schema.Field[] fieldOrder = in.readFieldOrderIfDiff();
        if (fieldOrder == null) {
            this.time = in.readDouble();
            this.timeReceived = in.readDouble();
            this.label = in.readString();
            this.age = in.readInt();
            this.yearsOfEducation = in.readInt();
            this.gender = GenderType.values()[in.readEnum()];
            if (in.readIndex() != 1) {
                in.readNull();
                this.classification = null;
            } else {
                this.classification = Classification.values()[in.readEnum()];
            }
            this.nmi = in.readDouble();
        } else {
            block10: for (int i = 0; i < 8; ++i) {
                switch (fieldOrder[i].pos()) {
                    case 0: {
                        this.time = in.readDouble();
                        continue block10;
                    }
                    case 1: {
                        this.timeReceived = in.readDouble();
                        continue block10;
                    }
                    case 2: {
                        this.label = in.readString();
                        continue block10;
                    }
                    case 3: {
                        this.age = in.readInt();
                        continue block10;
                    }
                    case 4: {
                        this.yearsOfEducation = in.readInt();
                        continue block10;
                    }
                    case 5: {
                        this.gender = GenderType.values()[in.readEnum()];
                        continue block10;
                    }
                    case 6: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.classification = null;
                            continue block10;
                        }
                        this.classification = Classification.values()[in.readEnum()];
                        continue block10;
                    }
                    case 7: {
                        this.nmi = in.readDouble();
                        continue block10;
                    }
                    default: {
                        throw new IOException("Corrupt ResolvingDecoder.");
                    }
                }
            }
        }
    }

    @AvroGenerated
    public static class Builder
    extends SpecificRecordBuilderBase<AltoidaSummary>
    implements RecordBuilder<AltoidaSummary> {
        private double time;
        private double timeReceived;
        private String label;
        private int age;
        private int yearsOfEducation;
        private GenderType gender;
        private Classification classification;
        private double nmi;

        private Builder() {
            super(SCHEMA$);
        }

        private Builder(Builder other) {
            super((SpecificRecordBuilderBase)other);
            if (Builder.isValidValue((Schema.Field)this.fields()[0], (Object)other.time)) {
                this.time = (Double)this.data().deepCopy(this.fields()[0].schema(), (Object)other.time);
                this.fieldSetFlags()[0] = other.fieldSetFlags()[0];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[1], (Object)other.timeReceived)) {
                this.timeReceived = (Double)this.data().deepCopy(this.fields()[1].schema(), (Object)other.timeReceived);
                this.fieldSetFlags()[1] = other.fieldSetFlags()[1];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[2], (Object)other.label)) {
                this.label = (String)this.data().deepCopy(this.fields()[2].schema(), (Object)other.label);
                this.fieldSetFlags()[2] = other.fieldSetFlags()[2];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[3], (Object)other.age)) {
                this.age = (Integer)this.data().deepCopy(this.fields()[3].schema(), (Object)other.age);
                this.fieldSetFlags()[3] = other.fieldSetFlags()[3];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[4], (Object)other.yearsOfEducation)) {
                this.yearsOfEducation = (Integer)this.data().deepCopy(this.fields()[4].schema(), (Object)other.yearsOfEducation);
                this.fieldSetFlags()[4] = other.fieldSetFlags()[4];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[5], (Object)((Object)other.gender))) {
                this.gender = (GenderType)((Object)this.data().deepCopy(this.fields()[5].schema(), (Object)other.gender));
                this.fieldSetFlags()[5] = other.fieldSetFlags()[5];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[6], (Object)((Object)other.classification))) {
                this.classification = (Classification)((Object)this.data().deepCopy(this.fields()[6].schema(), (Object)other.classification));
                this.fieldSetFlags()[6] = other.fieldSetFlags()[6];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[7], (Object)other.nmi)) {
                this.nmi = (Double)this.data().deepCopy(this.fields()[7].schema(), (Object)other.nmi);
                this.fieldSetFlags()[7] = other.fieldSetFlags()[7];
            }
        }

        private Builder(AltoidaSummary other) {
            super(SCHEMA$);
            if (Builder.isValidValue((Schema.Field)this.fields()[0], (Object)other.time)) {
                this.time = (Double)this.data().deepCopy(this.fields()[0].schema(), (Object)other.time);
                this.fieldSetFlags()[0] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[1], (Object)other.timeReceived)) {
                this.timeReceived = (Double)this.data().deepCopy(this.fields()[1].schema(), (Object)other.timeReceived);
                this.fieldSetFlags()[1] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[2], (Object)other.label)) {
                this.label = (String)this.data().deepCopy(this.fields()[2].schema(), (Object)other.label);
                this.fieldSetFlags()[2] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[3], (Object)other.age)) {
                this.age = (Integer)this.data().deepCopy(this.fields()[3].schema(), (Object)other.age);
                this.fieldSetFlags()[3] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[4], (Object)other.yearsOfEducation)) {
                this.yearsOfEducation = (Integer)this.data().deepCopy(this.fields()[4].schema(), (Object)other.yearsOfEducation);
                this.fieldSetFlags()[4] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[5], (Object)((Object)other.gender))) {
                this.gender = (GenderType)((Object)this.data().deepCopy(this.fields()[5].schema(), (Object)other.gender));
                this.fieldSetFlags()[5] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[6], (Object)((Object)other.classification))) {
                this.classification = (Classification)((Object)this.data().deepCopy(this.fields()[6].schema(), (Object)other.classification));
                this.fieldSetFlags()[6] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[7], (Object)other.nmi)) {
                this.nmi = (Double)this.data().deepCopy(this.fields()[7].schema(), (Object)other.nmi);
                this.fieldSetFlags()[7] = true;
            }
        }

        public double getTime() {
            return this.time;
        }

        public Builder setTime(double value) {
            this.validate(this.fields()[0], value);
            this.time = value;
            this.fieldSetFlags()[0] = true;
            return this;
        }

        public boolean hasTime() {
            return this.fieldSetFlags()[0];
        }

        public Builder clearTime() {
            this.fieldSetFlags()[0] = false;
            return this;
        }

        public double getTimeReceived() {
            return this.timeReceived;
        }

        public Builder setTimeReceived(double value) {
            this.validate(this.fields()[1], value);
            this.timeReceived = value;
            this.fieldSetFlags()[1] = true;
            return this;
        }

        public boolean hasTimeReceived() {
            return this.fieldSetFlags()[1];
        }

        public Builder clearTimeReceived() {
            this.fieldSetFlags()[1] = false;
            return this;
        }

        public String getLabel() {
            return this.label;
        }

        public Builder setLabel(String value) {
            this.validate(this.fields()[2], value);
            this.label = value;
            this.fieldSetFlags()[2] = true;
            return this;
        }

        public boolean hasLabel() {
            return this.fieldSetFlags()[2];
        }

        public Builder clearLabel() {
            this.label = null;
            this.fieldSetFlags()[2] = false;
            return this;
        }

        public int getAge() {
            return this.age;
        }

        public Builder setAge(int value) {
            this.validate(this.fields()[3], value);
            this.age = value;
            this.fieldSetFlags()[3] = true;
            return this;
        }

        public boolean hasAge() {
            return this.fieldSetFlags()[3];
        }

        public Builder clearAge() {
            this.fieldSetFlags()[3] = false;
            return this;
        }

        public int getYearsOfEducation() {
            return this.yearsOfEducation;
        }

        public Builder setYearsOfEducation(int value) {
            this.validate(this.fields()[4], value);
            this.yearsOfEducation = value;
            this.fieldSetFlags()[4] = true;
            return this;
        }

        public boolean hasYearsOfEducation() {
            return this.fieldSetFlags()[4];
        }

        public Builder clearYearsOfEducation() {
            this.fieldSetFlags()[4] = false;
            return this;
        }

        public GenderType getGender() {
            return this.gender;
        }

        public Builder setGender(GenderType value) {
            this.validate(this.fields()[5], (Object)value);
            this.gender = value;
            this.fieldSetFlags()[5] = true;
            return this;
        }

        public boolean hasGender() {
            return this.fieldSetFlags()[5];
        }

        public Builder clearGender() {
            this.gender = null;
            this.fieldSetFlags()[5] = false;
            return this;
        }

        public Classification getClassification() {
            return this.classification;
        }

        public Builder setClassification(Classification value) {
            this.validate(this.fields()[6], (Object)value);
            this.classification = value;
            this.fieldSetFlags()[6] = true;
            return this;
        }

        public boolean hasClassification() {
            return this.fieldSetFlags()[6];
        }

        public Builder clearClassification() {
            this.classification = null;
            this.fieldSetFlags()[6] = false;
            return this;
        }

        public double getNmi() {
            return this.nmi;
        }

        public Builder setNmi(double value) {
            this.validate(this.fields()[7], value);
            this.nmi = value;
            this.fieldSetFlags()[7] = true;
            return this;
        }

        public boolean hasNmi() {
            return this.fieldSetFlags()[7];
        }

        public Builder clearNmi() {
            this.fieldSetFlags()[7] = false;
            return this;
        }

        public AltoidaSummary build() {
            try {
                AltoidaSummary record = new AltoidaSummary();
                record.time = this.fieldSetFlags()[0] ? this.time : (Double)this.defaultValue(this.fields()[0]);
                record.timeReceived = this.fieldSetFlags()[1] ? this.timeReceived : (Double)this.defaultValue(this.fields()[1]);
                record.label = this.fieldSetFlags()[2] ? this.label : (String)this.defaultValue(this.fields()[2]);
                record.age = this.fieldSetFlags()[3] ? this.age : (Integer)this.defaultValue(this.fields()[3]);
                record.yearsOfEducation = this.fieldSetFlags()[4] ? this.yearsOfEducation : (Integer)this.defaultValue(this.fields()[4]);
                record.gender = this.fieldSetFlags()[5] ? this.gender : (GenderType)((Object)this.defaultValue(this.fields()[5]));
                record.classification = this.fieldSetFlags()[6] ? this.classification : (Classification)((Object)this.defaultValue(this.fields()[6]));
                record.nmi = this.fieldSetFlags()[7] ? this.nmi : (Double)this.defaultValue(this.fields()[7]);
                return record;
            }
            catch (AvroMissingFieldException e) {
                throw e;
            }
            catch (Exception e) {
                throw new AvroRuntimeException((Throwable)e);
            }
        }
    }
}

