/*
 * Decompiled with CFR 0.152.
 */
package org.radarcns.connector.fitbit;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.nio.ByteBuffer;
import org.apache.avro.AvroMissingFieldException;
import org.apache.avro.AvroRuntimeException;
import org.apache.avro.Schema;
import org.apache.avro.data.RecordBuilder;
import org.apache.avro.generic.GenericData;
import org.apache.avro.io.DatumReader;
import org.apache.avro.io.DatumWriter;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.Encoder;
import org.apache.avro.io.ResolvingDecoder;
import org.apache.avro.message.BinaryMessageDecoder;
import org.apache.avro.message.BinaryMessageEncoder;
import org.apache.avro.message.SchemaStore;
import org.apache.avro.specific.AvroGenerated;
import org.apache.avro.specific.SpecificData;
import org.apache.avro.specific.SpecificRecord;
import org.apache.avro.specific.SpecificRecordBase;
import org.apache.avro.specific.SpecificRecordBuilderBase;

@AvroGenerated
public class FitbitActivityHeartRate
extends SpecificRecordBase
implements SpecificRecord {
    private static final long serialVersionUID = 4732936356363441672L;
    public static final Schema SCHEMA$ = new Schema.Parser().parse("{\"type\":\"record\",\"name\":\"FitbitActivityHeartRate\",\"namespace\":\"org.radarcns.connector.fitbit\",\"doc\":\"Aggregate heart rate as measured over an activity. The heart rates are divided amongst so-called heart rate zones. A heart rate zone is a range of heart rates and it does not overlap with other heart rate zones. These zones are called, in order of increasing heart rate, 'Out of Range', 'Fat Burn', 'Cardio', and 'Peak'. Fitbit uses the common formula of 220 minus your age to estimate your maximum heart rate. The 'Out of Range' zone has heart rates up to 50 percent of maximum heart rate, the 'Fat Burn' has heart rates up to 70 percent of maximum heart rate, 'Cardio' up to 85 percent of maximum heart rate and the 'Peak' range has heart rates higher than that.\",\"fields\":[{\"name\":\"mean\",\"type\":[\"null\",\"int\"],\"doc\":\"Mean heart rate over the duration of an activity (bpm). Null if unknown.\",\"default\":null},{\"name\":\"min\",\"type\":[\"null\",\"int\"],\"doc\":\"Minimum heart rate for the duration of an activity (bpm). Null if unknown.\",\"default\":null},{\"name\":\"max\",\"type\":[\"null\",\"int\"],\"doc\":\"Maximum heart rate for the duration of an activity (bpm). Null if unknown.\",\"default\":null},{\"name\":\"minFatBurn\",\"type\":[\"null\",\"int\"],\"doc\":\"Threshold heart rate above which a the heart rate is considered in the heart rate zone 'Fat Burn' (bpm), up to the value of the minCardio field. Null if unknown.\",\"default\":null},{\"name\":\"minCardio\",\"type\":[\"null\",\"int\"],\"doc\":\"Threshold heart rate above which a the heart rate is considered in the heart rate zone 'Cardio' (bpm), up to the value of the minPeak field. Null if unknown.\",\"default\":null},{\"name\":\"minPeak\",\"type\":[\"null\",\"int\"],\"doc\":\"Threshold heart rate above which a the heart rate is considered in the heart rate zone 'Peak' (bpm). Null if unknown.\",\"default\":null},{\"name\":\"durationOutOfRange\",\"type\":[\"null\",\"int\"],\"doc\":\"Duration in the heart rate zone 'Out Of Range', which is the lowest heart rate zone (s). Null if unknown.\",\"default\":null},{\"name\":\"durationFatBurn\",\"type\":[\"null\",\"int\"],\"doc\":\"Duration in the heart rate zone 'Fat Burn', which is the second lowest heart rate zone (s). Null if unknown.\",\"default\":null},{\"name\":\"durationCardio\",\"type\":[\"null\",\"int\"],\"doc\":\"Duration in the heart rate zone 'Cardio', which is the third lowest heart rate zone (s). Null if unknown.\",\"default\":null},{\"name\":\"durationPeak\",\"type\":[\"null\",\"int\"],\"doc\":\"Duration in the heart rate zone 'Peak', which is the highest heart rate zone (s). Null if unknown.\",\"default\":null}]}");
    private static SpecificData MODEL$ = new SpecificData();
    private static final BinaryMessageEncoder<FitbitActivityHeartRate> ENCODER = new BinaryMessageEncoder((GenericData)MODEL$, SCHEMA$);
    private static final BinaryMessageDecoder<FitbitActivityHeartRate> DECODER = new BinaryMessageDecoder((GenericData)MODEL$, SCHEMA$);
    @Deprecated
    public Integer mean;
    @Deprecated
    public Integer min;
    @Deprecated
    public Integer max;
    @Deprecated
    public Integer minFatBurn;
    @Deprecated
    public Integer minCardio;
    @Deprecated
    public Integer minPeak;
    @Deprecated
    public Integer durationOutOfRange;
    @Deprecated
    public Integer durationFatBurn;
    @Deprecated
    public Integer durationCardio;
    @Deprecated
    public Integer durationPeak;
    private static final DatumWriter<FitbitActivityHeartRate> WRITER$ = MODEL$.createDatumWriter(SCHEMA$);
    private static final DatumReader<FitbitActivityHeartRate> READER$ = MODEL$.createDatumReader(SCHEMA$);

    public static Schema getClassSchema() {
        return SCHEMA$;
    }

    public static BinaryMessageEncoder<FitbitActivityHeartRate> getEncoder() {
        return ENCODER;
    }

    public static BinaryMessageDecoder<FitbitActivityHeartRate> getDecoder() {
        return DECODER;
    }

    public static BinaryMessageDecoder<FitbitActivityHeartRate> createDecoder(SchemaStore resolver) {
        return new BinaryMessageDecoder((GenericData)MODEL$, SCHEMA$, resolver);
    }

    public ByteBuffer toByteBuffer() throws IOException {
        return ENCODER.encode((Object)this);
    }

    public static FitbitActivityHeartRate fromByteBuffer(ByteBuffer b) throws IOException {
        return (FitbitActivityHeartRate)((Object)DECODER.decode(b));
    }

    public FitbitActivityHeartRate() {
    }

    public FitbitActivityHeartRate(Integer mean, Integer min, Integer max, Integer minFatBurn, Integer minCardio, Integer minPeak, Integer durationOutOfRange, Integer durationFatBurn, Integer durationCardio, Integer durationPeak) {
        this.mean = mean;
        this.min = min;
        this.max = max;
        this.minFatBurn = minFatBurn;
        this.minCardio = minCardio;
        this.minPeak = minPeak;
        this.durationOutOfRange = durationOutOfRange;
        this.durationFatBurn = durationFatBurn;
        this.durationCardio = durationCardio;
        this.durationPeak = durationPeak;
    }

    public SpecificData getSpecificData() {
        return MODEL$;
    }

    public Schema getSchema() {
        return SCHEMA$;
    }

    public Object get(int field$) {
        switch (field$) {
            case 0: {
                return this.mean;
            }
            case 1: {
                return this.min;
            }
            case 2: {
                return this.max;
            }
            case 3: {
                return this.minFatBurn;
            }
            case 4: {
                return this.minCardio;
            }
            case 5: {
                return this.minPeak;
            }
            case 6: {
                return this.durationOutOfRange;
            }
            case 7: {
                return this.durationFatBurn;
            }
            case 8: {
                return this.durationCardio;
            }
            case 9: {
                return this.durationPeak;
            }
        }
        throw new IndexOutOfBoundsException("Invalid index: " + field$);
    }

    public void put(int field$, Object value$) {
        switch (field$) {
            case 0: {
                this.mean = (Integer)value$;
                break;
            }
            case 1: {
                this.min = (Integer)value$;
                break;
            }
            case 2: {
                this.max = (Integer)value$;
                break;
            }
            case 3: {
                this.minFatBurn = (Integer)value$;
                break;
            }
            case 4: {
                this.minCardio = (Integer)value$;
                break;
            }
            case 5: {
                this.minPeak = (Integer)value$;
                break;
            }
            case 6: {
                this.durationOutOfRange = (Integer)value$;
                break;
            }
            case 7: {
                this.durationFatBurn = (Integer)value$;
                break;
            }
            case 8: {
                this.durationCardio = (Integer)value$;
                break;
            }
            case 9: {
                this.durationPeak = (Integer)value$;
                break;
            }
            default: {
                throw new IndexOutOfBoundsException("Invalid index: " + field$);
            }
        }
    }

    public Integer getMean() {
        return this.mean;
    }

    public void setMean(Integer value) {
        this.mean = value;
    }

    public Integer getMin() {
        return this.min;
    }

    public void setMin(Integer value) {
        this.min = value;
    }

    public Integer getMax() {
        return this.max;
    }

    public void setMax(Integer value) {
        this.max = value;
    }

    public Integer getMinFatBurn() {
        return this.minFatBurn;
    }

    public void setMinFatBurn(Integer value) {
        this.minFatBurn = value;
    }

    public Integer getMinCardio() {
        return this.minCardio;
    }

    public void setMinCardio(Integer value) {
        this.minCardio = value;
    }

    public Integer getMinPeak() {
        return this.minPeak;
    }

    public void setMinPeak(Integer value) {
        this.minPeak = value;
    }

    public Integer getDurationOutOfRange() {
        return this.durationOutOfRange;
    }

    public void setDurationOutOfRange(Integer value) {
        this.durationOutOfRange = value;
    }

    public Integer getDurationFatBurn() {
        return this.durationFatBurn;
    }

    public void setDurationFatBurn(Integer value) {
        this.durationFatBurn = value;
    }

    public Integer getDurationCardio() {
        return this.durationCardio;
    }

    public void setDurationCardio(Integer value) {
        this.durationCardio = value;
    }

    public Integer getDurationPeak() {
        return this.durationPeak;
    }

    public void setDurationPeak(Integer value) {
        this.durationPeak = value;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newBuilder(Builder other) {
        if (other == null) {
            return new Builder();
        }
        return new Builder(other);
    }

    public static Builder newBuilder(FitbitActivityHeartRate other) {
        if (other == null) {
            return new Builder();
        }
        return new Builder(other);
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        WRITER$.write((Object)this, (Encoder)SpecificData.getEncoder((ObjectOutput)out));
    }

    public void readExternal(ObjectInput in) throws IOException {
        READER$.read((Object)this, (Decoder)SpecificData.getDecoder((ObjectInput)in));
    }

    protected boolean hasCustomCoders() {
        return true;
    }

    public void customEncode(Encoder out) throws IOException {
        if (this.mean == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeInt(this.mean.intValue());
        }
        if (this.min == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeInt(this.min.intValue());
        }
        if (this.max == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeInt(this.max.intValue());
        }
        if (this.minFatBurn == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeInt(this.minFatBurn.intValue());
        }
        if (this.minCardio == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeInt(this.minCardio.intValue());
        }
        if (this.minPeak == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeInt(this.minPeak.intValue());
        }
        if (this.durationOutOfRange == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeInt(this.durationOutOfRange.intValue());
        }
        if (this.durationFatBurn == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeInt(this.durationFatBurn.intValue());
        }
        if (this.durationCardio == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeInt(this.durationCardio.intValue());
        }
        if (this.durationPeak == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeInt(this.durationPeak.intValue());
        }
    }

    public void customDecode(ResolvingDecoder in) throws IOException {
        Schema.Field[] fieldOrder = in.readFieldOrderIfDiff();
        if (fieldOrder == null) {
            if (in.readIndex() != 1) {
                in.readNull();
                this.mean = null;
            } else {
                this.mean = in.readInt();
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.min = null;
            } else {
                this.min = in.readInt();
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.max = null;
            } else {
                this.max = in.readInt();
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.minFatBurn = null;
            } else {
                this.minFatBurn = in.readInt();
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.minCardio = null;
            } else {
                this.minCardio = in.readInt();
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.minPeak = null;
            } else {
                this.minPeak = in.readInt();
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.durationOutOfRange = null;
            } else {
                this.durationOutOfRange = in.readInt();
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.durationFatBurn = null;
            } else {
                this.durationFatBurn = in.readInt();
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.durationCardio = null;
            } else {
                this.durationCardio = in.readInt();
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.durationPeak = null;
            } else {
                this.durationPeak = in.readInt();
            }
        } else {
            block12: for (int i = 0; i < 10; ++i) {
                switch (fieldOrder[i].pos()) {
                    case 0: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.mean = null;
                            continue block12;
                        }
                        this.mean = in.readInt();
                        continue block12;
                    }
                    case 1: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.min = null;
                            continue block12;
                        }
                        this.min = in.readInt();
                        continue block12;
                    }
                    case 2: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.max = null;
                            continue block12;
                        }
                        this.max = in.readInt();
                        continue block12;
                    }
                    case 3: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.minFatBurn = null;
                            continue block12;
                        }
                        this.minFatBurn = in.readInt();
                        continue block12;
                    }
                    case 4: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.minCardio = null;
                            continue block12;
                        }
                        this.minCardio = in.readInt();
                        continue block12;
                    }
                    case 5: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.minPeak = null;
                            continue block12;
                        }
                        this.minPeak = in.readInt();
                        continue block12;
                    }
                    case 6: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.durationOutOfRange = null;
                            continue block12;
                        }
                        this.durationOutOfRange = in.readInt();
                        continue block12;
                    }
                    case 7: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.durationFatBurn = null;
                            continue block12;
                        }
                        this.durationFatBurn = in.readInt();
                        continue block12;
                    }
                    case 8: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.durationCardio = null;
                            continue block12;
                        }
                        this.durationCardio = in.readInt();
                        continue block12;
                    }
                    case 9: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.durationPeak = null;
                            continue block12;
                        }
                        this.durationPeak = in.readInt();
                        continue block12;
                    }
                    default: {
                        throw new IOException("Corrupt ResolvingDecoder.");
                    }
                }
            }
        }
    }

    @AvroGenerated
    public static class Builder
    extends SpecificRecordBuilderBase<FitbitActivityHeartRate>
    implements RecordBuilder<FitbitActivityHeartRate> {
        private Integer mean;
        private Integer min;
        private Integer max;
        private Integer minFatBurn;
        private Integer minCardio;
        private Integer minPeak;
        private Integer durationOutOfRange;
        private Integer durationFatBurn;
        private Integer durationCardio;
        private Integer durationPeak;

        private Builder() {
            super(SCHEMA$);
        }

        private Builder(Builder other) {
            super((SpecificRecordBuilderBase)other);
            if (Builder.isValidValue((Schema.Field)this.fields()[0], (Object)other.mean)) {
                this.mean = (Integer)this.data().deepCopy(this.fields()[0].schema(), (Object)other.mean);
                this.fieldSetFlags()[0] = other.fieldSetFlags()[0];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[1], (Object)other.min)) {
                this.min = (Integer)this.data().deepCopy(this.fields()[1].schema(), (Object)other.min);
                this.fieldSetFlags()[1] = other.fieldSetFlags()[1];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[2], (Object)other.max)) {
                this.max = (Integer)this.data().deepCopy(this.fields()[2].schema(), (Object)other.max);
                this.fieldSetFlags()[2] = other.fieldSetFlags()[2];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[3], (Object)other.minFatBurn)) {
                this.minFatBurn = (Integer)this.data().deepCopy(this.fields()[3].schema(), (Object)other.minFatBurn);
                this.fieldSetFlags()[3] = other.fieldSetFlags()[3];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[4], (Object)other.minCardio)) {
                this.minCardio = (Integer)this.data().deepCopy(this.fields()[4].schema(), (Object)other.minCardio);
                this.fieldSetFlags()[4] = other.fieldSetFlags()[4];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[5], (Object)other.minPeak)) {
                this.minPeak = (Integer)this.data().deepCopy(this.fields()[5].schema(), (Object)other.minPeak);
                this.fieldSetFlags()[5] = other.fieldSetFlags()[5];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[6], (Object)other.durationOutOfRange)) {
                this.durationOutOfRange = (Integer)this.data().deepCopy(this.fields()[6].schema(), (Object)other.durationOutOfRange);
                this.fieldSetFlags()[6] = other.fieldSetFlags()[6];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[7], (Object)other.durationFatBurn)) {
                this.durationFatBurn = (Integer)this.data().deepCopy(this.fields()[7].schema(), (Object)other.durationFatBurn);
                this.fieldSetFlags()[7] = other.fieldSetFlags()[7];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[8], (Object)other.durationCardio)) {
                this.durationCardio = (Integer)this.data().deepCopy(this.fields()[8].schema(), (Object)other.durationCardio);
                this.fieldSetFlags()[8] = other.fieldSetFlags()[8];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[9], (Object)other.durationPeak)) {
                this.durationPeak = (Integer)this.data().deepCopy(this.fields()[9].schema(), (Object)other.durationPeak);
                this.fieldSetFlags()[9] = other.fieldSetFlags()[9];
            }
        }

        private Builder(FitbitActivityHeartRate other) {
            super(SCHEMA$);
            if (Builder.isValidValue((Schema.Field)this.fields()[0], (Object)other.mean)) {
                this.mean = (Integer)this.data().deepCopy(this.fields()[0].schema(), (Object)other.mean);
                this.fieldSetFlags()[0] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[1], (Object)other.min)) {
                this.min = (Integer)this.data().deepCopy(this.fields()[1].schema(), (Object)other.min);
                this.fieldSetFlags()[1] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[2], (Object)other.max)) {
                this.max = (Integer)this.data().deepCopy(this.fields()[2].schema(), (Object)other.max);
                this.fieldSetFlags()[2] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[3], (Object)other.minFatBurn)) {
                this.minFatBurn = (Integer)this.data().deepCopy(this.fields()[3].schema(), (Object)other.minFatBurn);
                this.fieldSetFlags()[3] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[4], (Object)other.minCardio)) {
                this.minCardio = (Integer)this.data().deepCopy(this.fields()[4].schema(), (Object)other.minCardio);
                this.fieldSetFlags()[4] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[5], (Object)other.minPeak)) {
                this.minPeak = (Integer)this.data().deepCopy(this.fields()[5].schema(), (Object)other.minPeak);
                this.fieldSetFlags()[5] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[6], (Object)other.durationOutOfRange)) {
                this.durationOutOfRange = (Integer)this.data().deepCopy(this.fields()[6].schema(), (Object)other.durationOutOfRange);
                this.fieldSetFlags()[6] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[7], (Object)other.durationFatBurn)) {
                this.durationFatBurn = (Integer)this.data().deepCopy(this.fields()[7].schema(), (Object)other.durationFatBurn);
                this.fieldSetFlags()[7] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[8], (Object)other.durationCardio)) {
                this.durationCardio = (Integer)this.data().deepCopy(this.fields()[8].schema(), (Object)other.durationCardio);
                this.fieldSetFlags()[8] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[9], (Object)other.durationPeak)) {
                this.durationPeak = (Integer)this.data().deepCopy(this.fields()[9].schema(), (Object)other.durationPeak);
                this.fieldSetFlags()[9] = true;
            }
        }

        public Integer getMean() {
            return this.mean;
        }

        public Builder setMean(Integer value) {
            this.validate(this.fields()[0], value);
            this.mean = value;
            this.fieldSetFlags()[0] = true;
            return this;
        }

        public boolean hasMean() {
            return this.fieldSetFlags()[0];
        }

        public Builder clearMean() {
            this.mean = null;
            this.fieldSetFlags()[0] = false;
            return this;
        }

        public Integer getMin() {
            return this.min;
        }

        public Builder setMin(Integer value) {
            this.validate(this.fields()[1], value);
            this.min = value;
            this.fieldSetFlags()[1] = true;
            return this;
        }

        public boolean hasMin() {
            return this.fieldSetFlags()[1];
        }

        public Builder clearMin() {
            this.min = null;
            this.fieldSetFlags()[1] = false;
            return this;
        }

        public Integer getMax() {
            return this.max;
        }

        public Builder setMax(Integer value) {
            this.validate(this.fields()[2], value);
            this.max = value;
            this.fieldSetFlags()[2] = true;
            return this;
        }

        public boolean hasMax() {
            return this.fieldSetFlags()[2];
        }

        public Builder clearMax() {
            this.max = null;
            this.fieldSetFlags()[2] = false;
            return this;
        }

        public Integer getMinFatBurn() {
            return this.minFatBurn;
        }

        public Builder setMinFatBurn(Integer value) {
            this.validate(this.fields()[3], value);
            this.minFatBurn = value;
            this.fieldSetFlags()[3] = true;
            return this;
        }

        public boolean hasMinFatBurn() {
            return this.fieldSetFlags()[3];
        }

        public Builder clearMinFatBurn() {
            this.minFatBurn = null;
            this.fieldSetFlags()[3] = false;
            return this;
        }

        public Integer getMinCardio() {
            return this.minCardio;
        }

        public Builder setMinCardio(Integer value) {
            this.validate(this.fields()[4], value);
            this.minCardio = value;
            this.fieldSetFlags()[4] = true;
            return this;
        }

        public boolean hasMinCardio() {
            return this.fieldSetFlags()[4];
        }

        public Builder clearMinCardio() {
            this.minCardio = null;
            this.fieldSetFlags()[4] = false;
            return this;
        }

        public Integer getMinPeak() {
            return this.minPeak;
        }

        public Builder setMinPeak(Integer value) {
            this.validate(this.fields()[5], value);
            this.minPeak = value;
            this.fieldSetFlags()[5] = true;
            return this;
        }

        public boolean hasMinPeak() {
            return this.fieldSetFlags()[5];
        }

        public Builder clearMinPeak() {
            this.minPeak = null;
            this.fieldSetFlags()[5] = false;
            return this;
        }

        public Integer getDurationOutOfRange() {
            return this.durationOutOfRange;
        }

        public Builder setDurationOutOfRange(Integer value) {
            this.validate(this.fields()[6], value);
            this.durationOutOfRange = value;
            this.fieldSetFlags()[6] = true;
            return this;
        }

        public boolean hasDurationOutOfRange() {
            return this.fieldSetFlags()[6];
        }

        public Builder clearDurationOutOfRange() {
            this.durationOutOfRange = null;
            this.fieldSetFlags()[6] = false;
            return this;
        }

        public Integer getDurationFatBurn() {
            return this.durationFatBurn;
        }

        public Builder setDurationFatBurn(Integer value) {
            this.validate(this.fields()[7], value);
            this.durationFatBurn = value;
            this.fieldSetFlags()[7] = true;
            return this;
        }

        public boolean hasDurationFatBurn() {
            return this.fieldSetFlags()[7];
        }

        public Builder clearDurationFatBurn() {
            this.durationFatBurn = null;
            this.fieldSetFlags()[7] = false;
            return this;
        }

        public Integer getDurationCardio() {
            return this.durationCardio;
        }

        public Builder setDurationCardio(Integer value) {
            this.validate(this.fields()[8], value);
            this.durationCardio = value;
            this.fieldSetFlags()[8] = true;
            return this;
        }

        public boolean hasDurationCardio() {
            return this.fieldSetFlags()[8];
        }

        public Builder clearDurationCardio() {
            this.durationCardio = null;
            this.fieldSetFlags()[8] = false;
            return this;
        }

        public Integer getDurationPeak() {
            return this.durationPeak;
        }

        public Builder setDurationPeak(Integer value) {
            this.validate(this.fields()[9], value);
            this.durationPeak = value;
            this.fieldSetFlags()[9] = true;
            return this;
        }

        public boolean hasDurationPeak() {
            return this.fieldSetFlags()[9];
        }

        public Builder clearDurationPeak() {
            this.durationPeak = null;
            this.fieldSetFlags()[9] = false;
            return this;
        }

        public FitbitActivityHeartRate build() {
            try {
                FitbitActivityHeartRate record = new FitbitActivityHeartRate();
                record.mean = this.fieldSetFlags()[0] ? this.mean : (Integer)this.defaultValue(this.fields()[0]);
                record.min = this.fieldSetFlags()[1] ? this.min : (Integer)this.defaultValue(this.fields()[1]);
                record.max = this.fieldSetFlags()[2] ? this.max : (Integer)this.defaultValue(this.fields()[2]);
                record.minFatBurn = this.fieldSetFlags()[3] ? this.minFatBurn : (Integer)this.defaultValue(this.fields()[3]);
                record.minCardio = this.fieldSetFlags()[4] ? this.minCardio : (Integer)this.defaultValue(this.fields()[4]);
                record.minPeak = this.fieldSetFlags()[5] ? this.minPeak : (Integer)this.defaultValue(this.fields()[5]);
                record.durationOutOfRange = this.fieldSetFlags()[6] ? this.durationOutOfRange : (Integer)this.defaultValue(this.fields()[6]);
                record.durationFatBurn = this.fieldSetFlags()[7] ? this.durationFatBurn : (Integer)this.defaultValue(this.fields()[7]);
                record.durationCardio = this.fieldSetFlags()[8] ? this.durationCardio : (Integer)this.defaultValue(this.fields()[8]);
                record.durationPeak = this.fieldSetFlags()[9] ? this.durationPeak : (Integer)this.defaultValue(this.fields()[9]);
                return record;
            }
            catch (AvroMissingFieldException e) {
                throw e;
            }
            catch (Exception e) {
                throw new AvroRuntimeException((Throwable)e);
            }
        }
    }
}

