/*
 * Decompiled with CFR 0.152.
 */
package org.radarcns.active.thincit;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.nio.ByteBuffer;
import org.apache.avro.AvroMissingFieldException;
import org.apache.avro.AvroRuntimeException;
import org.apache.avro.Schema;
import org.apache.avro.data.RecordBuilder;
import org.apache.avro.generic.GenericData;
import org.apache.avro.io.DatumReader;
import org.apache.avro.io.DatumWriter;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.Encoder;
import org.apache.avro.io.ResolvingDecoder;
import org.apache.avro.message.BinaryMessageDecoder;
import org.apache.avro.message.BinaryMessageEncoder;
import org.apache.avro.message.SchemaStore;
import org.apache.avro.specific.AvroGenerated;
import org.apache.avro.specific.SpecificData;
import org.apache.avro.specific.SpecificRecord;
import org.apache.avro.specific.SpecificRecordBase;
import org.apache.avro.specific.SpecificRecordBuilderBase;
import org.radarcns.active.thincit.ThincItCodeBreakerQuarterSummary;
import org.radarcns.active.thincit.ThincItInputType;

@AvroGenerated
public class ThincItCodeBreaker
extends SpecificRecordBase
implements SpecificRecord {
    private static final long serialVersionUID = -3704861208005084479L;
    public static final Schema SCHEMA$ = new Schema.Parser().parse("{\"type\":\"record\",\"name\":\"ThincItCodeBreaker\",\"namespace\":\"org.radarcns.active.thincit\",\"doc\":\"THINC-it Assessment derived from Digit Symbol Substitution Test. As many trials as can be completed within 2 minutes. Each trial is a symbol/number to be matched.\",\"fields\":[{\"name\":\"time\",\"type\":\"double\",\"doc\":\"Timestamp in UTC (s) when the test is submitted to the subject.\"},{\"name\":\"timeCompleted\",\"type\":\"double\",\"doc\":\"Timestamp in UTC (s) when the subject completes the test.\"},{\"name\":\"score\",\"type\":\"int\",\"doc\":\"THINC-it index score - 0 to 4000.\"},{\"name\":\"completed\",\"type\":\"int\",\"doc\":\"The number of completed trials.\"},{\"name\":\"incorrect\",\"type\":\"int\",\"doc\":\"The number of incorrect responses.\"},{\"name\":\"longestTrial\",\"type\":\"int\",\"doc\":\"Longest trial completion time expressed in milliseconds.\"},{\"name\":\"iqrCompletion\",\"type\":\"int\",\"doc\":\"Mean of trial completion times within interquartile range.\"},{\"name\":\"inputType\",\"type\":{\"type\":\"enum\",\"name\":\"ThincItInputType\",\"doc\":\"Possible input type that a subject can use to do an assignment.\",\"symbols\":[\"KEYBOARD\",\"MOUSE\",\"TOUCHSCREEN\",\"UNKNOWN\"]},\"doc\":\"Dominant input type used by the subject to answer.\",\"default\":\"UNKNOWN\"},{\"name\":\"quarterSummaryOne\",\"type\":{\"type\":\"record\",\"name\":\"ThincItCodeBreakerQuarterSummary\",\"doc\":\"Trial summary for CodeBreaker assessmen.\",\"fields\":[{\"name\":\"longestTrial\",\"type\":\"int\",\"doc\":\"Longest trial completion time expressed in milliseconds.\"},{\"name\":\"meanTime\",\"type\":\"int\",\"doc\":\"Mean trial completion time expressed in milliseconds.\"},{\"name\":\"incorrect\",\"type\":\"int\",\"doc\":\"The number of incorrect responses.\"},{\"name\":\"inputType\",\"type\":\"ThincItInputType\",\"doc\":\"Dominant input type used by the subject to answer.\",\"default\":\"UNKNOWN\"}]},\"doc\":\"Trial summary for CodeBreaker assessment Quarter 1.\"},{\"name\":\"quarterSummaryTwo\",\"type\":\"ThincItCodeBreakerQuarterSummary\",\"doc\":\"Trial summary for CodeBreaker assessment Quarter 2.\"},{\"name\":\"quarterSummaryThree\",\"type\":\"ThincItCodeBreakerQuarterSummary\",\"doc\":\"Trial summary for CodeBreaker assessment Quarter 3.\"},{\"name\":\"quarterSummaryFour\",\"type\":\"ThincItCodeBreakerQuarterSummary\",\"doc\":\"Trial summary for CodeBreaker assessment Quarter 4.\"},{\"name\":\"appVersion\",\"type\":\"int\",\"doc\":\"App version.\"}]}");
    private static SpecificData MODEL$ = new SpecificData();
    private static final BinaryMessageEncoder<ThincItCodeBreaker> ENCODER = new BinaryMessageEncoder((GenericData)MODEL$, SCHEMA$);
    private static final BinaryMessageDecoder<ThincItCodeBreaker> DECODER = new BinaryMessageDecoder((GenericData)MODEL$, SCHEMA$);
    @Deprecated
    public double time;
    @Deprecated
    public double timeCompleted;
    @Deprecated
    public int score;
    @Deprecated
    public int completed;
    @Deprecated
    public int incorrect;
    @Deprecated
    public int longestTrial;
    @Deprecated
    public int iqrCompletion;
    @Deprecated
    public ThincItInputType inputType;
    @Deprecated
    public ThincItCodeBreakerQuarterSummary quarterSummaryOne;
    @Deprecated
    public ThincItCodeBreakerQuarterSummary quarterSummaryTwo;
    @Deprecated
    public ThincItCodeBreakerQuarterSummary quarterSummaryThree;
    @Deprecated
    public ThincItCodeBreakerQuarterSummary quarterSummaryFour;
    @Deprecated
    public int appVersion;
    private static final DatumWriter<ThincItCodeBreaker> WRITER$ = MODEL$.createDatumWriter(SCHEMA$);
    private static final DatumReader<ThincItCodeBreaker> READER$ = MODEL$.createDatumReader(SCHEMA$);

    public static Schema getClassSchema() {
        return SCHEMA$;
    }

    public static BinaryMessageEncoder<ThincItCodeBreaker> getEncoder() {
        return ENCODER;
    }

    public static BinaryMessageDecoder<ThincItCodeBreaker> getDecoder() {
        return DECODER;
    }

    public static BinaryMessageDecoder<ThincItCodeBreaker> createDecoder(SchemaStore resolver) {
        return new BinaryMessageDecoder((GenericData)MODEL$, SCHEMA$, resolver);
    }

    public ByteBuffer toByteBuffer() throws IOException {
        return ENCODER.encode((Object)this);
    }

    public static ThincItCodeBreaker fromByteBuffer(ByteBuffer b) throws IOException {
        return (ThincItCodeBreaker)((Object)DECODER.decode(b));
    }

    public ThincItCodeBreaker() {
    }

    public ThincItCodeBreaker(Double time, Double timeCompleted, Integer score, Integer completed, Integer incorrect, Integer longestTrial, Integer iqrCompletion, ThincItInputType inputType, ThincItCodeBreakerQuarterSummary quarterSummaryOne, ThincItCodeBreakerQuarterSummary quarterSummaryTwo, ThincItCodeBreakerQuarterSummary quarterSummaryThree, ThincItCodeBreakerQuarterSummary quarterSummaryFour, Integer appVersion) {
        this.time = time;
        this.timeCompleted = timeCompleted;
        this.score = score;
        this.completed = completed;
        this.incorrect = incorrect;
        this.longestTrial = longestTrial;
        this.iqrCompletion = iqrCompletion;
        this.inputType = inputType;
        this.quarterSummaryOne = quarterSummaryOne;
        this.quarterSummaryTwo = quarterSummaryTwo;
        this.quarterSummaryThree = quarterSummaryThree;
        this.quarterSummaryFour = quarterSummaryFour;
        this.appVersion = appVersion;
    }

    public SpecificData getSpecificData() {
        return MODEL$;
    }

    public Schema getSchema() {
        return SCHEMA$;
    }

    public Object get(int field$) {
        switch (field$) {
            case 0: {
                return this.time;
            }
            case 1: {
                return this.timeCompleted;
            }
            case 2: {
                return this.score;
            }
            case 3: {
                return this.completed;
            }
            case 4: {
                return this.incorrect;
            }
            case 5: {
                return this.longestTrial;
            }
            case 6: {
                return this.iqrCompletion;
            }
            case 7: {
                return this.inputType;
            }
            case 8: {
                return this.quarterSummaryOne;
            }
            case 9: {
                return this.quarterSummaryTwo;
            }
            case 10: {
                return this.quarterSummaryThree;
            }
            case 11: {
                return this.quarterSummaryFour;
            }
            case 12: {
                return this.appVersion;
            }
        }
        throw new IndexOutOfBoundsException("Invalid index: " + field$);
    }

    public void put(int field$, Object value$) {
        switch (field$) {
            case 0: {
                this.time = (Double)value$;
                break;
            }
            case 1: {
                this.timeCompleted = (Double)value$;
                break;
            }
            case 2: {
                this.score = (Integer)value$;
                break;
            }
            case 3: {
                this.completed = (Integer)value$;
                break;
            }
            case 4: {
                this.incorrect = (Integer)value$;
                break;
            }
            case 5: {
                this.longestTrial = (Integer)value$;
                break;
            }
            case 6: {
                this.iqrCompletion = (Integer)value$;
                break;
            }
            case 7: {
                this.inputType = (ThincItInputType)((Object)value$);
                break;
            }
            case 8: {
                this.quarterSummaryOne = (ThincItCodeBreakerQuarterSummary)((Object)value$);
                break;
            }
            case 9: {
                this.quarterSummaryTwo = (ThincItCodeBreakerQuarterSummary)((Object)value$);
                break;
            }
            case 10: {
                this.quarterSummaryThree = (ThincItCodeBreakerQuarterSummary)((Object)value$);
                break;
            }
            case 11: {
                this.quarterSummaryFour = (ThincItCodeBreakerQuarterSummary)((Object)value$);
                break;
            }
            case 12: {
                this.appVersion = (Integer)value$;
                break;
            }
            default: {
                throw new IndexOutOfBoundsException("Invalid index: " + field$);
            }
        }
    }

    public double getTime() {
        return this.time;
    }

    public void setTime(double value) {
        this.time = value;
    }

    public double getTimeCompleted() {
        return this.timeCompleted;
    }

    public void setTimeCompleted(double value) {
        this.timeCompleted = value;
    }

    public int getScore() {
        return this.score;
    }

    public void setScore(int value) {
        this.score = value;
    }

    public int getCompleted() {
        return this.completed;
    }

    public void setCompleted(int value) {
        this.completed = value;
    }

    public int getIncorrect() {
        return this.incorrect;
    }

    public void setIncorrect(int value) {
        this.incorrect = value;
    }

    public int getLongestTrial() {
        return this.longestTrial;
    }

    public void setLongestTrial(int value) {
        this.longestTrial = value;
    }

    public int getIqrCompletion() {
        return this.iqrCompletion;
    }

    public void setIqrCompletion(int value) {
        this.iqrCompletion = value;
    }

    public ThincItInputType getInputType() {
        return this.inputType;
    }

    public void setInputType(ThincItInputType value) {
        this.inputType = value;
    }

    public ThincItCodeBreakerQuarterSummary getQuarterSummaryOne() {
        return this.quarterSummaryOne;
    }

    public void setQuarterSummaryOne(ThincItCodeBreakerQuarterSummary value) {
        this.quarterSummaryOne = value;
    }

    public ThincItCodeBreakerQuarterSummary getQuarterSummaryTwo() {
        return this.quarterSummaryTwo;
    }

    public void setQuarterSummaryTwo(ThincItCodeBreakerQuarterSummary value) {
        this.quarterSummaryTwo = value;
    }

    public ThincItCodeBreakerQuarterSummary getQuarterSummaryThree() {
        return this.quarterSummaryThree;
    }

    public void setQuarterSummaryThree(ThincItCodeBreakerQuarterSummary value) {
        this.quarterSummaryThree = value;
    }

    public ThincItCodeBreakerQuarterSummary getQuarterSummaryFour() {
        return this.quarterSummaryFour;
    }

    public void setQuarterSummaryFour(ThincItCodeBreakerQuarterSummary value) {
        this.quarterSummaryFour = value;
    }

    public int getAppVersion() {
        return this.appVersion;
    }

    public void setAppVersion(int value) {
        this.appVersion = value;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newBuilder(Builder other) {
        if (other == null) {
            return new Builder();
        }
        return new Builder(other);
    }

    public static Builder newBuilder(ThincItCodeBreaker other) {
        if (other == null) {
            return new Builder();
        }
        return new Builder(other);
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        WRITER$.write((Object)this, (Encoder)SpecificData.getEncoder((ObjectOutput)out));
    }

    public void readExternal(ObjectInput in) throws IOException {
        READER$.read((Object)this, (Decoder)SpecificData.getDecoder((ObjectInput)in));
    }

    protected boolean hasCustomCoders() {
        return true;
    }

    public void customEncode(Encoder out) throws IOException {
        out.writeDouble(this.time);
        out.writeDouble(this.timeCompleted);
        out.writeInt(this.score);
        out.writeInt(this.completed);
        out.writeInt(this.incorrect);
        out.writeInt(this.longestTrial);
        out.writeInt(this.iqrCompletion);
        out.writeEnum(this.inputType.ordinal());
        this.quarterSummaryOne.customEncode(out);
        this.quarterSummaryTwo.customEncode(out);
        this.quarterSummaryThree.customEncode(out);
        this.quarterSummaryFour.customEncode(out);
        out.writeInt(this.appVersion);
    }

    public void customDecode(ResolvingDecoder in) throws IOException {
        Schema.Field[] fieldOrder = in.readFieldOrderIfDiff();
        if (fieldOrder == null) {
            this.time = in.readDouble();
            this.timeCompleted = in.readDouble();
            this.score = in.readInt();
            this.completed = in.readInt();
            this.incorrect = in.readInt();
            this.longestTrial = in.readInt();
            this.iqrCompletion = in.readInt();
            this.inputType = ThincItInputType.values()[in.readEnum()];
            if (this.quarterSummaryOne == null) {
                this.quarterSummaryOne = new ThincItCodeBreakerQuarterSummary();
            }
            this.quarterSummaryOne.customDecode(in);
            if (this.quarterSummaryTwo == null) {
                this.quarterSummaryTwo = new ThincItCodeBreakerQuarterSummary();
            }
            this.quarterSummaryTwo.customDecode(in);
            if (this.quarterSummaryThree == null) {
                this.quarterSummaryThree = new ThincItCodeBreakerQuarterSummary();
            }
            this.quarterSummaryThree.customDecode(in);
            if (this.quarterSummaryFour == null) {
                this.quarterSummaryFour = new ThincItCodeBreakerQuarterSummary();
            }
            this.quarterSummaryFour.customDecode(in);
            this.appVersion = in.readInt();
        } else {
            block15: for (int i = 0; i < 13; ++i) {
                switch (fieldOrder[i].pos()) {
                    case 0: {
                        this.time = in.readDouble();
                        continue block15;
                    }
                    case 1: {
                        this.timeCompleted = in.readDouble();
                        continue block15;
                    }
                    case 2: {
                        this.score = in.readInt();
                        continue block15;
                    }
                    case 3: {
                        this.completed = in.readInt();
                        continue block15;
                    }
                    case 4: {
                        this.incorrect = in.readInt();
                        continue block15;
                    }
                    case 5: {
                        this.longestTrial = in.readInt();
                        continue block15;
                    }
                    case 6: {
                        this.iqrCompletion = in.readInt();
                        continue block15;
                    }
                    case 7: {
                        this.inputType = ThincItInputType.values()[in.readEnum()];
                        continue block15;
                    }
                    case 8: {
                        if (this.quarterSummaryOne == null) {
                            this.quarterSummaryOne = new ThincItCodeBreakerQuarterSummary();
                        }
                        this.quarterSummaryOne.customDecode(in);
                        continue block15;
                    }
                    case 9: {
                        if (this.quarterSummaryTwo == null) {
                            this.quarterSummaryTwo = new ThincItCodeBreakerQuarterSummary();
                        }
                        this.quarterSummaryTwo.customDecode(in);
                        continue block15;
                    }
                    case 10: {
                        if (this.quarterSummaryThree == null) {
                            this.quarterSummaryThree = new ThincItCodeBreakerQuarterSummary();
                        }
                        this.quarterSummaryThree.customDecode(in);
                        continue block15;
                    }
                    case 11: {
                        if (this.quarterSummaryFour == null) {
                            this.quarterSummaryFour = new ThincItCodeBreakerQuarterSummary();
                        }
                        this.quarterSummaryFour.customDecode(in);
                        continue block15;
                    }
                    case 12: {
                        this.appVersion = in.readInt();
                        continue block15;
                    }
                    default: {
                        throw new IOException("Corrupt ResolvingDecoder.");
                    }
                }
            }
        }
    }

    @AvroGenerated
    public static class Builder
    extends SpecificRecordBuilderBase<ThincItCodeBreaker>
    implements RecordBuilder<ThincItCodeBreaker> {
        private double time;
        private double timeCompleted;
        private int score;
        private int completed;
        private int incorrect;
        private int longestTrial;
        private int iqrCompletion;
        private ThincItInputType inputType;
        private ThincItCodeBreakerQuarterSummary quarterSummaryOne;
        private ThincItCodeBreakerQuarterSummary.Builder quarterSummaryOneBuilder;
        private ThincItCodeBreakerQuarterSummary quarterSummaryTwo;
        private ThincItCodeBreakerQuarterSummary.Builder quarterSummaryTwoBuilder;
        private ThincItCodeBreakerQuarterSummary quarterSummaryThree;
        private ThincItCodeBreakerQuarterSummary.Builder quarterSummaryThreeBuilder;
        private ThincItCodeBreakerQuarterSummary quarterSummaryFour;
        private ThincItCodeBreakerQuarterSummary.Builder quarterSummaryFourBuilder;
        private int appVersion;

        private Builder() {
            super(SCHEMA$);
        }

        private Builder(Builder other) {
            super((SpecificRecordBuilderBase)other);
            if (Builder.isValidValue((Schema.Field)this.fields()[0], (Object)other.time)) {
                this.time = (Double)this.data().deepCopy(this.fields()[0].schema(), (Object)other.time);
                this.fieldSetFlags()[0] = other.fieldSetFlags()[0];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[1], (Object)other.timeCompleted)) {
                this.timeCompleted = (Double)this.data().deepCopy(this.fields()[1].schema(), (Object)other.timeCompleted);
                this.fieldSetFlags()[1] = other.fieldSetFlags()[1];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[2], (Object)other.score)) {
                this.score = (Integer)this.data().deepCopy(this.fields()[2].schema(), (Object)other.score);
                this.fieldSetFlags()[2] = other.fieldSetFlags()[2];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[3], (Object)other.completed)) {
                this.completed = (Integer)this.data().deepCopy(this.fields()[3].schema(), (Object)other.completed);
                this.fieldSetFlags()[3] = other.fieldSetFlags()[3];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[4], (Object)other.incorrect)) {
                this.incorrect = (Integer)this.data().deepCopy(this.fields()[4].schema(), (Object)other.incorrect);
                this.fieldSetFlags()[4] = other.fieldSetFlags()[4];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[5], (Object)other.longestTrial)) {
                this.longestTrial = (Integer)this.data().deepCopy(this.fields()[5].schema(), (Object)other.longestTrial);
                this.fieldSetFlags()[5] = other.fieldSetFlags()[5];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[6], (Object)other.iqrCompletion)) {
                this.iqrCompletion = (Integer)this.data().deepCopy(this.fields()[6].schema(), (Object)other.iqrCompletion);
                this.fieldSetFlags()[6] = other.fieldSetFlags()[6];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[7], (Object)((Object)other.inputType))) {
                this.inputType = (ThincItInputType)((Object)this.data().deepCopy(this.fields()[7].schema(), (Object)other.inputType));
                this.fieldSetFlags()[7] = other.fieldSetFlags()[7];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[8], (Object)((Object)other.quarterSummaryOne))) {
                this.quarterSummaryOne = (ThincItCodeBreakerQuarterSummary)((Object)this.data().deepCopy(this.fields()[8].schema(), (Object)other.quarterSummaryOne));
                this.fieldSetFlags()[8] = other.fieldSetFlags()[8];
            }
            if (other.hasQuarterSummaryOneBuilder()) {
                this.quarterSummaryOneBuilder = ThincItCodeBreakerQuarterSummary.newBuilder(other.getQuarterSummaryOneBuilder());
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[9], (Object)((Object)other.quarterSummaryTwo))) {
                this.quarterSummaryTwo = (ThincItCodeBreakerQuarterSummary)((Object)this.data().deepCopy(this.fields()[9].schema(), (Object)other.quarterSummaryTwo));
                this.fieldSetFlags()[9] = other.fieldSetFlags()[9];
            }
            if (other.hasQuarterSummaryTwoBuilder()) {
                this.quarterSummaryTwoBuilder = ThincItCodeBreakerQuarterSummary.newBuilder(other.getQuarterSummaryTwoBuilder());
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[10], (Object)((Object)other.quarterSummaryThree))) {
                this.quarterSummaryThree = (ThincItCodeBreakerQuarterSummary)((Object)this.data().deepCopy(this.fields()[10].schema(), (Object)other.quarterSummaryThree));
                this.fieldSetFlags()[10] = other.fieldSetFlags()[10];
            }
            if (other.hasQuarterSummaryThreeBuilder()) {
                this.quarterSummaryThreeBuilder = ThincItCodeBreakerQuarterSummary.newBuilder(other.getQuarterSummaryThreeBuilder());
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[11], (Object)((Object)other.quarterSummaryFour))) {
                this.quarterSummaryFour = (ThincItCodeBreakerQuarterSummary)((Object)this.data().deepCopy(this.fields()[11].schema(), (Object)other.quarterSummaryFour));
                this.fieldSetFlags()[11] = other.fieldSetFlags()[11];
            }
            if (other.hasQuarterSummaryFourBuilder()) {
                this.quarterSummaryFourBuilder = ThincItCodeBreakerQuarterSummary.newBuilder(other.getQuarterSummaryFourBuilder());
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[12], (Object)other.appVersion)) {
                this.appVersion = (Integer)this.data().deepCopy(this.fields()[12].schema(), (Object)other.appVersion);
                this.fieldSetFlags()[12] = other.fieldSetFlags()[12];
            }
        }

        private Builder(ThincItCodeBreaker other) {
            super(SCHEMA$);
            if (Builder.isValidValue((Schema.Field)this.fields()[0], (Object)other.time)) {
                this.time = (Double)this.data().deepCopy(this.fields()[0].schema(), (Object)other.time);
                this.fieldSetFlags()[0] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[1], (Object)other.timeCompleted)) {
                this.timeCompleted = (Double)this.data().deepCopy(this.fields()[1].schema(), (Object)other.timeCompleted);
                this.fieldSetFlags()[1] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[2], (Object)other.score)) {
                this.score = (Integer)this.data().deepCopy(this.fields()[2].schema(), (Object)other.score);
                this.fieldSetFlags()[2] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[3], (Object)other.completed)) {
                this.completed = (Integer)this.data().deepCopy(this.fields()[3].schema(), (Object)other.completed);
                this.fieldSetFlags()[3] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[4], (Object)other.incorrect)) {
                this.incorrect = (Integer)this.data().deepCopy(this.fields()[4].schema(), (Object)other.incorrect);
                this.fieldSetFlags()[4] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[5], (Object)other.longestTrial)) {
                this.longestTrial = (Integer)this.data().deepCopy(this.fields()[5].schema(), (Object)other.longestTrial);
                this.fieldSetFlags()[5] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[6], (Object)other.iqrCompletion)) {
                this.iqrCompletion = (Integer)this.data().deepCopy(this.fields()[6].schema(), (Object)other.iqrCompletion);
                this.fieldSetFlags()[6] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[7], (Object)((Object)other.inputType))) {
                this.inputType = (ThincItInputType)((Object)this.data().deepCopy(this.fields()[7].schema(), (Object)other.inputType));
                this.fieldSetFlags()[7] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[8], (Object)((Object)other.quarterSummaryOne))) {
                this.quarterSummaryOne = (ThincItCodeBreakerQuarterSummary)((Object)this.data().deepCopy(this.fields()[8].schema(), (Object)other.quarterSummaryOne));
                this.fieldSetFlags()[8] = true;
            }
            this.quarterSummaryOneBuilder = null;
            if (Builder.isValidValue((Schema.Field)this.fields()[9], (Object)((Object)other.quarterSummaryTwo))) {
                this.quarterSummaryTwo = (ThincItCodeBreakerQuarterSummary)((Object)this.data().deepCopy(this.fields()[9].schema(), (Object)other.quarterSummaryTwo));
                this.fieldSetFlags()[9] = true;
            }
            this.quarterSummaryTwoBuilder = null;
            if (Builder.isValidValue((Schema.Field)this.fields()[10], (Object)((Object)other.quarterSummaryThree))) {
                this.quarterSummaryThree = (ThincItCodeBreakerQuarterSummary)((Object)this.data().deepCopy(this.fields()[10].schema(), (Object)other.quarterSummaryThree));
                this.fieldSetFlags()[10] = true;
            }
            this.quarterSummaryThreeBuilder = null;
            if (Builder.isValidValue((Schema.Field)this.fields()[11], (Object)((Object)other.quarterSummaryFour))) {
                this.quarterSummaryFour = (ThincItCodeBreakerQuarterSummary)((Object)this.data().deepCopy(this.fields()[11].schema(), (Object)other.quarterSummaryFour));
                this.fieldSetFlags()[11] = true;
            }
            this.quarterSummaryFourBuilder = null;
            if (Builder.isValidValue((Schema.Field)this.fields()[12], (Object)other.appVersion)) {
                this.appVersion = (Integer)this.data().deepCopy(this.fields()[12].schema(), (Object)other.appVersion);
                this.fieldSetFlags()[12] = true;
            }
        }

        public double getTime() {
            return this.time;
        }

        public Builder setTime(double value) {
            this.validate(this.fields()[0], value);
            this.time = value;
            this.fieldSetFlags()[0] = true;
            return this;
        }

        public boolean hasTime() {
            return this.fieldSetFlags()[0];
        }

        public Builder clearTime() {
            this.fieldSetFlags()[0] = false;
            return this;
        }

        public double getTimeCompleted() {
            return this.timeCompleted;
        }

        public Builder setTimeCompleted(double value) {
            this.validate(this.fields()[1], value);
            this.timeCompleted = value;
            this.fieldSetFlags()[1] = true;
            return this;
        }

        public boolean hasTimeCompleted() {
            return this.fieldSetFlags()[1];
        }

        public Builder clearTimeCompleted() {
            this.fieldSetFlags()[1] = false;
            return this;
        }

        public int getScore() {
            return this.score;
        }

        public Builder setScore(int value) {
            this.validate(this.fields()[2], value);
            this.score = value;
            this.fieldSetFlags()[2] = true;
            return this;
        }

        public boolean hasScore() {
            return this.fieldSetFlags()[2];
        }

        public Builder clearScore() {
            this.fieldSetFlags()[2] = false;
            return this;
        }

        public int getCompleted() {
            return this.completed;
        }

        public Builder setCompleted(int value) {
            this.validate(this.fields()[3], value);
            this.completed = value;
            this.fieldSetFlags()[3] = true;
            return this;
        }

        public boolean hasCompleted() {
            return this.fieldSetFlags()[3];
        }

        public Builder clearCompleted() {
            this.fieldSetFlags()[3] = false;
            return this;
        }

        public int getIncorrect() {
            return this.incorrect;
        }

        public Builder setIncorrect(int value) {
            this.validate(this.fields()[4], value);
            this.incorrect = value;
            this.fieldSetFlags()[4] = true;
            return this;
        }

        public boolean hasIncorrect() {
            return this.fieldSetFlags()[4];
        }

        public Builder clearIncorrect() {
            this.fieldSetFlags()[4] = false;
            return this;
        }

        public int getLongestTrial() {
            return this.longestTrial;
        }

        public Builder setLongestTrial(int value) {
            this.validate(this.fields()[5], value);
            this.longestTrial = value;
            this.fieldSetFlags()[5] = true;
            return this;
        }

        public boolean hasLongestTrial() {
            return this.fieldSetFlags()[5];
        }

        public Builder clearLongestTrial() {
            this.fieldSetFlags()[5] = false;
            return this;
        }

        public int getIqrCompletion() {
            return this.iqrCompletion;
        }

        public Builder setIqrCompletion(int value) {
            this.validate(this.fields()[6], value);
            this.iqrCompletion = value;
            this.fieldSetFlags()[6] = true;
            return this;
        }

        public boolean hasIqrCompletion() {
            return this.fieldSetFlags()[6];
        }

        public Builder clearIqrCompletion() {
            this.fieldSetFlags()[6] = false;
            return this;
        }

        public ThincItInputType getInputType() {
            return this.inputType;
        }

        public Builder setInputType(ThincItInputType value) {
            this.validate(this.fields()[7], (Object)value);
            this.inputType = value;
            this.fieldSetFlags()[7] = true;
            return this;
        }

        public boolean hasInputType() {
            return this.fieldSetFlags()[7];
        }

        public Builder clearInputType() {
            this.inputType = null;
            this.fieldSetFlags()[7] = false;
            return this;
        }

        public ThincItCodeBreakerQuarterSummary getQuarterSummaryOne() {
            return this.quarterSummaryOne;
        }

        public Builder setQuarterSummaryOne(ThincItCodeBreakerQuarterSummary value) {
            this.validate(this.fields()[8], (Object)value);
            this.quarterSummaryOneBuilder = null;
            this.quarterSummaryOne = value;
            this.fieldSetFlags()[8] = true;
            return this;
        }

        public boolean hasQuarterSummaryOne() {
            return this.fieldSetFlags()[8];
        }

        public ThincItCodeBreakerQuarterSummary.Builder getQuarterSummaryOneBuilder() {
            if (this.quarterSummaryOneBuilder == null) {
                if (this.hasQuarterSummaryOne()) {
                    this.setQuarterSummaryOneBuilder(ThincItCodeBreakerQuarterSummary.newBuilder(this.quarterSummaryOne));
                } else {
                    this.setQuarterSummaryOneBuilder(ThincItCodeBreakerQuarterSummary.newBuilder());
                }
            }
            return this.quarterSummaryOneBuilder;
        }

        public Builder setQuarterSummaryOneBuilder(ThincItCodeBreakerQuarterSummary.Builder value) {
            this.clearQuarterSummaryOne();
            this.quarterSummaryOneBuilder = value;
            return this;
        }

        public boolean hasQuarterSummaryOneBuilder() {
            return this.quarterSummaryOneBuilder != null;
        }

        public Builder clearQuarterSummaryOne() {
            this.quarterSummaryOne = null;
            this.quarterSummaryOneBuilder = null;
            this.fieldSetFlags()[8] = false;
            return this;
        }

        public ThincItCodeBreakerQuarterSummary getQuarterSummaryTwo() {
            return this.quarterSummaryTwo;
        }

        public Builder setQuarterSummaryTwo(ThincItCodeBreakerQuarterSummary value) {
            this.validate(this.fields()[9], (Object)value);
            this.quarterSummaryTwoBuilder = null;
            this.quarterSummaryTwo = value;
            this.fieldSetFlags()[9] = true;
            return this;
        }

        public boolean hasQuarterSummaryTwo() {
            return this.fieldSetFlags()[9];
        }

        public ThincItCodeBreakerQuarterSummary.Builder getQuarterSummaryTwoBuilder() {
            if (this.quarterSummaryTwoBuilder == null) {
                if (this.hasQuarterSummaryTwo()) {
                    this.setQuarterSummaryTwoBuilder(ThincItCodeBreakerQuarterSummary.newBuilder(this.quarterSummaryTwo));
                } else {
                    this.setQuarterSummaryTwoBuilder(ThincItCodeBreakerQuarterSummary.newBuilder());
                }
            }
            return this.quarterSummaryTwoBuilder;
        }

        public Builder setQuarterSummaryTwoBuilder(ThincItCodeBreakerQuarterSummary.Builder value) {
            this.clearQuarterSummaryTwo();
            this.quarterSummaryTwoBuilder = value;
            return this;
        }

        public boolean hasQuarterSummaryTwoBuilder() {
            return this.quarterSummaryTwoBuilder != null;
        }

        public Builder clearQuarterSummaryTwo() {
            this.quarterSummaryTwo = null;
            this.quarterSummaryTwoBuilder = null;
            this.fieldSetFlags()[9] = false;
            return this;
        }

        public ThincItCodeBreakerQuarterSummary getQuarterSummaryThree() {
            return this.quarterSummaryThree;
        }

        public Builder setQuarterSummaryThree(ThincItCodeBreakerQuarterSummary value) {
            this.validate(this.fields()[10], (Object)value);
            this.quarterSummaryThreeBuilder = null;
            this.quarterSummaryThree = value;
            this.fieldSetFlags()[10] = true;
            return this;
        }

        public boolean hasQuarterSummaryThree() {
            return this.fieldSetFlags()[10];
        }

        public ThincItCodeBreakerQuarterSummary.Builder getQuarterSummaryThreeBuilder() {
            if (this.quarterSummaryThreeBuilder == null) {
                if (this.hasQuarterSummaryThree()) {
                    this.setQuarterSummaryThreeBuilder(ThincItCodeBreakerQuarterSummary.newBuilder(this.quarterSummaryThree));
                } else {
                    this.setQuarterSummaryThreeBuilder(ThincItCodeBreakerQuarterSummary.newBuilder());
                }
            }
            return this.quarterSummaryThreeBuilder;
        }

        public Builder setQuarterSummaryThreeBuilder(ThincItCodeBreakerQuarterSummary.Builder value) {
            this.clearQuarterSummaryThree();
            this.quarterSummaryThreeBuilder = value;
            return this;
        }

        public boolean hasQuarterSummaryThreeBuilder() {
            return this.quarterSummaryThreeBuilder != null;
        }

        public Builder clearQuarterSummaryThree() {
            this.quarterSummaryThree = null;
            this.quarterSummaryThreeBuilder = null;
            this.fieldSetFlags()[10] = false;
            return this;
        }

        public ThincItCodeBreakerQuarterSummary getQuarterSummaryFour() {
            return this.quarterSummaryFour;
        }

        public Builder setQuarterSummaryFour(ThincItCodeBreakerQuarterSummary value) {
            this.validate(this.fields()[11], (Object)value);
            this.quarterSummaryFourBuilder = null;
            this.quarterSummaryFour = value;
            this.fieldSetFlags()[11] = true;
            return this;
        }

        public boolean hasQuarterSummaryFour() {
            return this.fieldSetFlags()[11];
        }

        public ThincItCodeBreakerQuarterSummary.Builder getQuarterSummaryFourBuilder() {
            if (this.quarterSummaryFourBuilder == null) {
                if (this.hasQuarterSummaryFour()) {
                    this.setQuarterSummaryFourBuilder(ThincItCodeBreakerQuarterSummary.newBuilder(this.quarterSummaryFour));
                } else {
                    this.setQuarterSummaryFourBuilder(ThincItCodeBreakerQuarterSummary.newBuilder());
                }
            }
            return this.quarterSummaryFourBuilder;
        }

        public Builder setQuarterSummaryFourBuilder(ThincItCodeBreakerQuarterSummary.Builder value) {
            this.clearQuarterSummaryFour();
            this.quarterSummaryFourBuilder = value;
            return this;
        }

        public boolean hasQuarterSummaryFourBuilder() {
            return this.quarterSummaryFourBuilder != null;
        }

        public Builder clearQuarterSummaryFour() {
            this.quarterSummaryFour = null;
            this.quarterSummaryFourBuilder = null;
            this.fieldSetFlags()[11] = false;
            return this;
        }

        public int getAppVersion() {
            return this.appVersion;
        }

        public Builder setAppVersion(int value) {
            this.validate(this.fields()[12], value);
            this.appVersion = value;
            this.fieldSetFlags()[12] = true;
            return this;
        }

        public boolean hasAppVersion() {
            return this.fieldSetFlags()[12];
        }

        public Builder clearAppVersion() {
            this.fieldSetFlags()[12] = false;
            return this;
        }

        public ThincItCodeBreaker build() {
            try {
                ThincItCodeBreaker record = new ThincItCodeBreaker();
                record.time = this.fieldSetFlags()[0] ? this.time : (Double)this.defaultValue(this.fields()[0]);
                record.timeCompleted = this.fieldSetFlags()[1] ? this.timeCompleted : (Double)this.defaultValue(this.fields()[1]);
                record.score = this.fieldSetFlags()[2] ? this.score : (Integer)this.defaultValue(this.fields()[2]);
                record.completed = this.fieldSetFlags()[3] ? this.completed : (Integer)this.defaultValue(this.fields()[3]);
                record.incorrect = this.fieldSetFlags()[4] ? this.incorrect : (Integer)this.defaultValue(this.fields()[4]);
                record.longestTrial = this.fieldSetFlags()[5] ? this.longestTrial : (Integer)this.defaultValue(this.fields()[5]);
                record.iqrCompletion = this.fieldSetFlags()[6] ? this.iqrCompletion : (Integer)this.defaultValue(this.fields()[6]);
                ThincItInputType thincItInputType = record.inputType = this.fieldSetFlags()[7] ? this.inputType : (ThincItInputType)((Object)this.defaultValue(this.fields()[7]));
                if (this.quarterSummaryOneBuilder != null) {
                    try {
                        record.quarterSummaryOne = this.quarterSummaryOneBuilder.build();
                    }
                    catch (AvroMissingFieldException e) {
                        e.addParentField(record.getSchema().getField("quarterSummaryOne"));
                        throw e;
                    }
                } else {
                    ThincItCodeBreakerQuarterSummary thincItCodeBreakerQuarterSummary = record.quarterSummaryOne = this.fieldSetFlags()[8] ? this.quarterSummaryOne : (ThincItCodeBreakerQuarterSummary)((Object)this.defaultValue(this.fields()[8]));
                }
                if (this.quarterSummaryTwoBuilder != null) {
                    try {
                        record.quarterSummaryTwo = this.quarterSummaryTwoBuilder.build();
                    }
                    catch (AvroMissingFieldException e) {
                        e.addParentField(record.getSchema().getField("quarterSummaryTwo"));
                        throw e;
                    }
                } else {
                    ThincItCodeBreakerQuarterSummary thincItCodeBreakerQuarterSummary = record.quarterSummaryTwo = this.fieldSetFlags()[9] ? this.quarterSummaryTwo : (ThincItCodeBreakerQuarterSummary)((Object)this.defaultValue(this.fields()[9]));
                }
                if (this.quarterSummaryThreeBuilder != null) {
                    try {
                        record.quarterSummaryThree = this.quarterSummaryThreeBuilder.build();
                    }
                    catch (AvroMissingFieldException e) {
                        e.addParentField(record.getSchema().getField("quarterSummaryThree"));
                        throw e;
                    }
                } else {
                    ThincItCodeBreakerQuarterSummary thincItCodeBreakerQuarterSummary = record.quarterSummaryThree = this.fieldSetFlags()[10] ? this.quarterSummaryThree : (ThincItCodeBreakerQuarterSummary)((Object)this.defaultValue(this.fields()[10]));
                }
                if (this.quarterSummaryFourBuilder != null) {
                    try {
                        record.quarterSummaryFour = this.quarterSummaryFourBuilder.build();
                    }
                    catch (AvroMissingFieldException e) {
                        e.addParentField(record.getSchema().getField("quarterSummaryFour"));
                        throw e;
                    }
                } else {
                    record.quarterSummaryFour = this.fieldSetFlags()[11] ? this.quarterSummaryFour : (ThincItCodeBreakerQuarterSummary)((Object)this.defaultValue(this.fields()[11]));
                }
                record.appVersion = this.fieldSetFlags()[12] ? this.appVersion : (Integer)this.defaultValue(this.fields()[12]);
                return record;
            }
            catch (AvroMissingFieldException e) {
                throw e;
            }
            catch (Exception e) {
                throw new AvroRuntimeException((Throwable)e);
            }
        }
    }
}

