/*
 * Decompiled with CFR 0.152.
 */
package org.radarbase.stream;

import java.util.concurrent.TimeUnit;
import org.radarcns.catalogue.TimeWindow;

public enum TimeWindowMetadata {
    TEN_SECOND(TimeWindow.TEN_SECOND, TimeUnit.SECONDS.toMillis(10L), "_10sec"),
    ONE_MIN(TimeWindow.ONE_MIN, TimeUnit.MINUTES.toMillis(1L), "_1min"),
    TEN_MIN(TimeWindow.TEN_MIN, TimeUnit.MINUTES.toMillis(10L), "_10min"),
    ONE_HOUR(TimeWindow.ONE_HOUR, TimeUnit.HOURS.toMillis(1L), "_1hour"),
    ONE_DAY(TimeWindow.ONE_DAY, TimeUnit.DAYS.toMillis(1L), "_1day"),
    ONE_WEEK(TimeWindow.ONE_WEEK, TimeUnit.DAYS.toMillis(7L), "_1week");

    private final TimeWindow timeWindow;
    private final long intervalInMilliSec;
    private final String label;

    private TimeWindowMetadata(TimeWindow timeWindow, long intervalInMilliSec, String label) {
        this.timeWindow = timeWindow;
        this.intervalInMilliSec = intervalInMilliSec;
        this.label = label;
    }

    public TimeWindow getTimeWindow() {
        return this.timeWindow;
    }

    public long getIntervalInMilliSec() {
        return this.intervalInMilliSec;
    }

    public String getTopicLabel(String topic) {
        return topic + this.label;
    }

    public static TimeWindowMetadata getMetadata(TimeWindow timeWindow) {
        switch (timeWindow) {
            case TEN_SECOND: {
                return TEN_SECOND;
            }
            case ONE_MIN: {
                return ONE_MIN;
            }
            case TEN_MIN: {
                return TEN_MIN;
            }
            case ONE_HOUR: {
                return ONE_HOUR;
            }
            case ONE_DAY: {
                return ONE_DAY;
            }
            case ONE_WEEK: {
                return ONE_WEEK;
            }
        }
        return null;
    }
}

