/*
 * Decompiled with CFR 0.152.
 */
package org.radarbase.jersey.hibernate;

import jakarta.ws.rs.core.Context;
import java.util.Map;
import java.util.Properties;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.spi.PersistenceUnitInfo;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.InlineMarker;
import kotlin.jvm.internal.Intrinsics;
import org.glassfish.jersey.internal.inject.DisposableSupplier;
import org.hibernate.jpa.HibernatePersistenceProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.radarbase.jersey.hibernate.config.DatabaseConfig;
import org.radarbase.jersey.hibernate.config.RadarPersistenceInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u0000 \u000e2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u000eB\u000f\u0012\b\b\u0001\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0012\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\u0002H\u0016J\b\u0010\r\u001a\u00020\u0002H\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lorg/radarbase/jersey/hibernate/RadarEntityManagerFactoryFactory;", "Lorg/glassfish/jersey/internal/inject/DisposableSupplier;", "Ljavax/persistence/EntityManagerFactory;", "config", "Lorg/radarbase/jersey/hibernate/config/DatabaseConfig;", "(Lorg/radarbase/jersey/hibernate/config/DatabaseConfig;)V", "persistenceInfo", "Lorg/radarbase/jersey/hibernate/config/RadarPersistenceInfo;", "persistenceProvider", "Lorg/hibernate/jpa/HibernatePersistenceProvider;", "dispose", "", "instance", "get", "Companion", "radar-jersey-hibernate"})
public final class RadarEntityManagerFactoryFactory
implements DisposableSupplier<EntityManagerFactory> {
    private final RadarPersistenceInfo persistenceInfo;
    private final HibernatePersistenceProvider persistenceProvider;
    private static final Logger logger;
    @NotNull
    public static final Companion Companion;

    @NotNull
    public EntityManagerFactory get() {
        logger.info("Initializing EntityManagerFactory with config: " + this.persistenceInfo);
        EntityManagerFactory entityManagerFactory = this.persistenceProvider.createContainerEntityManagerFactory((PersistenceUnitInfo)this.persistenceInfo, (Map)new Properties());
        Intrinsics.checkNotNullExpressionValue((Object)entityManagerFactory, (String)"persistenceProvider.crea\u2026stenceInfo, Properties())");
        return entityManagerFactory;
    }

    public void dispose(@Nullable EntityManagerFactory instance) {
        block0: {
            logger.info("Disposing EntityManagerFactory");
            EntityManagerFactory entityManagerFactory = instance;
            if (entityManagerFactory == null) break block0;
            entityManagerFactory.close();
        }
    }

    public RadarEntityManagerFactoryFactory(@Context @NotNull DatabaseConfig config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        this.persistenceInfo = new RadarPersistenceInfo(config);
        this.persistenceProvider = new HibernatePersistenceProvider();
    }

    static {
        Companion = new Companion(null);
        logger = LoggerFactory.getLogger(RadarEntityManagerFactoryFactory.class);
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J/\u0010\u0006\u001a\u0002H\u0007\"\u0004\b\u0000\u0010\u0007*\u00020\b2\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u0002H\u00070\nH\u0086\b\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\fR\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006\r"}, d2={"Lorg/radarbase/jersey/hibernate/RadarEntityManagerFactoryFactory$Companion;", "", "()V", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "useEntityManager", "T", "Ljavax/persistence/EntityManagerFactory;", "method", "Lkotlin/Function1;", "Ljavax/persistence/EntityManager;", "(Ljavax/persistence/EntityManagerFactory;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "radar-jersey-hibernate"})
    public static final class Companion {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final <T> T useEntityManager(@NotNull EntityManagerFactory $this$useEntityManager, @NotNull Function1<? super EntityManager, ? extends T> method) {
            Object object;
            int $i$f$useEntityManager = 0;
            Intrinsics.checkNotNullParameter((Object)$this$useEntityManager, (String)"$this$useEntityManager");
            Intrinsics.checkNotNullParameter(method, (String)"method");
            EntityManager entityManager = $this$useEntityManager.createEntityManager();
            try {
                EntityManager entityManager2 = entityManager;
                Intrinsics.checkNotNullExpressionValue((Object)entityManager2, (String)"entityManager");
                object = method.invoke((Object)entityManager2);
            }
            finally {
                InlineMarker.finallyStart((int)1);
                entityManager.close();
                InlineMarker.finallyEnd((int)1);
            }
            return (T)object;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

