/*
 * Decompiled with CFR 0.152.
 */
package org.radarbase.jersey.hibernate;

import jakarta.inject.Provider;
import jakarta.ws.rs.core.Context;
import java.time.Duration;
import javax.persistence.EntityManager;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.radarbase.jersey.hibernate.DatabaseHealthMetrics;
import org.radarbase.jersey.hibernate.RadarEntityManagerFactory;
import org.radarbase.jersey.hibernate.config.DatabaseConfig;
import org.radarbase.jersey.service.HealthService;
import org.radarbase.jersey.util.CacheConfig;
import org.radarbase.jersey.util.CachedValue;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u001f\u0012\u000e\b\u0001\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\b\b\u0001\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\b\u0010\u0012\u001a\u00020\nH\u0002R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\u00020\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0013"}, d2={"Lorg/radarbase/jersey/hibernate/DatabaseHealthMetrics;", "Lorg/radarbase/jersey/service/HealthService$Metric;", "entityManager", "Ljakarta/inject/Provider;", "Ljavax/persistence/EntityManager;", "dbConfig", "Lorg/radarbase/jersey/hibernate/config/DatabaseConfig;", "(Ljakarta/inject/Provider;Lorg/radarbase/jersey/hibernate/config/DatabaseConfig;)V", "cachedStatus", "Lorg/radarbase/jersey/util/CachedValue;", "Lorg/radarbase/jersey/service/HealthService$Status;", "metrics", "", "getMetrics", "()Ljava/lang/Object;", "status", "getStatus", "()Lorg/radarbase/jersey/service/HealthService$Status;", "testConnection", "radar-jersey-hibernate"})
public final class DatabaseHealthMetrics
extends HealthService.Metric {
    private final CachedValue<HealthService.Status> cachedStatus;
    private final Provider<EntityManager> entityManager;

    @NotNull
    public HealthService.Status getStatus() {
        return (HealthService.Status)this.cachedStatus.get((Function1)status.1.INSTANCE);
    }

    @NotNull
    public Object getMetrics() {
        return MapsKt.mapOf((Pair)TuplesKt.to((Object)"status", (Object)this.getStatus()));
    }

    private final HealthService.Status testConnection() {
        HealthService.Status status2;
        try {
            Object object = this.entityManager.get();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"entityManager.get()");
            RadarEntityManagerFactory.Companion.connection((EntityManager)object).close();
            status2 = HealthService.Status.UP;
        }
        catch (Throwable ex) {
            status2 = HealthService.Status.DOWN;
        }
        return status2;
    }

    public DatabaseHealthMetrics(@Context @NotNull Provider<EntityManager> entityManager, @Context @NotNull DatabaseConfig dbConfig) {
        Intrinsics.checkNotNullParameter(entityManager, (String)"entityManager");
        Intrinsics.checkNotNullParameter((Object)dbConfig, (String)"dbConfig");
        super("db");
        this.entityManager = entityManager;
        Duration duration = Duration.ofSeconds(dbConfig.getHealthCheckValiditySeconds());
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"Duration.ofSeconds(dbCon\u2026althCheckValiditySeconds)");
        Duration duration2 = Duration.ofSeconds(dbConfig.getHealthCheckValiditySeconds());
        Intrinsics.checkNotNullExpressionValue((Object)duration2, (String)"Duration.ofSeconds(dbCon\u2026althCheckValiditySeconds)");
        this.cachedStatus = new CachedValue(new CacheConfig(duration, duration2, null, false, null, 0, 60, null), (Function0)new Function0<HealthService.Status>(this){

            @NotNull
            public final HealthService.Status invoke() {
                return DatabaseHealthMetrics.access$testConnection((DatabaseHealthMetrics)((Object)this.receiver));
            }
        }, null, 4, null);
    }

    public static final /* synthetic */ HealthService.Status access$testConnection(DatabaseHealthMetrics $this) {
        return $this.testConnection();
    }
}

