/*
 * Decompiled with CFR 0.152.
 */
package org.radarbase.util;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Iterator;
import java.util.regex.Pattern;

public final class Strings {
    private static final Charset UTF_8 = StandardCharsets.UTF_8;
    private static final char[] HEX_ARRAY = "0123456789ABCDEF".toCharArray();

    private Strings() {
    }

    public static Pattern[] containsPatterns(Collection<String> contains) {
        Pattern[] patterns = new Pattern[contains.size()];
        Iterator<String> containsIterator = contains.iterator();
        for (int i = 0; i < patterns.length; ++i) {
            patterns[i] = Strings.containsIgnoreCasePattern(containsIterator.next());
        }
        return patterns;
    }

    public static Pattern containsIgnoreCasePattern(String containsString) {
        int flags = 82;
        return Pattern.compile(containsString, flags);
    }

    public static boolean findAny(Pattern[] patterns, CharSequence value) {
        for (Pattern pattern : patterns) {
            if (!pattern.matcher(value).find()) continue;
            return true;
        }
        return false;
    }

    public static byte[] utf8(String value) {
        return value.getBytes(UTF_8);
    }

    public static boolean isNullOrEmpty(String value) {
        return value == null || value.isEmpty();
    }

    public static String bytesToHex(byte[] bytes) {
        char[] hexChars = new char[bytes.length * 2];
        for (int i = 0; i < bytes.length; ++i) {
            int value = bytes[i] & 0xFF;
            hexChars[i * 2] = HEX_ARRAY[value >>> 4];
            hexChars[i * 2 + 1] = HEX_ARRAY[value & 0xF];
        }
        return new String(hexChars);
    }
}

