/*
 * Decompiled with CFR 0.152.
 */
package org.radarbase.topic;

import org.apache.avro.Schema;
import org.apache.avro.specific.SpecificRecord;
import org.radarbase.topic.AvroTopic;

public class SensorTopic<K, V>
extends AvroTopic<K, V> {
    public SensorTopic(String name, Schema keySchema, Schema valueSchema, Class<? extends K> keyClass, Class<? extends V> valueClass) {
        super(name, keySchema, valueSchema, keyClass, valueClass);
        if (keySchema.getType() != Schema.Type.RECORD) {
            throw new IllegalArgumentException("Sensors must send records as keys");
        }
        if (valueSchema.getType() != Schema.Type.RECORD) {
            throw new IllegalArgumentException("Sensors must send records as values");
        }
        if (keySchema.getField("projectId") == null) {
            throw new IllegalArgumentException("Key schema must have a project ID");
        }
        if (keySchema.getField("userId") == null) {
            throw new IllegalArgumentException("Key schema must have a user ID");
        }
        if (keySchema.getField("sourceId") == null) {
            throw new IllegalArgumentException("Key schema must have a source ID");
        }
        if (valueSchema.getField("time") == null) {
            throw new IllegalArgumentException("Schema must have time as its first field");
        }
        if (valueSchema.getField("timeReceived") == null) {
            throw new IllegalArgumentException("Schema must have timeReceived as a field");
        }
    }

    public static <K extends SpecificRecord, V extends SpecificRecord> SensorTopic<K, V> parse(String topic, String keySchema, String valueSchema) {
        AvroTopic parseAvro = AvroTopic.parse(topic, keySchema, valueSchema);
        return new SensorTopic(parseAvro.getName(), parseAvro.getKeySchema(), parseAvro.getValueSchema(), parseAvro.getKeyClass(), parseAvro.getValueClass());
    }
}

