/*
 * Decompiled with CFR 0.152.
 */
package org.radarbase.producer.rest;

import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import org.apache.avro.Schema;
import org.json.JSONException;
import org.radarbase.config.ServerConfig;
import org.radarbase.producer.rest.ParsedSchemaMetadata;
import org.radarbase.producer.rest.RestClient;
import org.radarbase.producer.rest.RestException;
import org.radarbase.producer.rest.SchemaRestClient;
import org.radarbase.util.TimedInt;
import org.radarbase.util.TimedValue;
import org.radarbase.util.TimedVariable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SchemaRetriever {
    private static final Logger logger = LoggerFactory.getLogger(SchemaRetriever.class);
    private static final long MAX_VALIDITY = 86400L;
    private final ConcurrentMap<Integer, TimedValue<Schema>> idCache = new ConcurrentHashMap<Integer, TimedValue<Schema>>();
    private final ConcurrentMap<Schema, TimedInt> schemaCache = new ConcurrentHashMap<Schema, TimedInt>();
    private final ConcurrentMap<String, ConcurrentMap<Integer, TimedInt>> subjectVersionCache = new ConcurrentHashMap<String, ConcurrentMap<Integer, TimedInt>>();
    private final SchemaRestClient restClient;
    private final long cacheValidity;

    public SchemaRetriever(RestClient client, long cacheValidity) {
        this.restClient = new SchemaRestClient(client);
        this.cacheValidity = cacheValidity;
    }

    public SchemaRetriever(RestClient client) {
        this(client, 86400L);
    }

    public SchemaRetriever(ServerConfig config, long connectionTimeout) {
        this(RestClient.global().server(Objects.requireNonNull(config)).timeout(connectionTimeout, TimeUnit.SECONDS).build());
    }

    public SchemaRetriever(ServerConfig config, long connectionTimeout, long cacheValidity) {
        this(RestClient.global().server(Objects.requireNonNull(config)).timeout(connectionTimeout, TimeUnit.SECONDS).build(), cacheValidity);
    }

    public int addSchema(String topic, boolean ofValue, Schema schema) throws JSONException, IOException {
        String subject = SchemaRetriever.subject(topic, ofValue);
        int id = this.restClient.addSchema(subject, schema);
        this.cache(new ParsedSchemaMetadata(id, null, schema), subject, false);
        return id;
    }

    public ParsedSchemaMetadata getOrSetSchemaMetadata(String topic, boolean ofValue, Schema schema, int version) throws JSONException, IOException {
        try {
            return this.getBySubjectAndVersion(topic, ofValue, version);
        }
        catch (RestException ex) {
            if (ex.getStatusCode() == 404) {
                logger.warn("Schema for {} value was not yet added to the schema registry.", (Object)topic);
                this.addSchema(topic, ofValue, schema);
                return this.getMetadata(topic, ofValue, schema, version <= 0);
            }
            throw ex;
        }
    }

    public Schema getById(int id) throws IOException {
        TimedValue<Schema> value = (TimedValue<Schema>)this.idCache.get(id);
        if (value == null || value.isExpired()) {
            value = new TimedValue<Schema>(this.restClient.retrieveSchemaById(id), this.cacheValidity);
            this.idCache.put(id, value);
            this.schemaCache.put((Schema)value.value, new TimedInt(id, this.cacheValidity));
        }
        return (Schema)value.value;
    }

    public ParsedSchemaMetadata getBySubjectAndId(String topic, boolean ofValue, int id) throws IOException {
        Schema schema = this.getById(id);
        String subject = SchemaRetriever.subject(topic, ofValue);
        ParsedSchemaMetadata metadata = this.getCachedVersion(subject, id, null, schema);
        return metadata != null ? metadata : this.getMetadata(topic, ofValue, schema);
    }

    public ParsedSchemaMetadata getBySubjectAndVersion(String topic, boolean ofValue, int version) throws JSONException, IOException {
        String subject = SchemaRetriever.subject(topic, ofValue);
        ConcurrentMap versionMap = SchemaRetriever.computeIfAbsent(this.subjectVersionCache, subject, new ConcurrentHashMap());
        TimedInt id = (TimedInt)versionMap.get(Math.max(version, 0));
        if (id == null || id.isExpired()) {
            ParsedSchemaMetadata metadata = this.restClient.retrieveSchemaMetadata(subject, version);
            this.cache(metadata, subject, version <= 0);
            return metadata;
        }
        Schema schema = this.getById(id.value);
        ParsedSchemaMetadata metadata = this.getCachedVersion(subject, id.value, version, schema);
        return metadata != null ? metadata : this.getMetadata(topic, ofValue, schema, version <= 0);
    }

    public ParsedSchemaMetadata getMetadata(String topic, boolean ofValue, Schema schema) throws IOException {
        return this.getMetadata(topic, ofValue, schema, false);
    }

    public ParsedSchemaMetadata getMetadata(String topic, boolean ofValue, Schema schema, boolean ofLatestVersion) throws IOException {
        ParsedSchemaMetadata metadata;
        TimedInt id = (TimedInt)this.schemaCache.get(schema);
        String subject = SchemaRetriever.subject(topic, ofValue);
        if (id != null && !id.isExpired() && (metadata = this.getCachedVersion(subject, id.value, null, schema)) != null) {
            return metadata;
        }
        metadata = this.restClient.requestMetadata(subject, schema);
        this.cache(metadata, subject, ofLatestVersion);
        return metadata;
    }

    protected ParsedSchemaMetadata getCachedVersion(String subject, int id, Integer reportedVersion, Schema schema) {
        ConcurrentMap versions;
        Integer version = reportedVersion;
        if (!(version != null && version > 0 || (version = this.findCachedVersion(id, versions = (ConcurrentMap)this.subjectVersionCache.get(subject))) != null && version > 0)) {
            return null;
        }
        return new ParsedSchemaMetadata(id, version, schema);
    }

    private Integer findCachedVersion(int id, ConcurrentMap<Integer, TimedInt> cache) {
        if (cache == null) {
            return null;
        }
        for (Map.Entry entry : cache.entrySet()) {
            if (((TimedInt)entry.getValue()).isExpired() || (Integer)entry.getKey() == 0 || ((TimedInt)entry.getValue()).value != id) continue;
            return (Integer)entry.getKey();
        }
        return null;
    }

    protected void cache(ParsedSchemaMetadata metadata, String subject, boolean latest) {
        TimedInt id = new TimedInt(metadata.getId(), this.cacheValidity);
        this.schemaCache.put(metadata.getSchema(), id);
        if (metadata.getVersion() != null) {
            ConcurrentMap versionCache = SchemaRetriever.computeIfAbsent(this.subjectVersionCache, subject, new ConcurrentHashMap());
            versionCache.put(metadata.getVersion(), id);
            if (latest) {
                versionCache.put(0, id);
            }
        }
        this.idCache.put(metadata.getId(), new TimedValue<Schema>(metadata.getSchema(), this.cacheValidity));
    }

    public void pruneCache() {
        SchemaRetriever.prune(this.schemaCache);
        SchemaRetriever.prune(this.idCache);
        for (ConcurrentMap versionMap : this.subjectVersionCache.values()) {
            SchemaRetriever.prune(versionMap);
        }
    }

    public void clearCache() {
        this.subjectVersionCache.clear();
        this.idCache.clear();
        this.schemaCache.clear();
    }

    protected static String subject(String topic, boolean ofValue) {
        return topic + (ofValue ? "-value" : "-key");
    }

    private static void prune(Map<?, ? extends TimedVariable> map) {
        for (Map.Entry<?, TimedVariable> entry : map.entrySet()) {
            if (!entry.getValue().isExpired()) continue;
            map.remove(entry.getKey(), entry.getValue());
        }
    }

    private static <K, V> V computeIfAbsent(ConcurrentMap<K, V> original, K key, V newValue) {
        V existingValue = original.putIfAbsent(key, newValue);
        return existingValue != null ? existingValue : newValue;
    }
}

