/*
 * Decompiled with CFR 0.152.
 */
package org.radarbase.data;

import java.io.IOException;
import org.apache.avro.Schema;
import org.apache.avro.SchemaValidationException;
import org.apache.avro.generic.GenericData;
import org.apache.avro.specific.SpecificData;
import org.apache.avro.specific.SpecificRecord;
import org.radarbase.data.AvroDatumEncoder;
import org.radarbase.data.AvroEncoder;
import org.radarbase.producer.rest.AvroDataMapper;
import org.radarbase.producer.rest.AvroDataMapperFactory;
import org.radarbase.producer.rest.ParsedSchemaMetadata;

public class RemoteSchemaEncoder
implements AvroEncoder {
    private final boolean binary;

    public RemoteSchemaEncoder(boolean binary) {
        this.binary = binary;
    }

    @Override
    public <T> AvroEncoder.AvroWriter<T> writer(Schema schema, Class<? extends T> clazz) {
        return new SchemaEncoderWriter<T>(schema, clazz);
    }

    private class SchemaEncoderWriter<T>
    implements AvroEncoder.AvroWriter<T> {
        private final AvroEncoder recordEncoder;
        private AvroEncoder.AvroWriter<Object> encoder;
        private final boolean isGeneric;
        private ParsedSchemaMetadata serverSchema;
        private AvroDataMapper mapper;
        private final Schema schema;

        SchemaEncoderWriter(Schema schema, Class<? extends T> clazz) {
            SpecificData genericData;
            this.schema = schema;
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            if (SpecificRecord.class.isAssignableFrom(clazz)) {
                genericData = new SpecificData(classLoader);
                this.isGeneric = false;
            } else {
                genericData = new GenericData(classLoader);
                this.isGeneric = true;
            }
            this.recordEncoder = new AvroDatumEncoder((GenericData)genericData, RemoteSchemaEncoder.this.binary);
        }

        @Override
        public byte[] encode(T object) throws IOException {
            return this.encoder.encode(this.mapper.convertAvro(object));
        }

        @Override
        public final void setReaderSchema(ParsedSchemaMetadata readerSchema) throws SchemaValidationException {
            if (this.serverSchema != null && readerSchema.getSchema().equals((Object)this.serverSchema.getSchema())) {
                return;
            }
            try {
                if (!this.isGeneric) {
                    this.mapper = AvroDataMapperFactory.IDENTITY_MAPPER;
                    this.encoder = this.recordEncoder.writer(this.schema, Object.class);
                } else {
                    this.mapper = AvroDataMapperFactory.get().createMapper(this.schema, readerSchema.getSchema(), null);
                    this.encoder = this.recordEncoder.writer(readerSchema.getSchema(), Object.class);
                }
                this.serverSchema = readerSchema;
            }
            catch (IOException ex) {
                throw new IllegalStateException("Cannot construct Avro writer", ex);
            }
        }

        @Override
        public ParsedSchemaMetadata getReaderSchema() {
            return this.serverSchema;
        }
    }
}

