/*
 * Decompiled with CFR 0.152.
 */
package org.radarbase.data;

import java.io.IOException;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.avro.io.DatumWriter;
import org.apache.avro.io.EncoderFactory;
import org.radarbase.data.AvroEncoder;
import org.radarbase.data.AvroRecordWriter;

public class AvroDatumEncoder
implements AvroEncoder {
    private final EncoderFactory encoderFactory;
    private final boolean binary;
    private final GenericData genericData;

    public AvroDatumEncoder(GenericData genericData, boolean binary) {
        this.genericData = genericData;
        this.encoderFactory = EncoderFactory.get();
        this.binary = binary;
    }

    @Override
    public <T> AvroEncoder.AvroWriter<T> writer(Schema schema, Class<? extends T> clazz) throws IOException {
        DatumWriter writer = this.genericData.createDatumWriter(schema);
        return new AvroRecordWriter(this.encoderFactory, schema, writer, this.binary);
    }
}

