/*
 * Decompiled with CFR 0.152.
 */
package org.radarbase.config;

import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.URL;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import okhttp3.HttpUrl;

public class ServerConfig {
    private static final Pattern URL_PATTERN = Pattern.compile("(?:(?<protocol>\\w+)://)?(?<host>[^:/]+)(?::(?<port>\\d+))?(?<path>/.*)?");
    private String host;
    private int port = -1;
    private String protocol;
    private String path = null;
    private String proxyHost;
    private int proxyPort = -1;
    private boolean unsafe = false;

    public ServerConfig() {
    }

    public ServerConfig(URL url) {
        this.host = url.getHost();
        this.port = url.getPort();
        this.protocol = url.getProtocol();
        this.setPath(url.getFile());
    }

    public ServerConfig(String urlString) throws MalformedURLException {
        Matcher matcher = URL_PATTERN.matcher(urlString);
        if (!matcher.matches()) {
            throw new MalformedURLException("Cannot create URL from string " + urlString);
        }
        this.protocol = matcher.group("protocol");
        this.host = matcher.group("host");
        String portString = matcher.group("port");
        if (portString != null && !portString.isEmpty()) {
            this.port = Integer.parseInt(portString);
        }
        this.setPath(matcher.group("path"));
    }

    public String getUrlString() {
        StringBuilder builder = new StringBuilder(this.host.length() + (this.path != null ? this.path.length() : 0) + 20);
        this.appendUrlString(builder);
        return builder.toString();
    }

    private void appendUrlString(StringBuilder builder) {
        if (this.protocol != null) {
            builder.append(this.protocol).append("://");
        }
        builder.append(this.host);
        if (this.port != -1) {
            builder.append(':').append(this.port);
        }
        if (this.path != null) {
            builder.append(this.path);
        }
    }

    public static String getPaths(List<ServerConfig> configList) {
        StringBuilder builder = new StringBuilder(configList.size() * 40);
        boolean first = true;
        for (ServerConfig server : configList) {
            if (first) {
                first = false;
            } else {
                builder.append(',');
            }
            server.appendUrlString(builder);
        }
        return builder.toString();
    }

    public URL getUrl() {
        if (this.protocol == null || this.host == null) {
            throw new IllegalStateException("Cannot create URL without protocol and host");
        }
        try {
            return new URL(this.protocol, this.host, this.port, this.path == null ? "" : this.path);
        }
        catch (MalformedURLException ex) {
            throw new IllegalStateException("Already parsed a URL but it turned out invalid", ex);
        }
    }

    public HttpUrl getHttpUrl() {
        if (this.protocol == null) {
            this.protocol = "http";
        }
        return HttpUrl.get((String)this.getUrlString());
    }

    public Proxy getHttpProxy() {
        if (this.proxyHost == null) {
            return null;
        }
        if (this.proxyPort == -1) {
            throw new IllegalStateException("proxy_port is not specified for server " + this.getUrlString() + " with proxyHost");
        }
        if (this.protocol != null && !this.protocol.equalsIgnoreCase("http") && !this.protocol.equalsIgnoreCase("https")) {
            throw new IllegalStateException("Server is not an HTTP(S) server, so it cannot use a HTTP proxyHost.");
        }
        return new Proxy(Proxy.Type.HTTP, new InetSocketAddress(this.proxyHost, this.proxyPort));
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    public String getProxyHost() {
        return this.proxyHost;
    }

    public void setProxyHost(String proxyHost) {
        this.proxyHost = proxyHost;
    }

    public int getProxyPort() {
        return this.proxyPort;
    }

    public void setProxyPort(int proxyPort) {
        this.proxyPort = proxyPort;
    }

    public String getPath() {
        return this.path;
    }

    public final void setPath(String path) {
        this.path = ServerConfig.cleanPath(path);
    }

    private static String cleanPath(String path) {
        if (path == null) {
            return null;
        }
        if (path.contains("?") || path.contains("#")) {
            throw new IllegalArgumentException("Cannot set server path with query string");
        }
        Object newPath = path.trim();
        if (((String)newPath).isEmpty()) {
            return "/";
        }
        if (((String)newPath).charAt(0) != '/') {
            newPath = "/" + (String)newPath;
        }
        if (((String)newPath).charAt(((String)newPath).length() - 1) != '/') {
            newPath = (String)newPath + "/";
        }
        return newPath;
    }

    public String toString() {
        return this.getUrlString();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        ServerConfig otherConfig = (ServerConfig)other;
        return Objects.equals(this.host, otherConfig.host) && this.port == otherConfig.port && this.unsafe == otherConfig.unsafe && Objects.equals(this.protocol, otherConfig.protocol) && Objects.equals(this.proxyHost, otherConfig.proxyHost) && this.proxyPort == otherConfig.proxyPort;
    }

    public int hashCode() {
        return Objects.hash(this.protocol, this.host, this.port);
    }

    public boolean isUnsafe() {
        return this.unsafe;
    }

    public void setUnsafe(boolean unsafe) {
        this.unsafe = unsafe;
    }
}

