/*
 * Decompiled with CFR 0.152.
 */
package org.quickperf.spring.sql;

import java.lang.reflect.Method;
import javax.sql.DataSource;
import org.aopalliance.aop.Advice;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.quickperf.sql.config.QuickPerfSqlDataSourceBuilder;
import org.springframework.aop.framework.ProxyFactory;
import org.springframework.aop.scope.ScopedProxyUtils;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.core.Ordered;
import org.springframework.util.ReflectionUtils;

public class QuickPerfProxyBeanPostProcessor
implements BeanPostProcessor,
Ordered {
    public Object postProcessBeforeInitialization(Object bean, String beanName) {
        return bean;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) {
        if (bean instanceof DataSource && !ScopedProxyUtils.isScopedTarget((String)beanName)) {
            ProxyFactory factory = new ProxyFactory(bean);
            factory.setProxyTargetClass(true);
            factory.addAdvice((Advice)new ProxyDataSourceInterceptor((DataSource)bean));
            return factory.getProxy();
        }
        return bean;
    }

    public int getOrder() {
        return 0x7FFFFFFE;
    }

    private static class ProxyDataSourceInterceptor
    implements MethodInterceptor {
        private final DataSource datasourceProxy;

        public ProxyDataSourceInterceptor(DataSource dataSource) {
            this.datasourceProxy = QuickPerfSqlDataSourceBuilder.aDataSourceBuilder().buildProxy(dataSource);
        }

        public Object invoke(MethodInvocation invocation) throws Throwable {
            Method proxyMethod = ReflectionUtils.findMethod(this.datasourceProxy.getClass(), (String)invocation.getMethod().getName());
            if (proxyMethod != null) {
                return proxyMethod.invoke((Object)this.datasourceProxy, invocation.getArguments());
            }
            return invocation.proceed();
        }
    }
}

