/*
 * Decompiled with CFR 0.152.
 */
package org.quickperf.sql.time;

import java.util.concurrent.TimeUnit;
import org.quickperf.issue.PerfIssue;
import org.quickperf.issue.VerifiablePerformanceIssue;
import org.quickperf.measure.PerfMeasure;
import org.quickperf.sql.annotation.ExpectMaxQueryExecutionTime;
import org.quickperf.time.ExecutionTime;

public class SqlQueryMaxExecutionTimeVerifier
implements VerifiablePerformanceIssue<ExpectMaxQueryExecutionTime, ExecutionTime> {
    public static final SqlQueryMaxExecutionTimeVerifier INSTANCE = new SqlQueryMaxExecutionTimeVerifier();

    private SqlQueryMaxExecutionTimeVerifier() {
    }

    public PerfIssue verifyPerfIssue(ExpectMaxQueryExecutionTime annotation, ExecutionTime measure) {
        ExecutionTime maxExpectedSqlExecutionTime = new ExecutionTime(annotation.thresholdInMilliSeconds(), TimeUnit.MILLISECONDS);
        if (measure.isGreaterThan((PerfMeasure)maxExpectedSqlExecutionTime)) {
            return this.buildPerfIssue(measure, maxExpectedSqlExecutionTime);
        }
        return PerfIssue.NONE;
    }

    private PerfIssue buildPerfIssue(ExecutionTime effectiveExecutionTime, ExecutionTime maxExecutionTime) {
        String description = "Query execution time expected to be less than <" + maxExecutionTime.toString() + ">\n\tAt least one query has a greater execution time. The greater query execution time is <" + effectiveExecutionTime.toString() + ">";
        return new PerfIssue(description);
    }
}

