/*
 * Decompiled with CFR 0.152.
 */
package org.quickperf.sql.time;

import java.util.concurrent.TimeUnit;
import org.quickperf.ExtractablePerformanceMeasure;
import org.quickperf.sql.SqlExecution;
import org.quickperf.sql.SqlExecutions;
import org.quickperf.time.ExecutionTime;

public class SqlQueryExecutionTimeExtractor
implements ExtractablePerformanceMeasure<SqlExecutions, ExecutionTime> {
    public static final SqlQueryExecutionTimeExtractor INSTANCE = new SqlQueryExecutionTimeExtractor();

    private SqlQueryExecutionTimeExtractor() {
    }

    public ExecutionTime extractPerfMeasureFrom(SqlExecutions perfRecord) {
        long maxExecutionTime = 0L;
        for (SqlExecution execution : perfRecord) {
            long executionTime = execution.getElapsedTime();
            if (executionTime <= maxExecutionTime) continue;
            maxExecutionTime = executionTime;
        }
        return new ExecutionTime(Long.valueOf(maxExecutionTime), TimeUnit.MILLISECONDS);
    }
}

