/*
 * Decompiled with CFR 0.152.
 */
package org.quickperf.sql.select.analysis;

import org.quickperf.SystemProperties;
import org.quickperf.measure.PerfMeasure;
import org.quickperf.sql.framework.ClassPath;
import org.quickperf.sql.framework.HibernateSuggestion;
import org.quickperf.sql.framework.JdbcSuggestion;
import org.quickperf.sql.framework.MicronautSuggestion;
import org.quickperf.unit.Count;
import org.quickperf.unit.NoUnit;

public class SelectAnalysis
implements PerfMeasure {
    private final Count selectNumber;
    private final SameSelectTypesWithDifferentParamValues sameSelectTypesWithDifferentParamValues;
    private final Count sameSelectsNumber;

    public static String getNPlusOneSelectAlert() {
        if (((Boolean)SystemProperties.SIMPLIFIED_SQL_DISPLAY.evaluate()).booleanValue()) {
            return "";
        }
        return System.lineSeparator() + System.lineSeparator() + JdbcSuggestion.SERVER_ROUND_TRIPS.getMessage() + SelectAnalysis.getNPlusOneFrameworkMessage();
    }

    public static String getNPlusOneFrameworkMessage() {
        if (ClassPath.INSTANCE.containsHibernate()) {
            return System.lineSeparator() + HibernateSuggestion.N_PLUS_ONE_SELECT.getMessage();
        }
        if (ClassPath.INSTANCE.containsMicronautData()) {
            return System.lineSeparator() + MicronautSuggestion.N_PLUS_ONE_SELECT.getMessage();
        }
        return "";
    }

    public SelectAnalysis(int selectNumber, int sameSelectsNumber, boolean sameSelectTypesWithDifferentParamValues) {
        this.selectNumber = new Count(Integer.valueOf(selectNumber));
        this.sameSelectsNumber = new Count(Integer.valueOf(sameSelectsNumber));
        this.sameSelectTypesWithDifferentParamValues = new SameSelectTypesWithDifferentParamValues(sameSelectTypesWithDifferentParamValues);
    }

    public Count getSelectNumber() {
        return this.selectNumber;
    }

    public boolean hasOnlySameSelects() {
        return this.selectNumber.isEqualTo((PerfMeasure)this.sameSelectsNumber);
    }

    public SameSelectTypesWithDifferentParamValues getSameSelectTypesWithDifferentParamValues() {
        return this.sameSelectTypesWithDifferentParamValues;
    }

    public boolean hasSameSelects() {
        return this.sameSelectsNumber.isGreaterThan((PerfMeasure)Count.ZERO);
    }

    public SelectAnalysis getValue() {
        return this;
    }

    public NoUnit getUnit() {
        return NoUnit.INSTANCE;
    }

    public String getComment() {
        return null;
    }

    public static class SameSelectTypesWithDifferentParamValues {
        private final boolean value;

        public SameSelectTypesWithDifferentParamValues(boolean value) {
            this.value = value;
        }

        public boolean evaluate() {
            return this.value;
        }

        public String getSuggestionToFixIt() {
            return SelectAnalysis.getNPlusOneSelectAlert();
        }
    }
}

