/*
 * Decompiled with CFR 0.152.
 */
package org.quickperf.sql.select.analysis;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.ttddyy.dsproxy.QueryInfo;
import net.ttddyy.dsproxy.proxy.ParameterSetOperation;

class QueryParamsExtractor {
    static final QueryParamsExtractor INSTANCE = new QueryParamsExtractor();

    private QueryParamsExtractor() {
    }

    List<Object> getParamsOf(QueryInfo query) {
        List<ParameterSetOperation> parameterSetOperations = this.retrieveParameterSetOperations(query);
        ArrayList<Object> paramsList = new ArrayList<Object>();
        for (ParameterSetOperation parameterSetOperation : parameterSetOperations) {
            Object[] paramsOfThisQuery = parameterSetOperation.getArgs();
            paramsList.add(paramsOfThisQuery[1]);
        }
        return paramsList;
    }

    private List<ParameterSetOperation> retrieveParameterSetOperations(QueryInfo query) {
        List allParametersLists = query.getParametersList();
        if (allParametersLists.isEmpty()) {
            return Collections.emptyList();
        }
        if (allParametersLists.size() > 1) {
            String message = "Several parameter set not managed, please create an issue on https://github.com/quick-perf/quickperf/issues describing your use case.";
            throw new IllegalStateException(message);
        }
        return (List)allParametersLists.get(0);
    }
}

