/*
 * Decompiled with CFR 0.152.
 */
package org.quickperf.sql.select;

import org.quickperf.issue.PerfIssue;
import org.quickperf.issue.VerifiablePerformanceIssue;
import org.quickperf.sql.annotation.DisableSameSelectTypesWithDifferentParamValues;
import org.quickperf.sql.select.analysis.SelectAnalysis;

public class HasSameSelectTypesWithDiffParamValuesVerifier
implements VerifiablePerformanceIssue<DisableSameSelectTypesWithDifferentParamValues, SelectAnalysis> {
    public static final HasSameSelectTypesWithDiffParamValuesVerifier INSTANCE = new HasSameSelectTypesWithDiffParamValuesVerifier();

    private HasSameSelectTypesWithDiffParamValuesVerifier() {
    }

    public PerfIssue verifyPerfIssue(DisableSameSelectTypesWithDifferentParamValues annotation, SelectAnalysis selectAnalysis) {
        SelectAnalysis.SameSelectTypesWithDifferentParamValues sameSelectTypesWithDifferentParamValues = selectAnalysis.getSameSelectTypesWithDifferentParamValues();
        if (sameSelectTypesWithDifferentParamValues.evaluate()) {
            String description = "Same SELECT types with different parameter values";
            description = description + sameSelectTypesWithDifferentParamValues.getSuggestionToFixIt();
            return new PerfIssue(description);
        }
        return PerfIssue.NONE;
    }
}

