/*
 * Decompiled with CFR 0.152.
 */
package org.quickperf.sql.insert;

import org.quickperf.issue.PerfIssue;
import org.quickperf.issue.VerifiablePerformanceIssue;
import org.quickperf.measure.PerfMeasure;
import org.quickperf.sql.SqlStatementPerfIssueBuilder;
import org.quickperf.sql.annotation.ExpectMaxInsert;
import org.quickperf.unit.Count;

public class MaxOfInsertsPerfIssueVerifier
implements VerifiablePerformanceIssue<ExpectMaxInsert, Count> {
    public static final MaxOfInsertsPerfIssueVerifier INSTANCE = new MaxOfInsertsPerfIssueVerifier();

    private MaxOfInsertsPerfIssueVerifier() {
    }

    public PerfIssue verifyPerfIssue(ExpectMaxInsert annotation, Count measuredCount) {
        Count expectedCount = new Count(Integer.valueOf(annotation.value()));
        if (measuredCount.isGreaterThan((PerfMeasure)expectedCount)) {
            return this.buildPerfIssue(measuredCount, expectedCount);
        }
        return PerfIssue.NONE;
    }

    private PerfIssue buildPerfIssue(Count measuredCount, Count expectedCount) {
        String description = SqlStatementPerfIssueBuilder.aSqlPerfIssue().buildMaxOfStatementsDesc(measuredCount, expectedCount, "insert");
        return new PerfIssue(description);
    }
}

