/*
 * Decompiled with CFR 0.152.
 */
package org.quickperf.sql.framework.quickperf;

import org.quickperf.sql.framework.ClassPath;
import org.quickperf.sql.framework.QuickPerfSuggestion;
import org.quickperf.sql.framework.quickperf.QuickPerfDependency;

class SpringDataSourceConfig
implements QuickPerfSuggestion {
    private static final String LINE_SEPARATOR = System.lineSeparator();
    private final ClassPath classPath;

    SpringDataSourceConfig(ClassPath classPath) {
        this.classPath = classPath;
    }

    @Override
    public String getMessage() {
        if (this.classPath.containsSpringBoot1()) {
            if (this.classPath.contains(QuickPerfDependency.QUICKPERF_SPRING_BOOT_1_SQL_STARTER)) {
                return this.buildDataJpaTestAnnotationMessage() + LINE_SEPARATOR + LINE_SEPARATOR + this.buildSpringRESTControllerMessage();
            }
            return "To configure it, add the following dependency: " + LINE_SEPARATOR + this.format(QuickPerfDependency.QUICKPERF_SPRING_BOOT_1_SQL_STARTER);
        }
        if (this.classPath.containsSpringBoot2()) {
            if (this.classPath.contains(QuickPerfDependency.QUICKPERF_SPRING_BOOT_2_SQL_STARTER)) {
                return this.buildDataJpaTestAnnotationMessage() + LINE_SEPARATOR + LINE_SEPARATOR + this.buildSpringRESTControllerMessage();
            }
            return "To configure it, add the following dependency: " + LINE_SEPARATOR + this.format(QuickPerfDependency.QUICKPERF_SPRING_BOOT_2_SQL_STARTER);
        }
        if (this.classPath.containsSpring4()) {
            if (this.classPath.contains(QuickPerfDependency.QUICKPERF_SQL_SPRING_4)) {
                return "Import QuickPerfSqlConfig:" + LINE_SEPARATOR + this.buildImportQuickPerfSqlConfigExample() + LINE_SEPARATOR + LINE_SEPARATOR + this.buildSpringRESTControllerMessage();
            }
            return "To configure the proxy, add the following dependency: " + LINE_SEPARATOR + this.format(QuickPerfDependency.QUICKPERF_SQL_SPRING_4) + LINE_SEPARATOR + "You have also to import QuickPerfSqlConfig:" + LINE_SEPARATOR + this.buildImportQuickPerfSqlConfigExample();
        }
        if (this.classPath.containsSpring5()) {
            if (this.classPath.contains(QuickPerfDependency.QUICKPERF_SQL_SPRING_5)) {
                return "Import QuickPerfSqlConfig:" + LINE_SEPARATOR + this.buildImportQuickPerfSqlConfigExample() + LINE_SEPARATOR + LINE_SEPARATOR + this.buildSpringRESTControllerMessage();
            }
            return "To configure the proxy, add the following dependency: " + LINE_SEPARATOR + this.format(QuickPerfDependency.QUICKPERF_SQL_SPRING_5) + LINE_SEPARATOR + "You have also to import QuickPerfSqlConfig:" + LINE_SEPARATOR + this.buildImportQuickPerfSqlConfigExample();
        }
        return "";
    }

    private String buildDataJpaTestAnnotationMessage() {
        return "Do you use @DataJpaTest? This annotation disables Spring auto-configuration." + LINE_SEPARATOR + "So, QuickPerf Spring auto-configuration is disabled." + LINE_SEPARATOR + "To allow QuickPerf to intercept the SQL queries, you have two possibilities: " + LINE_SEPARATOR + "1) Import QuickPerfSqlConfig (recommended): " + LINE_SEPARATOR + this.buildImportQuickPerfSqlConfigExample() + LINE_SEPARATOR + "2) Force to enable Spring auto-configuration by adding" + LINE_SEPARATOR + "   @OverrideAutoConfiguration(enabled = true) on the test class";
    }

    private String buildSpringRESTControllerMessage() {
        return "Are you testing a REST controller without MockMvc? Execute the test in" + LINE_SEPARATOR + "a dedicated JVM by adding @HeapSize(value = ..., unit = AllocationUnit.MEGA_BYTE)." + LINE_SEPARATOR + "A heap size value around 50 megabytes may allow the test to run.";
    }

    private String buildImportQuickPerfSqlConfigExample() {
        return "\timport org.quickperf.spring.sql.QuickPerfSqlConfig;" + LINE_SEPARATOR + "\t..." + LINE_SEPARATOR + "\t@Import(QuickPerfSqlConfig.class)" + LINE_SEPARATOR + "\tpublic class TestClass {";
    }

    public String format(QuickPerfDependency quickPerfDependency) {
        return "\t* Maven" + LINE_SEPARATOR + quickPerfDependency.toMavenWithVersion() + LINE_SEPARATOR + "\t* Gradle" + LINE_SEPARATOR + quickPerfDependency.toGradleWithVersion() + LINE_SEPARATOR + "\t* Other: " + quickPerfDependency.getMavenSearchLink();
    }
}

