/*
 * Decompiled with CFR 0.152.
 */
package org.quickperf.sql.framework;

import org.quickperf.sql.framework.quickperf.QuickPerfDependency;

public class ClassPath {
    public static final ClassPath INSTANCE = new ClassPath();
    private final String value = System.getProperty("java.class.path");

    private ClassPath() {
    }

    public String getValue() {
        return this.value;
    }

    public boolean containsHibernate() {
        return this.value.contains("hibernate-core");
    }

    public boolean containsSpringDataJpa() {
        return this.value.contains("spring-data-jpa");
    }

    public boolean containsSpringBoot() {
        return this.value.contains("org.springframework.boot") || this.value.contains("spring-boot");
    }

    public boolean containsSpringBoot1() {
        return this.value.contains("spring-boot-1");
    }

    public boolean containsSpringBoot2() {
        return this.value.contains("spring-boot-2");
    }

    public boolean containsSpringCore() {
        return this.containsSpringframework() && this.value.contains("spring-core");
    }

    private boolean containsSpringframework() {
        return this.value.contains("springframework");
    }

    public boolean containsSpring4() {
        return this.containsSpringframework() && this.value.contains("spring-core-4");
    }

    public boolean containsSpring5() {
        return this.containsSpringframework() && this.value.contains("spring-core-5");
    }

    public boolean containsQuarkusCore() {
        return this.value.contains("quarkus-core");
    }

    public boolean containsMicronautData() {
        return this.value.contains("micronaut-data");
    }

    public boolean containsMicronautHibernateJpa() {
        return this.value.contains("micronaut-hibernate-jpa");
    }

    public boolean contains(QuickPerfDependency quickPerfDependency) {
        String quickPerfArtifactId = quickPerfDependency.getArtifactId();
        return this.value.contains(quickPerfArtifactId);
    }
}

