/*
 * Decompiled with CFR 0.152.
 */
package org.quickperf.sql.formatter;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Locale;
import org.quickperf.sql.SqlFormatter;
import org.quickperf.sql.framework.ClassPath;

class SqlFormatterBasedOnHibernate
implements SqlFormatter {
    static final SqlFormatter INSTANCE = SqlFormatterBasedOnHibernate.buildSqlFormatterBasedOnHibernate();
    private Object basicFormatter;
    private Method formatMethod;
    private Object ddlFormatter;

    private SqlFormatterBasedOnHibernate() {
    }

    private static SqlFormatter buildSqlFormatterBasedOnHibernate() {
        try {
            Class<? extends Enum> formatStyleClass = SqlFormatterBasedOnHibernate.retrieveHibernateFormatStyleClass();
            Method getFormatterMethod = formatStyleClass.getDeclaredMethod("getFormatter", null);
            Enum formatStyleBasic = Enum.valueOf(formatStyleClass, "BASIC");
            Object basicFormatter = getFormatterMethod.invoke((Object)formatStyleBasic, null);
            Enum formatStyleDdl = Enum.valueOf(formatStyleClass, "DDL");
            Object ddlFormatter = getFormatterMethod.invoke((Object)formatStyleDdl, null);
            SqlFormatterBasedOnHibernate sqlFormatterBasedOnHibernate = new SqlFormatterBasedOnHibernate();
            sqlFormatterBasedOnHibernate.basicFormatter = basicFormatter;
            sqlFormatterBasedOnHibernate.ddlFormatter = ddlFormatter;
            sqlFormatterBasedOnHibernate.formatMethod = SqlFormatterBasedOnHibernate.retrieveFormatOfHibernateFormatterClass();
            return sqlFormatterBasedOnHibernate;
        }
        catch (Exception e) {
            return SqlFormatter.NONE;
        }
    }

    private static Class<? extends Enum> retrieveHibernateFormatStyleClass() throws ClassNotFoundException {
        ClassLoader loader = SqlFormatterBasedOnHibernate.class.getClassLoader();
        String formatStyleClassName = "org.hibernate.engine.jdbc.internal.FormatStyle";
        return loader.loadClass(formatStyleClassName);
    }

    private static Method retrieveFormatOfHibernateFormatterClass() throws ClassNotFoundException, NoSuchMethodException {
        Class<?> formatterClass = Class.forName("org.hibernate.engine.jdbc.internal.Formatter");
        return formatterClass.getDeclaredMethod("format", String.class);
    }

    @Override
    public String formatQuery(String query) {
        if (ClassPath.INSTANCE.containsHibernate()) {
            try {
                return this.formatWithHibernateFormatter(query);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return query;
    }

    private String formatWithHibernateFormatter(String query) throws IllegalAccessException, InvocationTargetException {
        if (this.isDdlQuery(query)) {
            return (String)this.formatMethod.invoke(this.ddlFormatter, query);
        }
        String queryFormattedByHibernate = (String)this.formatMethod.invoke(this.basicFormatter, query);
        return queryFormattedByHibernate.replaceAll("cross " + System.lineSeparator() + "    ", System.lineSeparator() + "    cross ").replaceAll("CROSS " + System.lineSeparator() + "    ", System.lineSeparator() + "    CROSS ");
    }

    private boolean isDdlQuery(String sql) {
        return sql.toLowerCase(Locale.ROOT).startsWith("create table") || sql.toLowerCase(Locale.ROOT).startsWith("alter table") || sql.toLowerCase(Locale.ROOT).startsWith("comment on");
    }
}

