/*
 * Decompiled with CFR 0.152.
 */
package org.quickperf.sql.formatter;

import java.util.List;
import net.ttddyy.dsproxy.ExecutionInfo;
import net.ttddyy.dsproxy.QueryInfo;
import net.ttddyy.dsproxy.listener.logging.DefaultQueryLogEntryCreator;
import org.quickperf.sql.SqlFormatter;
import org.quickperf.sql.formatter.SqlFormatterBasedOnHibernate;
import org.quickperf.sql.formatter.SqlFormatterDefinedByUserRetriever;
import org.quickperf.sql.framework.ClassPath;

public class QuickPerfSqlFormatter {
    public static final QuickPerfSqlFormatter INSTANCE = new QuickPerfSqlFormatter();
    private static final QuickPerfQueryLogEntryCreator PRETTY_QUERY_LOG_ENTRY_CREATOR = new QuickPerfQueryLogEntryCreator();
    private static final SqlFormatter SQL_FORMATTER = QuickPerfSqlFormatter.buildSqlFormatter();

    private QuickPerfSqlFormatter() {
    }

    public String format(ExecutionInfo executionInfo, List<QueryInfo> queries) {
        boolean writeDataSourceName = false;
        boolean writeConnectionId = false;
        return PRETTY_QUERY_LOG_ENTRY_CREATOR.getLogEntry(executionInfo, queries, false, false);
    }

    private static SqlFormatter buildSqlFormatter() {
        SqlFormatter sqlFormatterDefinedByUser = SqlFormatterDefinedByUserRetriever.INSTANCE.retrieveSqlFormatterDefinedByUser();
        if (!sqlFormatterDefinedByUser.equals(SqlFormatter.NONE)) {
            return sqlFormatterDefinedByUser;
        }
        if (ClassPath.INSTANCE.containsHibernate()) {
            return SqlFormatterBasedOnHibernate.INSTANCE;
        }
        return SqlFormatter.NONE;
    }

    private static class QuickPerfQueryLogEntryCreator
    extends DefaultQueryLogEntryCreator {
        private QuickPerfQueryLogEntryCreator() {
        }

        protected String formatQuery(String query) {
            return SQL_FORMATTER.formatQuery(query);
        }
    }
}

