/*
 * Decompiled with CFR 0.152.
 */
package org.quickperf.sql.display;

import java.util.List;
import net.ttddyy.dsproxy.ExecutionInfo;
import net.ttddyy.dsproxy.QueryInfo;
import org.quickperf.TestExecutionContext;
import org.quickperf.sql.DataSourceProxyVerifier;
import org.quickperf.sql.SqlExecutions;
import org.quickperf.sql.SqlRecorder;
import org.quickperf.sql.SqlRecorderRegistry;
import org.quickperf.sql.annotation.DisplaySql;
import org.quickperf.sql.formatter.QuickPerfSqlFormatter;

public class DisplaySqlOfTestMethodBodyRecorder
implements SqlRecorder<SqlExecutions> {
    private final DataSourceProxyVerifier datasourceProxyVerifier = new DataSourceProxyVerifier();

    public void startRecording(TestExecutionContext testExecutionContext) {
        SqlRecorderRegistry.INSTANCE.register(this);
    }

    public void stopRecording(TestExecutionContext testExecutionContext) {
        SqlRecorderRegistry.unregister(this);
        if (this.datasourceProxyVerifier.hasQuickPerfBuiltSeveralDataSourceProxies()) {
            System.out.println();
            System.out.println("[WARNING] QuickPerf has built several datasource proxies");
        }
        System.out.println();
        System.out.println("Use @" + DisplaySql.class.getSimpleName() + " to also see queries before and after test execution.");
    }

    public SqlExecutions findRecord(TestExecutionContext testExecutionContext) {
        return SqlExecutions.NONE;
    }

    public void cleanResources() {
    }

    @Override
    public void addQueryExecution(ExecutionInfo execInfo, List<QueryInfo> queries, int listenerIdentifier) {
        this.datasourceProxyVerifier.addListenerIdentifier(listenerIdentifier);
        String sqlQueries = QuickPerfSqlFormatter.INSTANCE.format(execInfo, queries);
        System.out.println(sqlQueries);
    }
}

