/*
 * Decompiled with CFR 0.152.
 */
package org.quickperf.sql.connection.stack;

import org.quickperf.sql.connection.stack.PositionsFiltering;
import org.quickperf.sql.connection.stack.StackTraceFilter;

public class TestNGStackTraceFilter
implements StackTraceFilter {
    public static final TestNGStackTraceFilter INSTANCE = new TestNGStackTraceFilter();

    @Override
    public PositionsFiltering filter(StackTraceElement[] stackElements) {
        int zeroPos = 0;
        int quickPerfTestNGListenerPos = this.extractQuickPerfTestNGListenerPos(stackElements);
        int testNGLastPos = this.extractTestNGLastPos(stackElements, quickPerfTestNGListenerPos);
        return new PositionsFiltering(zeroPos, testNGLastPos);
    }

    private int extractQuickPerfTestNGListenerPos(StackTraceElement[] stackElements) {
        for (int pos = 0; pos < stackElements.length; ++pos) {
            String stackTraceElementAsString = stackElements[pos].toString();
            if (!stackTraceElementAsString.contains("org.quickperf.testng.QuickPerfTestNGListener")) continue;
            return pos;
        }
        return 0;
    }

    private int extractTestNGLastPos(StackTraceElement[] stackElements, int quickPerfTestNGListenerPos) {
        for (int pos = quickPerfTestNGListenerPos - 1; pos > 0; --pos) {
            String stackTraceElementAsString = stackElements[pos].toString();
            if (stackTraceElementAsString.startsWith("java") || stackTraceElementAsString.startsWith("org.testng") || stackTraceElementAsString.startsWith("sun.reflect")) continue;
            return pos;
        }
        return stackElements.length;
    }
}

