/*
 * Decompiled with CFR 0.152.
 */
package org.quickperf.sql.connection.stack;

import java.util.Collections;
import org.quickperf.sql.connection.stack.StackTrace;
import org.quickperf.sql.connection.stack.StackTraceFilter;

public class StackTraceDisplayConfig {
    private StackTrace.StackDepth stackDepth;
    private Iterable<StackTraceFilter> stackTraceFilters;

    private StackTraceDisplayConfig() {
    }

    public static StackTraceDisplayConfig of(StackTrace.StackDepth stackDepth, Iterable<StackTraceFilter> stackTraceFilters) {
        StackTraceDisplayConfig stackTraceDisplayConfig = new StackTraceDisplayConfig();
        stackTraceDisplayConfig.stackDepth = stackDepth;
        stackTraceDisplayConfig.stackTraceFilters = stackTraceFilters;
        return stackTraceDisplayConfig;
    }

    public static StackTraceDisplayConfig noStackTrace() {
        StackTraceDisplayConfig stackTraceDisplayConfig = new StackTraceDisplayConfig();
        stackTraceDisplayConfig.stackDepth = StackTrace.StackDepth.NONE;
        stackTraceDisplayConfig.stackTraceFilters = Collections.emptyList();
        return stackTraceDisplayConfig;
    }

    public StackTraceElement[] format(StackTraceElement[] stackTraceElements) {
        StackTrace stackTrace = StackTrace.of(stackTraceElements);
        stackTrace.formatWith(this.stackTraceFilters, this.stackDepth);
        return stackTrace.getElements();
    }

    public boolean isStackTraceDisplayed() {
        return !StackTrace.StackDepth.NONE.equals(this.stackDepth);
    }
}

