/*
 * Decompiled with CFR 0.152.
 */
package org.quickperf.sql.connection.stack;

import java.util.Arrays;
import org.quickperf.sql.connection.stack.PositionsFiltering;
import org.quickperf.sql.connection.stack.StackTraceFilter;

public class StackTrace {
    private final StackTraceElement[] allElements;
    private int firstPos = 0;
    private int lastPos;

    static StackTrace of(StackTraceElement[] elements) {
        return new StackTrace(elements);
    }

    private StackTrace(StackTraceElement[] elements) {
        this.lastPos = elements.length - 1;
        this.allElements = elements;
    }

    StackTraceElement[] getElements() {
        return Arrays.copyOfRange(this.allElements, this.firstPos, this.lastPos + 1);
    }

    void formatWith(Iterable<StackTraceFilter> stackTraceFilters, StackDepth stackDepth) {
        if (StackDepth.NONE.equals(stackDepth)) {
            this.firstPos = 0;
            this.lastPos = 0;
            return;
        }
        for (StackTraceFilter stackTraceFilter : stackTraceFilters) {
            this.filter(stackTraceFilter);
        }
        this.limitTo(stackDepth);
    }

    private void filter(StackTraceFilter stackTraceFilter) {
        PositionsFiltering positionsFiltering = stackTraceFilter.filter(this.allElements);
        int startFilteringPosition = positionsFiltering.getStart();
        int endFilteringPosition = positionsFiltering.getEnd();
        if (startFilteringPosition > this.firstPos) {
            this.firstPos = startFilteringPosition;
        }
        if (endFilteringPosition < this.lastPos) {
            this.lastPos = endFilteringPosition;
        }
    }

    private void limitTo(StackDepth stackDepth) {
        int allStackLength = this.allElements.length;
        if (stackDepth.isLessThan(allStackLength)) {
            this.lastPos = this.firstPos + stackDepth.maxValue - 1;
        }
    }

    public static class StackDepth {
        public static final StackDepth NONE = new StackDepth(0);
        public static final StackDepth ALL = new StackDepth(1000);
        private final int maxValue;

        public StackDepth(short maxValue) {
            this.maxValue = maxValue;
        }

        private boolean isLessThan(int value) {
            return this.maxValue < value;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            StackDepth that = (StackDepth)o;
            return this.maxValue == that.maxValue;
        }
    }
}

