/*
 * Decompiled with CFR 0.152.
 */
package org.quickperf.sql.connection.stack;

import org.quickperf.sql.config.library.QuickPerfProxyDataSource;
import org.quickperf.sql.connection.TestConnectionProfiler;
import org.quickperf.sql.connection.stack.PositionsFiltering;
import org.quickperf.sql.connection.stack.StackTraceFilter;

public class QuickPerfStackTraceTraceFilter
implements StackTraceFilter {
    public static final QuickPerfStackTraceTraceFilter INSTANCE = new QuickPerfStackTraceTraceFilter();

    private QuickPerfStackTraceTraceFilter() {
    }

    @Override
    public PositionsFiltering filter(StackTraceElement[] stackElements) {
        short quickPerfFirstPos = this.extractQuickPerfFirstPos(stackElements);
        int lastStackElementPos = stackElements.length;
        return new PositionsFiltering(quickPerfFirstPos, lastStackElementPos);
    }

    private short extractQuickPerfFirstPos(StackTraceElement[] stackElements) {
        String quickPerfProxyDataSourcePackage = QuickPerfProxyDataSource.class.getPackage().getName();
        String connectionProfilerPackageName = TestConnectionProfiler.class.getPackage().getName();
        for (short pos = 0; pos < stackElements.length; pos = (short)((short)(pos + 1))) {
            String stackTraceElementAsString = stackElements[pos].toString();
            if (stackTraceElementAsString.contains("java.lang.Thread") || stackTraceElementAsString.contains(connectionProfilerPackageName) || stackTraceElementAsString.contains(quickPerfProxyDataSourcePackage)) continue;
            return pos;
        }
        return 0;
    }
}

