/*
 * Decompiled with CFR 0.152.
 */
package org.quickperf.sql.connection.stack;

import org.quickperf.sql.connection.stack.PositionsFiltering;
import org.quickperf.sql.connection.stack.StackTraceFilter;

public class JUnit5StackTraceFilter
implements StackTraceFilter {
    public static final JUnit5StackTraceFilter INSTANCE = new JUnit5StackTraceFilter();

    @Override
    public PositionsFiltering filter(StackTraceElement[] stackElements) {
        int zeroPos = 0;
        int invokeMethodPos = this.extractInvokeMethodPos(stackElements);
        int junit5LastPos = this.extractJUnit5LastPos(stackElements, invokeMethodPos);
        return new PositionsFiltering(zeroPos, junit5LastPos);
    }

    private int extractInvokeMethodPos(StackTraceElement[] stackElements) {
        for (int pos = 0; pos < stackElements.length; ++pos) {
            String stackTraceElementAsString = stackElements[pos].toString();
            if (!stackTraceElementAsString.contains("org.junit.platform.commons.util.ReflectionUtils.invokeMethod")) continue;
            return pos;
        }
        return 0;
    }

    private int extractJUnit5LastPos(StackTraceElement[] stackElements, int quickPerMethodPos) {
        for (int pos = quickPerMethodPos - 1; pos > 0; --pos) {
            String stackTraceElementAsString = stackElements[pos].toString();
            if (stackTraceElementAsString.startsWith("java") || stackTraceElementAsString.startsWith("sun.reflect")) continue;
            return pos;
        }
        return stackElements.length;
    }
}

