/*
 * Decompiled with CFR 0.152.
 */
package org.quickperf.sql.connection.stack;

import org.quickperf.sql.connection.stack.PositionsFiltering;
import org.quickperf.sql.connection.stack.StackTraceFilter;

public class JUnit4StackTraceFilter
implements StackTraceFilter {
    public static final JUnit4StackTraceFilter INSTANCE = new JUnit4StackTraceFilter();

    @Override
    public PositionsFiltering filter(StackTraceElement[] stackElements) {
        int zeroPos = 0;
        int quickPerMethodPos = this.extractQuickPerfMethodPos(stackElements);
        int junit4LastPos = this.extractJUnit4LastPost(stackElements, quickPerMethodPos);
        return new PositionsFiltering(zeroPos, junit4LastPos);
    }

    private int extractQuickPerfMethodPos(StackTraceElement[] stackElements) {
        for (int pos = 0; pos < stackElements.length; ++pos) {
            String stackTraceElementAsString = stackElements[pos].toString();
            if (!stackTraceElementAsString.contains("org.quickperf.junit4.QuickPerfMethod")) continue;
            return pos;
        }
        return 0;
    }

    private int extractJUnit4LastPost(StackTraceElement[] stackElements, int quickPerMethodPos) {
        for (int pos = quickPerMethodPos - 1; pos > 0; --pos) {
            String stackTraceElementAsString = stackElements[pos].toString();
            if (stackTraceElementAsString.startsWith("java") || stackTraceElementAsString.startsWith("sun.reflect")) continue;
            return pos;
        }
        return stackElements.length;
    }
}

