/*
 * Decompiled with CFR 0.152.
 */
package org.quickperf.sql.connection;

import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.Collection;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Executor;
import org.quickperf.sql.connection.ConnectionListener;
import org.quickperf.sql.connection.ConnectionListenerRegistry;

public class QuickPerfDatabaseConnection
implements Connection {
    private final Connection delegate;
    private Collection<ConnectionListener> connectionListeners;

    private QuickPerfDatabaseConnection(Connection connection) {
        this.delegate = connection;
    }

    public static QuickPerfDatabaseConnection buildFrom(Connection connection) {
        QuickPerfDatabaseConnection quickPerfDatabaseConnection = new QuickPerfDatabaseConnection(connection);
        quickPerfDatabaseConnection.connectionListeners = ConnectionListenerRegistry.INSTANCE.getConnectionListeners();
        return quickPerfDatabaseConnection;
    }

    public void theDatasourceGetsTheConnection() {
        for (ConnectionListener connectionListener : this.connectionListeners) {
            connectionListener.theDatasourceGetsTheConnection(this);
        }
    }

    public void theDatasourceGetsTheConnectionWithUserNameAndPassword() {
        for (ConnectionListener connectionListener : this.connectionListeners) {
            connectionListener.theDatasourceGetsTheConnectionWithUserNameAndPassword(this);
        }
    }

    @Override
    public Statement createStatement() throws SQLException {
        for (ConnectionListener connectionListener : this.connectionListeners) {
            connectionListener.createStatement(this);
        }
        return this.delegate.createStatement();
    }

    @Override
    public PreparedStatement prepareStatement(String sql) throws SQLException {
        for (ConnectionListener connectionListener : this.connectionListeners) {
            connectionListener.prepareStatement(this, sql);
        }
        return this.delegate.prepareStatement(sql);
    }

    @Override
    public CallableStatement prepareCall(String sql) throws SQLException {
        for (ConnectionListener connectionListener : this.connectionListeners) {
            connectionListener.prepareCall(this, sql);
        }
        return this.delegate.prepareCall(sql);
    }

    @Override
    public String nativeSQL(String sql) throws SQLException {
        for (ConnectionListener connectionListener : this.connectionListeners) {
            connectionListener.nativeSQL(this, sql);
        }
        return this.delegate.nativeSQL(sql);
    }

    @Override
    public void setAutoCommit(boolean autoCommit) throws SQLException {
        for (ConnectionListener connectionListener : this.connectionListeners) {
            connectionListener.setAutoCommit(this, autoCommit);
        }
        this.delegate.setAutoCommit(autoCommit);
    }

    @Override
    public boolean getAutoCommit() throws SQLException {
        return this.delegate.getAutoCommit();
    }

    @Override
    public void commit() throws SQLException {
        for (ConnectionListener connectionListener : this.connectionListeners) {
            connectionListener.commit(this);
        }
        this.delegate.commit();
    }

    @Override
    public void rollback() throws SQLException {
        for (ConnectionListener connectionListener : this.connectionListeners) {
            connectionListener.rollback(this);
        }
        this.delegate.rollback();
    }

    @Override
    public void close() throws SQLException {
        for (ConnectionListener connectionListener : this.connectionListeners) {
            connectionListener.close(this);
        }
        this.delegate.close();
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.delegate.isClosed();
    }

    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        return this.delegate.getMetaData();
    }

    @Override
    public void setReadOnly(boolean readOnly) throws SQLException {
        for (ConnectionListener connectionListener : this.connectionListeners) {
            connectionListener.setReadOnly(this, readOnly);
        }
        this.delegate.setReadOnly(readOnly);
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        return this.delegate.isReadOnly();
    }

    @Override
    public void setCatalog(String catalog) throws SQLException {
        for (ConnectionListener connectionListener : this.connectionListeners) {
            connectionListener.setCatalog(this, catalog);
        }
        this.delegate.setCatalog(catalog);
    }

    @Override
    public String getCatalog() throws SQLException {
        return this.delegate.getCatalog();
    }

    @Override
    public void setTransactionIsolation(int level) throws SQLException {
        for (ConnectionListener connectionListener : this.connectionListeners) {
            connectionListener.setTransactionIsolation(this, level);
        }
        this.delegate.setTransactionIsolation(level);
    }

    @Override
    public int getTransactionIsolation() throws SQLException {
        return this.delegate.getTransactionIsolation();
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return this.delegate.getWarnings();
    }

    @Override
    public void clearWarnings() throws SQLException {
        for (ConnectionListener connectionListener : this.connectionListeners) {
            connectionListener.clearWarnings(this);
        }
        this.delegate.clearWarnings();
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        for (ConnectionListener connectionListener : this.connectionListeners) {
            connectionListener.createStatement(this, resultSetType, resultSetConcurrency);
        }
        return this.delegate.createStatement(resultSetType, resultSetConcurrency);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        for (ConnectionListener connectionListener : this.connectionListeners) {
            connectionListener.prepareStatement(this, sql, resultSetType, resultSetConcurrency);
        }
        return this.delegate.prepareStatement(sql, resultSetType, resultSetConcurrency);
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        for (ConnectionListener connectionListener : this.connectionListeners) {
            connectionListener.prepareCall(this, sql, resultSetType, resultSetConcurrency);
        }
        return this.delegate.prepareCall(sql, resultSetType, resultSetConcurrency);
    }

    @Override
    public Map<String, Class<?>> getTypeMap() throws SQLException {
        return this.delegate.getTypeMap();
    }

    @Override
    public void setTypeMap(Map<String, Class<?>> map) throws SQLException {
        for (ConnectionListener connectionListener : this.connectionListeners) {
            connectionListener.setTypeMap(this, map);
        }
        this.delegate.setTypeMap(map);
    }

    @Override
    public void setHoldability(int holdability) throws SQLException {
        for (ConnectionListener connectionListener : this.connectionListeners) {
            connectionListener.setHoldability(this, holdability);
        }
        this.delegate.setHoldability(holdability);
    }

    @Override
    public int getHoldability() throws SQLException {
        return this.delegate.getHoldability();
    }

    @Override
    public Savepoint setSavepoint() throws SQLException {
        for (ConnectionListener connectionListener : this.connectionListeners) {
            connectionListener.setSavepoint(this);
        }
        return this.delegate.setSavepoint();
    }

    @Override
    public Savepoint setSavepoint(String name) throws SQLException {
        for (ConnectionListener connectionListener : this.connectionListeners) {
            connectionListener.setSavepoint(this, name);
        }
        return this.delegate.setSavepoint(name);
    }

    @Override
    public void rollback(Savepoint savepoint) throws SQLException {
        for (ConnectionListener connectionListener : this.connectionListeners) {
            connectionListener.rollback(this, savepoint);
        }
        this.delegate.rollback(savepoint);
    }

    @Override
    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        for (ConnectionListener connectionListener : this.connectionListeners) {
            connectionListener.releaseSavepoint(this, savepoint);
        }
        this.delegate.releaseSavepoint(savepoint);
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        for (ConnectionListener connectionListener : this.connectionListeners) {
            connectionListener.createStatement(this, resultSetType, resultSetConcurrency, resultSetHoldability);
        }
        return this.delegate.createStatement(resultSetType, resultSetConcurrency, resultSetHoldability);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        for (ConnectionListener connectionListener : this.connectionListeners) {
            connectionListener.prepareStatement(this, sql, resultSetType, resultSetConcurrency, resultSetHoldability);
        }
        return this.delegate.prepareStatement(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        for (ConnectionListener connectionListener : this.connectionListeners) {
            connectionListener.prepareCall(this, sql, resultSetType, resultSetConcurrency, resultSetHoldability);
        }
        return this.delegate.prepareCall(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        for (ConnectionListener connectionListener : this.connectionListeners) {
            connectionListener.prepareStatement((Connection)this, sql, autoGeneratedKeys);
        }
        return this.delegate.prepareStatement(sql, autoGeneratedKeys);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        for (ConnectionListener connectionListener : this.connectionListeners) {
            connectionListener.prepareStatement((Connection)this, sql, columnIndexes);
        }
        return this.delegate.prepareStatement(sql, columnIndexes);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        for (ConnectionListener connectionListener : this.connectionListeners) {
            connectionListener.prepareStatement((Connection)this, sql, columnNames);
        }
        return this.delegate.prepareStatement(sql, columnNames);
    }

    @Override
    public Clob createClob() throws SQLException {
        for (ConnectionListener connectionListener : this.connectionListeners) {
            connectionListener.createClob(this);
        }
        return this.delegate.createClob();
    }

    @Override
    public Blob createBlob() throws SQLException {
        for (ConnectionListener connectionListener : this.connectionListeners) {
            connectionListener.createBlob(this);
        }
        return this.delegate.createBlob();
    }

    @Override
    public NClob createNClob() throws SQLException {
        for (ConnectionListener connectionListener : this.connectionListeners) {
            connectionListener.createNClob(this);
        }
        return this.delegate.createNClob();
    }

    @Override
    public SQLXML createSQLXML() throws SQLException {
        for (ConnectionListener connectionListener : this.connectionListeners) {
            connectionListener.createSQLXML(this);
        }
        return this.delegate.createSQLXML();
    }

    @Override
    public boolean isValid(int timeout) throws SQLException {
        return this.delegate.isValid(timeout);
    }

    @Override
    public void setClientInfo(String name, String value) throws SQLClientInfoException {
        for (ConnectionListener connectionListener : this.connectionListeners) {
            connectionListener.setClientInfo(this, name, value);
        }
        this.delegate.setClientInfo(name, value);
    }

    @Override
    public void setClientInfo(Properties properties) throws SQLClientInfoException {
        for (ConnectionListener connectionListener : this.connectionListeners) {
            connectionListener.setClientInfo(this, properties);
        }
        this.delegate.setClientInfo(properties);
    }

    @Override
    public String getClientInfo(String name) throws SQLException {
        return this.delegate.getClientInfo(name);
    }

    @Override
    public Properties getClientInfo() throws SQLException {
        return this.delegate.getClientInfo();
    }

    @Override
    public Array createArrayOf(String typeName, Object[] elements) throws SQLException {
        for (ConnectionListener connectionListener : this.connectionListeners) {
            connectionListener.createArrayOf(this, typeName, elements);
        }
        return this.delegate.createArrayOf(typeName, elements);
    }

    @Override
    public Struct createStruct(String typeName, Object[] attributes) throws SQLException {
        for (ConnectionListener connectionListener : this.connectionListeners) {
            connectionListener.createStruct(this, typeName, attributes);
        }
        return this.delegate.createStruct(typeName, attributes);
    }

    @Override
    public void setSchema(String schema) throws SQLException {
        for (ConnectionListener connectionListener : this.connectionListeners) {
            connectionListener.setSchema(this, schema);
        }
        this.delegate.setSchema(schema);
    }

    @Override
    public String getSchema() throws SQLException {
        return this.delegate.getSchema();
    }

    @Override
    public void abort(Executor executor) throws SQLException {
        for (ConnectionListener connectionListener : this.connectionListeners) {
            connectionListener.abort(this, executor);
        }
        this.delegate.abort(executor);
    }

    @Override
    public void setNetworkTimeout(Executor executor, int milliseconds) throws SQLException {
        for (ConnectionListener connectionListener : this.connectionListeners) {
            connectionListener.setNetworkTimeout(this, executor, milliseconds);
        }
        this.delegate.setNetworkTimeout(executor, milliseconds);
    }

    @Override
    public int getNetworkTimeout() throws SQLException {
        return this.delegate.getNetworkTimeout();
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return this.delegate.unwrap(iface);
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return this.delegate.isWrapperFor(iface);
    }
}

